/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.FloatEditor;
import jsbugs.table.RolloverMouseAdapter;
import jsbugs.table.StandardEditor;
import jsbugs.table.StandardRenderer;
import jsbugs.table.TitleButtonRenderer;
import jsbugs.table.TitleRenderer;
import util.table.TableColumnResizer;

public class PropertiesTable
extends JTable {
    private static final Logger LOGGER = Logger.getLogger(PropertiesTable.class.getName());
    public static final Color TITLE_COLOUR = new Color(128, 130, 133);
    private final MouseInputAdapter columnResizer;
    private final TitleRenderer titleRenderer = new TitleRenderer(TITLE_COLOUR, Color.WHITE);
    private final TitleRenderer innerTitleRenderer = new TitleRenderer(new Color(167, 169, 172), Color.WHITE);
    private final RolloverMouseAdapter rolloverAdapter;
    private final TitleButtonRenderer titleButtonRenderer;
    private final StandardRenderer standardRenderer = new StandardRenderer();
    private final StandardEditor standardEditor = new StandardEditor();
    private final RowFilter rowFilter;

    public PropertiesTable() {
        this.setUI(new PropertiesTableUI(this));
        this.setRowHeight(18);
        this.setGridColor(new Color(230, 231, 232));
        this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getPreferredSize().width, 0));
        this.getTableHeader().setVisible(false);
        this.setDefaultRenderer(Object.class, new StandardRenderer());
        this.setDefaultRenderer(Number.class, new StandardRenderer());
        this.setDefaultEditor(Number.class, new StandardEditor());
        this.setDefaultRenderer(Float.class, new StandardRenderer());
        this.setDefaultEditor(Float.class, new FloatEditor(false));
        this.setDefaultRenderer(Boolean.class, new CheckBoxRenderer());
        this.setDefaultEditor(Boolean.class, new CheckBoxEditor());
        this.columnResizer = new TableColumnResizer((JTable)this);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PropertiesTable this$0;
            {
                PropertiesTable propertiesTable = this$0;
                Objects.requireNonNull(propertiesTable);
                this.this$0 = propertiesTable;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int column;
                int row = this.this$0.rowAtPoint(evt.getPoint());
                TableCellRenderer cellRenderer = this.this$0.getCellRenderer(row, column = this.this$0.columnAtPoint(evt.getPoint()));
                if (cellRenderer instanceof TitleButtonRenderer) {
                    column = 0;
                    Rectangle rect = this.this$0.getCellRect(row, column, true);
                    if (rect.x + rect.width - evt.getX() < 24 && rect.y + rect.height - evt.getY() < 24) {
                        this.this$0.getModel().doTitleButtonRowAction();
                        this.this$0.repaint();
                    }
                }
            }
        });
        this.rolloverAdapter = new RolloverMouseAdapter(this);
        this.addMouseMotionListener(this.rolloverAdapter);
        this.titleButtonRenderer = new TitleButtonRenderer(this.rolloverAdapter, TITLE_COLOUR, Color.WHITE);
        this.rowFilter = new RowFilter(this){
            final /* synthetic */ PropertiesTable this$0;
            {
                PropertiesTable propertiesTable = this$0;
                Objects.requireNonNull(propertiesTable);
                this.this$0 = propertiesTable;
            }

            public boolean include(RowFilter.Entry entry) {
                if (entry.getModel() instanceof PropertiesTableModel && entry.getIdentifier() instanceof Integer) {
                    return this.this$0.getModel().showRow((Integer)entry.getIdentifier());
                }
                return true;
            }
        };
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        if (this.getCursor() == TableColumnResizer.resizeCursor) {
            return;
        }
        super.changeSelection(row, column, toggle, extend);
    }

    @Override
    public void setModel(TableModel model) {
        if (model != null && !(model instanceof PropertiesTableModel)) {
            model = PropertiesTableModel.getDefaultModel();
        }
        if (model != this.getModel()) {
            super.setModel(model);
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
            sorter.setRowFilter(this.rowFilter);
            this.setRowSorter(sorter);
            this.setVariableRowHeights();
        }
    }

    private void setVariableRowHeights() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getModel().isTitleButtonRow(this.getRowSorter().convertRowIndexToModel(i))) continue;
            this.setRowHeight(i, 26);
        }
    }

    public void fireTableDataChanged() {
        this.getModel().fireTableDataChanged();
        this.setVariableRowHeights();
    }

    @Override
    public PropertiesTableModel getModel() {
        return (PropertiesTableModel)super.getModel();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        row = this.getRowSorter().convertRowIndexToModel(row);
        if (this.getModel().isTitleRow(row)) {
            if (this.getModel().isTitleButtonRow(row)) {
                return this.titleButtonRenderer;
            }
            if (this.getModel().isTitleInnerRow(row)) {
                return this.innerTitleRenderer;
            }
            return this.titleRenderer;
        }
        TableCellRenderer renderer = this.getModel().getCellRenderer(row, column);
        if (renderer != null) {
            return renderer;
        }
        return this.standardRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        row = this.getRowSorter().convertRowIndexToModel(row);
        TableCellEditor editor = this.getModel().getCellEditor(row, column);
        if (editor != null) {
            return editor;
        }
        return this.standardEditor;
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle rval;
        if (row >= this.getModel().getRowCount() || row >= this.getRowSorter().getModelRowCount()) {
            return new Rectangle();
        }
        if (this.getModel() == null) {
            return super.getCellRect(row, column, includeSpacing);
        }
        boolean span = false;
        try {
            span = row < 0 ? false : this.getModel().isTitleRow(this.getRowSorter().convertRowIndexToModel(row)) && column == 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Out of bounds - model: " + String.valueOf(this.getModel()));
            e.printStackTrace();
        }
        if (span) {
            rval = super.getCellRect(row, column, includeSpacing);
            rval = rval.union(super.getCellRect(row, this.getModel().getColumnCount() - 1, includeSpacing));
        } else {
            rval = super.getCellRect(row, column, includeSpacing);
        }
        return rval;
    }

    @Override
    public int columnAtPoint(Point p) {
        int col = super.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        if (row > -1 && col == 1 && this.getModel().isTitleButtonRow(this.getRowSorter().convertRowIndexToModel(row))) {
            return 0;
        }
        return col;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String text;
        int row;
        if (this.getModel() != null && (row = this.convertRowIndexToModel(this.rowAtPoint(evt.getPoint()))) >= 0 && (text = this.getModel().getToolTipText(row)) != null) {
            return text;
        }
        return super.getToolTipText();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (LOGGER != null) {
            // empty if block
        }
        super.tableChanged(e);
    }

    private class PropertiesTableUI
    extends BasicTableUI {
        final /* synthetic */ PropertiesTable this$0;

        private PropertiesTableUI(PropertiesTable propertiesTable) {
            PropertiesTable propertiesTable2 = propertiesTable;
            Objects.requireNonNull(propertiesTable2);
            this.this$0 = propertiesTable2;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Rectangle r = g.getClipBounds();
            int firstRow = this.table.rowAtPoint(new Point(r.x, r.y));
            int lastRow = this.table.rowAtPoint(new Point(r.x, r.y + r.height));
            if (lastRow < 0) {
                lastRow = this.table.getRowCount() - 1;
            }
            for (int row = firstRow; row <= lastRow; ++row) {
                this.paintRow(row, g);
            }
        }

        private void paintRow(int row, Graphics g) {
            Rectangle clipRect = g.getClipBounds();
            for (int col = 0; col < this.table.getColumnCount(); ++col) {
                boolean paint;
                Rectangle cellRect = this.table.getCellRect(row, col, true);
                if (!cellRect.intersects(clipRect) || !(paint = this.this$0.getModel().paintCell(this.table.getRowSorter().convertRowIndexToModel(row), col))) continue;
                this.paintCell(row, col, g, cellRect);
            }
        }

        private void paintCell(int row, int column, Graphics g, Rectangle area) {
            int verticalMargin = this.table.getRowMargin();
            int horizontalMargin = this.table.getColumnModel().getColumnMargin();
            Color c = g.getColor();
            g.setColor(this.table.getGridColor());
            g.drawRect(area.x, area.y, area.width - 1, area.height - 1);
            g.setColor(c);
            area.setBounds(area.x + horizontalMargin / 2, area.y + verticalMargin / 2, area.width - horizontalMargin, area.height - verticalMargin);
            if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
                Component component = this.table.getEditorComponent();
                component.setBounds(area);
                component.validate();
            } else {
                TableCellRenderer renderer = this.table.getCellRenderer(row, column);
                Component component = this.table.prepareRenderer(renderer, row, column);
                if (component.getParent() == null) {
                    this.rendererPane.add(component);
                }
                this.rendererPane.paintComponent(g, component, this.table, area.x, area.y, area.width, area.height, true);
            }
        }
    }
}

