/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import com.stratadata.model3.taxon.Category;
import com.stratadata.util.ui.SBDialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

public class DialogCategoryOrder
extends SBDialog {
    private JButton jButtonCancel;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOk;
    private JButton jButtonSortList;
    private JList<Category> jListCategories;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogCategoryOrder(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void setCategories(List<Category> categories) {
        DefaultListModel<Category> model = new DefaultListModel<Category>();
        for (Category c : categories) {
            model.addElement(c);
        }
        this.jListCategories.setModel(model);
    }

    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (int i = 0; i < this.jListCategories.getModel().getSize(); ++i) {
            categories.add(this.jListCategories.getModel().getElementAt(i));
        }
        return categories;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListCategories = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonSortList = new JButton();
        this.jButtonOk = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Order Categories");
        this.jListCategories.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListCategories);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategoryOrder this$0;
            {
                DialogCategoryOrder dialogCategoryOrder = this$0;
                Objects.requireNonNull(dialogCategoryOrder);
                this.this$0 = dialogCategoryOrder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move Up");
        this.jButtonMoveUp.setMaximumSize(new Dimension(89, 23));
        this.jButtonMoveUp.setMinimumSize(new Dimension(89, 23));
        this.jButtonMoveUp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategoryOrder this$0;
            {
                DialogCategoryOrder dialogCategoryOrder = this$0;
                Objects.requireNonNull(dialogCategoryOrder);
                this.this$0 = dialogCategoryOrder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move Down");
        this.jButtonMoveDown.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategoryOrder this$0;
            {
                DialogCategoryOrder dialogCategoryOrder = this$0;
                Objects.requireNonNull(dialogCategoryOrder);
                this.this$0 = dialogCategoryOrder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonSortList.setText("Sort");
        this.jButtonSortList.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategoryOrder this$0;
            {
                DialogCategoryOrder dialogCategoryOrder = this$0;
                Objects.requireNonNull(dialogCategoryOrder);
                this.this$0 = dialogCategoryOrder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSortListActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategoryOrder this$0;
            {
                DialogCategoryOrder dialogCategoryOrder = this$0;
                Objects.requireNonNull(dialogCategoryOrder);
                this.this$0 = dialogCategoryOrder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 101, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonMoveDown, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMoveUp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSortList, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonMoveUp, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonSortList)).addComponent(this.jScrollPane1, -1, 149, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private void jButtonSortListActionPerformed(ActionEvent evt) {
        Category selected = null;
        if (!this.jListCategories.isSelectionEmpty()) {
            selected = this.jListCategories.getSelectedValue();
        }
        List<Category> categories = this.getCategories();
        Collections.sort(categories);
        this.setCategories(categories);
        if (selected != null) {
            this.jListCategories.setSelectedValue(selected, true);
        }
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        int index;
        if (!this.jListCategories.isSelectionEmpty() && (index = this.jListCategories.getSelectedIndex()) < this.jListCategories.getModel().getSize() - 1) {
            this.swapListItems(index, index + 1);
            this.jListCategories.setSelectedIndex(index + 1);
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        int index;
        if (!this.jListCategories.isSelectionEmpty() && (index = this.jListCategories.getSelectedIndex()) > 0) {
            this.swapListItems(index - 1, index);
            this.jListCategories.setSelectedIndex(index - 1);
        }
    }

    private void swapListItems(int index1, int index2) {
        if (index1 > index2) {
            this.swapListItems(index2, index1);
            return;
        }
        DefaultListModel model = (DefaultListModel)this.jListCategories.getModel();
        Category cat1 = (Category)model.getElementAt(index1);
        Category cat2 = (Category)model.getElementAt(index2);
        model.removeElementAt(index2);
        model.removeElementAt(index1);
        model.add(index1, cat2);
        model.add(index2, cat1);
    }
}

