/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.PanelType;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.chart.properties.PanelPropertiesTableModel;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.properties.taxon.JTreePTG;
import jsbugs.chart.properties.taxon.PanelTaxonGroupDisplay;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesTableModel;
import jsbugs.uiutil.icon.IconFactory;
import model3.SBRestrictable;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBPermissionException;

public class PanelTaxonPropertiesPanel
extends JPanel
implements PanelTemplate.Listener {
    private static final Logger LOGGER = Logger.getLogger(PanelTaxonPropertiesPanel.class.getName());
    static final String PANEL_ICON_ROOT = "/icon/panel/";
    private PanelTemplate templ;
    private PanelTaxonGroup panel;
    private final PanelTaxonGroupDisplay groupDisplay = new JTreePTG(this);
    private PanelPropertiesTableModel panelPropModel;
    private PanelTaxonPropertiesTableModel panelTaxonModel;
    private final PropertiesTable jTablePTG;
    private final PropertiesTable jTablePanelTaxon;
    private JButton jButtonPTGSave;
    private JButton jButtonPTGRestore;
    private JScrollPane jScrollPanePanelTaxonTab;
    private final JTabbedPane tabbedPanePTG = new JTabbedPane();
    private final JPopupMenu jPopupMenuPanelTaxonOcc = new JPopupMenu();
    private final JMenuItem jMenuItemCopyInnerPanel = new JMenuItem("Copy inner panel");
    private final JMenuItem jMenuItemPasteInnerPanel = new JMenuItem("Paste inner panel");
    private final SBdb sbdb;
    Component parentComponent;
    private PanelTaxonOcc copiedOcc;

    public PanelTaxonPropertiesPanel(Component parent, SBdb sbdb) {
        this.sbdb = sbdb;
        this.parentComponent = parent;
        this.jTablePTG = new PropertiesTable();
        this.jTablePanelTaxon = new PropertiesTable();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createVerticalStrut(4));
        JToolBar toolbar = this.initToolBar();
        this.add(toolbar);
        this.add(Box.createVerticalStrut(6));
        this.initOuterPanelDisplayListeners();
        JScrollPane listPane = new JScrollPane((Component)((Object)this.groupDisplay));
        listPane.setAlignmentX(0.0f);
        this.add(listPane);
        this.add(Box.createVerticalStrut(6));
        this.initTabbedPane();
        this.add(this.tabbedPanePTG);
        this.setPreferredSize(new Dimension(452, 150));
        this.jMenuItemCopyInnerPanel.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.copyOcc();
            }
        });
        this.jPopupMenuPanelTaxonOcc.add(this.jMenuItemCopyInnerPanel);
        this.jMenuItemPasteInnerPanel.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.pasteOcc();
            }
        });
        this.jPopupMenuPanelTaxonOcc.add(this.jMenuItemPasteInnerPanel);
    }

    private JToolBar initToolBar() {
        JToolBar jToolbarPTG = new JToolBar();
        jToolbarPTG.setFloatable(false);
        jToolbarPTG.setBackground(PropertiesTable.TITLE_COLOUR);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem jMenuItemAddPanelTaxon = new JMenuItem("<html><strong>Add taxon inner panel</strong></html>");
        Dimension preferredSize = jMenuItemAddPanelTaxon.getPreferredSize();
        jMenuItemAddPanelTaxon.setIcon(IconFactory.getIcon(PANEL_ICON_ROOT, "pt_taxon.png"));
        jMenuItemAddPanelTaxon.setPreferredSize(new Dimension(jMenuItemAddPanelTaxon.getPreferredSize().width, preferredSize.height));
        jMenuItemAddPanelTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.addTaxonPanel(PanelTaxonType.TAXON);
            }
        });
        JMenuItem jMenuItemAddPanelSamples = new JMenuItem("Add analyses inner panel", IconFactory.getIcon(PANEL_ICON_ROOT, "pt_samples.png"));
        jMenuItemAddPanelSamples.setPreferredSize(new Dimension(jMenuItemAddPanelSamples.getPreferredSize().width, preferredSize.height));
        jMenuItemAddPanelSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.addTaxonPanel(PanelTaxonType.SAMPLES);
            }
        });
        JMenuItem jMenuItemAddPanelDendrogram = new JMenuItem("Add clustering inner panel", IconFactory.getIcon(PANEL_ICON_ROOT, "pt_dendro.png"));
        jMenuItemAddPanelDendrogram.setPreferredSize(new Dimension(jMenuItemAddPanelDendrogram.getPreferredSize().width, preferredSize.height));
        jMenuItemAddPanelDendrogram.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.addTaxonPanel(PanelTaxonType.DENDRO);
            }
        });
        popup.add(jMenuItemAddPanelTaxon);
        popup.add(jMenuItemAddPanelSamples);
        popup.add(jMenuItemAddPanelDendrogram);
        final JToggleButton addButton = new JToggleButton(IconFactory.getIcon("addTaxonPanel.png"));
        addButton.setRolloverIcon(IconFactory.getIcon("addTaxonPanelRollover.png"));
        addButton.setSelectedIcon(IconFactory.getIcon("addTaxonPanelRollover.png"));
        addButton.setToolTipText("Add new inner panel");
        addButton.setFocusable(false);
        addButton.addItemListener(new ItemListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    popup.show(addButton, addButton.getX() - (int)popup.getPreferredSize().getWidth(), addButton.getY());
                }
            }
        });
        popup.addPopupMenuListener(new PopupMenuListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                addButton.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                addButton.setSelected(false);
            }
        });
        UIManager.put("PopupMenu.consureEventOnClose", Boolean.TRUE);
        jToolbarPTG.add(addButton);
        JButton leftButton = new JButton(IconFactory.getIcon("moveTaxonPanelL"));
        leftButton.setToolTipText("Move selected inner panel left");
        leftButton.addActionListener(e -> this.moveTaxonPanel(true));
        JButton rightButton = new JButton(IconFactory.getIcon("moveTaxonPanelR"));
        rightButton.setToolTipText("Move selected inner panel right");
        rightButton.addActionListener(e -> this.moveTaxonPanel(false));
        JButton deleteButton = new JButton(IconFactory.getIcon("deleteTaxonPanel"));
        deleteButton.setToolTipText("Remove selected inner panel");
        deleteButton.addActionListener(e -> this.deleteTaxonPanel());
        for (JButton button : new JButton[]{leftButton, rightButton, deleteButton}) {
            button.setOpaque(false);
            button.setFocusable(false);
            jToolbarPTG.add(button);
        }
        this.jButtonPTGSave = new JButton(IconFactory.getIcon("save24.png"));
        this.jButtonPTGSave.setBackground(jToolbarPTG.getBackground());
        this.jButtonPTGSave.setRolloverIcon(IconFactory.getIcon("save24rollover.png"));
        this.jButtonPTGSave.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PanelTemplate templ = this.this$0.panelPropModel.getPanelTemplate();
                    if (!templ.isEditing()) {
                        assert (false);
                        return;
                    }
                    if (this.this$0.parentComponent instanceof FrameChart && !((FrameChart)this.this$0.parentComponent).checkPanelSave(templ)) {
                        return;
                    }
                    System.out.println("SAVING TEMPLATE: " + String.valueOf(templ));
                    templ.update(this.this$0.sbdb);
                    this.this$0.sbdb.commit();
                    this.this$0.fireTreeNodeChanged(templ);
                    this.this$0.firePanelTaxonSaveButtonChange(templ);
                }
                catch (SQLException | SBPermissionException sql) {
                    FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.this$0.sbdb);
                }
            }
        });
        this.jButtonPTGSave.setBorderPainted(false);
        this.jButtonPTGSave.setVisible(false);
        this.jButtonPTGRestore = new JButton(IconFactory.getIcon("restore24"));
        this.jButtonPTGRestore.setBackground(jToolbarPTG.getBackground());
        this.jButtonPTGRestore.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelTemplate templ = this.this$0.panelPropModel.getPanelTemplate();
                if (!templ.isEditing()) {
                    assert (false);
                    return;
                }
                int option = JOptionPane.showConfirmDialog(this.this$0.parentComponent, "Really discard all changes?", "Restore Saved Properties", 0);
                if (option != 0) {
                    return;
                }
                System.out.println("RESTORING TEMPLATE: " + String.valueOf(templ));
                templ.restoreSavedProperties();
                this.this$0.fireTreeNodeChanged(templ);
                this.this$0.firePanelTaxonSaveButtonChange(templ);
            }
        });
        this.jButtonPTGRestore.setToolTipText("Undo changes");
        this.jButtonPTGRestore.setFocusable(false);
        this.jButtonPTGRestore.setVisible(false);
        this.jButtonPTGRestore.setBorderPainted(false);
        jToolbarPTG.add(Box.createHorizontalGlue());
        jToolbarPTG.add(this.jButtonPTGRestore);
        jToolbarPTG.add(this.jButtonPTGSave);
        jToolbarPTG.setAlignmentX(0.0f);
        return jToolbarPTG;
    }

    private void initTabbedPane() {
        JScrollPane outerTab = new JScrollPane(this.jTablePTG);
        outerTab.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPanePTG.addTab("Outer", outerTab);
        this.panelTaxonModel = new PanelTaxonPropertiesTableModel(this.sbdb, this);
        this.panelTaxonModel.addSaveButtonListener(new ActionListener(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.firePanelTaxonSaveButtonChange(this.this$0.panelTaxonModel.templ);
            }
        });
        this.jTablePanelTaxon.setModel(this.panelTaxonModel);
        this.jScrollPanePanelTaxonTab = new JScrollPane(this.jTablePanelTaxon);
        this.jScrollPanePanelTaxonTab.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPanePTG.setAlignmentX(0.0f);
    }

    private void initOuterPanelDisplayListeners() {
        this.groupDisplay.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PanelTaxonPropertiesPanel this$0;
            {
                PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = this$0;
                Objects.requireNonNull(panelTaxonPropertiesPanel);
                this.this$0 = panelTaxonPropertiesPanel;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.doPTGPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.doPTGPopup(evt);
            }

            private void doPTGPopup(MouseEvent evt) {
                if (!evt.isPopupTrigger()) {
                    return;
                }
                this.this$0.groupDisplay.setSelectedAtLocationOfEvent(evt);
                this.this$0.jMenuItemCopyInnerPanel.setVisible(this.this$0.templ != null && this.this$0.groupDisplay.getSelection() != null);
                this.this$0.jMenuItemPasteInnerPanel.setVisible(this.this$0.templ != null && this.this$0.copiedOcc != null);
                this.this$0.jPopupMenuPanelTaxonOcc.show((Component)((Object)this.this$0.groupDisplay), evt.getX(), evt.getY());
            }
        });
        this.groupDisplay.addSelectionListener(this::onDisplaySelectionChanged);
    }

    private void onDisplaySelectionChanged() {
        if (this.groupDisplay.isInitialising()) {
            return;
        }
        PanelTaxonOcc occ = this.groupDisplay.getSelection();
        if (occ != null) {
            if (this.panelPropModel.getPanelTemplate() != null) {
                this.panelTaxonModel.setPanel(occ, this.panelPropModel.getPanelTemplate());
            } else {
                this.panelTaxonModel.setPanel(occ, (PanelTaxonGroup)this.panelPropModel.getPanel());
            }
            this.jTablePanelTaxon.fireTableDataChanged();
            String tabTitle = this.getPanelProperties().getOccCaption(occ);
            int index = this.tabbedPanePTG.indexOfComponent(this.jScrollPanePanelTaxonTab);
            if (index < 0) {
                this.tabbedPanePTG.addTab(tabTitle, occ.getIcon(), this.jScrollPanePanelTaxonTab);
                index = this.tabbedPanePTG.indexOfComponent(this.jScrollPanePanelTaxonTab);
                this.tabbedPanePTG.setSelectedIndex(index);
            } else {
                this.tabbedPanePTG.setTitleAt(index, tabTitle);
                this.tabbedPanePTG.setIconAt(index, occ.getIcon());
            }
        } else {
            this.tabbedPanePTG.remove(this.jScrollPanePanelTaxonTab);
        }
        if (this.panelPropModel.getPanel() != null) {
            ((PanelTaxonGroup)this.panelPropModel.getPanel()).setSelectedPanels(occ);
            Component component = this.parentComponent;
            if (component instanceof FrameChart) {
                FrameChart fc = (FrameChart)component;
                fc.fireChartMightHaveChanged();
            } else {
                this.panelPropModel.getPanel().notifyListeners();
            }
        }
    }

    public PanelTemplate getTempl() {
        return this.templ;
    }

    public PanelTaxonGroup getPanel() {
        return this.panel;
    }

    PanelTaxonGroupProperties getPanelProperties() {
        if (this.templ != null) {
            return (PanelTaxonGroupProperties)this.templ.getEditableProp();
        }
        if (this.panel != null) {
            return (PanelTaxonGroupProperties)this.panel.getProperties();
        }
        return null;
    }

    private void setTemplate(PanelTemplate templ) {
        if (this.templ == templ) {
            FrameChart frameChart;
            ChartPanel p;
            Component component = this.parentComponent;
            if (component instanceof FrameChart && (p = (ChartPanel)(frameChart = (FrameChart)component).getSelectedChart().getSelectedBlock().map(b -> b.getSelectedPanel().orElse(null)).orElse(null)) instanceof PanelTaxonGroup) {
                PanelTaxonGroup panelTaxonGroup = (PanelTaxonGroup)p;
                this.groupDisplay.setSelection(panelTaxonGroup.getSelectedPanel());
            }
            return;
        }
        if (this.templ != null) {
            this.templ.deleteListener(this);
        }
        if (templ == null) {
            this.templ = null;
            this.groupDisplay.initData();
            return;
        }
        if (!PanelType.isTaxonPanel(templ.getType())) {
            throw new IllegalArgumentException("Attempt to set ptg list to non taxon panel");
        }
        this.groupDisplay.clearData();
        this.templ = templ;
        templ.addListener(this);
        this.groupDisplay.initData();
        int index = this.tabbedPanePTG.indexOfComponent(this.jScrollPanePanelTaxonTab);
        if (index > -1) {
            this.tabbedPanePTG.remove(index);
        }
        this.firePanelTaxonSaveButtonChange(templ);
    }

    public boolean hasGroupDisplayViewportWithNoDimensions() {
        JViewport viewport;
        Container container = ((Component)((Object)this.groupDisplay)).getParent();
        return container instanceof JViewport && (viewport = (JViewport)container).getWidth() == 0 && viewport.getHeight() == 0;
    }

    void setPanel(PanelTaxonGroup panel) {
        this.panel = panel;
        assert (this.templ == null);
        this.groupDisplay.initData();
    }

    private void addTaxonPanel(PanelTaxonType type) {
        PanelTaxonOcc newOcc;
        PanelTemplate template = this.panelPropModel.getPanelTemplate();
        if (template != null) {
            if (!template.isTaxonPanelTemplate()) {
                assert (false);
                return;
            }
            if (!this.checkCanWrite(template, true)) {
                return;
            }
            newOcc = template.addInnerPanel(type);
        } else {
            PanelTaxonGroupProperties panelTaxonGroupProp = (PanelTaxonGroupProperties)this.panelPropModel.getPanel().getProperties();
            newOcc = panelTaxonGroupProp.addInnerPanel(this.panelPropModel.getPanel(), type);
            this.panelPropModel.getPanel().setProperties(panelTaxonGroupProp);
            this.groupDisplay.initData();
        }
        this.groupDisplay.setSelectedValue(newOcc);
        this.fireTreeNodeChanged(template);
        this.firePanelTaxonSaveButtonChange(template);
    }

    private void deleteTaxonPanel() {
        PanelTaxonOcc occ = this.groupDisplay.getSelection();
        if (occ == null) {
            return;
        }
        PanelTemplate template = this.panelPropModel.getPanelTemplate();
        if (template != null) {
            if (!template.isTaxonPanelTemplate()) {
                assert (false);
                return;
            }
            if (!this.checkCanWrite(template, true)) {
                return;
            }
            try {
                template.deleteInnerPanel(occ);
                this.tabbedPanePTG.remove(this.jScrollPanePanelTaxonTab);
                this.fireTreeNodeChanged(template);
                this.firePanelTaxonSaveButtonChange(template);
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), "Remove Inner Panel", 2);
            }
        } else {
            PanelTaxonGroup panel = (PanelTaxonGroup)this.panelPropModel.getPanel();
            ((PanelTaxonGroupProperties)panel.getProperties()).removeInnerPanel(this.panelPropModel.getPanel(), occ);
            this.groupDisplay.initData();
            panel.setProperties(panel.getProperties());
            panel.notifyListeners();
        }
    }

    private void moveTaxonPanel(boolean left) {
        PanelTaxonOcc occ = this.groupDisplay.getSelection();
        if (occ == null) {
            return;
        }
        PanelTemplate template = this.panelPropModel.getPanelTemplate();
        if (template != null) {
            if (!template.isTaxonPanelTemplate()) {
                assert (false);
                return;
            }
            if (!this.checkCanWrite(template, true)) {
                return;
            }
            template.moveInnerPanel(occ, left);
            this.fireTreeNodeChanged(template);
            this.firePanelTaxonSaveButtonChange(template);
        } else {
            ((PanelTaxonGroupProperties)this.panelPropModel.getPanel().getProperties()).moveInnerPanel(this.panelPropModel.getPanel(), occ, left);
            this.groupDisplay.initData();
            this.groupDisplay.setSelectedValue(occ);
            ((PanelTaxonGroup)this.panelPropModel.getPanel()).update(null, this.panelPropModel.getPanel().getProperties());
        }
    }

    public void setSelectedValue(PanelTaxonOcc occ) {
        this.groupDisplay.setSelectedValue(occ);
    }

    public void setModelTemplate(PanelPropertiesTableModel panelPropModel, PanelTemplate panelTemplate) {
        this.panelPropModel = panelPropModel;
        this.jTablePTG.setModel(panelPropModel);
        this.setTemplate(panelTemplate);
    }

    public void setPanel(PanelPropertiesTableModel panelPropModel, PanelTaxonGroup panel) {
        this.panelPropModel = panelPropModel;
        this.jTablePTG.setModel(panelPropModel);
        this.setPanel(panel);
    }

    public PropertiesTable getTable() {
        return this.jTablePTG;
    }

    public void stopCellEditing() {
        if (this.jTablePTG.isEditing()) {
            this.jTablePTG.getCellEditor().stopCellEditing();
        }
        if (this.jTablePanelTaxon.isEditing()) {
            this.jTablePanelTaxon.getCellEditor().stopCellEditing();
        }
    }

    public void firePanelTaxonSaveButtonChange(PanelTemplate p) {
        if (p == null) {
            return;
        }
        if (PanelType.isTaxonPanel(p.getType())) {
            this.jButtonPTGSave.setVisible(p.isEditing());
            this.jButtonPTGRestore.setVisible(p.isEditing());
        }
    }

    public JComponent getBalloonTipComponent() {
        return this.tabbedPanePTG;
    }

    JFrame getFrameParent() {
        return (JFrame)this.parentComponent;
    }

    private boolean checkCanWrite(SBRestrictable template, boolean showMessage) {
        try {
            if (!template.canWrite(this.sbdb, null)) {
                if (showMessage) {
                    JOptionPane.showMessageDialog(this.parentComponent, template.getDeniedReason(this.sbdb, "template", false), "Template", 2);
                }
                return false;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return false;
        }
        return true;
    }

    void fireTreeNodeChanged(Object templ) {
        if (this.parentComponent instanceof FrameChart) {
            ((FrameChart)this.parentComponent).fireTreeNodeChanged(templ);
        }
    }

    void repaintList() {
        ((Component)((Object)this.groupDisplay)).repaint();
    }

    public void restoreProperties() {
        this.jButtonPTGRestore.doClick();
    }

    void copyOcc() {
        this.copiedOcc = this.groupDisplay.getSelection();
    }

    void pasteOcc() {
        if (this.getTempl() == null) {
            return;
        }
        if (this.copiedOcc == null) {
            return;
        }
        PanelTaxonOcc newOcc = this.getTempl().addTaxonPanelCopy(this.copiedOcc);
        this.groupDisplay.setSelectedValue(newOcc);
        this.fireTreeNodeChanged(this.getTempl());
        this.firePanelTaxonSaveButtonChange(this.getTempl());
    }

    public void update() {
        PanelTaxonOcc selected = this.groupDisplay.getSelection();
        this.groupDisplay.initData();
        this.groupDisplay.setSelection(selected);
    }

    @Override
    public void onTemplateEditingStarted(PanelProperties newEditableProperties) {
        this.update();
    }

    @Override
    public void onTemplateEditingFinished(boolean bln) {
        this.update();
    }

    @Override
    public void onTemplatePropertyChanged(PanelProperties propertiesThatChanged) {
        this.update();
    }

    @Override
    public void onInnerPanelMoved(PanelProperties pp) {
        this.update();
    }
}

