/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonSamplesProperties;
import jsbchart.panel.PanelType;
import jsbchart.util.colour.ColourSpectrum;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.ButtonRendererNoClear;
import jsbugs.table.CaptionEditor;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.ColumnWidthRendererEditor;
import jsbugs.table.ComboRenderer;
import jsbugs.table.CompositeStandardEditor;
import jsbugs.table.EnumEditor;
import jsbugs.table.FloatEditor;
import jsbugs.table.IntegerEditor;
import jsbugs.table.ListEditor;
import jsbugs.table.PanelTaxonOccFilterEditor;
import jsbugs.table.SchemeButtonEditor;
import jsbugs.table.SliderEditor;
import jsbugs.table.SliderRenderer;
import jsbugs.table.SpecTypeCollectionEditor;
import jsbugs.table.SpecTypeRenderer;
import jsbugs.table.SpectrumEditor;
import jsbugs.table.SpectrumRenderer;
import model3.Category;
import model3.CompositeStandard;
import model3.IGDScheme;
import model3.SBdb;
import model3.TxGroup;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;

public class PanelTaxonPropertiesTableModel
extends PropertiesTableModel
implements Observer {
    private final PanelTaxonPropertiesPanel parent;
    PanelTemplate templ;
    private PanelTaxonGroup panel;
    PanelTaxonOcc ptOcc;
    private static final int ROW_T1 = 0;
    private static final int ROW_CAPTION = 1;
    private static final int ROW_FILTER = 2;
    private static final int ROW_SUBCATS = 3;
    private static final int ROW_ISDEFAULT = 4;
    private static final int ROW_OVERPLOT = 5;
    private static final int MAXPANELOCCROWS = 6;
    private final HashMap<Class<?>, TableCellRenderer> renderers = new HashMap();
    private final HashMap<Class<?>, TableCellEditor> editors = new HashMap();
    private final ArrayList<ActionListener> saveButtonListeners = new ArrayList();

    PanelTaxonPropertiesTableModel(SBdb sbdb, PanelTaxonPropertiesPanel parent) {
        super(sbdb);
        this.parent = parent;
        this.initRendererEditors();
    }

    boolean setPanel(PanelTaxonOcc ptOcc, PanelTemplate templ) {
        if (ptOcc != this.ptOcc) {
            if (!PanelType.isTaxonPanel(templ.getType())) {
                throw new IllegalArgumentException("Attempt to set wrong panel type on PanelTaxonPropertiesTableModel");
            }
            this.ptOcc = ptOcc;
            this.setupCompositeStandardEditor();
            if (this.templ != null) {
                templ.deleteObserver(this);
            }
            this.templ = templ;
            this.panel = null;
            templ.addObserver(this);
            return true;
        }
        return false;
    }

    boolean setPanel(PanelTaxonOcc ptOcc, PanelTaxonGroup panel) {
        if (ptOcc != this.ptOcc) {
            if (!PanelType.isTaxonPanel(panel.getPanelType())) {
                throw new IllegalArgumentException("Attempt to set wrong panel type on PanelTaxonPropertiesTableModel");
            }
            this.ptOcc = ptOcc;
            this.setupCompositeStandardEditor();
            if (this.templ != null) {
                this.templ.deleteObserver(this);
            }
            this.templ = null;
            this.panel = panel;
            return true;
        }
        return false;
    }

    private void initRendererEditors() {
        PanelTaxonInputVerifier verifier = new PanelTaxonInputVerifier(this);
        this.renderers.put(CompositeStandard.class, new ComboRenderer("<none>"));
        CompositeStandardEditor compositeStandardEditor = new CompositeStandardEditor(this.sbdb);
        compositeStandardEditor.allowNullValue(true);
        this.editors.put(CompositeStandard.class, compositeStandardEditor);
        this.renderers.put(PanelProperties.ColumnWidth.class, new ColumnWidthRendererEditor());
        this.editors.put(PanelProperties.ColumnWidth.class, new ColumnWidthRendererEditor());
        this.renderers.put(Color.class, new ColourButtonRenderer());
        this.editors.put(Color.class, new ColourChooserEditor());
        this.renderers.put(Boolean.class, new CheckBoxRenderer());
        this.editors.put(Boolean.class, new PanelTaxonCheckBoxEditor(this, verifier));
        this.editors.put(Float.class, new FloatEditor(false));
        this.editors.put(Integer.class, new IntegerEditor(false));
        this.renderers.put(Integer[].class, new SpecTypeRenderer(this.sbdb.getSpeciesTypeService()));
        this.editors.put(Integer[].class, new SpecTypeCollectionEditor(this.parent.getFrameParent(), this.sbdb.getSpeciesTypeService()));
        this.renderers.put(PanelTaxonOcc.Filter.class, new ButtonRenderer("<not restricted>"));
        this.editors.put(PanelTaxonOcc.Filter.class, new PanelTaxonOccFilterEditor(this.parent.getFrameParent(), "<not restricted>", true));
        this.renderers.put(JSlider.class, new SliderRenderer());
        this.editors.put(JSlider.class, new SliderEditor());
        this.renderers.put(PanelTaxonProperties.Abundance.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Abundance.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Abundance.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Group.class, new ComboRenderer());
        JComboBox groupBox = new JComboBox();
        groupBox.setMaximumRowCount(PanelTaxonProperties.Group.values().length);
        this.editors.put(PanelTaxonProperties.Group.class, new PanelTaxonEnumEditor(this, groupBox, PanelTaxonProperties.Group.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.SubGroup.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.SubGroup.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.SubGroup.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Plot.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Plot.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Plot.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Calc.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Calc.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Calc.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Track.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Track.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Track.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Justify.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Justify.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Justify.class, null, verifier));
        this.renderers.put(PanelTaxonProperties.Sort.class, new ComboRenderer());
        this.editors.put(PanelTaxonProperties.Sort.class, new PanelTaxonEnumEditor(this, new JComboBox(), PanelTaxonProperties.Sort.class, null, verifier));
        ButtonRenderer groupRenderer = new ButtonRenderer("<none>");
        groupRenderer.canClear(true);
        this.renderers.put(TxGroup.class, groupRenderer);
        this.editors.put(TxGroup.class, new ListEditor(this.parent.getFrameParent(), "Select Group", new RestrictableProjectListCellRenderer()));
        ButtonRenderer schemeRenderer = new ButtonRenderer("<none>");
        schemeRenderer.canClear(true);
        this.renderers.put(IGDScheme.class, schemeRenderer);
        SchemeButtonEditor schemeEditor = new SchemeButtonEditor(this.parent.getFrameParent(), this.sbdb);
        schemeEditor.renderer.canClear(true);
        this.editors.put(IGDScheme.class, schemeEditor);
        this.renderers.put(CaptionTemplate.class, new ButtonRendererNoClear("<default>"));
        this.editors.put(CaptionTemplate.class, new CaptionEditor(this.parent.getFrameParent()));
        this.renderers.put(PanelTaxonProperties.OccFilter.class, new ComboRenderer("<all>"));
        this.editors.put(PanelTaxonProperties.OccFilter.class, new EnumEditor(new JComboBox(), PanelTaxonProperties.OccFilter.class, "<all>"));
        this.renderers.put(ColourSpectrum.class, new SpectrumRenderer());
        this.editors.put(ColourSpectrum.class, new SpectrumEditor(this.parent.getFrameParent()));
    }

    private PanelTaxonGroupProperties getEditableProp() {
        if (this.templ != null) {
            return (PanelTaxonGroupProperties)this.templ.getEditableProp();
        }
        if (this.panel != null) {
            return (PanelTaxonGroupProperties)this.panel.getProperties();
        }
        return null;
    }

    private void setupCompositeStandardEditor() {
        CompositeStandardEditor cEd = (CompositeStandardEditor)this.editors.get(CompositeStandard.class);
        if (this.ptOcc.getFilter() instanceof CompositeStandard) {
            cEd.filter((CompositeStandard)this.ptOcc.getFilter());
        } else {
            cEd.fill(this.sbdb);
        }
    }

    @Override
    public boolean isTitleRow(int row) {
        if (row == 0) {
            return true;
        }
        return this.getnTitleRow(row) > -1;
    }

    @Override
    public boolean isTitleButtonRow(int row) {
        return false;
    }

    @Override
    public boolean isTitleInnerRow(int row) {
        return this.getnTitleRow(row) > -1;
    }

    private int getnTitleRow(int row) {
        if (row < 6) {
            return -1;
        }
        int[] titleRows = this.ptOcc.getProperties().getTitleRows();
        if (titleRows == null) {
            return -1;
        }
        int titleRow = row - 6;
        for (int i = 0; i < titleRows.length; ++i) {
            if (titleRow != titleRows[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean allowNull(int row) {
        return this.ptOcc.getProperties().allowNull(this.convertRowIndexToPanelProperties(row));
    }

    private int convertRowIndexToPanelProperties(int row) {
        int propRow = row - 6;
        if (this.ptOcc.getProperties().getTitleRows() != null) {
            int nTitles = 0;
            for (int titleRow : this.ptOcc.getProperties().getTitleRows()) {
                if (titleRow > propRow) continue;
                ++nTitles;
            }
            return propRow - nTitles;
        }
        return propRow;
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        return this.renderers.get(this.getCellClass(row, column));
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor ed = this.editors.get(this.getCellClass(row, column));
        if (ed instanceof PanelTaxonOccFilterEditor) {
            Set<Integer> projIDs;
            int projID = 0;
            if (this.templ != null) {
                projID = this.templ.getProjID();
            } else if (this.panel != null && this.panel.getBlock().getWell() != null && !(projIDs = this.panel.getBlock().getWell().getDataModel().getProjIDs(this.panel.getBlock().getWell())).isEmpty()) {
                projID = projIDs.iterator().next();
            }
            ((PanelTaxonOccFilterEditor)ed).setContext(this.getEditableProp().getFilterSet(), this.getEditableProp().getPanelType().getDiscipine(), projID);
        } else if (ed instanceof VerifiedEditor) {
            ((VerifiedEditor)((Object)ed)).setVerifierProp(row, this.ptOcc);
        } else if (ed instanceof ListEditor) {
            try {
                LinkedList<TxGroup> list = new LinkedList<TxGroup>(this.sbdb.getTxGroups(this.templ != null ? Integer.valueOf(this.templ.getProjID()) : null, true));
                Collections.sort(list);
                ((ListEditor)ed).setList(list);
                ((ListEditor)ed).allowNullValue(true);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
        return ed;
    }

    public Class<?> getCellClass(int row, int col) {
        switch (col) {
            default: {
                return this.getColumnClass(col);
            }
            case 1: 
        }
        if (this.isTitleRow(row)) {
            return String.class;
        }
        if (row < 6) {
            return PanelTaxonOcc.getPropertyClass(this.convertRowToPTOccProp(row));
        }
        row = this.convertRowIndexToPanelProperties(row);
        return this.ptOcc.getProperties().getPropertyClass(row);
    }

    @Override
    public int getRowCount() {
        if (this.ptOcc == null || this.ptOcc.getProperties() == null) {
            return 0;
        }
        int titleRows = 0;
        if (this.ptOcc.getProperties().getTitleRows() != null) {
            titleRows = this.ptOcc.getProperties().getTitleRows().length;
        }
        return 6 + this.ptOcc.getProperties().getnProps() + titleRows;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    protected boolean showRow(int row) {
        switch (row) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.ptOcc != null && !(this.ptOcc.getProperties() instanceof PanelTaxonSamplesProperties);
            }
            case 3: {
                return this.ptOcc != null && this.ptOcc.getFilter() != null && this.ptOcc.getFilter() instanceof Category;
            }
            case 4: {
                return !this.ptOcc.isOverplot() && this.getEditableProp().hasOtherPanelsLike(this.ptOcc) && !PanelTaxonGroupProperties.isOverplotBase(this.getEditableProp().getInnerPanels(), this.ptOcc);
            }
            case 5: {
                return this.ptOcc != null && this.ptOcc.getProperties() instanceof PanelTaxonProperties;
            }
        }
        int nTitleRow = this.getnTitleRow(row);
        if (nTitleRow > -1) {
            return true;
        }
        row = this.convertRowIndexToPanelProperties(row);
        return this.ptOcc.getProperties().showRow(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.ptOcc.getProperties() == null) {
            return null;
        }
        if (!this.showRow(row)) {
            return null;
        }
        switch (row) {
            case 0: {
                if (col == 0) {
                    return this.getEditableProp().getOccCaption(this.ptOcc);
                }
            }
            case 1: {
                if (col == 0) {
                    return "Caption";
                }
                return this.ptOcc.getCaption();
            }
            case 2: {
                if (col == 0) {
                    return "Restrict data to";
                }
                return this.ptOcc.getFilterObj();
            }
            case 3: {
                if (col == 0) {
                    return "Include sub-categories";
                }
                return this.ptOcc.getIncludeSubCats();
            }
            case 4: {
                if (col == 0) {
                    return "Link properties";
                }
                return this.ptOcc.isDefault();
            }
            case 5: {
                if (col == 0) {
                    return "Overplot";
                }
                return this.ptOcc.isOverplot();
            }
        }
        int nTitleRow = this.getnTitleRow(row);
        if (nTitleRow > -1) {
            if (col == 0) {
                return this.ptOcc.getProperties().getTitleName(nTitleRow);
            }
            return null;
        }
        row = this.convertRowIndexToPanelProperties(row);
        switch (col) {
            case 0: {
                return this.ptOcc.getProperties().getPropertyName(row);
            }
            case 1: {
                return this.ptOcc.getProperties().getProperty(row);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.parent.getFrameParent() instanceof FrameOrganiser) {
            return false;
        }
        switch (col) {
            default: {
                return false;
            }
            case 1: 
        }
        if (this.isTitleRow(row) || this.getnTitleRow(row) > -1) {
            return false;
        }
        try {
            if (this.ptOcc.isOverplot()) {
                switch (row) {
                    case 2: 
                    case 3: {
                        return this.ptOcc.getProperties().getProperty(12) == PanelTaxonProperties.Group.TOTAL;
                    }
                }
                if (row > 6 && PanelTaxonProperties.isOverplotRow(this.convertRowIndexToPanelProperties(row))) {
                    return false;
                }
            }
            if (this.templ == null) {
                return true;
            }
            if (!this.templ.isVisible() && this.parent.getFrameParent() instanceof FrameChart) {
                if (((FrameChart)this.parent.getFrameParent()).getSelectedChart().getBlockSingle() != null) {
                    BlockTemplate blockTemplate = ((FrameChart)this.parent.getFrameParent()).getSelectedChart().getBlockSingle().getTemplate();
                    if (blockTemplate != null && !blockTemplate.canWrite(this.sbdb, null)) {
                        return false;
                    }
                } else if (((FrameChart)this.parent.getFrameParent()).getSelectedChart().getBlocks() != null) {
                    List<ChartBlockBase> chartBlocks = ((FrameChart)this.parent.getFrameParent()).getSelectedChart().getBlocks();
                    for (ChartBlockBase chartBlock : chartBlocks) {
                        BlockTemplate blockTemplate = chartBlock.getTemplate();
                        for (PanelOcc panelOcc : blockTemplate.getPanels()) {
                            if (panelOcc.getPanelID() != this.templ.getID() || blockTemplate.canWrite(this.sbdb, null)) continue;
                            return false;
                        }
                    }
                }
            }
            return this.templ.canWrite(this.sbdb, null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error checking template.canWrite", sql, this.sbdb);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object o, int row, int col) {
        if (col == 0) {
            return;
        }
        try {
            if (row < 6) {
                row = this.convertRowToPTOccProp(row);
                if (this.templ != null) {
                    this.templ.updateInnerPanelProperty(this.ptOcc, true, row, o);
                } else {
                    this.getEditableProp().updateOcc(this.panel, this.ptOcc, row, o);
                    this.parent.repaintList();
                    this.panel.setProperties(this.panel.getProperties());
                }
                if (row == 1 || row == 5) {
                    this.fireTableStructureChanged();
                    this.setupCompositeStandardEditor();
                }
                return;
            }
            row = this.convertRowIndexToPanelProperties(row);
            if (this.templ != null) {
                this.templ.updateInnerPanelProperty(this.ptOcc, false, row, o);
            } else {
                this.ptOcc.getProperties().setProperty(row, o);
                this.panel.doPropertyChangeNotify();
            }
            if (this.ptOcc.getProperties().hasShowRowDependencies(row)) {
                this.fireTableStructureChanged();
            }
        }
        finally {
            if (this.parent.getFrameParent() instanceof FrameChart) {
                ((FrameChart)this.parent.getFrameParent()).fireTreeNodeChanged(this.templ);
            }
            for (ActionListener l : this.saveButtonListeners) {
                l.actionPerformed(null);
            }
        }
    }

    private int convertRowToPTOccProp(int row) {
        int ptOccProp = -1;
        switch (row) {
            case 1: {
                ptOccProp = 0;
                break;
            }
            case 2: {
                ptOccProp = 1;
                break;
            }
            case 3: {
                ptOccProp = 2;
                break;
            }
            case 4: {
                ptOccProp = 3;
                break;
            }
            case 5: {
                ptOccProp = 4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return ptOccProp;
    }

    void addSaveButtonListener(ActionListener listener) {
        this.saveButtonListeners.add(listener);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.templ && arg instanceof PanelProperties) {
            System.out.println("Inner panel model updating...");
            PanelTaxonGroupProperties ptgProp = (PanelTaxonGroupProperties)arg;
            for (PanelTaxonOcc occ : ptgProp.getInnerPanels()) {
                if (occ != this.ptOcc) continue;
                System.out.println("Inner panel: no change to ptOcc");
                return;
            }
            if (this.ptOcc == null) {
                return;
            }
            PanelTaxonOcc ours = this.ptOcc;
            this.ptOcc = null;
            for (PanelTaxonOcc occ : ptgProp.getInnerPanels()) {
                if (!occ.wasCopiedFrom(ours) && !ours.wasCopiedFrom(occ)) continue;
                this.ptOcc = occ;
                System.out.println("Inner panel model ptOcc reset");
                break;
            }
        }
    }

    private static boolean showBalloon(PanelTaxonInputVerifier verifier, JComponent balloontipUnverifiedComp, Object value, JComponent balloontipVerifiedComp) {
        if (verifier != null) {
            if (!verifier.verify(value)) {
                EdgedBalloonStyle style = new EdgedBalloonStyle(new Color(255, 204, 204), Color.BLACK);
                BalloonTip bTip = new BalloonTip(balloontipUnverifiedComp, (JComponent)new JLabel(verifier.getReason()), (BalloonTipStyle)style, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 0, 0, false);
                balloontipUnverifiedComp.setBorder(BorderFactory.createLineBorder(Color.RED));
                TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)3500);
                return false;
            }
            if (verifier.getUpdated() != null) {
                Object updatedText;
                if (verifier.getUpdated().length == 1) {
                    updatedText = verifier.getUpdated()[0];
                } else {
                    updatedText = "<html>";
                    for (String s : verifier.getUpdated()) {
                        updatedText = (String)updatedText + s + "<br>";
                    }
                    updatedText = (String)updatedText + "</html>";
                }
                EdgedBalloonStyle style = new EdgedBalloonStyle(new Color(204, 255, 204), Color.BLACK);
                BalloonTip bTip = new BalloonTip(balloontipVerifiedComp, (JComponent)new JLabel((String)updatedText), (BalloonTipStyle)style, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 0, 0, false);
                TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)5000);
            }
        }
        return true;
    }

    private class PanelTaxonInputVerifier {
        Integer row;
        PanelTaxonOcc ptOcc;
        private String reason;
        private String[] updated;
        final /* synthetic */ PanelTaxonPropertiesTableModel this$0;

        private PanelTaxonInputVerifier(PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel) {
            PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel2 = panelTaxonPropertiesTableModel;
            Objects.requireNonNull(panelTaxonPropertiesTableModel2);
            this.this$0 = panelTaxonPropertiesTableModel2;
            this.row = null;
            this.ptOcc = null;
        }

        void setRow(int row, PanelTaxonOcc occ) {
            this.row = row;
            this.ptOcc = occ;
        }

        String getReason() {
            return this.reason;
        }

        String[] getUpdated() {
            return this.updated;
        }

        public boolean verify(Object o) {
            this.reason = this.this$0.getEditableProp().verifyInnerPanelProperty(this.ptOcc, this.this$0.convertRowIndexToPanelProperties(this.row), o);
            if (this.reason != null) {
                this.updated = null;
                return false;
            }
            this.updated = this.this$0.getEditableProp().getDependentInnerPanelPropertyUpdates(this.ptOcc, this.this$0.convertRowIndexToPanelProperties(this.row), o);
            this.reason = null;
            return true;
        }
    }

    private class PanelTaxonCheckBoxEditor
    extends CheckBoxEditor
    implements VerifiedEditor {
        private final PanelTaxonInputVerifier verifier;
        final /* synthetic */ PanelTaxonPropertiesTableModel this$0;

        PanelTaxonCheckBoxEditor(PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel, PanelTaxonInputVerifier verifier) {
            PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel2 = panelTaxonPropertiesTableModel;
            Objects.requireNonNull(panelTaxonPropertiesTableModel2);
            this.this$0 = panelTaxonPropertiesTableModel2;
            this.verifier = verifier;
        }

        @Override
        public boolean stopCellEditing() {
            this.renderer.panel.setBorder(BorderFactory.createEmptyBorder());
            return super.stopCellEditing();
        }

        @Override
        public void setVerifierProp(int prop, PanelTaxonOcc occ) {
            if (this.verifier != null) {
                this.verifier.setRow(prop, occ);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PanelTaxonPropertiesTableModel.showBalloon(this.verifier, this.renderer.panel, this.renderer.isSelected(), this.this$0.parent.getBalloonTipComponent())) {
                this.renderer.changeSelection();
                return;
            }
            this.fireEditingStopped();
        }
    }

    private class PanelTaxonEnumEditor
    extends EnumEditor
    implements VerifiedEditor {
        private final PanelTaxonInputVerifier verifier;
        final /* synthetic */ PanelTaxonPropertiesTableModel this$0;

        PanelTaxonEnumEditor(PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel, JComboBox combo, Class<? extends Enum> c, String nullValue, PanelTaxonInputVerifier verifier) {
            PanelTaxonPropertiesTableModel panelTaxonPropertiesTableModel2 = panelTaxonPropertiesTableModel;
            Objects.requireNonNull(panelTaxonPropertiesTableModel2);
            this.this$0 = panelTaxonPropertiesTableModel2;
            super(combo, c, nullValue);
            this.verifier = verifier;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.this$0.parent.getBalloonTipComponent() == null) {
                return false;
            }
            if (!PanelTaxonPropertiesTableModel.showBalloon(this.verifier, this.editorComponent, ((JComboBox)this.editorComponent).getSelectedItem(), this.this$0.parent.getBalloonTipComponent())) {
                return false;
            }
            this.editorComponent.setBorder(BorderFactory.createEmptyBorder());
            return super.stopCellEditing();
        }

        @Override
        public void setVerifierProp(int prop, PanelTaxonOcc occ) {
            if (this.verifier != null) {
                this.verifier.setRow(prop, occ);
            }
        }
    }

    private static interface VerifiedEditor {
        public void setVerifierProp(int var1, PanelTaxonOcc var2);
    }
}

