/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.spatial;

import com.stratadata.util.ui.DialogBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsbchart.core.ChartProperties;
import jsbchart.panel.spatial.MapLabelAttribute;
import jsbugs.uiutil.ComboboxItem;
import net.miginfocom.swing.MigLayout;

public class DialogLabelAttributeSelect
extends DialogBase {
    private MapLabelAttribute attribute = null;
    private DefaultListModel<String> listModel = new DefaultListModel();
    private JLabel labelAttributeNames;
    private JScrollPane scrollPane1;
    private JList jListNames;
    private JLabel labelTextSize;
    private JComboBox comboBoxTextSize;

    public DialogLabelAttributeSelect(Window owner, List<String> attributeNames) {
        super(owner);
        this.initComponents();
        this.listModel.addAll(attributeNames);
        this.jListNames.setModel(this.listModel);
        this.jListNames.setSelectionMode(0);
        this.jListNames.addListSelectionListener(e -> this.onSelectionChanged());
        this.setupFontSizeCombobox();
        this.enbaleOkButton(false, "No attribute selected.");
        this.addOkButtonActionListener(this::onOKPress);
    }

    public void setSelectedAttribute(MapLabelAttribute attribute) {
        this.jListNames.setSelectedValue(attribute.getAttributeName(), true);
        for (int i = 0; i < this.comboBoxTextSize.getItemCount(); ++i) {
            ComboboxItem item = (ComboboxItem)this.comboBoxTextSize.getItemAt(i);
            if (item.getValue() != attribute.getFontSize()) continue;
            this.comboBoxTextSize.setSelectedItem(item);
            break;
        }
    }

    private void onSelectionChanged() {
        if (this.jListNames.getSelectedValue() != null) {
            this.enbaleOkButton(true, "");
        } else {
            this.enbaleOkButton(false, "No attribute selected.");
        }
    }

    private void onOKPress(ActionEvent e) {
        String name = (String)this.jListNames.getSelectedValue();
        if (name == null) {
            return;
        }
        ComboboxItem item = (ComboboxItem)this.comboBoxTextSize.getSelectedItem();
        ChartProperties.FontSizeExtended fontSize = (ChartProperties.FontSizeExtended)((Object)item.getValue());
        this.attribute = new MapLabelAttribute(name, fontSize);
        this.returnWithCode(DialogBase.ReturnCode.SUCCESS);
    }

    public MapLabelAttribute getAttribute() {
        return this.attribute;
    }

    private void setupFontSizeCombobox() {
        ArrayList<ComboboxItem<ChartProperties.FontSizeExtended>> options = new ArrayList<ComboboxItem<ChartProperties.FontSizeExtended>>();
        ComboboxItem<ChartProperties.FontSizeExtended> defaultItem = null;
        for (ChartProperties.FontSizeExtended value : ChartProperties.FontSizeExtended.values()) {
            ComboboxItem<ChartProperties.FontSizeExtended> item = new ComboboxItem<ChartProperties.FontSizeExtended>(value, value.toString());
            if (value == ChartProperties.FontSizeExtended.SMALL) {
                defaultItem = item;
            }
            options.add(item);
        }
        ComboboxItem[] optionsArr = options.toArray(new ComboboxItem[0]);
        DefaultComboBoxModel<ComboboxItem> comboBoxModel = new DefaultComboBoxModel<ComboboxItem>(optionsArr);
        comboBoxModel.setSelectedItem(defaultItem);
        this.comboBoxTextSize.setModel(comboBoxModel);
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.labelAttributeNames = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.jListNames = new JList();
        this.labelTextSize = new JLabel();
        this.comboBoxTextSize = new JComboBox();
        this.setTitle(bundle.getString("DialogLabelAttributeSelect.title"));
        this.setMinimumSize(new Dimension(350, 400));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][grow, fill]", "[][grow,fill][]"));
        this.labelAttributeNames.setText(bundle.getString("DialogLabelAttributeSelect.nameList.label"));
        contentPanel.add((Component)this.labelAttributeNames, "cell 0 0 2 1");
        this.scrollPane1.setViewportView(this.jListNames);
        contentPanel.add((Component)this.scrollPane1, "cell 0 1 2 1");
        this.labelTextSize.setText(bundle.getString("DialogLabelAttributeSelect.textSize.label"));
        contentPanel.add((Component)this.labelTextSize, "cell 0 2");
        contentPanel.add((Component)this.comboBoxTextSize, "cell 1 2");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

