/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.spatial;

import com.stratadata.util.ui.SBDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.PanelOcc;
import jsbchart.graphics.FillType;
import jsbchart.graphics.text.MapFill;
import jsbchart.panel.spatial.GraticuleLayer;
import jsbchart.panel.spatial.PolygonLayer;
import jsbugs.chart.StretchyMapBlockPanel;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.ComboRenderer;
import jsbugs.table.FloatEditor;
import jsbugs.table.IntegerEditor;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.jts.geom.Coordinate;
import util.NumberUtils;

public class DialogMapFillSelect
extends SBDialog {
    private static Logger LOGGER = Logger.getLogger(DialogMapFillSelect.class.getName());
    StretchyMapBlockPanel mapBlockPanel = new StretchyMapBlockPanel();
    private PolygonLayer polyLayer = null;
    private MapFillPropertiesTableModel tableModel;

    public DialogMapFillSelect(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.init();
    }

    private void init() {
        this.setTitle("Select fill");
        this.setupMapBlockPanel();
        this.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)this.mapBlockPanel, "Center");
        PropertiesTable table = new PropertiesTable();
        this.tableModel = new MapFillPropertiesTableModel(this, SbugsSession.getDb());
        this.tableModel.setProperties(this.polyLayer.getFill());
        table.setModel(this.tableModel);
        this.tableModel.addTableModelListener(e -> this.tableDataChanged());
        innerPanel.add((Component)table, "South");
        this.add(innerPanel, "Center");
        this.add(this.buildButtonPanel(), "South");
        this.pack();
    }

    public void setFill(MapFill fill) {
        this.polyLayer.setFill(fill);
        this.polyLayer.clearCachedLayer();
        try {
            this.mapBlockPanel.getMapBlock().setData(this.mapBlockPanel.getChartProperties());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Exception while updating the dialog map after setting the fill.");
        }
        this.mapBlockPanel.repaint();
        this.tableModel.setProperties(fill);
    }

    private void tableDataChanged() {
        this.polyLayer.getFill().setFillColour(this.tableModel.getFillColour());
        this.polyLayer.getFill().setType(this.tableModel.getFillType());
        this.polyLayer.getFill().setBackgroundColour(this.tableModel.getBackgorundColour());
        this.polyLayer.getFill().setMarkerSize((int)this.tableModel.getMarkerSize());
        this.polyLayer.getFill().setStrokeColour(this.tableModel.getLineColour());
        this.polyLayer.getFill().setStrokeSize(this.tableModel.getLineWidth());
        this.polyLayer.getFill().setMarkerGap((int)this.tableModel.getMargin());
        this.polyLayer.getFill().setMarkerStrokeColour(this.tableModel.getMarkerLineColour());
        this.polyLayer.getFill().setMarkerStrokeSize(this.tableModel.getMarkerLineWidth());
        try {
            this.mapBlockPanel.getMapBlock().clearCachedLayers();
            this.mapBlockPanel.getMapBlock().setData(this.mapBlockPanel.getChartProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.mapBlockPanel.repaint();
    }

    private void setupMapBlockPanel() {
        SBdb sbdb = SbugsSession.getDb();
        try {
            if (sbdb != null) {
                MapBlock block = new MapBlock(sbdb, null, null);
                block.addMember(new GraticuleLayer(null, new PanelOcc(-1), block));
                this.polyLayer = new PolygonLayer(null, new PanelOcc(-1), block);
                this.polyLayer.setCoordinates(new Coordinate[]{new Coordinate(-8.0, 46.0), new Coordinate(-9.0, 63.0), new Coordinate(9.0, 64.0), new Coordinate(8.0, 47.0), new Coordinate(-8.0, 46.0)});
                block.addMember(this.polyLayer);
                block.getProp().setLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
                this.mapBlockPanel.setMapBlock(block);
                block.getProp().setLongMin(-10.0);
                block.getProp().setLongMax(10.0);
                block.getProp().setLatMin(45.0);
                block.getProp().setLatMax(65.0);
                block.setData(this.mapBlockPanel.getChartProperties());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        FlowLayout fl = new FlowLayout(2);
        buttonPanel.setLayout(fl);
        JButton okJButton = new JButton("OK");
        okJButton.addActionListener(e -> this.onOKPress());
        JButton cancelJButton = new JButton("Cancel");
        cancelJButton.addActionListener(e -> this.onCancelPress());
        buttonPanel.add(okJButton);
        buttonPanel.add(cancelJButton);
        return buttonPanel;
    }

    private void onCancelPress() {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void onOKPress() {
        this.setIsOK(true);
        this.setVisible(false);
    }

    public MapFill getFill() {
        return this.polyLayer.getFill();
    }

    private void copyShapefileToTempDirectory(String pathToShapefile) throws IOException {
        File shapeFileDir;
        File shapeFile = new File(pathToShapefile);
        String name = shapeFile.getName();
        File sourceDir = shapeFile.getParentFile();
        String baseName = FilenameUtils.getBaseName((String)name);
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempShapeFileDir = new File(tempDir, "sbugs_shapefiles");
        if (!tempShapeFileDir.exists()) {
            tempShapeFileDir.mkdir();
        }
        if ((shapeFileDir = new File(tempShapeFileDir, baseName)).exists()) {
            File shpFile = new File(shapeFileDir, baseName + ".shp");
            if (shpFile.exists()) {
                LOGGER.log(Level.INFO, "Temporary directory already exists for shapefile: {0}", shapeFileDir.getPath());
                return;
            }
            shapeFileDir.delete();
        }
        shapeFileDir.mkdir();
        FileUtils.copyDirectory((File)sourceDir, (File)shapeFileDir);
    }

    private class MapFillPropertiesTableModel
    extends PropertiesTableModel {
        private String[] propertyNames;
        private Class[] propertyClasses;
        private static final int COL_TEXTURE = 0;
        private static final int COL_FILL_COLOUR = 1;
        private static final int COL_MARKER_SIZE = 2;
        private static final int COL_LINE_COLOUR = 3;
        private static final int COL_LINE_WIDTH = 4;
        private static final int COL_BACKGROUND_COLOUR = 5;
        private static final int COL_MARGIN = 6;
        private static final int COL_MARKER_LINE_COLOUR = 7;
        private static final int COL_MARKER_LINE_WIDTH = 8;
        private FillType texture;
        private Color fillColour;
        private Color markerLineColour;
        private float markerLineWidth;
        private Color lineColour;
        private float lineWidth;
        private Color backgorundColour;
        private float margin;
        private float markerSize;
        final /* synthetic */ DialogMapFillSelect this$0;

        public Color getFillColour() {
            return this.fillColour;
        }

        public FillType getFillType() {
            return this.texture;
        }

        public Color getLineColour() {
            return this.lineColour;
        }

        public float getLineWidth() {
            return this.lineWidth;
        }

        public Color getBackgorundColour() {
            return this.backgorundColour;
        }

        public float getMarkerSize() {
            return this.markerSize;
        }

        public float getMargin() {
            return this.margin;
        }

        public Color getMarkerLineColour() {
            return this.markerLineColour;
        }

        public float getMarkerLineWidth() {
            return this.markerLineWidth;
        }

        public MapFillPropertiesTableModel(DialogMapFillSelect dialogMapFillSelect, SBdb sbdb) {
            DialogMapFillSelect dialogMapFillSelect2 = dialogMapFillSelect;
            Objects.requireNonNull(dialogMapFillSelect2);
            this.this$0 = dialogMapFillSelect2;
            super(sbdb);
            this.propertyNames = new String[]{"Type", "Fill colour", "Marker size", "Line colour", "Line width", "Background", "Margin", "Marker line colour", "Marker line width"};
            this.propertyClasses = new Class[]{String.class, Color.class, Integer.class, Color.class, Double.class, Color.class, Integer.class, Color.class, Float.class};
            this.texture = FillType.CIRCLES;
            this.fillColour = Color.red;
            this.markerLineColour = Color.black;
            this.markerLineWidth = 0.1f;
            this.lineColour = Color.black;
            this.lineWidth = 0.1f;
            this.backgorundColour = Color.green;
            this.margin = 1.0f;
            this.markerSize = 10.0f;
        }

        @Override
        protected boolean isTitleRow(int row) {
            return false;
        }

        @Override
        protected boolean isTitleButtonRow(int row) {
            return false;
        }

        @Override
        protected boolean isTitleInnerRow(int row) {
            return false;
        }

        @Override
        protected boolean allowNull(int row) {
            return false;
        }

        private JComboBox<ComboboxItem<FillType>> buildFillTypeCombo() {
            ArrayList<ComboboxItem<FillType>> options = new ArrayList<ComboboxItem<FillType>>();
            for (FillType value : FillType.values()) {
                ComboboxItem<FillType> item = new ComboboxItem<FillType>(value, value.getDisplayName());
                options.add(item);
            }
            ComboboxItem[] optionsArr = options.toArray(new ComboboxItem[0]);
            DefaultComboBoxModel<ComboboxItem> comboBoxModel = new DefaultComboBoxModel<ComboboxItem>(optionsArr);
            JComboBox<ComboboxItem<FillType>> comboBox = new JComboBox<ComboboxItem<FillType>>(comboBoxModel);
            ComboboxItem selected = null;
            for (ComboboxItem comboboxItem : options) {
                if (comboboxItem.getValue() != this.texture) continue;
                selected = comboboxItem;
                break;
            }
            if (selected != null) {
                comboBox.setSelectedItem(selected);
            }
            return comboBox;
        }

        @Override
        protected TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return null;
            }
            if (column == 1) {
                return switch (row) {
                    case 0 -> new ComboRenderer();
                    case 1, 3 -> new ColourButtonRenderer();
                    case 5 -> {
                        ColourButtonRenderer renderer = new ColourButtonRenderer(true);
                        renderer.setNullString("No background");
                        yield renderer;
                    }
                    case 4 -> null;
                    case 2 -> null;
                    case 7 -> new ColourButtonRenderer();
                    default -> null;
                };
            }
            return null;
        }

        @Override
        protected TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return null;
            }
            if (column == 1) {
                return switch (row) {
                    case 0 -> new DefaultCellEditor(this.buildFillTypeCombo());
                    case 1, 3 -> new ColourChooserEditor();
                    case 5 -> {
                        ColourChooserEditor editor = new ColourChooserEditor(true);
                        editor.setRendererNullString("No background");
                        yield editor;
                    }
                    case 4 -> new FloatEditor(false);
                    case 2 -> new IntegerEditor(false);
                    case 6 -> new IntegerEditor(false);
                    case 8 -> new FloatEditor(false);
                    case 7 -> new ColourChooserEditor();
                    default -> null;
                };
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.propertyNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.propertyNames[rowIndex];
            }
            if (columnIndex == 1) {
                return switch (rowIndex) {
                    case 0 -> this.texture.getDisplayName();
                    case 1 -> this.fillColour;
                    case 3 -> this.lineColour;
                    case 4 -> Float.valueOf(this.lineWidth);
                    case 5 -> this.backgorundColour;
                    case 2 -> Float.valueOf(this.markerSize);
                    case 6 -> Float.valueOf(this.margin);
                    case 7 -> this.markerLineColour;
                    case 8 -> Float.valueOf(this.markerLineWidth);
                    default -> null;
                };
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return;
            }
            switch (rowIndex) {
                case 0: {
                    if (!(value instanceof ComboboxItem)) break;
                    ComboboxItem v = (ComboboxItem)value;
                    this.texture = (FillType)((Object)v.getValue());
                    this.this$0.tableDataChanged();
                    break;
                }
                case 1: {
                    if (!(value instanceof Color)) break;
                    this.fillColour = (Color)value;
                    this.this$0.tableDataChanged();
                    break;
                }
                case 3: {
                    if (!(value instanceof Color)) break;
                    this.lineColour = (Color)value;
                    this.this$0.tableDataChanged();
                    break;
                }
                case 4: {
                    if (NumberUtils.tryParseFloat((String)value.toString()) == null) break;
                    this.lineWidth = Float.parseFloat(value.toString());
                    this.this$0.tableDataChanged();
                    break;
                }
                case 5: {
                    if (value instanceof Color) {
                        this.backgorundColour = (Color)value;
                        this.this$0.tableDataChanged();
                        break;
                    }
                    if (value != null) break;
                    this.backgorundColour = null;
                    this.this$0.tableDataChanged();
                    break;
                }
                case 2: {
                    if (NumberUtils.tryParseInteger((String)value.toString()) == null) break;
                    this.markerSize = Integer.parseInt(value.toString());
                    this.this$0.tableDataChanged();
                    break;
                }
                case 6: {
                    if (NumberUtils.tryParseInteger((String)value.toString()) == null) break;
                    this.margin = Integer.parseInt(value.toString());
                    this.this$0.tableDataChanged();
                    break;
                }
                case 7: {
                    if (!(value instanceof Color)) break;
                    this.markerLineColour = (Color)value;
                    this.this$0.tableDataChanged();
                    break;
                }
                case 8: {
                    if (NumberUtils.tryParseFloat((String)value.toString()) == null) break;
                    this.markerLineWidth = Float.parseFloat(value.toString());
                    this.this$0.tableDataChanged();
                    break;
                }
            }
        }

        public void setProperties(MapFill fill) {
            this.texture = fill.getType();
            this.fillColour = fill.getFillColour();
            this.markerSize = fill.getMarkerSize();
            this.lineColour = fill.getStrokeColour();
            this.lineWidth = fill.getStrokeSize();
            this.backgorundColour = fill.getBackgroundColour();
            this.margin = fill.getMarkerGap();
            this.markerLineWidth = fill.getMarkerStrokeSize();
            this.markerLineColour = fill.getMarkerStrokeColour();
        }
    }
}

