/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.tag;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.tag.ChartTag;
import jsbchart.tag.ChartTagButton;
import jsbugs.ChartJPanel;
import jsbugs.chart.mouse.MouseBehaviourAdapter;

public class ChartTagButtonBehaviour
extends MouseBehaviourAdapter {
    private boolean isCurrent;

    public ChartTagButtonBehaviour(ChartJPanel panel) {
        super(panel);
    }

    @Override
    public boolean isCurrent() {
        return this.isCurrent;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection instanceof ChartTag;
    }

    @Override
    public Cursor getCursor(Point p) {
        return new Cursor(12);
    }

    @Override
    public boolean activeAt(Point pixelPoint) {
        Point2D.Float p = this.panel.getPoint(pixelPoint);
        return this.intersectsSelectedTagButton(p);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        ChartTagButton b = this.getTagButtonAtPoint(p);
        if (b != null) {
            switch (b.getType()) {
                case ADD_POINTER: {
                    Point2D.Float targetPoint = new Point2D.Float((float)(p.getX() - b.getWidth()), (float)(p.getY() - b.getWidth()));
                    this.getSelectedTag().setTarget(targetPoint);
                    this.getSelectedTag().setActive(true);
                    break;
                }
                case REMOVE_POINTER: {
                    this.getSelectedTag().setTarget(null);
                    ChartBlockBase anchor = this.getSelectedTag().getAnchorBlock();
                    if (anchor != null && anchor instanceof MapBlock && !this.getSelectedTag().hasTargetSet()) {
                        this.getSelectedTag().setAnchorBlock(null);
                    }
                    this.getSelectedTag().clearCoords();
                    this.notifyChartChange();
                    break;
                }
                case REMOVE_TAG: {
                    if (this.getSelectedTag() == null) break;
                    this.panel.chart.removeTag(this.getSelectedTag());
                    this.notifyChartChange();
                }
            }
        }
        this.isCurrent = true;
        this.panel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isCurrent = false;
    }

    private boolean intersectsSelectedTagButton(Point2D.Float p) {
        ChartTag t = this.getSelectedTag();
        if (t != null) {
            for (ChartTagButton b : t.getButtons(this.panel.getZoomManager())) {
                if (!b.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    private ChartTagButton getTagButtonAtPoint(Point2D.Float p) {
        ChartTag t = this.getSelectedTag();
        if (t != null) {
            for (ChartTagButton b : t.getButtons(this.panel.getZoomManager())) {
                if (!b.contains(p)) continue;
                return b;
            }
        }
        return null;
    }

    private ChartTag getSelectedTag() {
        for (ChartTag t : this.panel.chart.getTags()) {
            if (!t.isSelected()) continue;
            return t;
        }
        return null;
    }
}

