/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.tag;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.tag.ChartTag;
import jsbchart.tag.ChartTagArtist;
import jsbugs.ChartJPanel;
import jsbugs.chart.mouse.MouseBehaviourAdapter;
import jsbugs.uiutil.JOptionPaneUtils;

public class ChartTagMoveResizeBehaviour
extends MouseBehaviourAdapter {
    private ChartTag activeTag = null;
    private boolean activeTagHasMoved = false;
    private Point2D.Float offset = null;
    private int actionCursor = 0;

    public ChartTagMoveResizeBehaviour(ChartJPanel panel) {
        super(panel);
    }

    @Override
    public boolean isCurrent() {
        return this.activeTag != null;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection instanceof ChartTag;
    }

    @Override
    public Cursor getCursor(Point point) {
        Point2D.Float p = this.panel.getPoint(point);
        ChartTag r = this.getOverlappingRect(p);
        if (r != null) {
            return new Cursor(r.getCursorStyle(p));
        }
        return null;
    }

    @Override
    public boolean activeAt(Point pixelPoint) {
        Point2D.Float p = this.panel.getPoint(pixelPoint);
        ChartTag tagAtPoint = this.getOverlappingRect(p);
        return tagAtPoint != null && tagAtPoint.isSelected();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        ChartTag t = this.getOverlappingRect(p);
        if (t != null && e.getClickCount() == 2 && e.getButton() == 1) {
            String result = JOptionPaneUtils.showEditTextDialog("Annotation text", t.getText());
            if (result != null) {
                t.setText(result);
                this.panel.repaint();
                this.notifyChartChange();
            }
        } else if (t != null) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        ChartTag tagAtPoint = this.getOverlappingRect(p);
        if (tagAtPoint.isSelected()) {
            this.activeTag = tagAtPoint;
            this.activeTagHasMoved = false;
        }
        if (this.activeTag != null) {
            this.actionCursor = this.activeTag.getCursorStyle(p);
            this.offset = new Point2D.Float(p.x - this.activeTag.x, p.y - this.activeTag.y);
        }
        this.panel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.activeTag != null && this.activeTagHasMoved) {
            this.clearAnchorMapBlock();
            this.notifyChartChange();
        }
        this.activeTag = null;
        this.panel.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        if (this.activeTag != null) {
            switch (this.actionCursor) {
                case 13: {
                    this.moveTarget(p);
                    break;
                }
                case 11: {
                    this.resizeTargetE(p);
                    break;
                }
                case 10: {
                    this.resizeTargetW(p);
                    break;
                }
                case 9: {
                    this.resizeTargetS(p);
                    break;
                }
                case 8: {
                    this.resizeTargetN(p);
                    break;
                }
                case 7: {
                    this.resizeTargetN(p);
                    this.resizeTargetE(p);
                    break;
                }
                case 6: {
                    this.resizeTargetN(p);
                    this.resizeTargetW(p);
                    break;
                }
                case 5: {
                    this.resizeTargetS(p);
                    this.resizeTargetE(p);
                    break;
                }
                case 4: {
                    this.resizeTargetS(p);
                    this.resizeTargetW(p);
                    break;
                }
            }
            this.offset.x = p.x - this.activeTag.x;
            this.offset.y = p.y - this.activeTag.y;
            this.clearAnchorMapBlock();
            this.activeTagHasMoved = true;
            this.panel.repaint();
        }
    }

    private void clearAnchorMapBlock() {
        ChartBlockBase anchor = this.activeTag.getAnchorBlock();
        if (anchor != null && anchor instanceof MapBlock && !this.activeTag.hasTargetSet()) {
            this.activeTag.setAnchorBlock(null);
        }
        this.activeTag.clearCoords();
    }

    private void moveTarget(Point2D.Float p) {
        float newX = p.x - this.offset.x;
        if (newX < this.getBounds().x) {
            newX = this.getBounds().x;
        } else if (newX + this.activeTag.width > this.getBounds().x + this.getBounds().width) {
            newX = this.getBounds().x + this.getBounds().width - this.activeTag.width;
        }
        float newY = p.y - this.offset.y;
        if (newY < this.getBounds().y) {
            newY = this.getBounds().y;
        } else if (newY + this.activeTag.height > this.getBounds().y + this.getBounds().height) {
            newY = this.getBounds().y + this.getBounds().height - this.activeTag.height;
        }
        this.activeTag.x = newX;
        this.activeTag.y = newY;
    }

    private void resizeTargetE(Point2D.Float p) {
        float newW;
        float pX = p.x;
        if (p.x > this.getBounds().width + this.getBounds().x) {
            pX = this.getBounds().width + this.getBounds().x;
        }
        if ((newW = pX - this.activeTag.x) < this.activeTag.getMinWidth()) {
            newW = this.activeTag.getMinWidth();
        }
        this.activeTag.width = newW;
    }

    private void resizeTargetW(Point2D.Float p) {
        float newW;
        float newX = p.x;
        if (newX < this.getBounds().x) {
            newX = this.getBounds().x;
        }
        if ((newW = this.activeTag.width + this.activeTag.x - newX) < this.activeTag.getMinWidth()) {
            newX = this.activeTag.width + this.activeTag.x - this.activeTag.getMinWidth();
            newW = this.activeTag.getMinWidth();
        }
        this.activeTag.width = newW;
        this.activeTag.x = newX;
    }

    private void resizeTargetN(Point2D.Float p) {
        float newH;
        float newY = p.y;
        if (newY < this.getBounds().y) {
            newY = this.getBounds().y;
        }
        if ((newH = this.activeTag.height + this.activeTag.y - newY) < this.activeTag.getMinHeight()) {
            newY = this.activeTag.height + this.activeTag.y - this.activeTag.getMinHeight();
            newH = this.activeTag.getMinHeight();
        }
        this.activeTag.y = newY;
        this.activeTag.height = newH;
    }

    private void resizeTargetS(Point2D.Float p) {
        float newH;
        float pY = p.y;
        if (pY > this.getBounds().y + this.getBounds().height) {
            pY = this.getBounds().y + this.getBounds().height;
        }
        if ((newH = pY - this.activeTag.y) < this.activeTag.getMinHeight()) {
            newH = this.activeTag.getMinHeight();
        }
        this.activeTag.height = newH;
    }

    private ChartTag getOverlappingRect(Point2D.Float p) {
        List<ChartTag> tags = new ChartTagArtist().getTagOrderForSelection(this.panel.chart.getTags());
        for (ChartTag t : tags) {
            if (!t.contains(p)) continue;
            return t;
        }
        return null;
    }

    private float getZoom() {
        return this.panel.getZoom();
    }

    private Rectangle2D.Float getBounds() {
        return new Rectangle2D.Float(0.0f, 0.0f, this.getContainerWidth(), this.getContainerHeight());
    }

    private float getContainerHeight() {
        return (float)this.panel.getHeight() / (this.getZoom() * 2.8346457f);
    }

    private float getContainerWidth() {
        return (float)this.panel.getWidth() / (this.getZoom() * 2.8346457f);
    }
}

