/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.tag;

import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.core.ChartProperties;
import jsbchart.tag.ChartTag;
import jsbugs.FrameChart;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import jsbugs.table.FloatEditor;
import jsbugs.table.TextAreaEditor;
import model3.SBdb;

public class ChartTagPropertiesTableModel
extends PropertiesTableModel {
    private static final int ROW_TITLE = 0;
    private static final int ROW_TEXT = 1;
    private static final int ROW_FONT_SIZE = 2;
    private static final int ROW_FILL = 3;
    private static final int ROW_COLOUR_FILL = 4;
    private static final int ROW_COLOUR_LINE = 5;
    private static final int ROW_WEIGHT = 6;
    private static final int N_ROWS = 7;
    private final FrameChart parent;
    private Mode mode = Mode.FULL;
    private final ComboRenderer comboRenderer = new ComboRenderer();
    private final ButtonRenderer buttonRenderer = new ButtonRenderer();
    private final ColourButtonRenderer colourRenderer = new ColourButtonRenderer(true);
    private final CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
    private final EnumEditor fontSizeEditor = new EnumEditor(new JComboBox(), ChartProperties.FontSizeExtended.class, null);
    private final TextAreaEditor textEditor;
    private final ColourChooserEditor colourEditor = new ColourChooserEditor(true);
    private final CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
    private final FloatEditor floatEditor = new FloatEditor(false);
    private ChartTag tag;

    public ChartTagPropertiesTableModel(FrameChart parent, SBdb sbdb) {
        super(sbdb);
        this.parent = parent;
        this.textEditor = new TextAreaEditor(parent);
    }

    public boolean setTag(ChartTag tag) {
        if (this.tag != tag) {
            this.tag = tag;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTitleRow(int row) {
        return row == 0;
    }

    @Override
    protected boolean isTitleButtonRow(int row) {
        return false;
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return false;
    }

    @Override
    protected boolean allowNull(int row) {
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.tag == null) {
            return false;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        if (column != 1) {
            return null;
        }
        return switch (row) {
            case 1 -> this.buttonRenderer;
            case 2 -> this.comboRenderer;
            case 3 -> this.checkBoxRenderer;
            case 4, 5 -> this.colourRenderer;
            default -> null;
        };
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        if (column != 1) {
            return null;
        }
        return switch (row) {
            case 1 -> this.textEditor;
            case 2 -> this.fontSizeEditor;
            case 3 -> this.checkBoxEditor;
            case 4, 5 -> this.colourEditor;
            case 6 -> this.floatEditor;
            default -> null;
        };
    }

    @Override
    public int getRowCount() {
        return 7;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.getTitleAt(row);
        }
        if (this.tag == null) {
            return null;
        }
        return switch (row) {
            case 1 -> this.tag.getText();
            case 2 -> this.tag.getFontSize();
            case 3 -> Boolean.valueOf(this.tag.getProperties().getFillBackground());
            case 4 -> this.tag.getProperties().getFillColour();
            case 5 -> this.tag.getProperties().getLineColour();
            case 6 -> Float.valueOf(this.tag.getProperties().getLineWeight());
            default -> null;
        };
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.tag == null) {
            return;
        }
        switch (row) {
            case 1: {
                this.tag.setText((String)aValue);
                break;
            }
            case 2: {
                this.tag.setFontSize((ChartProperties.FontSizeExtended)((Object)aValue));
                break;
            }
            case 3: {
                this.tag.getProperties().setFillBackground((Boolean)aValue);
                this.fireTableDataChanged();
                break;
            }
            case 4: {
                this.tag.getProperties().setFillColour((Color)aValue);
                break;
            }
            case 5: {
                this.tag.getProperties().setLineColour((Color)aValue);
                break;
            }
            case 6: {
                this.tag.getProperties().setLineWeight(Float.parseFloat((String)aValue));
            }
        }
        this.parent.fireChartMightHaveChanged();
    }

    private String getTitleAt(int row) {
        return switch (row) {
            case 0 -> "Annotation";
            case 1 -> "Text";
            case 2 -> "Font size";
            case 3 -> "Fill background";
            case 4 -> "Fill colour";
            case 5 -> "Line colour";
            case 6 -> "Line weight";
            default -> "";
        };
    }

    @Override
    protected boolean showRow(int row) {
        if (this.tag == null) {
            return true;
        }
        return switch (row) {
            case 0, 1 -> {
                if (this.mode == Mode.FULL) {
                    yield true;
                }
                yield false;
            }
            case 4 -> this.tag.getProperties().getFillBackground();
            default -> true;
        };
    }

    public void setDialogMode() {
        this.mode = Mode.DIALOG;
    }

    private static enum Mode {
        FULL,
        DIALOG;

    }
}

