/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chartgen;

import com.stratadata.util.ui.HelpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartPropertiesFactory;
import jsbchart.core.ChartTemplateBase;
import jsbugs.DialogChartTemplates;
import jsbugs.chart.DialogChartProperties;
import jsbugs.chartgen.ChartGenerationResult;
import jsbugs.chartgen.ChartGenerator;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import model3.project.Project;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import util.exception.StackError;

public class DialogChartGen
extends JDialog {
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private ChartGenerator chartGenerator;
    private static SwingWorker workerTask;
    private static ChartTemplateBase template;
    private static File folder;
    private static Project project;
    private static ChartProperties chartProperties;
    private static final String LASTVAL_KEY_TEMPLATE = "CHTGENTMPL";
    private static final String LASTVAL_KEY_PROJECT = "CHTGENPROJ";
    private static final String LASTVAL_KEY_FOLDER = "CHTGENDIR";
    private static final Logger LOGGER;
    private static DialogChartGen instance;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel jLabel1;
    private JComboBox<String> jComboBoxProject;
    private JLabel jLabel2;
    private JButton jButtonTemplate;
    private JTextField jTextFieldTemplate;
    private JLabel jLabel3;
    private JTextField jTextFieldFile;
    private JButton jButtonFile;
    private JRadioButton jRadioButtonDepth;
    private JRadioButton jRadioButtonAge;
    private JPanel buttonBar;
    private JButton jButtonGenerate;
    private JButton jButtonChartProperties;
    private JPanel hSpacer1;
    private JButton jButtonHelp;
    private JButton jButtonClose;
    private ButtonGroup buttonGroup1;

    public static DialogChartGen getInstance(Frame parent) {
        if (instance == null) {
            instance = new DialogChartGen(parent);
        }
        return instance;
    }

    private DialogChartGen(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Chart Generator");
        try {
            ProjectUtils.loadProjectCombo(SbugsSession.getDb(), this.projectModel, false);
            this.jComboBoxProject.insertItemAt("<select>", 0);
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError("Error loading projects", ex, this);
        }
        this.initProject();
        this.initTemplate();
        this.initFolder();
    }

    private void initProject() {
        if (project == null) {
            try {
                Project proj;
                int projID = Lastval.getInt(SbugsSession.getDb(), LASTVAL_KEY_PROJECT);
                if (projID > 0 && (proj = SbugsSession.getDb().getProject(projID)) != null) {
                    project = proj;
                    this.jComboBoxProject.setSelectedItem((Object)project);
                }
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error loading project pref", sql);
            }
        }
        if (project != null) {
            this.jComboBoxProject.setSelectedItem((Object)project);
        } else {
            this.jComboBoxProject.setSelectedIndex(0);
        }
    }

    private void initTemplate() {
        if (template == null) {
            try {
                int templID = Lastval.getInt(SbugsSession.getDb(), LASTVAL_KEY_TEMPLATE);
                if (templID > 0 && (template = SbugsSession.getSession().getChartManager().getBlockTemplate(templID)) == null) {
                    template = SbugsSession.getSession().getChartManager().getChartTemplate(templID);
                }
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error loading project pref", sql);
            }
        }
        if (template != null) {
            this.jTextFieldTemplate.setText(template.getName());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent e) {
        HelpUtils.openAdminSupport((String)"admin-chartgen.html");
    }

    private void initFolder() {
        if (folder == null) {
            try {
                File file;
                String path = Lastval.getString(SbugsSession.getDb(), LASTVAL_KEY_FOLDER);
                if (!StringUtils.isBlank((CharSequence)path) && (file = new File(path)).exists()) {
                    folder = file;
                }
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error loading project pref", sql);
            }
        }
        if (folder != null) {
            this.jTextFieldFile.setText(folder.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jButtonTemplate = new JButton();
        this.jTextFieldTemplate = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonFile = new JButton();
        this.jRadioButtonDepth = new JRadioButton();
        this.jRadioButtonAge = new JRadioButton();
        this.buttonBar = new JPanel();
        this.jButtonGenerate = new JButton();
        this.jButtonChartProperties = new JButton();
        this.hSpacer1 = new JPanel(null);
        this.jButtonHelp = new JButton();
        this.jButtonClose = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[shrink 0,left][fill][shrink 0,left]", "[][][]unrel[]"));
        this.jLabel1.setText("Project:");
        this.contentPanel.add((Component)this.jLabel1, "cell 0 0,alignx right,growx 0");
        this.jComboBoxProject.setModel(this.projectModel);
        this.contentPanel.add(this.jComboBoxProject, "cell 1 0 2 1");
        this.jLabel2.setText("Template:");
        this.contentPanel.add((Component)this.jLabel2, "cell 0 1");
        this.jButtonTemplate.setText("...");
        this.jButtonTemplate.addActionListener(e -> this.jButtonTemplateActionPerformed(e));
        this.contentPanel.add((Component)this.jButtonTemplate, "cell 2 1");
        this.jTextFieldTemplate.setEditable(false);
        this.jTextFieldTemplate.setBackground(new Color(0xFFFFCC));
        this.contentPanel.add((Component)this.jTextFieldTemplate, "cell 1 1");
        this.jLabel3.setText("Location:");
        this.contentPanel.add((Component)this.jLabel3, "cell 0 2,alignx right,growx 0");
        this.jTextFieldFile.setEditable(false);
        this.jTextFieldFile.setBackground(new Color(0xFFFFCC));
        this.contentPanel.add((Component)this.jTextFieldFile, "cell 1 2");
        this.jButtonFile.setText("...");
        this.jButtonFile.addActionListener(e -> this.jButtonFileActionPerformed(e));
        this.contentPanel.add((Component)this.jButtonFile, "cell 2 2");
        this.jRadioButtonDepth.setSelected(true);
        this.jRadioButtonDepth.setText("Vertical scale is Measured Depth");
        this.contentPanel.add((Component)this.jRadioButtonDepth, "cell 1 3");
        this.jRadioButtonAge.setText("Vertical scale is AGE");
        this.jRadioButtonAge.setToolTipText("Plot charts with a vertical scale of Age, where age ragne is defined by depth/age curve");
        this.contentPanel.add((Component)this.jRadioButtonAge, "cell 1 3");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][grow,fill][fill][fill][fill]", "para[24]"));
        this.jButtonGenerate.setFont(new Font("Tahoma", 1, 11));
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.addActionListener(e -> this.jButtonGenerateActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonGenerate, "cell 2 0,growy");
        this.jButtonChartProperties.setText("Chart properties...");
        this.jButtonChartProperties.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/chartProperties16.png")));
        this.jButtonChartProperties.addActionListener(e -> this.jButtonChartPropertiesActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonChartProperties, "cell 0 0,growy");
        this.buttonBar.add((Component)this.hSpacer1, "cell 1 0");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonHelp, "cell 3 0");
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(e -> this.jButtonCloseActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonClose, "cell 4 0,alignx right,grow 0 100");
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroup1.add(this.jRadioButtonDepth);
        this.buttonGroup1.add(this.jRadioButtonAge);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        instance = null;
        this.dispose();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        if (workerTask != null) {
            return;
        }
        Object pItem = this.jComboBoxProject.getSelectedItem();
        if (pItem instanceof Project) {
            project = (Project)((Object)pItem);
            try {
                Lastval.putInt(SbugsSession.getDb(), LASTVAL_KEY_PROJECT, project.getID());
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error storing project pref", sql);
            }
        } else {
            project = null;
        }
        if (project == null) {
            JOptionPane.showMessageDialog(this, "You must select a project.", this.getTitle(), 2);
            return;
        }
        if (template == null) {
            JOptionPane.showMessageDialog(this, "You must select a template.", this.getTitle(), 2);
            return;
        }
        if (folder == null) {
            JOptionPane.showMessageDialog(this, "You must select a file location.", this.getTitle(), 2);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "This process may take a long time. Existing chart files may be overwritten.\nAre you sure you want to continue?", this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        if (this.chartGenerator == null) {
            this.chartGenerator = new ChartGenerator(SbugsSession.getSession().getChartManager(), SbugsSession.getDb(), folder.getAbsolutePath(), null, this.jRadioButtonAge.isSelected() ? BlockProperties.ScaleType.AGE : BlockProperties.ScaleType.MD);
        } else {
            this.chartGenerator.setFilePath(folder.getAbsolutePath());
            this.chartGenerator.setScaleType(this.jRadioButtonAge.isSelected() ? BlockProperties.ScaleType.AGE : BlockProperties.ScaleType.MD);
        }
        this.chartGenerator.setTemplate(template);
        this.chartGenerator.setProject(project);
        this.chartGenerator.setChartProperties(chartProperties);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.enableButtons(false);
        workerTask = new SwingWorker(this){
            private ChartGenerationResult result;
            final /* synthetic */ DialogChartGen this$0;
            {
                DialogChartGen dialogChartGen = this$0;
                Objects.requireNonNull(dialogChartGen);
                this.this$0 = dialogChartGen;
            }

            public Exception doInBackground() throws Exception {
                try {
                    this.result = this.this$0.chartGenerator.generateCharts();
                    return null;
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            @Override
            protected void done() {
                try {
                    LOGGER.info("Chart generation task complete.");
                    Exception ex = (Exception)this.get();
                    if (ex != null) {
                        LOGGER.log(Level.SEVERE, "Chart generation task threw exception.", ex);
                        StackError.showStackError((String)("Exception from chart generator: " + ex.getMessage()), (Throwable)ex);
                    } else {
                        Object msg = "Chart generation complete. ";
                        msg = this.result.getnCreated() > 0 ? (String)msg + "\n" + this.result.getnCreated() + " new chart PDF" + (this.result.getnCreated() > 1 ? "s" : "") + " created." : (String)msg + "\nNo new charts created. ";
                        msg = this.result.getnUpdated() > 0 ? (String)msg + "\n" + this.result.getnUpdated() + " chart PDF" + (this.result.getnUpdated() > 1 ? "s" : "") + " updated." : (String)msg + "\nNo charts updated. ";
                        if (this.result.getnErrors() > 0) {
                            msg = (String)msg + "\n" + this.result.getnErrors() + " chart PDF" + (this.result.getnErrors() > 1 ? "s were" : " was") + " not created due to error.";
                        }
                        JOptionPane.showMessageDialog(this.this$0, msg, this.this$0.getTitle(), 1);
                    }
                }
                catch (ExecutionException ex) {
                    SbugsExceptionHandler.showStackError("Error generating charts", ex, this.this$0);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Chart generation task interrupted", e);
                }
                finally {
                    workerTask = null;
                    this.this$0.enableButtons(true);
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        workerTask.execute();
    }

    private void enableButtons(boolean enable) {
        this.jButtonGenerate.setEnabled(enable);
        this.jButtonClose.setEnabled(enable);
        this.jButtonFile.setEnabled(enable);
        this.jButtonTemplate.setEnabled(enable);
        this.jComboBoxProject.setEnabled(enable);
        this.jButtonChartProperties.setEnabled(enable);
    }

    private void jButtonTemplateActionPerformed(ActionEvent evt) {
        DialogChartTemplates dialog = new DialogChartTemplates(this, true, SbugsSession.getDb(), SbugsSession.getSession().getChartManager(), BlockType.WELL, (Boolean)false, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            template = dialog.selection.get(0);
            try {
                Lastval.putInt(SbugsSession.getDb(), LASTVAL_KEY_TEMPLATE, template.getID());
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error storing template pref", sql);
            }
        }
        this.jTextFieldTemplate.setText(template != null ? template.getName() : "");
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            folder = fileChooser.getSelectedFile();
            try {
                Lastval.putString(SbugsSession.getDb(), LASTVAL_KEY_FOLDER, folder.getAbsolutePath());
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "Error storing file location pref", sql);
            }
            this.jTextFieldFile.setText(folder.getAbsolutePath());
        }
    }

    private void jButtonChartPropertiesActionPerformed(ActionEvent evt) {
        if (chartProperties == null) {
            chartProperties = ChartPropertiesFactory.newInstance(SbugsSession.getDb());
        }
        DialogChartProperties dialog = new DialogChartProperties(this, true, chartProperties, SbugsSession.getDb());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    static {
        LOGGER = Logger.getLogger(DialogChartGen.class.getName());
    }
}

