/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsbugs.uiutil.DecimalTextField;
import jsbugs.util.UserPrefsHelper;
import util.AgeFormat;
import util.DepthUnits;

public class JPanelSnapRange
extends JPanel {
    public static final String AGE_RANGE = "age range";
    public static final String DEPTH_RANGE = "depth range";
    private static final double DEFAULT_DEPTH_RANGE = 2.0;
    private static final double MAX_DEPTH_RANGE = 1000000.0;
    private static final double DEFAULT_AGE_RANGE = 0.5;
    private AgeFormat ageFormat;
    private char depthUnits;
    private double depthRange;
    private double ageRange;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAgeUnits;
    private JLabel jLabelDistanceUnits;
    private JTextField jTextFieldAgeRange;
    private JTextField jTextFieldDepthRange;

    public JPanelSnapRange() {
        this.initComponents();
    }

    public void setupPanel(UserPrefsHelper prefs, char depthUnits, AgeFormat ageFormat) {
        this.depthUnits = depthUnits;
        this.ageFormat = ageFormat;
        this.jLabelAgeUnits.setText(ageFormat.getDescr());
        this.jLabelDistanceUnits.setText(DepthUnits.getUnits((char)depthUnits).getAbr());
        ((DecimalTextField)this.jTextFieldAgeRange).init(false, 4600.0, ageFormat.getPrecision());
        ((DecimalTextField)this.jTextFieldAgeRange).setDisplayUnitsMultipler(ageFormat.getMultiplyer());
        ((DecimalTextField)this.jTextFieldDepthRange).init(false, 1000000.0, 2);
        if (DepthUnits.getUnits((char)depthUnits) == DepthUnits.F) {
            ((DecimalTextField)this.jTextFieldDepthRange).setDisplayUnitsMultipler(3.280839895013123);
        }
        this.jTextFieldDepthRange.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ JPanelSnapRange this$0;
            {
                JPanelSnapRange jPanelSnapRange = this$0;
                Objects.requireNonNull(jPanelSnapRange);
                this.this$0 = jPanelSnapRange;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.depthRangeChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.depthRangeChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.depthRangeChanged();
            }
        });
        this.jTextFieldAgeRange.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ JPanelSnapRange this$0;
            {
                JPanelSnapRange jPanelSnapRange = this$0;
                Objects.requireNonNull(jPanelSnapRange);
                this.this$0 = jPanelSnapRange;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.ageRangeChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.ageRangeChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.ageRangeChanged();
            }
        });
        this.setAgeRange(prefs.getLastNodeSnapAgeRange(0.5));
        this.setDepthRange(prefs.getLastNodeSnapDepthRange(2.0));
    }

    public void setAgeRange(double range) {
        ((DecimalTextField)this.jTextFieldAgeRange).setDoubleValue(range, this.ageFormat.getPrecision());
        this.ageRange = range;
    }

    public void setDepthRange(double range) {
        ((DecimalTextField)this.jTextFieldDepthRange).setDoubleValue(range, 2);
        this.depthRange = range;
    }

    private void ageRangeChanged() {
        double newValue;
        double oldValue = this.ageRange;
        this.ageRange = newValue = this.getAgeRange();
        this.firePropertyChange(AGE_RANGE, oldValue, newValue);
    }

    private void depthRangeChanged() {
        double newValue;
        double oldValue = this.depthRange;
        this.depthRange = newValue = this.getDepthRange();
        this.firePropertyChange(DEPTH_RANGE, oldValue, newValue);
    }

    public double getAgeRange() {
        Double result = ((DecimalTextField)this.jTextFieldAgeRange).getDoubleValue();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    public double getDepthRange() {
        Double result = ((DecimalTextField)this.jTextFieldDepthRange).getDoubleValue();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldAgeRange = new DecimalTextField();
        this.jLabelAgeUnits = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldDepthRange = new DecimalTextField();
        this.jLabelDistanceUnits = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, -4, 0, 0));
        this.setLayout(new FlowLayout(0, 4, 0));
        this.jLabel1.setText("Snap within");
        this.jLabel1.setToolTipText("");
        this.add(this.jLabel1);
        this.jTextFieldAgeRange.setColumns(8);
        this.add(this.jTextFieldAgeRange);
        this.jLabelAgeUnits.setText("Ma");
        this.add(this.jLabelAgeUnits);
        this.jLabel2.setText("and");
        this.jLabel2.setToolTipText("");
        this.add(this.jLabel2);
        this.jTextFieldDepthRange.setColumns(6);
        this.jTextFieldDepthRange.setMinimumSize(new Dimension(100, 20));
        this.add(this.jTextFieldDepthRange);
        this.jLabelDistanceUnits.setText("m");
        this.add(this.jLabelDistanceUnits);
    }
}

