/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import com.stratadata.model3.wellinterp.LOCNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbugs.depthage.DepthAgeEventDetails;
import jsbugs.depthage.SnapToEventTableRow;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.WellEvent;
import model3.WellInterp;
import util.AgeFormat;

public class SnapNodeToEventHelper {
    public static double AGE_RANGE_TOLERANCE = 0.001;

    public static List<SnapToEventTableRow> buldRowsList(char units, AgeFormat ageFormat, CompositeStandard cs, WellInterp wellInterp, double depthRange, double ageRange, List<LOCNode> nodes, boolean hideExactMatches) {
        ArrayList<SnapToEventTableRow> rows = new ArrayList<SnapToEventTableRow>();
        if (cs != null) {
            try {
                cs.loadEvents();
            }
            catch (SQLException ex) {
                Logger.getLogger(SnapNodeToEventHelper.class.getName()).log(Level.SEVERE, "Error loading events from composite standard", ex);
            }
            if (cs.getEvents(true) != null) {
                List<DepthAgeEventDetails> events = SnapNodeToEventHelper.findMatchingEvents(cs, wellInterp);
                Collections.sort(nodes, new Comparator<LOCNode>(){

                    @Override
                    public int compare(LOCNode o1, LOCNode o2) {
                        int result = Double.compare(o1.getDepth(), o2.getDepth());
                        if (result == 0) {
                            result = Double.compare(o1.getAge(), o2.getAge());
                        }
                        return result;
                    }
                });
                for (int i = 0; i < nodes.size(); ++i) {
                    LOCNode node = nodes.get(i);
                    LOCNode lastNode = null;
                    if (i > 0) {
                        lastNode = nodes.get(i - 1);
                    }
                    LOCNode nextNode = null;
                    if (i < nodes.size() - 1) {
                        nextNode = nodes.get(i + 1);
                    }
                    for (DepthAgeEventDetails event : events) {
                        if (hideExactMatches && node.getDepth() == event.getDepth() && SnapNodeToEventHelper.areWithinRange(node.getAge(), event.getAge(), AGE_RANGE_TOLERANCE) || lastNode != null && event.getDepth() <= lastNode.getDepth() || nextNode != null && event.getDepth() >= nextNode.getDepth() || !SnapNodeToEventHelper.areWithinRange(node.getDepth(), event.getDepth(), depthRange) || !SnapNodeToEventHelper.areWithinRange(node.getAge(), event.getAge(), ageRange)) continue;
                        rows.add(new SnapToEventTableRow(units, ageFormat, node.getDepth(), node.getAge(), node.getBnd(), event));
                    }
                }
            }
        }
        return rows;
    }

    public static int findNumberOfMatchingEvents(CompositeStandard cs, WellInterp wellInterp) {
        return SnapNodeToEventHelper.findMatchingEvents(cs, wellInterp).size();
    }

    public static List<DepthAgeEventDetails> findMatchingEvents(CompositeStandard cs, WellInterp wellInterp) {
        ArrayList<DepthAgeEventDetails> matched = new ArrayList<DepthAgeEventDetails>();
        if (cs != null && cs.getEvents(true) != null) {
            for (CompositeStandardEvent cse : cs.getEvents(true)) {
                int compositeEventId = cse.getEvent().getEvID();
                double compositeEventAge = cs.getAge(cse.getCSU());
                for (WellEvent we : wellInterp.getEvents()) {
                    if (we.getEvent().getEvID() != compositeEventId || cse.getType() != we.getTypeObj()) continue;
                    double eventDepth = we.getSample().getDepth();
                    matched.add(new DepthAgeEventDetails(compositeEventId, we.getEvent().toString(), cse.getType(), eventDepth, compositeEventAge));
                }
            }
        }
        return matched;
    }

    private static boolean areWithinRange(double a, double b, double range) {
        return a <= b + range && a >= b - range;
    }
}

