/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.igdunits;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.igdunits.ISelectedHierProvider;
import jsbugs.igdunits.PanelIGDBuilderLimit;
import jsbugs.uiutil.ColourChooser;
import jsbugs.userconnect.SbugsSession;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;

public class DialogIGDUnitBuilder
extends SBDialog
implements ISelectedHierProvider {
    private final DefaultComboBoxModel modelHier = new DefaultComboBoxModel();
    private IGDScheme scheme;
    private int igdType;
    private IGDUnit.Builder builder;
    private List<IGDUnitBase.Builder> otherBuilders;
    private ColourChooser colourChooser1;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox<String> jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelColour;
    private JLabel jLabelName;
    private JLabel jLabelType;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaComments;
    private JTextField jTextFieldAbbreviation;
    private JTextField jTextFieldName;
    private PanelIGDBuilderLimit panelIGDBuilderLimitOldest;
    private PanelIGDBuilderLimit panelIGDBuilderLimitYoungest;

    public DialogIGDUnitBuilder(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Edit Stratigraphic Unit");
        this.getRootPane().setDefaultButton(this.jButtonOk);
        this.panelIGDBuilderLimitOldest.setLimitName("Oldest:");
        GroupLayout gl = (GroupLayout)this.getContentPane().getLayout();
        gl.linkSize(0, this.jButtonOk, this.jButtonCancel);
        int width = this.panelIGDBuilderLimitYoungest.getFirstLabel().getPreferredSize().width;
        this.panelIGDBuilderLimitOldest.getFirstLabel().setMinimumSize(new Dimension(width, this.panelIGDBuilderLimitOldest.getFirstLabel().getPreferredSize().height));
        this.jLabelName.setMinimumSize(new Dimension(width, this.panelIGDBuilderLimitOldest.getFirstLabel().getPreferredSize().height));
        this.jLabelType.setMinimumSize(new Dimension(width, this.panelIGDBuilderLimitOldest.getFirstLabel().getPreferredSize().height));
        this.jLabelColour.setMinimumSize(new Dimension(width, this.panelIGDBuilderLimitOldest.getFirstLabel().getPreferredSize().height));
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDUnitBuilder this$0;
            {
                DialogIGDUnitBuilder dialogIGDUnitBuilder = this$0;
                Objects.requireNonNull(dialogIGDUnitBuilder);
                this.this$0 = dialogIGDUnitBuilder;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.selectedTypeChanged();
            }
        });
    }

    public void setup(IGDScheme scheme, int igdType, IGDUnit.Builder builder, List<IGDUnitBase.Builder> otherBuilders) {
        this.scheme = scheme;
        this.igdType = igdType;
        this.otherBuilders = otherBuilders;
        this.panelIGDBuilderLimitOldest.setSelectedHierProvider(this);
        this.panelIGDBuilderLimitYoungest.setSelectedHierProvider(this);
        this.setHierCombo();
        this.populateControls(builder, otherBuilders);
    }

    private void populateControls(IGDUnit.Builder builder, List<IGDUnitBase.Builder> otherBuilders) {
        this.jTextFieldName.setText(builder.getName());
        this.jComboBoxType.setSelectedIndex(builder.getHier() - 1);
        this.builder = builder;
        this.jTextFieldAbbreviation.setText(builder.getAbr());
        this.jTextAreaComments.setText(builder.getComments());
        this.colourChooser1.setColour(builder.getColour());
        this.panelIGDBuilderLimitYoungest.setup(this.scheme, builder, otherBuilders, builder.getigdAge(true), builder.u_age_ref);
        this.panelIGDBuilderLimitOldest.setup(this.scheme, builder, otherBuilders, builder.getigdAge(false), builder.l_age_ref);
    }

    private void setHierCombo() {
        this.modelHier.removeAllElements();
        int nHier = IGDIntervalZone.getNHier(this.igdType, true);
        for (int hier = 1; hier <= nHier; ++hier) {
            this.modelHier.addElement(IGDIntervalZone.getHierName(this.igdType, hier));
        }
    }

    public void selectedTypeChanged() {
        this.checkRefUnitHierValue(this.panelIGDBuilderLimitOldest);
        this.checkRefUnitHierValue(this.panelIGDBuilderLimitYoungest);
    }

    public void checkRefUnitHierValue(PanelIGDBuilderLimit panel) {
        if (panel.getRefUnit() != null && this.otherBuilders.contains(panel.getRefUnit()) && panel.getRefUnit() instanceof IGDUnit.Builder) {
            IGDUnit.Builder b = (IGDUnit.Builder)panel.getRefUnit();
            if (this.getSelectedHier() <= b.getHier()) {
                panel.clearRefUnit();
            }
        }
    }

    public IGDUnit.Builder getBuilder() {
        IGDUnit.Builder newBuilder = this.builder == null ? new IGDUnit.Builder(SbugsSession.getDb()) : this.builder;
        newBuilder.name(this.jTextFieldName.getText());
        newBuilder.abr(this.jTextFieldAbbreviation.getText());
        newBuilder.comments(this.jTextAreaComments.getText());
        newBuilder.colour(this.colourChooser1.getColour());
        newBuilder.age(true, this.panelIGDBuilderLimitYoungest.getIGDAge());
        newBuilder.age(false, this.panelIGDBuilderLimitOldest.getIGDAge());
        newBuilder.u_age_ref = this.panelIGDBuilderLimitYoungest.getRefUnit();
        newBuilder.l_age_ref = this.panelIGDBuilderLimitOldest.getRefUnit();
        newBuilder.hier(this.getSelectedHier());
        return newBuilder;
    }

    @Override
    public int getSelectedHier() {
        return this.jComboBoxType.getSelectedIndex() + 1;
    }

    private void initComponents() {
        this.jLabelType = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.panelIGDBuilderLimitYoungest = new PanelIGDBuilderLimit();
        this.panelIGDBuilderLimitOldest = new PanelIGDBuilderLimit();
        this.jLabel1 = new JLabel();
        this.jTextFieldAbbreviation = new JTextField();
        this.jLabelColour = new JLabel();
        this.colourChooser1 = new ColourChooser();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComments = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(470, 240));
        this.jLabelType.setText("Unit type:");
        this.jComboBoxType.setModel(this.modelHier);
        this.jLabelName.setText("Unit name:");
        this.jLabel1.setText("Abbreviation:");
        this.jLabelColour.setText("Colour:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDUnitBuilder this$0;
            {
                DialogIGDUnitBuilder dialogIGDUnitBuilder = this$0;
                Objects.requireNonNull(dialogIGDUnitBuilder);
                this.this$0 = dialogIGDUnitBuilder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDUnitBuilder this$0;
            {
                DialogIGDUnitBuilder dialogIGDUnitBuilder = this$0;
                Objects.requireNonNull(dialogIGDUnitBuilder);
                this.this$0 = dialogIGDUnitBuilder;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Comments:");
        this.jTextAreaComments.setColumns(20);
        this.jTextAreaComments.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComments);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabelColour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colourChooser1, -2, -1, -2).addComponent(this.jScrollPane1)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelIGDBuilderLimitOldest, -1, 502, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelIGDBuilderLimitYoungest, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelType).addGap(18, 18, 18).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldAbbreviation, -2, 130, -2))).addContainerGap()));
        layout.linkSize(0, this.jLabel2, this.jLabelColour);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jTextFieldAbbreviation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelIGDBuilderLimitYoungest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelIGDBuilderLimitOldest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelColour).addComponent(this.colourChooser1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 102, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.jTextFieldName.getText().isEmpty()) {
            validationErrors.add("No name specified.");
        }
        if (this.panelIGDBuilderLimitYoungest.getAge() != null && this.panelIGDBuilderLimitOldest.getAge() != null && this.panelIGDBuilderLimitYoungest.getAge() > this.panelIGDBuilderLimitOldest.getAge()) {
            validationErrors.add("Yougest age is greater than oldest age.");
        }
        if (validationErrors.size() > 0) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Cannot update unit:\n");
            for (String error : validationErrors) {
                errorMessage.append(error).append("\n");
            }
            JOptionPane.showMessageDialog((Component)((Object)this), errorMessage.toString(), this.getTitle(), 2);
        } else {
            this.setIsOK(true);
            this.setVisible(false);
        }
    }
}

