/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.igdunits;

import com.stratadata.model3.scheme.Confidence;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.DialogIGDAge;
import jsbugs.igdunits.ISelectedHierProvider;
import jsbugs.uiutil.DecimalTextField;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.IGDAge;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.IGDUnitClass;

public class PanelIGDBuilderLimit
extends JPanel {
    private final DefaultComboBoxModel<Confidence> modelConfidence1 = new DefaultComboBoxModel<Confidence>(Confidence.values());
    private static final double DELTA = 1.0E-5;
    private IGDUnitClass refUnit;
    private int refPercentage;
    private IGDScheme scheme;
    private IGDUnitClass editingObject;
    private List<IGDUnitBase.Builder> possibleRefUnits;
    private ISelectedHierProvider selectedHierProvider;
    private JButton jButton1;
    private JComboBox<Confidence> jComboBoxConfidence;
    private DecimalTextField jDecimalTextFieldAge;
    private JLabel jLabelConfidence;
    private JLabel jLabelDerived;
    private JLabel jLabelLimitName;
    private JTextField jTextFieldDerived;

    public PanelIGDBuilderLimit() {
        this.initComponents();
        this.jDecimalTextFieldAge.init(false, (Double)Double.MAX_VALUE, 5);
        TextFieldUtils.addChangeListener(this.jDecimalTextFieldAge, new ChangeListener(this){
            final /* synthetic */ PanelIGDBuilderLimit this$0;
            {
                PanelIGDBuilderLimit panelIGDBuilderLimit = this$0;
                Objects.requireNonNull(panelIGDBuilderLimit);
                this.this$0 = panelIGDBuilderLimit;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.decimalAgeValueChanged();
            }
        });
    }

    public void setSelectedHierProvider(ISelectedHierProvider provider) {
        this.selectedHierProvider = provider;
    }

    public void setup(IGDScheme scheme, IGDUnitClass editingObject, List<IGDUnitBase.Builder> possibleRefUnits, IGDAge igdAge, IGDUnitClass refUnit) {
        if (igdAge.getPercent() > 100) {
            throw new IllegalArgumentException("reference percentage can't be above 100%");
        }
        if (igdAge.getPercent() < 0) {
            throw new IllegalArgumentException("reference percentage can't be below 0%");
        }
        this.scheme = scheme;
        this.editingObject = editingObject;
        this.possibleRefUnits = possibleRefUnits;
        this.refPercentage = igdAge.getPercent();
        this.refUnit = refUnit;
        this.jComboBoxConfidence.setSelectedItem(igdAge.getConfidence());
        if (refUnit == null) {
            this.jDecimalTextFieldAge.setDoubleValue(igdAge.getAge());
        } else {
            this.jDecimalTextFieldAge.setDoubleValue(this.calculateRefAge(), 5);
            this.jTextFieldDerived.setText(this.refPercentage + "% " + String.valueOf(refUnit));
        }
    }

    private void decimalAgeValueChanged() {
        if (this.refUnit != null && this.jDecimalTextFieldAge.hasFocus() && (this.jDecimalTextFieldAge.getDoubleValue() == null || Math.abs(this.jDecimalTextFieldAge.getDoubleValue() - this.calculateRefAge()) > 1.0E-5)) {
            this.refUnit = null;
            this.refPercentage = 0;
            this.jTextFieldDerived.setText("");
        }
    }

    private void initComponents() {
        this.jLabelLimitName = new JLabel();
        this.jLabelDerived = new JLabel();
        this.jTextFieldDerived = new JTextField();
        this.jButton1 = new JButton();
        this.jLabelConfidence = new JLabel();
        this.jComboBoxConfidence = new JComboBox();
        this.jDecimalTextFieldAge = new DecimalTextField();
        this.jLabelLimitName.setText("Youngest:");
        this.jLabelDerived.setText("Derived:");
        this.jTextFieldDerived.setEditable(false);
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelIGDBuilderLimit this$0;
            {
                PanelIGDBuilderLimit panelIGDBuilderLimit = this$0;
                Objects.requireNonNull(panelIGDBuilderLimit);
                this.this$0 = panelIGDBuilderLimit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        this.jLabelConfidence.setText("Confidence:");
        this.jComboBoxConfidence.setModel(this.modelConfidence1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelLimitName).addGap(18, 18, 18).addComponent(this.jDecimalTextFieldAge, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDerived).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDerived, -1, 90, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jButton1, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelConfidence).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxConfidence, 0, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxConfidence, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLimitName).addComponent(this.jLabelDerived).addComponent(this.jTextFieldDerived, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jLabelConfidence).addComponent(this.jDecimalTextFieldAge, -2, -1, -2)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        IGDScheme parentScheme = null;
        try {
            if (this.scheme.getParentSchID() > 0) {
                parentScheme = SbugsSession.getDb().getIGDScheme(this.scheme.getParentSchID());
            }
            Window topWindow = SwingUtilities.getWindowAncestor(this);
            List<Object> filteredList = new LinkedList();
            if (this.selectedHierProvider != null) {
                for (IGDUnitBase.Builder b : this.possibleRefUnits) {
                    if (b.getHier() >= this.selectedHierProvider.getSelectedHier()) continue;
                    filteredList.add(b);
                }
            } else {
                filteredList = this.possibleRefUnits;
            }
            DialogIGDAge dialog = new DialogIGDAge(topWindow, true, parentScheme, null, filteredList, this.scheme.getName(), this.refUnit, this.refPercentage, this.editingObject);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                if (dialog.ageRef != null && dialog.ageRef instanceof IGDUnitClass) {
                    this.refUnit = dialog.ageRef;
                    this.refPercentage = dialog.refVal;
                    this.jTextFieldDerived.setText(this.refPercentage + "% " + String.valueOf(dialog.ageRef));
                    this.jDecimalTextFieldAge.setDoubleValue(this.calculateRefAge(), 5);
                } else {
                    if (this.refUnit != null) {
                        this.jDecimalTextFieldAge.setDoubleValue(0.0);
                    }
                    this.clearRefUnit();
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PanelIGDBuilderLimit.class.getName()).log(Level.SEVERE, null, ex);
            SbugsExceptionHandler.showStackError("An error occurred accessing the refferenced unit.", ex);
        }
    }

    public void clearRefUnit() {
        this.jTextFieldDerived.setText("");
        this.refUnit = null;
        this.refPercentage = 0;
    }

    private double calculateRefAge() {
        if (this.refUnit == null || this.refUnit.getUage() == null) {
            return 0.0;
        }
        double age = this.refUnit.getUage();
        return age += (this.refUnit.getLage() - this.refUnit.getUage()) * (this.refPercentage > 0 ? (double)this.refPercentage / 100.0 : 0.0);
    }

    public void setLimitName(String name) {
        this.jLabelLimitName.setText(name);
    }

    public JLabel getFirstLabel() {
        return this.jLabelLimitName;
    }

    public Double getAge() {
        return this.jDecimalTextFieldAge.getDoubleValue();
    }

    IGDAge getIGDAge() {
        IGDAge age;
        Confidence confidence = (Confidence)this.jComboBoxConfidence.getSelectedItem();
        if (this.refUnit == null) {
            age = new IGDAge(this.jDecimalTextFieldAge.getDoubleValue());
            age.setConfidence(confidence);
        } else {
            int unitID = 0;
            if (this.refUnit instanceof IGDUnit) {
                unitID = ((IGDUnit)this.refUnit).getUnitID();
            }
            age = new IGDAge(unitID, this.refPercentage, this.jDecimalTextFieldAge.getDoubleValue(), confidence);
            age.calcAge(this.refUnit);
        }
        return age;
    }

    public IGDUnitClass getRefUnit() {
        return this.refUnit;
    }
}

