/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagestorage;

import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordServiceDbImpl;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.imagestorage.DialogStoreImagePaths;
import jsbugs.imagestorage.DialogStoreImages;
import jsbugs.imagestorage.ImageExportOptions;
import jsbugs.imagestorage.ImageImportOptions;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogManageImages
extends JDialog {
    private static final String STORED_IN_DB_DESC = "New images are currently stored in the database.";
    private static final String STORED_IN_FILES_DESC = "New images are currently stored on the filesystem, with only the paths stored in the database.";
    private static final Logger LOGGER = Logger.getLogger(DialogManageImages.class.getName());
    private final SBdb db;
    private final ImageRecordServiceDbImpl imageRecordService;
    private int nFile = 0;
    private int nDatabase = 0;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClearExternal;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonSelectExternal;
    private JButton jButtonStoreImages;
    private JButton jButtonStorePathsOnly;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JTextArea jTextArea3;
    private JTextArea jTextAreaCurrentStorage;
    private JTextField jTextFieldExternal;
    private JTextField jTextFieldFiles;
    private JTextField jTextFieldStored;

    public DialogManageImages(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        ImageRecordService service = db.getImageRecordService();
        if (!(service instanceof ImageRecordServiceDbImpl)) {
            throw new IllegalStateException("Only implemented for database model");
        }
        this.imageRecordService = (ImageRecordServiceDbImpl)service;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Image Storage Options");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.setCounts();
        this.enableStorageButtons();
        if (this.db.getImageFolder() != null) {
            this.jTextFieldExternal.setText(this.db.getImageFolder());
        }
        this.pack();
    }

    private void enableStorageButtons() {
        if (this.db.storeImage()) {
            this.jTextAreaCurrentStorage.setText(STORED_IN_DB_DESC);
            this.jButtonStoreImages.setEnabled(false);
            this.jButtonStorePathsOnly.setEnabled(true);
        } else {
            this.jTextAreaCurrentStorage.setText(STORED_IN_FILES_DESC);
            this.jButtonStoreImages.setEnabled(true);
            this.jButtonStorePathsOnly.setEnabled(false);
        }
    }

    private void setCounts() throws SQLException {
        this.nFile = this.imageRecordService.getImageCount(false);
        this.nDatabase = this.imageRecordService.getImageCount(true);
        this.jTextFieldFiles.setText("" + this.nFile);
        this.jTextFieldStored.setText("" + this.nDatabase);
    }

    private void tryUpdateCounts() {
        try {
            this.setCounts();
        }
        catch (RuntimeException | SQLException e) {
            LOGGER.log(Level.WARNING, "Error updating image counts", e);
        }
    }

    private void showSuccessDialog() {
        JOptionPane.showMessageDialog(this, "The database image storage setting was successfully changed.", this.getTitle(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImageExport(ImageExportOptions options) {
        boolean exportSuccess = true;
        if (options.shouldAttemptExport()) {
            File folder = options.getExportFolder();
            if (!folder.exists()) {
                JOptionPane.showMessageDialog(this, "Image export failed, the export folder was not found", this.getTitle(), 0);
                exportSuccess = false;
            } else {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.imageRecordService.exportImages(folder, options.shouldUpdatePaths(), this.db.getImageLoader());
                }
                catch (IOException | RuntimeException | SQLException e) {
                    exportSuccess = false;
                    this.db.doRollback();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, e.toString(), this.getTitle(), 0);
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        if (exportSuccess) {
            try {
                this.db.setStoreImage(false);
                this.db.commit();
            }
            catch (RuntimeException | SQLException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
            this.showSuccessDialog();
        }
        this.tryUpdateCounts();
        this.enableStorageButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImageImport(ImageImportOptions options) {
        boolean importSuccessful = true;
        if (options.shouldAttemptImport()) {
            if (options.isImportFolderSet() && !options.getImportFolder().exists()) {
                JOptionPane.showMessageDialog(this, "Image import failed, the import folder specified was not found", this.getTitle(), 0);
                importSuccessful = false;
            } else {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.imageRecordService.importImages(options.getImportFolder());
                }
                catch (IOException | RuntimeException | SQLException e) {
                    SbugsExceptionHandler.showStackError(e, this);
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        if (importSuccessful) {
            try {
                this.db.setStoreImage(true);
                this.db.commit();
            }
            catch (SQLException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
            this.showSuccessDialog();
        }
        this.tryUpdateCounts();
        this.enableStorageButtons();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldStored = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldFiles = new JTextField();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaCurrentStorage = new JTextArea();
        this.jButtonStorePathsOnly = new JButton();
        this.jButtonStoreImages = new JButton();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel3 = new JPanel();
        this.jTextFieldExternal = new JTextField();
        this.jButtonSelectExternal = new JButton();
        this.jButtonClearExternal = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Number of images", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Stored in database:");
        this.jTextFieldStored.setEditable(false);
        this.jTextFieldStored.setText("jTextField1");
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Linked to files:");
        this.jTextFieldFiles.setEditable(false);
        this.jTextFieldFiles.setText("jTextField1");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldFiles).add((Component)this.jTextFieldStored)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldFiles, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldStored, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Storage option", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jScrollPane1.setBorder(null);
        this.jTextAreaCurrentStorage.setEditable(false);
        this.jTextAreaCurrentStorage.setColumns(20);
        this.jTextAreaCurrentStorage.setFont(new Font("Segoe UI", 1, 12));
        this.jTextAreaCurrentStorage.setLineWrap(true);
        this.jTextAreaCurrentStorage.setRows(2);
        this.jTextAreaCurrentStorage.setText("Images are currently stored on the filesystem, with only the paths stored in the database.");
        this.jTextAreaCurrentStorage.setWrapStyleWord(true);
        this.jTextAreaCurrentStorage.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextAreaCurrentStorage);
        this.jButtonStorePathsOnly.setText("Store image paths only (option to export existing images)...");
        this.jButtonStorePathsOnly.setHorizontalAlignment(2);
        this.jButtonStorePathsOnly.setHorizontalTextPosition(2);
        this.jButtonStorePathsOnly.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonStorePathsOnlyActionPerformed(evt);
            }
        });
        this.jButtonStoreImages.setText("Store image data in database (option to import existing images)...");
        this.jButtonStoreImages.setEnabled(false);
        this.jButtonStoreImages.setHorizontalAlignment(2);
        this.jButtonStoreImages.setHorizontalTextPosition(2);
        this.jButtonStoreImages.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonStoreImagesActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Segoe UI", 1, 12));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Warning: changes to these preferences are system-wide, affecting other users! \n\n");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane3.setBorder(null);
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setRows(2);
        this.jTextArea3.setText("These changes may not take effect until each user has restarted their session. Users may experience unpredictable behaviour if they are currently logged on.");
        this.jTextArea3.setWrapStyleWord(true);
        this.jTextArea3.setOpaque(false);
        this.jScrollPane3.setViewportView(this.jTextArea3);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add((Component)this.jScrollPane3).add(1, (Component)this.jTextArea1).add(1, (Component)this.jScrollPane1).add(1, (Component)this.jButtonStorePathsOnly, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonStoreImages, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 43, -2).addPreferredGap(0).add((Component)this.jButtonStorePathsOnly, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonStoreImages).addPreferredGap(1).add((Component)this.jTextArea1, -2, 38, -2).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 52, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "External folder for taxon type images", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldExternal.setEditable(false);
        this.jTextFieldExternal.setBackground(new Color(255, 255, 204));
        this.jTextFieldExternal.setToolTipText("Folder containing \"type\" images, where the filename is prefixed with the species name followed by an underscore");
        this.jButtonSelectExternal.setText("...");
        this.jButtonSelectExternal.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSelectExternal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectExternalActionPerformed(evt);
            }
        });
        this.jButtonClearExternal.setText("Clear");
        this.jButtonClearExternal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogManageImages this$0;
            {
                DialogManageImages dialogManageImages = this$0;
                Objects.requireNonNull(dialogManageImages);
                this.this$0 = dialogManageImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearExternalActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTextFieldExternal).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonClearExternal).addPreferredGap(0).add((Component)this.jButtonSelectExternal, -2, 30, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldExternal, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jButtonSelectExternal).add((Component)this.jButtonClearExternal)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonHelp)).add(19, 19, 19)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmanageimages.html");
    }

    private void jButtonSelectExternalActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            File folder = fileChooser.getSelectedFile();
            try {
                if (!folder.exists()) {
                    int opt = JOptionPane.showConfirmDialog(this, "Folder doesn't exist. Create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        return;
                    }
                    if (!folder.mkdir()) {
                        throw new SBException("Cannot make folder: " + String.valueOf(folder));
                    }
                }
                this.db.putDatabasePref("imagefolder", folder.getPath());
                this.db.setImageFolder(folder.getPath());
                this.db.commit();
                this.jTextFieldExternal.setText(folder.getPath());
            }
            catch (SQLException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
    }

    private void jButtonClearExternalActionPerformed(ActionEvent evt) {
        try {
            this.db.putDatabasePref("imagefolder", "");
            this.db.setImageFolder(null);
            this.db.commit();
            this.jTextFieldExternal.setText("");
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonStorePathsOnlyActionPerformed(ActionEvent evt) {
        if (!this.db.storeImage()) {
            this.enableStorageButtons();
            return;
        }
        DialogStoreImagePaths dialog = new DialogStoreImagePaths((Dialog)this, true);
        dialog.setLocationRelativeTo(this);
        int result = dialog.showDialog();
        ImageExportOptions options = dialog.getOptions();
        dialog.dispose();
        if (result == 0) {
            this.doImageExport(options);
        }
    }

    private void jButtonStoreImagesActionPerformed(ActionEvent evt) {
        if (this.db.storeImage()) {
            this.enableStorageButtons();
            return;
        }
        DialogStoreImages dialog = new DialogStoreImages((Dialog)this, true);
        dialog.setLocationRelativeTo(this);
        int result = dialog.showDialog();
        ImageImportOptions options = dialog.getOptions();
        dialog.dispose();
        if (result == 0) {
            this.doImageImport(options);
        }
    }
}

