/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.io.OrganiserReportSettings;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.util.UserPrefsHelper;
import model3.SBdb;
import model3.Sample;
import model3.Well;

public class DialogOrganiserReport
extends SBDialog {
    private static String TITLE = "Report Options";
    private static String DEFAULT_REPORT_NAME = "report";
    private static Logger log = Logger.getLogger(DialogOrganiserReport.class.getName());
    private static FileNameExtensionFilter[] supportedFileTypes = new FileNameExtensionFilter[]{FileChooserUtils.TEXT_FILTER};
    private UserPrefsHelper prefs;
    private List<Well> wells;
    private JButton jButtonCancel;
    private JButton jButtonFileBrowse;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JList<String> jList1;
    private JPanel jPanel1;
    private JPanel jPanelWarnings;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextFieldFilePath;

    public DialogOrganiserReport(Frame parent, boolean modal, SBdb sbdb, List<Well> wells) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(TITLE);
        this.wells = wells;
        this.prefs = new UserPrefsHelper(sbdb);
        this.setupDefaultPath();
        this.checkWellData();
    }

    private void setupDefaultPath() {
        File f = this.prefs.getLastOrganiserReportFile();
        if (f != null && f.getParent() != null) {
            this.jTextFieldFilePath.setText(f.getParent() + File.separator + this.getSuggestedFileName());
        }
    }

    private void checkWellData() {
        ArrayList<Object> warnings = new ArrayList<Object>();
        try {
            for (Well well : this.wells) {
                if (well.getSamples().isEmpty()) {
                    warnings.add(String.format("The well %s has no samples loaded.", well.getWellName()));
                    continue;
                }
                int total = 0;
                int empty = 0;
                for (Sample s : well.getSamples()) {
                    ++total;
                    if (!s.getAnalysesCopy().isEmpty()) continue;
                    ++empty;
                }
                if (empty != total) continue;
                warnings.add(String.format("There are no analyses present on the %d samples in well %s.", total, well.getWellName()));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error reading well data", e);
            warnings.add("Error reading well data. " + e.getMessage());
        }
        if (warnings.isEmpty()) {
            this.jPanelWarnings.setVisible(false);
        } else {
            this.jList1.removeAll();
            for (String string : warnings) {
                DefaultListModel<String> m = new DefaultListModel<String>();
                m.addElement(string);
                this.jList1.setModel(m);
            }
            this.jPanelWarnings.setVisible(true);
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilePath = new JTextField();
        this.jButtonFileBrowse = new JButton();
        this.jPanelWarnings = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOrganiserReport this$0;
            {
                DialogOrganiserReport dialogOrganiserReport = this$0;
                Objects.requireNonNull(dialogOrganiserReport);
                this.this$0 = dialogOrganiserReport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOrganiserReport this$0;
            {
                DialogOrganiserReport dialogOrganiserReport = this$0;
                Objects.requireNonNull(dialogOrganiserReport);
                this.this$0 = dialogOrganiserReport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File :");
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jButtonFileBrowse.setText("...");
        this.jButtonFileBrowse.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOrganiserReport this$0;
            {
                DialogOrganiserReport dialogOrganiserReport = this$0;
                Objects.requireNonNull(dialogOrganiserReport);
                this.this$0 = dialogOrganiserReport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFileBrowseActionPerformed(evt);
            }
        });
        this.jPanelWarnings.setBorder(BorderFactory.createTitledBorder(null, "Warnings", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jList1.setSelectionMode(0);
        this.jList1.setFocusable(false);
        this.jList1.setVisibleRowCount(3);
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout jPanelWarningsLayout = new GroupLayout(this.jPanelWarnings);
        this.jPanelWarnings.setLayout(jPanelWarningsLayout);
        jPanelWarningsLayout.setHorizontalGroup(jPanelWarningsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelWarningsLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 430, Short.MAX_VALUE)));
        jPanelWarningsLayout.setVerticalGroup(jPanelWarningsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, -1, -2));
        this.jScrollPane2.setBorder(null);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText("This will generate a report on the samples analyses for wells currently loaded into the workspace. Please make sure all the desired data has been loaded into the workspace before generating the report.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelWarnings, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileBrowse))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFilePath, -2, -1, -2).addComponent(this.jButtonFileBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelWarnings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldFilePath.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No file selected.", TITLE, 1);
            return;
        }
        if (!FileOverwriteCheck.checkForFileOverwrite(new File(this.jTextFieldFilePath.getText()), (Component)((Object)this))) {
            return;
        }
        this.prefs.setLastOrganiserReportFile(new File(this.jTextFieldFilePath.getText()));
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonFileBrowseActionPerformed(ActionEvent evt) {
        File f;
        String lastFile = null;
        if (this.prefs.getLastOrganiserReportFile() != null) {
            lastFile = this.prefs.getLastOrganiserReportFile().getPath();
        }
        if ((f = FileChooserUtils.saveAsDialogWithFilters((Component)((Object)this), (String)lastFile, (String)this.getSuggestedFileName(), (FileNameExtensionFilter[])supportedFileTypes)) != null) {
            this.jTextFieldFilePath.setText(f.getPath());
        }
    }

    public OrganiserReportSettings getSelectedSettings() {
        return new OrganiserReportSettings(this.jTextFieldFilePath.getText());
    }

    private String getSuggestedFileName() {
        String suggestedName = this.wells.size() == 1 ? this.wells.get(0).getWellName() : DEFAULT_REPORT_NAME;
        String lastFile = null;
        File f = this.prefs.getLastOrganiserReportFile();
        if (f != null) {
            lastFile = f.getPath();
        }
        String ext = FileChooserUtils.getSelectedExtension((String)lastFile, (FileNameExtensionFilter[])supportedFileTypes);
        return suggestedName + "." + ext;
    }
}

