/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbchart.block.MapBlock;
import jsbugs.ChartExporter;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.util.UserPrefsHelper;
import model3.SBdb;
import util.FilePathUtils;

public class DialogShapefileExport
extends SBDialog {
    private File exportFile;
    private final UserPrefsHelper prefs;
    private final Frame parentFrame;
    private String suggestedChartName = null;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonSetFilePath;
    private JComboBox<ComboboxItem<MapBlock>> jComboBoxMapBlocks;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelButtonPanel;
    private JPanel jPanelFilePath;
    private JPanel jPanelFilePathSpacer;
    private JTextField jTextFieldFilePath;

    public DialogShapefileExport(Frame parent, boolean modal, List<MapBlock> mapBlocks, SBdb sbdb) {
        super(parent, modal);
        this.initComponents();
        this.parentFrame = parent;
        this.prefs = new UserPrefsHelper(sbdb);
        this.setupMapBlockComboBox(mapBlocks);
        this.setTitle("Shapefile Export");
        this.getRootPane().setDefaultButton(this.jButtonCancel);
    }

    public void setSuggestedChartName(String name) {
        this.suggestedChartName = name;
    }

    private void setupMapBlockComboBox(List<MapBlock> mapBlocks) {
        ArrayList<ComboboxItem<MapBlock>> options = new ArrayList<ComboboxItem<MapBlock>>();
        if (mapBlocks.isEmpty()) {
            options.add(new ComboboxItem<MapBlock>(null, "No Version Loaded"));
        } else {
            for (MapBlock block : mapBlocks) {
                options.add(new ComboboxItem<MapBlock>(block, block.toString()));
            }
        }
        this.jComboBoxMapBlocks.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
    }

    public MapBlock getSelectedMapBlock() {
        ComboboxItem item = (ComboboxItem)this.jComboBoxMapBlocks.getSelectedItem();
        return (MapBlock)item.getValue();
    }

    public void setExportFile(File export) {
        this.exportFile = export;
        this.jTextFieldFilePath.setText(this.exportFile.getPath());
    }

    public File getExportFile() {
        return this.exportFile;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanelFilePath = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilePath = new JTextField();
        this.jPanelFilePathSpacer = new JPanel();
        this.jButtonSetFilePath = new JButton();
        this.jPanel3 = new JPanel();
        this.jComboBoxMapBlocks = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jPanelButtonPanel = new JPanel();
        this.jButtonExport = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        this.jPanelFilePath.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.jPanelFilePath.setLayout(new BoxLayout(this.jPanelFilePath, 2));
        this.jLabel1.setText("File :");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.jPanelFilePath.add(this.jLabel1);
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jTextFieldFilePath.setMaximumSize(new Dimension(Integer.MAX_VALUE, 23));
        this.jTextFieldFilePath.setMinimumSize(new Dimension(6, 23));
        this.jPanelFilePath.add(this.jTextFieldFilePath);
        this.jPanelFilePathSpacer.setMaximumSize(new Dimension(4, 10));
        this.jPanelFilePathSpacer.setMinimumSize(new Dimension(4, 10));
        this.jPanelFilePathSpacer.setPreferredSize(new Dimension(4, 10));
        this.jPanelFilePathSpacer.setVerifyInputWhenFocusTarget(false);
        GroupLayout jPanelFilePathSpacerLayout = new GroupLayout(this.jPanelFilePathSpacer);
        this.jPanelFilePathSpacer.setLayout(jPanelFilePathSpacerLayout);
        jPanelFilePathSpacerLayout.setHorizontalGroup(jPanelFilePathSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 4, Short.MAX_VALUE));
        jPanelFilePathSpacerLayout.setVerticalGroup(jPanelFilePathSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanelFilePath.add(this.jPanelFilePathSpacer);
        this.jButtonSetFilePath.setText("...");
        this.jButtonSetFilePath.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogShapefileExport this$0;
            {
                DialogShapefileExport dialogShapefileExport = this$0;
                Objects.requireNonNull(dialogShapefileExport);
                this.this$0 = dialogShapefileExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetFilePathActionPerformed(evt);
            }
        });
        this.jPanelFilePath.add(this.jButtonSetFilePath);
        this.jPanel1.add(this.jPanelFilePath);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Map Block Selection"));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.jComboBoxMapBlocks.setMaximumSize(new Dimension(Short.MAX_VALUE, 22));
        this.jPanel3.add(this.jComboBoxMapBlocks);
        this.jPanel1.add(this.jPanel3);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 311, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel2);
        this.jButtonExport.setText("Export");
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogShapefileExport this$0;
            {
                DialogShapefileExport dialogShapefileExport = this$0;
                Objects.requireNonNull(dialogShapefileExport);
                this.this$0 = dialogShapefileExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogShapefileExport this$0;
            {
                DialogShapefileExport dialogShapefileExport = this$0;
                Objects.requireNonNull(dialogShapefileExport);
                this.this$0 = dialogShapefileExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanelButtonPanelLayout = new GroupLayout(this.jPanelButtonPanel);
        this.jPanelButtonPanel.setLayout(jPanelButtonPanelLayout);
        jPanelButtonPanelLayout.setHorizontalGroup(jPanelButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonPanelLayout.createSequentialGroup().addContainerGap(161, Short.MAX_VALUE).addComponent(this.jButtonExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(0, 0, 0)));
        jPanelButtonPanelLayout.setVerticalGroup(jPanelButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonExport).addComponent(this.jButtonCancel)));
        this.jPanel1.add(this.jPanelButtonPanel);
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void jButtonSetFilePathActionPerformed(ActionEvent evt) {
        this.exportFile = this.showFilePrompt();
        if (this.exportFile != null) {
            this.jTextFieldFilePath.setText(this.exportFile.getPath());
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.exportFile == null) {
            this.exportFile = this.showFilePrompt();
            if (this.exportFile == null) {
                JOptionPane.showMessageDialog(this.parentFrame, "No output file specified.", "Output file required", 2);
                return;
            }
        }
        if (this.getSelectedMapBlock() == null) {
            JOptionPane.showMessageDialog(this.parentFrame, "No map block selected.", "Map block required", 2);
            return;
        }
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private File showFilePrompt() {
        String suggestedName;
        String suggestedPath;
        if (this.exportFile == null) {
            suggestedPath = this.prefs.getLastExportShapefileFile().getPath();
            suggestedName = ChartExporter.getDefaultShapefileExportFileName(this.suggestedChartName, this.getSelectedMapBlock());
        } else {
            suggestedPath = this.exportFile.getPath();
            suggestedName = FilePathUtils.extractFileNameWithoutExtension((String)this.exportFile.getName());
        }
        return FileChooserUtils.saveAsDialogWithFilters((Component)((Object)this), (String)suggestedPath, (String)suggestedName, (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.SHAPFEILE_FILTER});
    }
}

