/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import java.awt.Color;
import java.sql.SQLException;
import java.util.List;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.Well;
import model3.WellInterp;
import util.SBException;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;

public class GridBuilderChronoBathy {
    public Object[][] buildGrid(List<Well> wells, int interpID, char units) throws SBException, SQLException {
        GridSheet gb = new GridSheet();
        gb.setFormat(new CellFormat().setBold(true));
        gb.append(new Object[]{"Well name", "Interval", "Top sample", "Thickness"});
        EnvScheme envScheme = null;
        for (Well well : wells) {
            WellInterp wellInterp = well.getInterp(interpID);
            List<IGDIntervalEnv> envs = wellInterp.getEnvs();
            if (envs.size() <= 0) continue;
            envScheme = envs.get(0).getScheme();
            for (int i = 1; i <= envScheme.getNClasses(); ++i) {
                gb.append(new Object[]{envScheme.getTerm(i)});
            }
        }
        gb.clearFormat();
        for (Well well : wells) {
            char useUnits = units;
            if (useUnits == 'D') {
                useUnits = well.getWellUnits();
            }
            WellInterp wellInterp = well.getInterp(interpID);
            for (IGDIntervalZone zone : wellInterp.getIGDList(3, 0, 2, 8)) {
                gb.addRow();
                gb.append(new Object[]{well.getWellName()});
                Color zoneColour = zone.getUnitColour(true);
                if (zoneColour != null) {
                    gb.appendFormatted(new CellFormat().setFillColour(zoneColour), new Object[]{zone.toString()});
                } else {
                    gb.append(new Object[]{zone.toString()});
                }
                gb.append(new Object[]{zone.getTopSample().toString(useUnits)});
                gb.append(new Object[]{zone.getBaseSample().getDepth(useUnits) - zone.getTopSample().getDepth(useUnits)});
                double zoneTop = zone.getTopSample().getDepth(useUnits);
                double zoneBase = zone.getBaseSample().getDepth(useUnits);
                float[] zoneThickness = null;
                for (IGDIntervalEnv env : wellInterp.getEnvs()) {
                    if (envScheme == null || zoneThickness == null || envScheme.getNClasses() != zoneThickness.length) {
                        envScheme = env.getScheme();
                        zoneThickness = new float[envScheme.getNClasses()];
                    }
                    double envTop = env.getTopSample().getDepth(useUnits);
                    double envBase = env.getBaseSample().getDepth(useUnits);
                    if (envTop < zoneTop) {
                        envTop = zoneTop;
                    }
                    if (envBase > zoneBase) {
                        envBase = zoneBase;
                    }
                    if (!(envTop <= zoneBase) || !(envBase >= zoneTop)) continue;
                    double thickNess = envBase - envTop;
                    for (int i = 1; i <= envScheme.getNClasses(); ++i) {
                        if (env.getUp() != i && env.getUd() != i && env.getLp() != i && env.getLd() != i) continue;
                        int n = i - 1;
                        zoneThickness[n] = (float)((double)zoneThickness[n] + thickNess);
                    }
                }
                if (zoneThickness == null) continue;
                for (int i = 0; i < zoneThickness.length; ++i) {
                    if (zoneThickness[i] > 0.0f) {
                        gb.append(new Object[]{Float.valueOf(zoneThickness[i])});
                        continue;
                    }
                    gb.append();
                }
            }
        }
        return gb.getObjectArray();
    }
}

