/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.gridwriter.CSVExportOptions;

public class JPanelCSVOptions
extends JPanel {
    public static final String DELIMITER = "delimiter";
    public static final String SEPARATOR = "separator";
    private char delimiter = (char)44;
    private char separator = (char)46;
    private JComboBox<String> jComboBoxColumnDelimiter;
    private JComboBox<String> jComboBoxDecimalSymbol;
    private JLabel jLabelColumnDelimiter;
    private JLabel jLabelDecimalSymbol;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public JPanelCSVOptions() {
        this.initComponents();
        this.setDefaults();
    }

    public void setDefaults() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        if (symbols.getDecimalSeparator() == ',') {
            this.jComboBoxDecimalSymbol.setSelectedIndex(1);
            this.delimiter = (char)59;
            this.jComboBoxColumnDelimiter.setSelectedIndex(1);
            this.separator = (char)44;
        } else {
            this.jComboBoxDecimalSymbol.setSelectedIndex(0);
            this.delimiter = (char)44;
            this.jComboBoxColumnDelimiter.setSelectedIndex(0);
            this.separator = (char)46;
        }
    }

    public CSVExportOptions getSelectedOptions() {
        return new CSVExportOptions().setColumnDelimiter(this.getColumnDelimiter()).setDecimalSeparator(this.getDecimalSeparator());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jComboBoxColumnDelimiter.setEnabled(enabled);
        this.jComboBoxDecimalSymbol.setEnabled(enabled);
    }

    public char getColumnDelimiter() {
        switch (this.jComboBoxColumnDelimiter.getSelectedIndex()) {
            case 1: {
                return ';';
            }
            case 2: {
                return '\t';
            }
        }
        return ',';
    }

    public char getDecimalSeparator() {
        switch (this.jComboBoxDecimalSymbol.getSelectedIndex()) {
            case 1: {
                return ',';
            }
        }
        return '.';
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelColumnDelimiter = new JLabel();
        this.jComboBoxColumnDelimiter = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabelDecimalSymbol = new JLabel();
        this.jComboBoxDecimalSymbol = new JComboBox();
        this.setMinimumSize(new Dimension(200, 55));
        this.setPreferredSize(new Dimension(200, 55));
        this.setLayout(new FlowLayout(0));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.jLabelColumnDelimiter.setText("Column Delimiter :");
        this.jLabelColumnDelimiter.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.jLabelColumnDelimiter.setHorizontalTextPosition(2);
        this.jLabelColumnDelimiter.setMaximumSize(new Dimension(100, 14));
        this.jLabelColumnDelimiter.setMinimumSize(new Dimension(100, 14));
        this.jLabelColumnDelimiter.setPreferredSize(new Dimension(135, 14));
        this.jPanel1.add(this.jLabelColumnDelimiter);
        this.jComboBoxColumnDelimiter.setModel(new DefaultComboBoxModel<String>(new String[]{", comma", "; semi-colon", "\\t tab"}));
        this.jComboBoxColumnDelimiter.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCSVOptions this$0;
            {
                JPanelCSVOptions jPanelCSVOptions = this$0;
                Objects.requireNonNull(jPanelCSVOptions);
                this.this$0 = jPanelCSVOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxColumnDelimiterActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxColumnDelimiter);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jLabelDecimalSymbol.setText("Decimal Separator :");
        this.jLabelDecimalSymbol.setHorizontalTextPosition(2);
        this.jLabelDecimalSymbol.setMaximumSize(new Dimension(100, 14));
        this.jLabelDecimalSymbol.setMinimumSize(new Dimension(100, 14));
        this.jLabelDecimalSymbol.setPreferredSize(new Dimension(135, 14));
        this.jPanel2.add(this.jLabelDecimalSymbol);
        this.jComboBoxDecimalSymbol.setModel(new DefaultComboBoxModel<String>(new String[]{". dot", ", comma"}));
        this.jComboBoxDecimalSymbol.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCSVOptions this$0;
            {
                JPanelCSVOptions jPanelCSVOptions = this$0;
                Objects.requireNonNull(jPanelCSVOptions);
                this.this$0 = jPanelCSVOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDecimalSymbolActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jComboBoxDecimalSymbol);
        this.add(this.jPanel2);
    }

    private void jComboBoxColumnDelimiterActionPerformed(ActionEvent evt) {
        char newValue;
        char oldValue = this.delimiter;
        this.delimiter = newValue = this.getColumnDelimiter();
        this.firePropertyChange(DELIMITER, oldValue, newValue);
    }

    private void jComboBoxDecimalSymbolActionPerformed(ActionEvent evt) {
        char newValue;
        char oldValue = this.separator;
        this.separator = newValue = this.getDecimalSeparator();
        this.firePropertyChange(SEPARATOR, oldValue, newValue);
    }
}

