/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import jsbugs.io.analysis.AnalysisOccurrenceCategory;
import jsbugs.io.analysis.TaxonOccurrenceCategory;
import model3.TaxonOcc;

public class OccurrenceCollection {
    private final Map<OccurrenceGroup, List<TaxonOcc>> collection = new HashMap<OccurrenceGroup, List<TaxonOcc>>();
    private final Map<AnalysisOccurrenceCategory, List<TaxonOcc>> analysisTotalOccurrences = new HashMap<AnalysisOccurrenceCategory, List<TaxonOcc>>();
    private final SortedSet<AnalysisOccurrenceCategory> analysisCategories = new TreeSet<AnalysisOccurrenceCategory>();
    private final SortedSet<TaxonOccurrenceCategory> taxonCategories = new TreeSet<TaxonOccurrenceCategory>();

    public SortedSet<AnalysisOccurrenceCategory> getAnalysisCategories() {
        return this.analysisCategories;
    }

    public SortedSet<TaxonOccurrenceCategory> getTaxonCategories() {
        return this.taxonCategories;
    }

    public void addOccurrence(AnalysisOccurrenceCategory analysisCategory, TaxonOccurrenceCategory taxonCategory, TaxonOcc occ) {
        OccurrenceGroup g = new OccurrenceGroup(analysisCategory, taxonCategory);
        this.analysisCategories.add(analysisCategory);
        this.taxonCategories.add(taxonCategory);
        if (!this.collection.containsKey(g)) {
            this.collection.put(g, new ArrayList());
        }
        this.collection.get(g).add(occ);
    }

    public void addAnalysisCategoryToSet(AnalysisOccurrenceCategory analysisCategory) {
        this.analysisCategories.add(analysisCategory);
    }

    void addTaxonCategoryToSet(TaxonOccurrenceCategory taxonCat) {
        this.taxonCategories.add(taxonCat);
    }

    public void setAnalysisTotalOccurrences(AnalysisOccurrenceCategory analysisCategory, List<TaxonOcc> occurrences) {
        this.analysisTotalOccurrences.put(analysisCategory, occurrences);
    }

    public void addAnalysisTotalOccurrences(AnalysisOccurrenceCategory analysisCategory, TaxonOcc occurrence) {
        if (!this.analysisTotalOccurrences.containsKey(analysisCategory)) {
            this.analysisTotalOccurrences.put(analysisCategory, new ArrayList());
        }
        this.analysisTotalOccurrences.get(analysisCategory).add(occurrence);
    }

    public List<TaxonOcc> getAnalysisTotalOccurrences(AnalysisOccurrenceCategory analysisCategory) {
        if (this.analysisTotalOccurrences.containsKey(analysisCategory)) {
            return this.analysisTotalOccurrences.get(analysisCategory);
        }
        return new ArrayList<TaxonOcc>();
    }

    public List<TaxonOcc> getOccurrences(AnalysisOccurrenceCategory analysisCategory, TaxonOccurrenceCategory taxonCategory) {
        OccurrenceGroup g = new OccurrenceGroup(analysisCategory, taxonCategory);
        if (this.collection.containsKey(g)) {
            return this.collection.get(g);
        }
        return new ArrayList<TaxonOcc>();
    }

    static class OccurrenceGroup {
        private TaxonOccurrenceCategory taxonCategory;
        private AnalysisOccurrenceCategory analysisCategory;

        public OccurrenceGroup(AnalysisOccurrenceCategory analysisCategory, TaxonOccurrenceCategory taxonCategory) {
            this.taxonCategory = taxonCategory;
            this.analysisCategory = analysisCategory;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + Objects.hashCode(this.taxonCategory);
            hash = 97 * hash + Objects.hashCode(this.analysisCategory);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OccurrenceGroup other = (OccurrenceGroup)obj;
            if (!Objects.equals(this.taxonCategory, other.taxonCategory)) {
                return false;
            }
            return Objects.equals(this.analysisCategory, other.analysisCategory);
        }

        public TaxonOccurrenceCategory getTaxonCategory() {
            return this.taxonCategory;
        }

        public AnalysisOccurrenceCategory getAnalysisCategory() {
            return this.analysisCategory;
        }
    }
}

