/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.igdxlsworkbook;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbugs.io.igdxlsworkbook.IXLSWorksheetWriter;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import jsbugs.userconnect.ISBSession;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.Well;
import model3.WellInterp;
import util.gridwriter.GridSheet;

public class IGDWorksheetWriterIntervalZone
implements IXLSWorksheetWriter {
    private final String sheetName;
    private final int igdType;
    private int hier = -1;
    private boolean includeDiscipline = false;
    private final ISBSession session;
    private final Logger log = Logger.getLogger(IGDWorksheetWriterIntervalZone.class.getName());
    private final SampleFormatter sampleFormatter;

    public IGDWorksheetWriterIntervalZone(String name, int igdType, SampleFormatter sf, ISBSession session) {
        this.sheetName = name;
        this.igdType = igdType;
        this.sampleFormatter = sf;
        this.session = session;
    }

    public IGDWorksheetWriterIntervalZone setIncludeDiscipline(boolean include) {
        this.includeDiscipline = include;
        return this;
    }

    public IGDWorksheetWriterIntervalZone setHierFilter(int hier) {
        this.hier = hier;
        return this;
    }

    @Override
    public String getName() {
        return this.sheetName;
    }

    @Override
    public boolean hasDataToWrite(Well w, WellInterp interp) {
        for (IGDIntervalZone z : interp.getIGDList(this.igdType)) {
            if (this.hier > 0) {
                if (z.getHier() != this.hier) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeHeader(GridSheet gb) {
        gb.addRow(new Object[]{"Well Name", "Well Code", "Top Depth", "Top Boundary", "Bottom Depth", "Lower Boundary", "Text"});
        if (this.hier <= 0) {
            gb.append(new Object[]{"Level"});
        }
        if (this.includeDiscipline) {
            gb.append(new Object[]{"Discipline"});
        }
    }

    @Override
    public void writeData(GridSheet gb, Well w, WellInterp interp) throws Exception {
        for (IGDIntervalZone zone : interp.getIGDList(this.igdType)) {
            if (this.hier > 0 && zone.getHier() != this.hier) continue;
            gb.addRow(new Object[]{w.getWellName(), w.getWellCode(), this.sampleFormatter.getDepthValue(zone.getTopSample(), w), zone.getTopBnd(), this.sampleFormatter.getDepthValue(zone.getBaseSample(), w), zone.getBaseBnd(), zone.toString()});
            if (this.hier <= 0) {
                gb.append(new Object[]{zone.getHierString()});
            }
            if (!this.includeDiscipline) continue;
            try {
                IGDScheme scheme = this.session.getDB().getIGDScheme(zone.getSchID());
                if (scheme.getDiscipline() != null) {
                    gb.append(new Object[]{scheme.getDiscipline().getAbr(false)});
                    continue;
                }
                gb.append(new Object[]{null});
            }
            catch (SQLException ex) {
                this.log.log(Level.SEVERE, "Exception getting discipline from scheme.", ex);
            }
        }
    }
}

