/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.igdxlsworkbook;

import jsbugs.io.igdxlsworkbook.IXLSWorksheetWriter;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import model3.SQPick;
import model3.Well;
import model3.WellInterp;
import util.gridwriter.GridSheet;

public class IGDWorksheetWriterSQPick
implements IXLSWorksheetWriter {
    private final SampleFormatter sampleFormatter;

    public IGDWorksheetWriterSQPick(SampleFormatter sf) {
        this.sampleFormatter = sf;
    }

    @Override
    public String getName() {
        return "Sequence";
    }

    @Override
    public boolean hasDataToWrite(Well w, WellInterp interp) {
        return interp.getSQPicks().size() > 0;
    }

    @Override
    public void writeHeader(GridSheet gb) {
        gb.addRow(new Object[]{"Well Name", "Well Code", "Top Depth", "Text", "Top Boundary"});
    }

    @Override
    public void writeData(GridSheet gb, Well w, WellInterp interp) throws Exception {
        for (SQPick pick : interp.getSQPicks()) {
            gb.addRow(new Object[]{w.getWellName(), w.getWellCode(), this.sampleFormatter.getDepthValue(pick.getSample(), w), pick.getQualifier() + pick.getName(), pick.getBnd()});
        }
    }
}

