/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.welldata;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.io.welldata.DialogListSelection;
import model3.AnalystHeader;
import model3.Well;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.FilePathUtils;
import util.SBException;

public class DialogOccurrenceFlatFileOptions
extends SBDialog {
    private String defaultDirectory = null;
    private String defaultFileName = null;
    private List<Well> wellsList = null;
    private Set<String> allAnalysts = null;
    private Set<String> selectedAnalysts = null;
    private final Frame myParent;
    private ButtonGroup buttonGroupDepthUnits;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectAnalysts;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxCoreCorrections;
    private JCheckBox jCheckBoxCuttingCorrections;
    private JCheckBox jCheckBoxIncludeMacro;
    private JCheckBox jCheckBoxIncludeMicro;
    private JCheckBox jCheckBoxIncludeNano;
    private JCheckBox jCheckBoxIncludePaly;
    private JCheckBox jCheckBoxInsertZeroWhenNoCount;
    private JCheckBox jCheckBoxOneSamplePerRow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAnalystsSelected;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelUnits;
    private JRadioButton jRadioButtonUnitMeters;
    private JRadioButton jRadioButtonUnitsFeet;
    private JTextField jTextFieldFilePath;

    public DialogOccurrenceFlatFileOptions(Frame parent, boolean modal) {
        super(parent, modal);
        this.myParent = parent;
        this.initComponents();
        this.setTitle("Multi-well Sample Analyses Export");
        GroupLayout layout = (GroupLayout)this.getContentPane().getLayout();
        layout.linkSize(0, this.jButtonOK, this.jButtonCancel);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jLabelAnalystsSelected.setVisible(false);
        this.jButtonSelectAnalysts.setVisible(false);
        this.setIsOK(false);
    }

    public void setWellsList(List<Well> wells) {
        this.wellsList = wells;
        this.updateAnalystList();
    }

    public void setDefaultDirectory(String value) {
        this.defaultDirectory = value;
    }

    public void setDefaultFileName(String value) {
        this.defaultFileName = value;
    }

    public File getOutputFile() {
        String text = this.jTextFieldFilePath.getText();
        File f = null;
        if (!StringUtils.isEmpty((CharSequence)text)) {
            f = new File(text);
        }
        return f;
    }

    private void initComponents() {
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilePath = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jPanel1 = new JPanel();
        this.jCheckBoxIncludeMicro = new JCheckBox();
        this.jCheckBoxIncludePaly = new JCheckBox();
        this.jCheckBoxIncludeNano = new JCheckBox();
        this.jCheckBoxIncludeMacro = new JCheckBox();
        this.jButtonSelectAnalysts = new JButton();
        this.jLabelAnalystsSelected = new JLabel();
        this.jPanel2 = new JPanel();
        this.jCheckBoxCoreCorrections = new JCheckBox();
        this.jCheckBoxCuttingCorrections = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanelUnits = new JPanel();
        this.jRadioButtonUnitMeters = new JRadioButton();
        this.jRadioButtonUnitsFeet = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jCheckBoxInsertZeroWhenNoCount = new JCheckBox();
        this.jCheckBoxOneSamplePerRow = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("File :");
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Filter Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxIncludeMicro.setSelected(true);
        this.jCheckBoxIncludeMicro.setText("Include Micropalaeontology");
        this.jCheckBoxIncludePaly.setSelected(true);
        this.jCheckBoxIncludePaly.setText("Include Palynology ");
        this.jCheckBoxIncludeNano.setSelected(true);
        this.jCheckBoxIncludeNano.setText("Include Nannopalaeontology");
        this.jCheckBoxIncludeMacro.setSelected(true);
        this.jCheckBoxIncludeMacro.setText("Include Macropalaeontology");
        this.jButtonSelectAnalysts.setText("Select Analysts");
        this.jButtonSelectAnalysts.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAnalystsActionPerformed(evt);
            }
        });
        this.jLabelAnalystsSelected.setText("0 analysts selected");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIncludeMicro).addComponent(this.jCheckBoxIncludeMacro).addComponent(this.jCheckBoxIncludeNano).addComponent(this.jCheckBoxIncludePaly)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectAnalysts).addComponent(this.jLabelAnalystsSelected)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIncludeMicro).addComponent(this.jButtonSelectAnalysts)).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIncludePaly).addComponent(this.jLabelAnalystsSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeNano).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeMacro).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Correction Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxCoreCorrections.setText("Output core-corrected depths for core samples");
        this.jCheckBoxCuttingCorrections.setText("Output core-corrected depths for cutting samples");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCuttingCorrections).addComponent(this.jCheckBoxCoreCorrections)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBoxCoreCorrections).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCuttingCorrections)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanelUnits.setBorder(BorderFactory.createTitledBorder(null, "Export Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupDepthUnits.add(this.jRadioButtonUnitMeters);
        this.jRadioButtonUnitMeters.setSelected(true);
        this.jRadioButtonUnitMeters.setText("Meters");
        this.buttonGroupDepthUnits.add(this.jRadioButtonUnitsFeet);
        this.jRadioButtonUnitsFeet.setText("Feet");
        this.jLabel2.setText("Depth Units :");
        this.jCheckBoxInsertZeroWhenNoCount.setText("Insert zero when no count exists");
        this.jCheckBoxInsertZeroWhenNoCount.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxInsertZeroWhenNoCountActionPerformed(evt);
            }
        });
        this.jCheckBoxOneSamplePerRow.setSelected(true);
        this.jCheckBoxOneSamplePerRow.setText("One sample per row (combine analysis from different disciplines)");
        this.jCheckBoxOneSamplePerRow.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrenceFlatFileOptions this$0;
            {
                DialogOccurrenceFlatFileOptions dialogOccurrenceFlatFileOptions = this$0;
                Objects.requireNonNull(dialogOccurrenceFlatFileOptions);
                this.this$0 = dialogOccurrenceFlatFileOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxOneSamplePerRowActionPerformed(evt);
            }
        });
        GroupLayout jPanelUnitsLayout = new GroupLayout(this.jPanelUnits);
        this.jPanelUnits.setLayout(jPanelUnitsLayout);
        jPanelUnitsLayout.setHorizontalGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUnitsLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonUnitMeters).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonUnitsFeet).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelUnitsLayout.createSequentialGroup().addGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxInsertZeroWhenNoCount).addComponent(this.jCheckBoxOneSamplePerRow)).addGap(0, 0, Short.MAX_VALUE)));
        jPanelUnitsLayout.setVerticalGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUnitsLayout.createSequentialGroup().addGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonUnitMeters).addComponent(this.jRadioButtonUnitsFeet).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxInsertZeroWhenNoCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOneSamplePerRow)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelUnits, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectFile)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFilePath, -2, -1, -2).addComponent(this.jButtonSelectFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelUnits, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.getOutputFile() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No output file selected, please select a file.", this.getTitle(), 2);
            return;
        }
        if (!(this.jCheckBoxIncludePaly.isSelected() || this.jCheckBoxIncludeMacro.isSelected() || this.jCheckBoxIncludeMicro.isSelected() || this.jCheckBoxIncludeNano.isSelected())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select at least one discapline in the filter options.", this.getTitle(), 2);
            return;
        }
        if (this.selectedAnalysts != null && this.selectedAnalysts.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select at least one analyst in the filter options.", this.getTitle(), 2);
            return;
        }
        if (this.wellsList != null && !this.willOptionsGenerateOutput()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The selected filters will generate no output for the selected wells.", this.getTitle(), 2);
            return;
        }
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        String suggestedDir;
        String suggestedName;
        File lastFile = this.getOutputFile();
        if (lastFile == null) {
            suggestedName = this.defaultFileName;
            suggestedDir = this.defaultDirectory;
        } else {
            suggestedName = FilePathUtils.extractFileNameWithoutExtension((String)lastFile.getName());
            suggestedDir = lastFile.getAbsoluteFile().getParent();
        }
        File f = FileChooserUtils.saveAsGridDataDialog((Component)((Object)this), (String)(lastFile != null ? lastFile.getPath() : suggestedDir), (String)suggestedName);
        if (f != null) {
            this.jTextFieldFilePath.setText(f.getPath());
        }
    }

    private void jButtonSelectAnalystsActionPerformed(ActionEvent evt) {
        DialogListSelection dialog = new DialogListSelection(this.myParent, true);
        dialog.setStringItems(this.allAnalysts);
        dialog.setSelectedItems(this.selectedAnalysts);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.selectedAnalysts = dialog.getSelected();
            this.updateAnalystsLabelAndButton();
        }
    }

    private void jCheckBoxInsertZeroWhenNoCountActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxOneSamplePerRowActionPerformed(ActionEvent evt) {
    }

    private boolean willOptionsGenerateOutput() {
        boolean outputFound = false;
        if (this.wellsList == null) {
            outputFound = false;
        } else {
            for (Well w : this.wellsList) {
                try {
                    block9: for (AnalystHeader analysisHead : w.getAnalystHeaders()) {
                        switch (analysisHead.getDiscipline()) {
                            case MICRO: {
                                if (this.jCheckBoxIncludeMicro.isSelected()) break;
                                continue block9;
                            }
                            case MACRO: {
                                if (this.jCheckBoxIncludeMacro.isSelected()) break;
                                continue block9;
                            }
                            case PALY: {
                                if (this.jCheckBoxIncludePaly.isSelected()) break;
                                continue block9;
                            }
                            case NANNO: {
                                if (this.jCheckBoxIncludeNano.isSelected()) break;
                                continue block9;
                            }
                        }
                        if (this.selectedAnalysts != null && !this.selectedAnalysts.contains(analysisHead.getAnalyst()) || w.getAnalyses(analysisHead.getDiscipline(), analysisHead.getAnalyst(), analysisHead.getAnalyNumber()).size() <= 0) continue;
                        outputFound = true;
                    }
                }
                catch (SQLException | SBException ex) {
                    Logger.getLogger(DialogOccurrenceFlatFileOptions.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return outputFound;
    }

    public boolean getIncludeMicroDisc() {
        return this.jCheckBoxIncludeMicro.isSelected();
    }

    public boolean getIncludeMacroDisc() {
        return this.jCheckBoxIncludeMacro.isSelected();
    }

    public boolean getIncludeNanoDisc() {
        return this.jCheckBoxIncludeNano.isSelected();
    }

    public boolean getIncludePalyDisc() {
        return this.jCheckBoxIncludePaly.isSelected();
    }

    public boolean getUseCoreCorrections() {
        return this.jCheckBoxCoreCorrections.isSelected();
    }

    public boolean getUseCuttingCorrections() {
        return this.jCheckBoxCuttingCorrections.isSelected();
    }

    public boolean getInsertZeroWhenNoCount() {
        return this.jCheckBoxInsertZeroWhenNoCount.isSelected();
    }

    public boolean getUseOneSamplePerRow() {
        return this.jCheckBoxOneSamplePerRow.isSelected();
    }

    public Set<String> getSelectedAnalysts() {
        return this.selectedAnalysts;
    }

    public void setDepthUnits(char units) {
        switch (units) {
            default: {
                this.jRadioButtonUnitMeters.setSelected(true);
                break;
            }
            case 'F': 
            case 'f': {
                this.jRadioButtonUnitsFeet.setSelected(true);
            }
        }
    }

    public char getDepthUnits() {
        if (this.jRadioButtonUnitMeters.isSelected()) {
            return DepthUnits.M.getChar();
        }
        return DepthUnits.F.getChar();
    }

    private void updateAnalystList() {
        this.allAnalysts = null;
        this.selectedAnalysts = null;
        if (this.wellsList != null) {
            HashSet<String> all = new HashSet<String>();
            for (Well w : this.wellsList) {
                try {
                    for (AnalystHeader analysisHead : w.getAnalystHeaders()) {
                        all.add(analysisHead.getAnalyst());
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(DialogOccurrenceFlatFileOptions.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.allAnalysts = all;
            this.selectedAnalysts = new HashSet<String>(all);
        }
        this.updateAnalystsLabelAndButton();
    }

    private void updateAnalystsLabelAndButton() {
        if (this.allAnalysts != null && this.selectedAnalysts != null) {
            this.jLabelAnalystsSelected.setText(this.selectedAnalysts.size() + " analysts selected");
            this.jLabelAnalystsSelected.setVisible(true);
            this.jButtonSelectAnalysts.setVisible(true);
        } else {
            this.jLabelAnalystsSelected.setVisible(false);
            this.jButtonSelectAnalysts.setVisible(false);
        }
    }
}

