/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.welldata;

import com.stratadata.model3.Discipline;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import model3.AnalystHeader;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import org.apache.commons.lang3.tuple.ImmutablePair;
import util.DepthUnits;
import util.SBException;
import util.gridwriter.CellFormat;
import util.gridwriter.GridCell;
import util.gridwriter.GridSheet;

public class GridBuilderMultiWellOccurrenceFlatFile {
    private static final CellFormat ROTATED_TAXON_FORMAT = new CellFormat().setTextRotation((short)90);
    private static final int NUM_HEADER_ROWS = 3;
    private static final int WELL_CODE_COLUMN = 1;
    private static final int SAMPLE_DEPTH_COLUMN = 5;
    private boolean includeMicro = true;
    private boolean includeMacro = true;
    private boolean includeNanno = true;
    private boolean includePally = true;
    private boolean useCuttingCorrections = true;
    private boolean useZeroWhenNoCount = false;
    private boolean useCoreCorrections = true;
    private Set<String> selectedAnalysts = null;
    private char exportUnits = DepthUnits.M.getChar();
    private boolean oneSamplePerRow = false;

    public List<String> validateOptions(List<Well> wells) throws SQLException, SBException {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.oneSamplePerRow) {
            List<String> taxonCountsFromDifferentDisciplines;
            List<String> samplesWithMultipleAnalyses = this.findSapmlesWithMultipleAnalyses(wells);
            if (!samplesWithMultipleAnalyses.isEmpty()) {
                if (samplesWithMultipleAnalyses.size() == 1) {
                    errors.add("Can't generate output with the one sample per line option because the sample " + samplesWithMultipleAnalyses.get(0) + " has multiple analyses within the same discipline.");
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Can't generate output with the one sample per line option because multiple analysis within the same discipline have been found for samples:\n");
                    for (String s : samplesWithMultipleAnalyses) {
                        sb.append(s).append("\n");
                    }
                    errors.add(sb.toString());
                }
            }
            if (!(taxonCountsFromDifferentDisciplines = this.findTaxonCountsFromDifferentDisciplines(wells)).isEmpty()) {
                if (taxonCountsFromDifferentDisciplines.size() == 1) {
                    errors.add("Can't generate output with the one sample per line option because the taxon " + taxonCountsFromDifferentDisciplines.get(0) + ".");
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Can't generate output with the one sample per line option because multiple taxon are recorded in multiple disciplines for the same samples:\n");
                    for (String s : taxonCountsFromDifferentDisciplines) {
                        sb.append(s).append("\n");
                    }
                    errors.add(sb.toString());
                }
            }
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    public Object[][] buildGrid(List<Well> wells) throws SQLException, SBException {
        GridSheet gb = new GridSheet();
        SampleFormatter sf = new SampleFormatter(false, false, this.useCoreCorrections, this.useCuttingCorrections);
        HashSet<Taxon> allTaxon = new HashSet<Taxon>();
        for (Well well : wells) {
            well.loadAnalyses();
            for (AnalystHeader analystHeader : well.getAnalystHeaders()) {
                if (!this.includeAnalysis(analystHeader)) continue;
                for (Smpdtl analysis : well.getAnalyses(analystHeader.getDiscipline(), analystHeader.getAnalyst(), analystHeader.getAnalyNumber())) {
                    for (TaxonOcc occ : analysis.getOccurUnsorted()) {
                        allTaxon.add(occ.getTaxon());
                    }
                }
            }
        }
        ArrayList taxonList = new ArrayList(allTaxon);
        Collections.sort(taxonList);
        gb.append(new Object[]{null, null, null, null, null, null, null});
        for (Taxon t : taxonList) {
            gb.appendFormatted(ROTATED_TAXON_FORMAT, new Object[]{t.toString()});
        }
        gb.addRow();
        gb.append(new Object[]{null, null, null, null, null, null, "Category"});
        for (Taxon t : taxonList) {
            gb.appendFormatted(ROTATED_TAXON_FORMAT, new Object[]{t.getCatMnem()});
        }
        gb.addRow();
        gb.append(new Object[]{"Well", "Well Code", "Analyst", "Discipline", "Suite No", "Depth (" + Character.toLowerCase(this.exportUnits) + ")", "Sample Type"});
        int n = 3;
        HashMap<ImmutablePair, Integer> sampleHash = new HashMap<ImmutablePair, Integer>();
        for (Well w : wells) {
            for (AnalystHeader analysisHead : w.getAnalystHeaders()) {
                if (!this.includeAnalysis(analysisHead)) continue;
                for (Smpdtl analysis : w.getAnalyses(analysisHead.getDiscipline(), analysisHead.getAnalyst(), analysisHead.getAnalyNumber())) {
                    void var6_10;
                    ImmutablePair pair = new ImmutablePair((Object)w, (Object)analysis.getSample());
                    if (this.oneSamplePerRow && sampleHash.containsKey(pair)) {
                        int rowForSample = (Integer)sampleHash.get(pair);
                        String newAnalystString = String.valueOf(gb.getValueOfCell(rowForSample, 2)) + ", " + analysisHead.getAnalyst();
                        gb.setValueOfCell(rowForSample, 2, (Object)newAnalystString);
                        String newDisciplineString = String.valueOf(gb.getValueOfCell(rowForSample, 3)) + ", " + analysisHead.getDiscipline().getAbr(false);
                        gb.setValueOfCell(rowForSample, 3, (Object)newDisciplineString);
                        String newSuiteNumberString = String.valueOf(gb.getValueOfCell(rowForSample, 4)) + ", " + analysisHead.getAnalyNumber();
                        gb.setValueOfCell(rowForSample, 4, (Object)newSuiteNumberString);
                        for (TaxonOcc occ : analysis.getOccurUnsorted()) {
                            double count = this.getOccCount(occ, analysis);
                            int col = 7 + taxonList.indexOf(occ.getTaxon());
                            gb.setValueOfCell(rowForSample, col, (Object)count);
                        }
                        continue;
                    }
                    Object[] rowItems = new Object[7 + taxonList.size()];
                    rowItems[0] = w.getWellName();
                    rowItems[1] = w.getWellCode();
                    rowItems[2] = analysisHead.getAnalyst();
                    rowItems[3] = analysisHead.getDiscipline().getAbr(false);
                    rowItems[4] = analysisHead.getAnalyNumber();
                    rowItems[5] = sf.getDepthValue(analysis.getSample(), w, this.exportUnits);
                    rowItems[6] = analysis.getSample().getTypeString();
                    if (this.useZeroWhenNoCount) {
                        for (int i = 0; i < taxonList.size(); ++i) {
                            rowItems[7 + i] = 0.0;
                        }
                    }
                    for (TaxonOcc occ : analysis.getOccurUnsorted()) {
                        rowItems[7 + taxonList.indexOf((Object)occ.getTaxon())] = this.getOccCount(occ, analysis);
                    }
                    gb.addRow(rowItems);
                    sampleHash.put(pair, (int)var6_10);
                    ++var6_10;
                }
            }
        }
        Object[][] objectArray = gb.getObjectArray();
        if (this.oneSamplePerRow) {
            return this.sortDataArray(objectArray);
        }
        return objectArray;
    }

    private Object[][] sortDataArray(Object[][] unsortedData) {
        Object[][] headerRows = new Object[3][];
        Object[][] dataRows = new Object[unsortedData.length - 3][];
        for (int i = 0; i < unsortedData.length; ++i) {
            if (i < 3) {
                headerRows[i] = unsortedData[i];
                continue;
            }
            dataRows[i - 3] = unsortedData[i];
        }
        Arrays.sort(dataRows, new Comparator<Object[]>(this){
            final /* synthetic */ GridBuilderMultiWellOccurrenceFlatFile this$0;
            {
                GridBuilderMultiWellOccurrenceFlatFile gridBuilderMultiWellOccurrenceFlatFile = this$0;
                Objects.requireNonNull(gridBuilderMultiWellOccurrenceFlatFile);
                this.this$0 = gridBuilderMultiWellOccurrenceFlatFile;
            }

            @Override
            public int compare(Object[] a, Object[] b) {
                String wellCodeB;
                String wellCodeA = this.this$0.getCellValue(a[1]).toString();
                int result = wellCodeA.compareTo(wellCodeB = this.this$0.getCellValue(b[1]).toString());
                if (result == 0) {
                    Double depthA = (Double)this.this$0.getCellValue(a[5]);
                    Double depthB = (Double)this.this$0.getCellValue(b[5]);
                    result = Double.compare(depthA, depthB);
                }
                return result;
            }
        });
        Object[][] sortedData = new Object[headerRows.length + dataRows.length][];
        for (int i = 0; i < sortedData.length; ++i) {
            sortedData[i] = i < headerRows.length ? headerRows[i] : dataRows[i - headerRows.length];
        }
        return sortedData;
    }

    private Object getCellValue(Object cell) {
        if (cell instanceof GridCell) {
            return ((GridCell)cell).getValue();
        }
        return cell;
    }

    private double getOccCount(TaxonOcc occ, Smpdtl analysis) {
        return occ.getDerivedCount(analysis.getDatabase().getAbundanceSchemeService().findAbundanceScheme(analysis.getHeader().getAbnSchID()).orElse(null), analysis.getCoarse(), analysis.getMedium(), analysis.getFine());
    }

    public void setIncludeMicro(boolean includeMicro) {
        this.includeMicro = includeMicro;
    }

    public void setIncludeMacro(boolean includeMacro) {
        this.includeMacro = includeMacro;
    }

    public void setIncludeNanno(boolean includeNanno) {
        this.includeNanno = includeNanno;
    }

    public void setIncludePally(boolean includePally) {
        this.includePally = includePally;
    }

    public void setCoreCorrectionForCutting(boolean coreCorrectionForCutting) {
        this.useCuttingCorrections = coreCorrectionForCutting;
    }

    public void setCoreCorrectionForCore(boolean coreCorrectionForCore) {
        this.useCoreCorrections = coreCorrectionForCore;
    }

    public void setSelectedAnalysts(Set<String> selected) {
        this.selectedAnalysts = selected;
    }

    public void setExportUnits(char units) {
        this.exportUnits = units;
    }

    public void setInsertZeroWhenNoCount(boolean value) {
        this.useZeroWhenNoCount = value;
    }

    public void setOneSamplePerRow(boolean value) {
        this.oneSamplePerRow = value;
    }

    private boolean includeAnalysis(AnalystHeader analysisHead) throws SQLException {
        switch (analysisHead.getDiscipline()) {
            case MICRO: {
                if (this.includeMicro) break;
                return false;
            }
            case MACRO: {
                if (this.includeMacro) break;
                return false;
            }
            case PALY: {
                if (this.includePally) break;
                return false;
            }
            case NANNO: {
                if (this.includeNanno) break;
                return false;
            }
        }
        return this.selectedAnalysts == null || this.selectedAnalysts.contains(analysisHead.getAnalyst());
    }

    private List<String> findSapmlesWithMultipleAnalyses(List<Well> wells) throws SQLException, SBException {
        ArrayList<String> foundSamples = new ArrayList<String>();
        HashMap<String, Boolean> sampleHash = new HashMap<String, Boolean>();
        for (Well w : wells) {
            for (AnalystHeader analysisHead : w.getAnalystHeaders()) {
                if (!this.includeAnalysis(analysisHead)) continue;
                for (Smpdtl analysis : w.getAnalyses(analysisHead.getDiscipline(), analysisHead.getAnalyst(), analysisHead.getAnalyNumber())) {
                    String descirption = this.getSampleMatchDescription(analysis.getSample(), w, analysisHead.getDiscipline());
                    if (sampleHash.containsKey(descirption)) {
                        foundSamples.add(descirption);
                        continue;
                    }
                    sampleHash.put(descirption, true);
                }
            }
        }
        return foundSamples;
    }

    private String getSampleMatchDescription(Sample s, Well w, Discipline d) {
        return w.getWellCode() + " " + String.valueOf(s) + " (" + d.getAbr(false) + ")";
    }

    private String getTaxonSampleWellString(Sample s, Well w, Taxon t) {
        return t.toString() + " in " + w.getWellCode() + " " + String.valueOf(s);
    }

    private List<String> findTaxonCountsFromDifferentDisciplines(List<Well> wells) throws SQLException, SBException {
        ArrayList<String> warnings = new ArrayList<String>();
        HashMap hash = new HashMap();
        for (Well w : wells) {
            for (AnalystHeader analysisHead : w.getAnalystHeaders()) {
                for (Smpdtl analysis : w.getAnalyses(analysisHead.getDiscipline(), analysisHead.getAnalyst(), analysisHead.getAnalyNumber())) {
                    if (!this.includeAnalysis(analysisHead)) continue;
                    for (TaxonOcc occ : analysis.getOccurUnsorted()) {
                        String taxonString = this.getTaxonSampleWellString(analysis.getSample(), w, occ.getTaxon());
                        if (!hash.containsKey(taxonString)) {
                            hash.put(taxonString, new HashSet());
                        }
                        ((Set)hash.get(taxonString)).add(analysis.getDiscipline());
                    }
                }
            }
        }
        for (String key : hash.keySet()) {
            if (((Set)hash.get(key)).size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(key).append(" is recorded for ");
            Iterator i = ((Set)hash.get(key)).iterator();
            sb.append(((Discipline)i.next()).getAbr(false));
            while (i.hasNext()) {
                Discipline d = (Discipline)i.next();
                if (i.hasNext()) {
                    sb.append(", ").append(d.getAbr(false));
                    continue;
                }
                sb.append(" and ").append(d.getAbr(false));
            }
            warnings.add(sb.toString());
        }
        return warnings;
    }
}

