/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.welldata;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jsbugs.io.welldata.ISampleSummaryRecordBuilder;
import jsbugs.io.welldata.SampleSummaryRecord;
import jsbugs.io.welldata.SummaryPickType;
import jsbugs.io.welldata.WellDataSummaryRecord;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.SBException;

public class SampleSummaryRecordBuilder
implements ISampleSummaryRecordBuilder {
    private boolean useCoreSampleCorrections = false;
    private boolean useCuttingSampleCorrections = false;
    private boolean duplicateSingleDepths = false;
    private boolean includeUncorrectedDepths = false;
    private final SBdb db;

    public SampleSummaryRecordBuilder(SBdb db) {
        this.db = db;
    }

    @Override
    public List<WellDataSummaryRecord> buildRecords(List<Well> wells, char inputUnits, Set<Integer> dataTypes, Set<Integer> interpIds) throws SBException, SQLException {
        ArrayList<WellDataSummaryRecord> records = new ArrayList<WellDataSummaryRecord>();
        for (int interpID : interpIds) {
            for (Well well : wells) {
                WellInterp wellInterp = well.getInterp(interpID);
                char units = inputUnits == 'D' ? well.getWellUnits() : inputUnits;
                block9: for (Integer dType : dataTypes) {
                    switch (dType) {
                        case 1: {
                            continue block9;
                        }
                        default: {
                            continue block9;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            this.addIntervalZoneRecords(records, dType, well, units, wellInterp);
                            continue block9;
                        }
                        case 14: {
                            this.addSequencePicks(records, dType, well, units, wellInterp);
                            continue block9;
                        }
                        case 15: {
                            this.addPaleoRecords(records, dType, well, units, wellInterp);
                            continue block9;
                        }
                        case 16: 
                    }
                    this.addEventRecords(records, dType, well, units, wellInterp);
                }
            }
        }
        return records;
    }

    private void addIntervalZoneRecords(List<WellDataSummaryRecord> records, Integer dType, Well well, char units, WellInterp wellInterp) throws SBException, SQLException {
        List<IGDIntervalZone> zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype(dType));
        if (zones != null) {
            for (IGDIntervalZone zone : zones) {
                SampleSummaryRecord top = this.buildSampleRecord(well, zone.getTopSample(), units, zone.getTopBnd());
                SampleSummaryRecord base = this.buildSampleRecord(well, zone.getBaseSample(), units, zone.getBaseBnd());
                SummaryPickType pickType = new SummaryPickType(IGDIntervalZone.getHierName(IGDIntervalZone.dType2IGDtype(dType), zone.getHier()), zone.getHier());
                int schId = zone.getSchID();
                IGDScheme scheme = this.db.getIGDScheme(schId);
                String discipline = null;
                if (scheme.getDiscipline() != null) {
                    discipline = scheme.getDiscipline().getAbr(false);
                }
                WellDataSummaryRecord rec = new WellDataSummaryRecord(top, base, well.getWellName(), well.getWellCode(), wellInterp.getHeader().getDescription(), dType, pickType, scheme.toString(), discipline, zone.toString(), zone);
                records.add(rec);
            }
        }
    }

    private void addSequencePicks(List<WellDataSummaryRecord> records, Integer dType, Well well, char units, WellInterp wellInterp) throws SBException, SQLException {
        List<SQPick> picks = wellInterp.getSQPicks();
        if (picks != null) {
            for (SQPick pick : picks) {
                SampleSummaryRecord base = this.buildSampleRecord(well, pick.getSample(), units, pick.getBnd());
                SummaryPickType pickType = new SummaryPickType(pick.getTypeString(), 0);
                WellDataSummaryRecord rec = new WellDataSummaryRecord(this.duplicateSingleDepths ? base : null, base, well.getWellName(), well.getWellCode(), wellInterp.getHeader().getDescription(), dType, pickType, pick.getSchemeName(), null, pick.getName(), pick);
                records.add(rec);
            }
        }
    }

    private void addPaleoRecords(List<WellDataSummaryRecord> records, Integer dType, Well well, char units, WellInterp wellInterp) throws SBException, SQLException {
        List<IGDIntervalEnv> envs = wellInterp.getEnvs();
        if (envs != null) {
            for (IGDIntervalEnv env : envs) {
                SampleSummaryRecord top = this.buildSampleRecord(well, env.getTopSample(), units, null);
                SampleSummaryRecord base = this.buildSampleRecord(well, env.getBaseSample(), units, null);
                WellDataSummaryRecord rec = new WellDataSummaryRecord(top, base, well.getWellName(), well.getWellCode(), wellInterp.getHeader().getDescription(), dType, null, env.getScheme().getName(), null, env.toString(), env);
                records.add(rec);
            }
        }
    }

    private void addEventRecords(List<WellDataSummaryRecord> records, Integer dType, Well well, char units, WellInterp wellInterp) throws SBException, SQLException {
        List<WellEvent> events = wellInterp.getEvents();
        if (events != null) {
            for (WellEvent event : events) {
                SampleSummaryRecord top = this.buildSampleRecord(well, event.getSample(), units, null);
                SummaryPickType pickType = new SummaryPickType(event.getType(), 0);
                Object eventValue = event.toString(true, false, false, units, true, false);
                if (event.getQualifier() != null && !event.getQualifier().isEmpty()) {
                    eventValue = (String)eventValue + " (" + event.getQualifier() + ")";
                }
                WellDataSummaryRecord rec = new WellDataSummaryRecord(top, this.duplicateSingleDepths ? top : null, well.getWellName(), well.getWellCode(), wellInterp.getHeader().getDescription(), dType, pickType, null, null, (String)eventValue, event);
                records.add(rec);
            }
        }
    }

    private SampleSummaryRecord buildSampleRecord(Well well, Sample sample, char units, String boundary) throws SQLException {
        double depth = well.getDepth(sample, units, this.getUseCoreSampleCorrections(), this.getUseCuttingSampleCorrections());
        double uncorrectedDepth = sample.getDepth(units);
        return new SampleSummaryRecord(depth, uncorrectedDepth, sample.getTypeString(), boundary);
    }

    @Override
    public boolean getUseCoreSampleCorrections() {
        return this.useCoreSampleCorrections;
    }

    @Override
    public void setUseCoreSampleCorrections(boolean useCoreSampleCorrections) {
        this.useCoreSampleCorrections = useCoreSampleCorrections;
    }

    @Override
    public boolean getUseCuttingSampleCorrections() {
        return this.useCuttingSampleCorrections;
    }

    @Override
    public void setUseCuttingSampleCorrections(boolean useCuttingSampleCorrections) {
        this.useCuttingSampleCorrections = useCuttingSampleCorrections;
    }

    @Override
    public void setDuplicateSingleDepths(boolean b) {
        this.duplicateSingleDepths = b;
    }

    @Override
    public boolean getDuplicateSingleDepths() {
        return this.duplicateSingleDepths;
    }
}

