/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.list;

import com.stratadata.model3.taxon.Category;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class CategoryListCellRenderer
extends JPanel
implements ListCellRenderer<Category>,
TableCellRenderer {
    private final JLabel mnemonicLabel = new JLabel();
    private final JLabel nameLabel = new JLabel();
    private final JTextField colourLabel = new JTextField();
    private Dimension d;
    private final List<Component> components = List.of(this.mnemonicLabel, this.nameLabel, this);

    public CategoryListCellRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.mnemonicLabel);
        this.add(this.nameLabel);
        Dimension colourD = new Dimension(12, 12);
        this.colourLabel.setMinimumSize(colourD);
        this.colourLabel.setMaximumSize(colourD);
        this.colourLabel.setPreferredSize(colourD);
        this.add(Box.createHorizontalGlue());
        this.add(this.colourLabel);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Category> list, Category value, int index, boolean isSelected, boolean cellHasFocus) {
        this.initForValue(value, isSelected, list.getBackground(), list.getForeground(), list.getSelectionBackground(), list.getSelectionForeground());
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Category cat;
        this.initForValue(value instanceof Category ? (cat = (Category)value) : null, isSelected, table.getBackground(), table.getForeground(), table.getSelectionBackground(), table.getSelectionForeground());
        return this;
    }

    private void initForValue(Category value, boolean isSelected, Color background, Color foreground, Color selectionBackground, Color selectionForeground) {
        if (this.d == null) {
            this.d = new Dimension(42, 17);
            this.mnemonicLabel.setMaximumSize(this.d);
            this.mnemonicLabel.setMinimumSize(this.d);
            this.mnemonicLabel.setPreferredSize(this.d);
        }
        if (isSelected) {
            this.components.forEach(comp -> comp.setBackground(selectionBackground));
            this.components.forEach(comp -> comp.setForeground(selectionForeground));
        } else {
            this.components.forEach(comp -> comp.setBackground(background));
            this.components.forEach(comp -> comp.setForeground(foreground));
        }
        if (value != null) {
            this.mnemonicLabel.setText(value.getMnemonic());
            this.nameLabel.setText(value.getName());
            this.colourLabel.setVisible(true);
            this.colourLabel.setBackground(value.getColour());
        } else {
            this.mnemonicLabel.setText("");
            this.nameLabel.setText("");
            this.colourLabel.setVisible(false);
        }
    }
}

