/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelWirelineLog;
import model3.LogDef;

public class LogSymbolRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon[] images;

    public LogSymbolRenderer(int symbolHeight) {
        this.init(symbolHeight);
    }

    private void init(int symbolHeight) {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.images = new ImageIcon[LogDef.symbols.length];
        float symbolSize = 5.0f;
        int width = (int)(symbolSize * 2.0f);
        int height = symbolHeight;
        for (int i = 0; i < LogDef.symbols.length; ++i) {
            ImageIcon icon;
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D g = bufferedImage.createGraphics();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.01f, 0.01f);
            g.transform(tnf);
            SBGraphics sbg = new SBGraphics(g, null, true, true);
            sbg.setStroke(1.0f);
            sbg.setColor(Color.WHITE);
            sbg.fillRect(0.0f, 0.0f, width, height);
            sbg.setColor(Color.BLACK);
            PanelWirelineLog.drawSymbol(sbg, width / 2, height / 2, i, symbolSize, Float.valueOf(45.0f));
            this.images[i] = icon = new ImageIcon(bufferedImage);
            if (this.images[i] == null) continue;
            this.images[i].setDescription(LogDef.symbols[i]);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int selectedIndex = (Integer)value;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        ImageIcon icon = this.images[selectedIndex];
        if (icon == null) {
            this.setText("Icon null");
        }
        this.setIcon(icon);
        return this;
    }
}

