/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.lithography;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import model3.GrainSizeDepth;
import util.gridreader.TableData;
import util.gridreader.TableRow;

public class GrainSizeDepthProcessor {
    private int depthColumnIndex = 0;
    private int grainSizeColumnIndex = 1;

    public List<GrainSizeDepth> buildGrainSizeList(TableData data) {
        List<GrainSizeDepth> grainSizes = this.extractGrainSizeFromTableData(data);
        return this.filterGrainSizeDepths(grainSizes);
    }

    public void setDepthColumnIndex(int depthColumnIndex) {
        this.depthColumnIndex = depthColumnIndex;
    }

    public void setGrainSizeColumnIndex(int grainSizeColumnIndex) {
        this.grainSizeColumnIndex = grainSizeColumnIndex;
    }

    private void sortGrainSizeDepths(List<GrainSizeDepth> grainSizes) {
        Collections.sort(grainSizes, new Comparator(this){
            {
                Objects.requireNonNull(this$0);
            }

            public int compare(Object objectA, Object objectB) {
                GrainSizeDepth a = (GrainSizeDepth)objectA;
                GrainSizeDepth b = (GrainSizeDepth)objectB;
                return Double.compare(a.getDepth(), b.getDepth());
            }
        });
    }

    private List<GrainSizeDepth> extractGrainSizeFromTableData(TableData data) {
        ArrayList<GrainSizeDepth> grainSizes = new ArrayList<GrainSizeDepth>();
        for (TableRow row : data.getRows()) {
            Double depth = row.getDouble(this.depthColumnIndex);
            Double grainSize = row.getDouble(this.grainSizeColumnIndex);
            if (depth == null || grainSize == null || grainSize <= -999.0 && grainSize >= -999.99) continue;
            grainSizes.add(new GrainSizeDepth(depth, grainSize.floatValue()));
        }
        return grainSizes;
    }

    private List<GrainSizeDepth> filterGrainSizeDepths(List<GrainSizeDepth> grainSizeDepths) {
        this.sortGrainSizeDepths(grainSizeDepths);
        ArrayList<GrainSizeDepth> filteredSizes = new ArrayList<GrainSizeDepth>();
        filteredSizes.add(grainSizeDepths.get(0));
        GrainSizeDepth lastGsd = grainSizeDepths.get(0);
        for (int i = 1; i < grainSizeDepths.size() - 1; ++i) {
            GrainSizeDepth thisGsd = grainSizeDepths.get(i);
            GrainSizeDepth nextGsd = grainSizeDepths.get(i + 1);
            if (!(thisGsd.equals(lastGsd) || thisGsd.getGrainSize() == lastGsd.getGrainSize() && thisGsd.getGrainSize() == nextGsd.getGrainSize())) {
                filteredSizes.add(grainSizeDepths.get(i));
            }
            lastGsd = thisGsd;
        }
        GrainSizeDepth thisGsd = grainSizeDepths.get(grainSizeDepths.size() - 1);
        if (!thisGsd.equals(lastGsd)) {
            filteredSizes.add(thisGsd);
        }
        return filteredSizes;
    }
}

