/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.TableCellUtils;
import model3.CompositeStandardEvent;

public class CmpStdEventRenderer
extends DefaultTableCellRenderer {
    private final JPanel panel = new JPanel();
    private final JCheckBox button;
    private final JLabel overrideLabel;

    public CmpStdEventRenderer() {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JCheckBox();
        this.button.setToolTipText("Include inherited event");
        this.overrideLabel = new JLabel();
        this.overrideLabel.setEnabled(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = this.getSuperLabel(table, value, isSelected, hasFocus, row, column);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        oLabel.setBorder(TableCellUtils.getEmptyBorder());
        oLabel.setOpaque(false);
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width - 1, 100);
        oLabel.setPreferredSize(d);
        this.panel.removeAll();
        this.panel.add(oLabel);
        String stringValue = "";
        if (value instanceof CompositeStandardEvent.Builder) {
            CompositeStandardEvent.Builder event = (CompositeStandardEvent.Builder)value;
            stringValue = event.getEvent().toString(event.getType(), false, false, false);
            if (event.inheritedFromParent) {
                this.panel.add(Box.createHorizontalGlue());
                this.panel.add(this.button);
                this.button.setSelected(!event.excluded);
            }
            if (event.matchingParentEvent != null) {
                this.overrideLabel.setText("(" + event.matchingParentEvent.getCSU() + ") ");
                this.panel.add(Box.createHorizontalGlue());
                this.panel.add(this.overrideLabel);
            }
        }
        oLabel.setText(stringValue);
        return this.panel;
    }

    JLabel getSuperLabel(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    JCheckBox getButton() {
        return this.button;
    }
}

