/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableRowSorter;
import jsbugs.FrameJsbugs;
import jsbugs.TaxonTransferHandler;
import jsbugs.model2.event.JPanelCmpStdHeader;
import jsbugs.model2.event.JTableCmpStd;
import jsbugs.model2.event.TableModelCmpStd;
import jsbugs.uiutil.audit.JPanelAuditLine;
import model3.Audit;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import util.InvalidFieldException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatus;
import util.table.ColumnHeaderToolTips;

public class InternalFrameCmpStd
extends JInternalFrame
implements PropertyChangeListener,
Observer {
    private final TableModelCmpStd model = new TableModelCmpStd();
    private final SBdb sbdb;
    private CompositeStandard std;
    private JButton jButtonSave;
    private JMenuItem jMenuItemDelete;
    private JPanelAuditLine jPanelAudit;
    private JPopupMenu jPopupMenuEvents;
    private JScrollPane jScrollPane1;
    private JTable jTableCmpStd;
    private JTextField jTextFieldStatus;
    private JPanelCmpStdHeader panelHdr;

    public InternalFrameCmpStd(CompositeStandard std, SBdb sbdb) throws SQLException {
        if (std != null && !std.getDatabase().isConnected()) {
            throw new IllegalArgumentException("Attempt edit workspace composite with internal frame");
        }
        this.sbdb = sbdb;
        this.std = std;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.panelHdr.init(this, this.model, this.sbdb, this.std);
        this.panelHdr.setFields();
        this.model.setupTable(this.jTableCmpStd);
        this.model.addPropertyChangeListener(this);
        this.jTableCmpStd.setRowSorter(new TableRowSorter<TableModelCmpStd>(this.model));
        new ColumnSortResetHandler(this.jTableCmpStd).attach();
        this.jTableCmpStd.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])TableModelCmpStd.tooltips, (JTable)this.jTableCmpStd));
        if (this.std != null) {
            this.std.loadEvents();
            this.loadModelStd();
            this.std.addObserver(this);
            Audit audit = this.std.getAudit();
            String creator = "";
            if (audit.getCreator() > 0 && this.std.getDatabase() != null) {
                creator = this.std.getDatabase().getUser(audit.getCreator()).getAbr();
            }
            String modifier = "";
            if (audit.getModifier() > 0 && this.std.getDatabase() != null) {
                modifier = this.std.getDatabase().getUser(audit.getModifier()).getAbr();
            }
            this.jPanelAudit.setAuditText(creator, audit.getCreated(), modifier, audit.getModified());
        } else {
            this.setTitle("New Composite Standard");
            this.jPanelAudit.setVisible(false);
        }
        this.refreshStatus();
        this.jTableCmpStd.setDragEnabled(true);
        this.jTableCmpStd.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jTableCmpStd.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.model.fireTableDataChanged();
        if (this.std != null && !this.std.canWrite(this.sbdb, null) || this.std == null && !SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonSave.setEnabled(false);
            this.jButtonSave.setToolTipText(this.std != null ? this.std.getDeniedReason(this.sbdb, "composite standard", false) : SBRestrictable.getDeniedReason(false));
        }
    }

    private void loadModelStd() {
        List events = this.std.getEvents(false).stream().map(event -> CompositeStandardEvent.Builder.copyOf(event).event(event.getEvent())).collect(Collectors.toCollection(ArrayList::new));
        if (this.std.getParentCmpStd() != null) {
            List<CompositeStandardEvent.Builder> excludedEvents = this.std.getEventsNotInherited();
            LinkedList<CompositeStandardEvent.Builder> inheritedEvents = new LinkedList<CompositeStandardEvent.Builder>();
            for (CompositeStandardEvent parentEvent : this.std.getParentCmpStd().getEvents(true)) {
                boolean hasMatch = events.stream().anyMatch(e -> e.matches(parentEvent));
                boolean excludes = excludedEvents.stream().anyMatch(e -> e.matches(parentEvent));
                if (hasMatch || excludes) continue;
                CompositeStandardEvent.Builder eventCopy = CompositeStandardEvent.Builder.copyOf(parentEvent).event(parentEvent.getEvent());
                eventCopy.inheritedFromParent = true;
                inheritedEvents.add(eventCopy);
            }
            events.addAll(inheritedEvents);
            events.addAll(excludedEvents);
        }
        this.model.setEvents(events);
        IGDScheme parentScheme = null;
        if (this.std.getParentSchID() > 0) {
            try {
                parentScheme = this.sbdb.getIGDScheme(this.std.getParentSchID());
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
        this.model.updateFields(this.std.getName(), this.std.getMinAge(), this.std.getMaxAge(), this.std.getTopCSU(), this.std.getBaseCSU(), this.std.isAgeScale(), parentScheme, this.std.getParentCmpStd());
        try {
            this.panelHdr.setFields();
        }
        catch (SQLException sqle) {
            StackError.showStackError((Exception)sqle);
        }
        this.setTitle("Editing Composite Standard: " + this.std.getName());
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.std && !this.std.equals(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.getEvents())) {
            if (this.jTextFieldStatus.getText().equalsIgnoreCase("Saved")) {
                this.loadModelStd();
                this.model.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "Warning: you have edited the Composite Standard that you have already modified in the underlying window.\nClose this window without saving, to discard your previous changes.");
            }
        }
    }

    private void refreshStatus() {
        System.out.println("Refreshing composite status...");
        if (this.std == null) {
            this.jTextFieldStatus.setText("Unsaved");
            this.jTextFieldStatus.setBackground(SbugsStatus.NOTSTORED);
            this.jButtonSave.setFont(new Font("Tahoma", 1, 11));
        } else if (this.std.equals(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.getEvents())) {
            this.jTextFieldStatus.setText("Saved");
            this.jTextFieldStatus.setBackground(SbugsStatus.STORED);
            this.jButtonSave.setFont(new Font("Tahoma", 0, 11));
        } else {
            try {
                this.panelHdr.validateFields(this.sbdb, this.std);
                this.model.validateCSU();
                CompositeStandard.validateBuilders(this.model.getEvents(), this.sbdb);
            }
            catch (InvalidFieldException e) {
                this.jTextFieldStatus.setText("Invalid");
                this.jTextFieldStatus.setBackground(SbugsStatus.CONFLICT);
                this.jButtonSave.setFont(new Font("Tahoma", 0, 11));
                return;
            }
            this.jTextFieldStatus.setText("Modified");
            this.jTextFieldStatus.setBackground(SbugsStatus.PARTSTORED);
            this.jButtonSave.setFont(new Font("Tahoma", 1, 11));
        }
    }

    public CompositeStandard getCmpStd() {
        return this.std;
    }

    private void initComponents() {
        this.jPopupMenuEvents = new JPopupMenu();
        this.jMenuItemDelete = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCmpStd = new JTableCmpStd(this.model);
        this.jTextFieldStatus = new JTextField();
        this.jButtonSave = new JButton();
        this.jPanelAudit = new JPanelAuditLine();
        this.panelHdr = new JPanelCmpStdHeader();
        this.jMenuItemDelete.setText("Remove");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameCmpStd this$0;
            {
                InternalFrameCmpStd internalFrameCmpStd = this$0;
                Objects.requireNonNull(internalFrameCmpStd);
                this.this$0 = internalFrameCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuEvents.add(this.jMenuItemDelete);
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/InternalFrameRangeChart.png")));
        this.setMinimumSize(new Dimension(560, 300));
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameCmpStd this$0;
            {
                InternalFrameCmpStd internalFrameCmpStd = this$0;
                Objects.requireNonNull(internalFrameCmpStd);
                this.this$0 = internalFrameCmpStd;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                this.this$0.internalFrameClosingEvent(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jTableCmpStd.setModel(this.model);
        this.jTableCmpStd.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameCmpStd this$0;
            {
                InternalFrameCmpStd internalFrameCmpStd = this$0;
                Objects.requireNonNull(internalFrameCmpStd);
                this.this$0 = internalFrameCmpStd;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableCmpStdMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableCmpStdMouseReleased(evt);
            }
        });
        this.jTableCmpStd.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ InternalFrameCmpStd this$0;
            {
                InternalFrameCmpStd internalFrameCmpStd = this$0;
                Objects.requireNonNull(internalFrameCmpStd);
                this.this$0 = internalFrameCmpStd;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableCmpStdKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCmpStd);
        this.jTextFieldStatus.setEditable(false);
        this.jTextFieldStatus.setHorizontalAlignment(0);
        this.jTextFieldStatus.setText("status");
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameCmpStd this$0;
            {
                InternalFrameCmpStd internalFrameCmpStd = this$0;
                Objects.requireNonNull(internalFrameCmpStd);
                this.this$0 = internalFrameCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanelAudit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldStatus, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave, -2, 70, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelHdr, -1, 787, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.panelHdr, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 264, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldStatus, -2, -1, -2).addComponent(this.jButtonSave)).addComponent(this.jPanelAudit, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.save();
        this.refreshStatus();
    }

    private void internalFrameClosingEvent(InternalFrameEvent evt) {
        this.close();
    }

    void close() {
        if (this.jTextFieldStatus.getBackground() != SbugsStatus.STORED) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to save changes?", this.getTitle(), 1);
            if (opt == 0) {
                this.save();
                if (this.std.getStatus() == SbugsStatus.STORED) {
                    this.dispose();
                }
            } else if (opt == 1) {
                this.dispose();
            } else {
                return;
            }
        }
        this.dispose();
    }

    private void jTableCmpStdKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteEvents();
        }
    }

    private void jTableCmpStdMousePressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jTableCmpStdMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteEvents();
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int rowNumber = this.jTableCmpStd.rowAtPoint(evt.getPoint());
            this.jTableCmpStd.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            this.jPopupMenuEvents.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void save() {
        Color status = this.jTextFieldStatus.getBackground();
        if (status == SbugsStatus.STORED) {
            return;
        }
        try {
            this.panelHdr.validateFields(this.sbdb, this.std);
            this.model.validateCSU();
            CompositeStandard.validateBuilders(this.model.getEvents(), this.sbdb);
            if (this.std != null) {
                this.std.update(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.getEvents(), this.model.getParentSchID(), this.model.getParentCmpStd());
            } else {
                this.panelHdr.setModelAge();
                this.std = this.sbdb.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.getEvents(), null, this.model.getParentSchID(), this.model.getParentCmpStd());
                this.setTitle("Editing Composite: " + this.std.getName());
            }
            this.sbdb.commit();
            if (this.std != null) {
                this.std.notifyObservers();
            }
            this.panelHdr.setFields();
        }
        catch (InvalidFieldException | SBPermissionException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshStatus();
    }

    public boolean importTaxa(Collection<Taxon> taxa) {
        try {
            int nBefore = this.sbdb.getSBEvents(false).size();
            int nAdded = this.model.importTaxa(taxa, this.sbdb);
            int nAfter = this.sbdb.getSBEvents(false).size();
            this.model.fireTableDataChanged();
            String msg = nAdded + (nAdded == 1 ? " event" : " events") + " added";
            if (nBefore != nAfter) {
                int nDict;
                msg = nDict + ((nDict = nAfter - nBefore) == 1 ? " event" : " events") + " added to dictionary\n" + msg + " to composite";
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            this.refreshStatus();
            return true;
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            return false;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return false;
        }
    }

    public boolean importEvents(Collection<SBEvent> events) {
        int nAdded = 0;
        for (SBEvent event : events) {
            nAdded += this.model.importEvent(event);
        }
        this.model.fireTableDataChanged();
        String msg = nAdded + (nAdded == 1 ? " event" : " events") + " added";
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
        this.refreshStatus();
        return true;
    }

    public boolean importCmpStdEvents(Collection<CompositeStandardEvent.Builder> events) {
        int nAdded = 0;
        for (CompositeStandardEvent.Builder event : events) {
            if (!this.model.importEvent(event)) continue;
            ++nAdded;
        }
        this.model.fireTableDataChanged();
        String msg = nAdded + (nAdded == 1 ? " event" : " events") + " added";
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
        this.refreshStatus();
        return true;
    }

    private void deleteEvents() {
        int[] selection = this.jTableCmpStd.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No row(s) selected", this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent.Builder> toRemove = new LinkedList<CompositeStandardEvent.Builder>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.getEvent(this.jTableCmpStd.convertRowIndexToModel(selection[i])));
        }
        this.model.removeEvents(toRemove);
        this.refreshStatus();
    }

    public Color getStatus() {
        return this.jTextFieldStatus.getBackground();
    }
}

