/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jsbugs.model2.event.TableModelCmpStd;
import model3.CompositeStandardEvent;
import util.table.SbugsTable;

public class JTableCmpStd
extends SbugsTable {
    private static final Color INHERITED_COLOR = new Color(255, 255, 204);
    private static final Color EXCLUDED_COLOR = Color.LIGHT_GRAY;

    public JTableCmpStd(TableModelCmpStd model) {
        super((TableModel)model);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void setModel(TableModel model) {
        if (!(model instanceof TableModelCmpStd)) {
            throw new IllegalArgumentException("Illegal model for composite standard table");
        }
        super.setModel(model);
    }

    public TableModelCmpStd getModel() {
        return (TableModelCmpStd)super.getModel();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        Component c = super.prepareRenderer(renderer, row, col);
        int modelRow = this.convertRowIndexToModel(row);
        CompositeStandardEvent.Builder event = this.getModel().getEvent(modelRow);
        if (this.getModel().highlightCells(col) || event.inheritedFromParent) {
            int[] selectedRows = this.getSelectedRows();
            Arrays.sort(selectedRows);
            if (Arrays.binarySearch(selectedRows, row) >= 0) {
                c.setBackground(this.getSelectionBackground());
                c.setForeground(this.getSelectionForeground());
            } else {
                if (event.inheritedFromParent) {
                    c.setBackground(event.excluded ? EXCLUDED_COLOR : INHERITED_COLOR);
                } else {
                    c.setBackground(this.getBackground());
                }
                c.setForeground(this.getForeground());
            }
        }
        if (col == 9) {
            c.setEnabled(false);
        } else {
            c.setEnabled(true);
        }
        return c;
    }
}

