/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.FloatRenderer;
import jsbugs.model2.event.CmpStdEventEditor;
import jsbugs.model2.event.CmpStdEventRenderer;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.DateRenderer;
import jsbugs.table.EnumEditor;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.EventCompareCSU;
import model3.IGDScheme;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;
import util.InvalidFieldException;
import util.SB;
import util.SBPermissionException;

public class TableModelCmpStd
extends AbstractTableModel {
    private final LinkedList<CompositeStandardEvent.Builder> allEvents = new LinkedList();
    private final LinkedList<CompositeStandardEvent.Builder> cmpStd = new LinkedList();
    double minAge;
    double maxAge;
    double topCSU;
    double baseCSU;
    boolean isAgeScale = true;
    String stdName = "";
    IGDScheme parentScheme;
    private CompositeStandard parentCmpStd;
    private boolean showInherited = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static final int COL_EVENT = 0;
    static final int COL_TYPE = 1;
    static final int COL_ERR_MINUS = 2;
    static final int COL_CSU = 3;
    static final int COL_ERR_PLUS = 4;
    static final int COL_AGE = 5;
    static final int COL_CONFIDENCE = 6;
    static final int COL_DISCIPLINE = 7;
    static final int COL_TAXON = 8;
    static final int COL_GEN = 9;
    static final int COL_COMMENT = 10;
    static final int COL_MODIFIED = 11;
    static final int COL_MODIFIER = 12;
    private static final String[] columnHeaders = new String[]{"Name", "Type", "Error -", "Age/CSU", "Error +", "Age", "Confidence", "Discipline", "Taxon", "Top/Base?", "Comment", "Modified", "By"};
    static final String[] tooltips = new String[]{"Event name (check box to include or exclude inherited events)", "Top (last appearance datum) or Base (first appearance datum)", "Lower extent of error bar", "Age (in Ma or Composite Standard Units)", "Upper extent of error bar", "Age (Ma)", "Confidence in age value", "Discipline of linked taxon", "Taxon to which dictionary event is linked (can be null)", "Is dictionary event flagged for generating events?", "Comment/reference", "", ""};
    private final int[] columnWidths = new int[]{180, 20, 20, 20, 20, 20, 25, 25, 100, 20, 40, 30, 10};

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        return this.cmpStd.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        CompositeStandardEvent.Builder event = this.cmpStd.get(row);
        switch (col) {
            default: {
                return "";
            }
            case 0: {
                return event;
            }
            case 1: {
                return CompositeStandardEvent.getEvTypeString(event.getType());
            }
            case 9: {
                return event.getEvent().isGenerate();
            }
            case 3: {
                return event.getCSU();
            }
            case 2: {
                return event.getErrMinus();
            }
            case 4: {
                return event.getErrPlus();
            }
            case 5: {
                return this.getAge(event.getCSU());
            }
            case 6: {
                return event.getConfidence();
            }
            case 7: {
                return event.getEvent().getTaxon() != null ? event.getEvent().getTaxon().getDisc().getAbr(false) : "";
            }
            case 8: {
                Object string = " ";
                string = (String)string + String.valueOf(event.getEvent().getTaxon() != null ? event.getEvent().getTaxon() : "");
                return string;
            }
            case 10: {
                return event.getComments();
            }
            case 11: {
                return event.getModified();
            }
            case 12: 
        }
        if (this.parentScheme != null && this.parentScheme.getDatabase() != null) {
            return event.getModifier(this.parentScheme.getDatabase());
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            case 0: {
                Boolean checked = (Boolean)obj;
                boolean excluded = checked == false;
                CompositeStandardEvent.Builder b = this.cmpStd.get(row);
                Boolean initial = b.excluded;
                if (initial.equals(excluded)) break;
                b.excluded = excluded;
                b.clearAuditModifier();
                this.pcs.firePropertyChange("notInherited for " + String.valueOf(b.getEvent()), initial, checked);
                break;
            }
            default: {
                return;
            }
            case 2: {
                double errMinus = Double.parseDouble(obj.toString());
                CompositeStandardEvent.Builder b = this.cmpStd.get(row);
                Double initial = b.getErrMinus();
                b.errMinus(errMinus);
                b.clearAuditModifier();
                if (initial != null && !(Math.abs(initial - errMinus) > 0.001)) break;
                this.pcs.firePropertyChange("errMinus for " + String.valueOf(b.getEvent()), initial, errMinus);
                break;
            }
            case 3: {
                double csu = Double.parseDouble(obj.toString());
                CompositeStandardEvent.Builder b = this.cmpStd.get(row);
                double initial = b.getCSU();
                b.csu(csu);
                b.clearAuditModifier();
                if (!(Math.abs(initial - csu) > 0.001)) break;
                this.pcs.firePropertyChange("csu for " + String.valueOf(b.getEvent()), initial, csu);
                break;
            }
            case 4: {
                double errPlus = Double.parseDouble(obj.toString());
                CompositeStandardEvent.Builder b = this.cmpStd.get(row);
                Double initial = b.getErrPlus();
                b.errPlus(errPlus);
                b.clearAuditModifier();
                if (initial != null && !(Math.abs(initial - errPlus) > 0.001)) break;
                this.pcs.firePropertyChange("errPlus for " + String.valueOf(b.getEvent()), initial, errPlus);
                break;
            }
            case 6: {
                Confidence orig = this.cmpStd.get(row).getConfidence();
                if (obj == orig) break;
                this.cmpStd.get(row).confidence((Confidence)obj);
                this.cmpStd.get(row).clearAuditModifier();
                this.pcs.firePropertyChange("confidence for " + String.valueOf(this.cmpStd.get(row).getEvent()), orig, obj);
                break;
            }
            case 10: {
                String origComment = this.cmpStd.get(row).getComments();
                if (SB.equal((Object)origComment, (Object)obj)) break;
                this.cmpStd.get(row).comment((String)obj);
                this.cmpStd.get(row).clearAuditModifier();
                this.pcs.firePropertyChange("comment for " + String.valueOf(this.cmpStd.get(row)), origComment, obj);
            }
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 8: {
                return Taxon.class;
            }
            case 3: 
            case 5: {
                return Double.class;
            }
            case 2: 
            case 4: {
                return Float.class;
            }
            case 9: {
                return Boolean.class;
            }
            case 6: {
                return Confidence.class;
            }
            case 0: {
                return CompositeStandardEvent.Builder.class;
            }
            case 11: 
        }
        return Date.class;
    }

    @Override
    public boolean isCellEditable(int r, int col) {
        CompositeStandardEvent.Builder b = this.cmpStd.get(r);
        switch (col) {
            case 0: {
                return b.inheritedFromParent;
            }
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
        }
        return !b.inheritedFromParent;
    }

    void setupTable(JTable table) {
        TableUtils.setTableHeaderBold((JTable)table);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidths[i]);
        }
        table.setBackground(Color.WHITE);
        table.setDefaultRenderer(Double.class, new ColouredRenderer(false, ColouredRenderer.GREY, 11));
        table.getColumnModel().getColumn(2).setCellRenderer(new FloatRenderer());
        table.getColumnModel().getColumn(4).setCellRenderer(new FloatRenderer());
        table.getColumnModel().getColumn(3).setCellRenderer(new FloatRenderer());
        table.getColumnModel().getColumn(6).setCellRenderer(new ComboRenderer());
        table.getColumnModel().getColumn(6).setCellEditor(new EnumEditor(new JComboBox(), Confidence.class, null));
        table.getColumnModel().getColumn(11).setCellRenderer(new DateRenderer());
        table.getColumnModel().getColumn(0).setCellRenderer(new CmpStdEventRenderer());
        table.getColumnModel().getColumn(0).setCellEditor(new CmpStdEventEditor());
        table.setRowHeight(20);
    }

    boolean highlightCells(int column) {
        return switch (column) {
            case 2, 3, 4 -> false;
            default -> true;
        };
    }

    CompositeStandardEvent.Builder getEvent(int evID, EventType type) {
        for (CompositeStandardEvent.Builder b : this.cmpStd) {
            if (b.getEvent().getEvID() != evID || b.getType() != type) continue;
            return b;
        }
        return null;
    }

    public CompositeStandardEvent.Builder getEvent(int index) {
        return this.cmpStd.get(index);
    }

    public void updateFields(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean isAgeScale, IGDScheme parentScheme, CompositeStandard parentCmpStd) {
        this.stdName = Objects.requireNonNullElse(name, "");
        this.minAge = minAge;
        this.maxAge = maxAge;
        this.topCSU = topCSU;
        this.baseCSU = baseCSU;
        this.isAgeScale = isAgeScale;
        this.parentScheme = parentScheme;
        this.parentCmpStd = parentCmpStd;
        this.pcs.firePropertyChange("All fields", "oldFields", "newFields");
    }

    public void setMinAge(double minAge) {
        double oldMin = this.minAge;
        this.minAge = minAge;
        this.pcs.firePropertyChange("min age", oldMin, minAge);
    }

    public void setMaxAge(double minAge) {
        double old = this.maxAge;
        this.maxAge = minAge;
        this.pcs.firePropertyChange("max age", old, minAge);
    }

    public void setTopCSU(double topCSU) {
        double old = this.topCSU;
        this.topCSU = topCSU;
        this.pcs.firePropertyChange("top CSU", old, topCSU);
    }

    public void setBaseCSU(double baseCSU) {
        double old = this.baseCSU;
        this.baseCSU = baseCSU;
        this.pcs.firePropertyChange("base CSU", old, baseCSU);
    }

    public void setNameField(String name) {
        String old = this.stdName;
        this.stdName = Objects.requireNonNullElse(name, "");
        this.pcs.firePropertyChange("name", old, this.stdName);
    }

    public void setAgeScale(boolean isAgeScale) {
        boolean old = this.isAgeScale;
        this.isAgeScale = isAgeScale;
        this.pcs.firePropertyChange("scale type", old, isAgeScale);
    }

    private double getAge(double CSU) {
        return CompositeStandard.getAge(CSU, this.isAgeScale, this.minAge, this.maxAge, this.topCSU, this.baseCSU);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void validateCSU() throws InvalidFieldException {
        double min = this.isAgeScale ? this.minAge : this.topCSU;
        double max = this.isAgeScale ? this.maxAge : this.baseCSU;
        for (CompositeStandardEvent.Builder event : this.cmpStd) {
            if (!(event.getMinCSU() < Math.min(min, max)) && !(event.getMaxCSU() > Math.max(min, max))) continue;
            throw new InvalidFieldException("'" + CompositeStandardEvent.getEvTypeString(event.getType()) + " " + String.valueOf(event.getEvent()) + "' falls outside Age/CSU range of section");
        }
    }

    public int importTaxa(Collection<Taxon> taxa, SBdb db) throws SQLException, SBPermissionException {
        int nAdded = 0;
        for (Taxon taxon : taxa) {
            SBEvent event = db.getSBEventGenerate(taxon.getSpecID());
            if (event == null) {
                event = db.addSBEvent(new SBEvent.Builder().name(taxon.toString()).taxon(taxon).isGenerate(true));
                db.commit();
            }
            nAdded += this.importEvent(event);
        }
        return nAdded;
    }

    public int importEvent(SBEvent event) {
        CompositeStandardEvent.Builder csEvent;
        int nAdded = 0;
        if (event.hasEvType(EventType.SINGLE) && this.getEvent(event.getEvID(), EventType.SINGLE) == null) {
            csEvent = new CompositeStandardEvent.Builder().event(event).type(EventType.SINGLE);
            this.allEvents.add(csEvent);
            this.cmpStd.add(csEvent);
            ++nAdded;
        }
        if (event.hasEvType(EventType.TOP) && this.getEvent(event.getEvID(), EventType.TOP) == null) {
            csEvent = new CompositeStandardEvent.Builder().event(event).type(EventType.TOP);
            this.allEvents.add(csEvent);
            this.cmpStd.add(csEvent);
            ++nAdded;
        }
        if (event.hasEvType(EventType.BASE) && this.getEvent(event.getEvID(), EventType.BASE) == null) {
            double csu = 0.0;
            CompositeStandardEvent.Builder fEvent = this.getEvent(event.getEvID(), EventType.TOP);
            if (fEvent != null) {
                csu = fEvent.getCSU();
            }
            CompositeStandardEvent.Builder csEvent2 = new CompositeStandardEvent.Builder().event(event).csu(csu).type(EventType.BASE);
            this.allEvents.add(csEvent2);
            this.cmpStd.add(csEvent2);
            ++nAdded;
        }
        return nAdded;
    }

    public boolean importEvent(CompositeStandardEvent.Builder event) {
        if (this.getEvent(event.getEvent().getEvID(), event.getType()) == null) {
            CompositeStandardEvent.Builder csEvent = new CompositeStandardEvent.Builder().event(event.getEvent()).type(event.getType()).csu(event.getCSU()).comment(event.getComments()).errMinus(event.getErrMinus()).errPlus(event.getErrPlus());
            this.cmpStd.add(csEvent);
            return true;
        }
        return false;
    }

    int getParentSchID() {
        if (this.parentScheme != null) {
            return this.parentScheme.getID();
        }
        return 0;
    }

    IGDScheme getParentScheme() {
        return this.parentScheme;
    }

    public void setEvents(Collection<CompositeStandardEvent.Builder> events) {
        this.allEvents.clear();
        this.allEvents.addAll(events);
        this.initEvents(this.showInherited);
    }

    public void initEvents(boolean includeInherited) {
        this.cmpStd.clear();
        if (includeInherited) {
            this.cmpStd.addAll(this.allEvents);
        } else {
            this.cmpStd.addAll(this.allEvents.stream().filter(e -> !e.inheritedFromParent).toList());
        }
        this.sort();
        this.showInherited = includeInherited;
        this.fireTableDataChanged();
    }

    List<CompositeStandardEvent.Builder> getEvents() {
        return this.allEvents.stream().filter(e -> !e.inheritedFromParent || e.excluded).toList();
    }

    void removeEvents(List<CompositeStandardEvent.Builder> toDelete) {
        this.allEvents.removeAll(toDelete);
        this.cmpStd.removeAll(toDelete);
        this.fireTableDataChanged();
    }

    void addEvent(CompositeStandardEvent.Builder toAdd) {
        this.allEvents.add(toAdd);
        if (!toAdd.inheritedFromParent || this.showInherited) {
            this.cmpStd.add(toAdd);
        }
        this.sort();
        this.fireTableDataChanged();
    }

    void sort() {
        Collections.sort(this.cmpStd, new EventCompareCSU(true));
    }

    boolean hasEvents() {
        return !this.allEvents.isEmpty();
    }

    int indexOf(CompositeStandardEvent.Builder b) {
        return this.cmpStd.indexOf(b);
    }

    public CompositeStandard getParentCmpStd() {
        return this.parentCmpStd;
    }

    public void setParentCmpStd(CompositeStandard parentCmpStd) {
        CompositeStandard old = this.parentCmpStd;
        this.parentCmpStd = parentCmpStd;
        this.pcs.firePropertyChange("parentComposite", old, parentCmpStd);
    }
}

