/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.Discipline;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.undo.UndoManager;
import jsbchart.block.ChartBlock;
import jsbchart.core.ChartManager;
import jsbugs.DialogEventOcc;
import jsbugs.DialogIGDAge;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.HintSequence;
import jsbugs.chart.DialogChartProperties;
import jsbugs.chart.component.JScrollPaneChartBase;
import jsbugs.controls.EnumButtonGroup;
import jsbugs.controls.EnumRadioButton;
import jsbugs.igdunits.DialogIGDUnitBuilder;
import jsbugs.igdunits.DialogLithostratUnit;
import jsbugs.model2.igdscheme.DialogSurfaceOption;
import jsbugs.model2.igdscheme.DialogSurfaceOption2;
import jsbugs.model2.igdscheme.DialogUnitUsage;
import jsbugs.model2.igdscheme.DialogUnlinked;
import jsbugs.model2.igdscheme.IGDSchTableModel;
import jsbugs.model2.igdscheme.IGDSchemeUpdate;
import jsbugs.model2.igdscheme.InteractiveChartJPanelLithostrat;
import jsbugs.model2.igdscheme.LithostratTableModel;
import jsbugs.model2.igdscheme.SchTableModel;
import jsbugs.model2.igdscheme.SurfaceTableModel;
import jsbugs.table.ButtonEditor;
import jsbugs.uiutil.audit.JPanelAuditLine;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.SbugsProcessHandler;
import model3.Chron;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDSchemeXLSReader;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.IGDUnitClass;
import model3.Lastval;
import model3.Lithdesc;
import model3.Lithology;
import model3.LithostratUnit;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Surface;
import net.java.balloontip.BalloonTip;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.process.SbugsProcess;
import util.table.SbugsTable;

public class DialogIGDScheme
extends SBDialog {
    private final SBdb db;
    private final ChartManager chartManager;
    private final SchTableModel modelUnits;
    private final JComboBox hierComboBox = new JComboBox();
    private final SurfaceTableModel modelSurfaces;
    private final JComboBox typeCombo = new JComboBox<Surface.SurfaceType>(Surface.SurfaceType.values());
    private final IGDScheme scheme;
    private final int igdType;
    private IGDScheme schemeAdded = null;
    private static final int NAME_LEN = 80;
    private Color copyColour = null;
    private IGDScheme parentScheme;
    Frame frameParent = null;
    private static BalloonTip LSTRAT_BALLOONTIP;
    private EnumButtonGroup<Discipline> discButtonGroup;
    private EnumButtonGroup<IGDScheme.SequenceType> sqButtonGroup;
    private Box.Filler filler1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonChrono;
    private JButton jButtonCopyColour;
    private JButton jButtonCreate;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonLstratBlockProp;
    private JButton jButtonLstratRedo;
    private JButton jButtonLstratTemplate;
    private JButton jButtonLstratUndo;
    private JButton jButtonLstratZoomIn;
    private JButton jButtonLstratZoomOut;
    private JButton jButtonOK;
    private JButton jButtonPasteColour;
    private JButton jButtonRead;
    private JButton jButtonShowUnlinked;
    private JButton jButtonWells;
    private JCheckBox jCheckBoxArchived;
    private JLabel jLabel1;
    private JPanelAuditLine jPanelAudit;
    private JPanel jPanelChronoScheme;
    private JPanel jPanelDisc;
    private JPanel jPanelLstrat;
    private JPanel jPanelSequence;
    private EnumRadioButton jRadioButtonMacro;
    private EnumRadioButton jRadioButtonMicro;
    private EnumRadioButton jRadioButtonNanno;
    private EnumRadioButton jRadioButtonPaly;
    private EnumRadioButton jRadioButtonSqD;
    private EnumRadioButton jRadioButtonSqG;
    private JScrollPane jScrollPaneSurfaces;
    private JScrollPane jScrollPaneUnits;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTable jTableScheme;
    private JTable jTableSurfaces;
    private JTextField jTextFieldChrono;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldName;
    private JToolBar jToolBar1;

    public DialogIGDScheme(Frame parent, boolean modal, SBdb db, IGDScheme scheme, int igdType, ChartManager chartManager) throws SQLException, SBException {
        super(parent, modal);
        if (db == null) {
            throw new IllegalArgumentException("Null data model in DialogIGDScheme");
        }
        this.db = db;
        this.chartManager = chartManager;
        this.scheme = scheme;
        this.igdType = scheme != null ? scheme.getIGDType() : igdType;
        switch (this.igdType) {
            case 2: {
                this.modelUnits = new LithostratTableModel();
                break;
            }
            default: {
                this.modelUnits = new IGDSchTableModel(this.igdType);
            }
        }
        this.modelSurfaces = new SurfaceTableModel(this.modelUnits.scheme);
        this.frameParent = parent;
        this.initComponents();
        this.init();
    }

    public DialogIGDScheme(JDialog parent, boolean modal, SBdb db, IGDScheme scheme, int igdType, ChartManager chartManager) throws SQLException, SBException {
        super((Window)parent, modal);
        if (db == null) {
            throw new IllegalArgumentException("Null data model in DialogIGDScheme");
        }
        this.db = db;
        this.chartManager = chartManager;
        this.scheme = scheme;
        this.igdType = scheme != null ? scheme.getIGDType() : igdType;
        switch (this.igdType) {
            case 2: {
                this.modelUnits = new LithostratTableModel();
                break;
            }
            default: {
                this.modelUnits = new IGDSchTableModel(igdType);
            }
        }
        this.modelSurfaces = new SurfaceTableModel(this.modelUnits.scheme);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.jTableScheme.setRowSorter(new TableRowSorter<SchTableModel>(this.modelUnits));
        new ColumnSortResetHandler(this.jTableScheme).attach();
        this.jTableSurfaces.setRowSorter(new TableRowSorter<SurfaceTableModel>(this.modelSurfaces));
        new ColumnSortResetHandler(this.jTableSurfaces).attach();
        this.setTitle(this.igdType == 26 ? "Magnetostratigraphy Scheme" : "Stratigraphic Scheme");
        this.discButtonGroup = new EnumButtonGroup(this.jRadioButtonMicro, this.jRadioButtonNanno, this.jRadioButtonPaly, this.jRadioButtonMacro);
        this.sqButtonGroup = new EnumButtonGroup(this.jRadioButtonSqD, this.jRadioButtonSqG);
        if (this.igdType != 10) {
            this.jScrollPaneSurfaces.setEnabled(false);
            this.jTabbedPane1.remove(this.jScrollPaneSurfaces);
        } else {
            this.jTabbedPane1.setSelectedComponent(this.jScrollPaneSurfaces);
            this.modelSurfaces.setupTable(this.jTableSurfaces, this.typeCombo);
        }
        if (this.igdType == 3 || this.igdType == 2) {
            this.jPanelChronoScheme.setVisible(false);
            this.jTextFieldChrono.setVisible(false);
            this.jButtonChrono.setVisible(false);
            this.jPanelDisc.setVisible(false);
            this.jPanelSequence.setVisible(false);
            this.pack();
        }
        if (this.igdType == 26) {
            this.jButtonWells.setVisible(false);
            this.jButtonShowUnlinked.setVisible(false);
            this.jButtonCreate.setVisible(false);
            this.jButtonCopyColour.setVisible(false);
            this.jTextFieldColour.setVisible(false);
            this.jButtonPasteColour.setVisible(false);
            this.jButtonRead.setVisible(false);
            this.jSeparator1.setVisible(false);
            this.jSeparator2.setVisible(false);
            this.jSeparator3.setVisible(false);
            this.jPanelDisc.setVisible(false);
            this.jPanelSequence.setVisible(false);
            this.pack();
        }
        if (this.scheme != null) {
            this.modelUnits.scheme.addAll(IGDScheme.copyUnits(this.scheme, this.db));
            if (this.scheme.getParentSchID() > 0) {
                this.parentScheme = this.db.getIGDScheme(this.scheme.getParentSchID());
                this.parentScheme.loadUnits();
                this.jTextFieldChrono.setText(this.parentScheme.getName());
            }
            if (this.scheme.isSequence()) {
                this.scheme.loadSurfaces();
                for (Surface surface : this.scheme.getSurfacesX()) {
                    Surface.Builder builder = Surface.Builder.copyOf(this.db, surface);
                    builder.setNOccs(surface.getNoccs(true));
                    this.modelSurfaces.scheme.add(builder);
                }
                this.modelUnits.surfaces = this.modelSurfaces.scheme;
            }
            this.setTitle(this.getTitle() + " : " + this.scheme.toString());
            if (this.scheme.getDatabase() == null || !this.scheme.getDatabase().isConnected()) {
                this.jButtonWells.setEnabled(false);
                this.jButtonShowUnlinked.setEnabled(false);
            }
            this.jTextFieldName.setText(this.scheme.getName());
            String creator = "";
            if (this.scheme.getCreator() > 0 && this.scheme.getDatabase() != null) {
                creator = this.scheme.getDatabase().getUser(this.scheme.getCreator()).getAbr();
            }
            Object modifier = "";
            if (this.scheme.getModifier() > 0 && this.scheme.getDatabase() != null) {
                modifier = this.scheme.getDatabase().getUser(this.scheme.getModifier()).getAbr();
            }
            this.jPanelAudit.setAuditText(creator, this.scheme.getCreated(), (String)modifier, this.scheme.getModified());
            this.jCheckBoxArchived.setSelected(this.scheme.isArchived());
            if (this.scheme.getIGDType() == 10) {
                this.sqButtonGroup.setSelection(this.scheme.getSqType());
            } else if (this.scheme.getIGDType() == 4) {
                this.discButtonGroup.setSelection(this.scheme.getDiscipline());
            }
            this.modelUnits.fireTableDataChanged();
        } else {
            this.setTitle(this.getTitle() + " : Add " + IGDInterval.getIGDName(this.igdType));
            this.jButtonWells.setEnabled(false);
            this.jButtonShowUnlinked.setEnabled(false);
            this.jCheckBoxArchived.setVisible(false);
            this.jPanelAudit.setVisible(false);
        }
        this.modelUnits.setupTable(this.jTableScheme, this.hierComboBox);
        if (this.modelUnits instanceof IGDSchTableModel) {
            this.jTableScheme.getColumnModel().getColumn(4).setCellEditor(new RefEditor(this));
            this.jTableScheme.getColumnModel().getColumn(7).setCellEditor(new RefEditor(this));
        } else if (this.modelUnits instanceof LithostratTableModel) {
            JComboBox<Lithology> lithBox = new JComboBox<Lithology>();
            lithBox.addItem(null);
            for (Lithology lith : this.db.getLithdesc().getList(Lithdesc.LithType.MAIN)) {
                lithBox.addItem(lith);
            }
            lithBox.setMaximumRowCount(30);
            this.jTableScheme.getColumnModel().getColumn(15).setCellEditor(new DefaultCellEditor(lithBox));
        }
        if (this.igdType != 10) {
            this.jButtonCreate.setEnabled(false);
            this.jPanelSequence.setEnabled(false);
            this.jRadioButtonSqD.setEnabled(false);
            this.jRadioButtonSqG.setEnabled(false);
        }
        if (this.igdType != 4) {
            this.jRadioButtonMicro.setEnabled(false);
            this.jRadioButtonMacro.setEnabled(false);
            this.jRadioButtonNanno.setEnabled(false);
            this.jRadioButtonPaly.setEnabled(false);
        }
        if (this.scheme != null && !this.scheme.canWrite(this.scheme.getDatabase(), null) || this.scheme == null && !SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.scheme != null ? this.scheme.getDeniedReason(this.db, "scheme", false) : SBRestrictable.getDeniedReason(false));
        }
        if (this.igdType == 2 && this.chartManager != null) {
            try {
                final InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat = new InteractiveChartJPanelLithostrat((LithostratTableModel)this.modelUnits, this.db, this.scheme != null ? this.scheme.getID() : 0, this.chartManager);
                final JScrollPaneChartBase scrollPane = new JScrollPaneChartBase(interactiveChartJPanelLithostrat);
                scrollPane.initMouseWheelZoomListener();
                scrollPane.refreshView();
                scrollPane.setAlignmentX(0.0f);
                this.jPanelLstrat.add(scrollPane);
                this.jButtonLstratZoomIn.addActionListener(new ActionListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        scrollPane.zoom(true);
                    }
                });
                this.jButtonLstratZoomOut.addActionListener(new ActionListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        scrollPane.zoom(false);
                    }
                });
                this.jButtonLstratBlockProp.addActionListener(new ActionListener(){
                    final /* synthetic */ DialogIGDScheme this$0;
                    {
                        DialogIGDScheme dialogIGDScheme = this$0;
                        Objects.requireNonNull(dialogIGDScheme);
                        this.this$0 = dialogIGDScheme;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            ChartBlock block = (ChartBlock)interactiveChartJPanelLithostrat.chart.getBlockSingle();
                            DialogChartProperties dialog = new DialogChartProperties((JDialog)((Object)this.this$0), true, interactiveChartJPanelLithostrat.chart.getProperties(), this.this$0.db, block, false, true);
                            dialog.setLocationRelativeTo((Component)((Object)this.this$0));
                            dialog.setVisible(true);
                            if (dialog.isOK()) {
                                interactiveChartJPanelLithostrat.updatePref();
                                scrollPane.refreshView();
                            }
                        }
                        catch (RuntimeException re) {
                            StackError.showStackError((String)"", (Throwable)re);
                        }
                    }
                });
                this.jButtonLstratTemplate.addActionListener(new ActionListener(){
                    final /* synthetic */ DialogIGDScheme this$0;
                    {
                        DialogIGDScheme dialogIGDScheme = this$0;
                        Objects.requireNonNull(dialogIGDScheme);
                        this.this$0 = dialogIGDScheme;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        interactiveChartJPanelLithostrat.chooseTemplate((Dialog)((Object)this.this$0), this.this$0.chartManager);
                    }
                });
                this.jButtonLstratUndo.addActionListener(new ActionListener(){
                    final /* synthetic */ DialogIGDScheme this$0;
                    {
                        DialogIGDScheme dialogIGDScheme = this$0;
                        Objects.requireNonNull(dialogIGDScheme);
                        this.this$0 = dialogIGDScheme;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UndoManager manager = scrollPane.getView().getUndoManager();
                        if (manager == null || !manager.canUndo()) {
                            this.this$0.getToolkit().beep();
                            return;
                        }
                        manager.undo();
                        scrollPane.repaint();
                    }
                });
                this.jButtonLstratRedo.addActionListener(new ActionListener(){
                    final /* synthetic */ DialogIGDScheme this$0;
                    {
                        DialogIGDScheme dialogIGDScheme = this$0;
                        Objects.requireNonNull(dialogIGDScheme);
                        this.this$0 = dialogIGDScheme;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UndoManager manager = scrollPane.getView().getUndoManager();
                        if (manager == null || !manager.canRedo()) {
                            this.this$0.getToolkit().beep();
                            return;
                        }
                        manager.redo();
                        scrollPane.repaint();
                    }
                });
            }
            catch (SQLException | SBException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        } else {
            this.jTabbedPane1.remove(this.jPanelLstrat);
            this.jPanelLstrat = null;
            this.jTabbedPane1StateChanged(null);
        }
        this.jTabbedPane1.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.tabbedPanelChanged();
            }
        });
        this.setEditButtonEnabled();
    }

    public void setDiscipline(Discipline discipline) {
        if (discipline == null) {
            return;
        }
        switch (discipline) {
            case MICRO: {
                this.jRadioButtonMicro.setSelected(true);
                break;
            }
            case NANNO: {
                this.jRadioButtonNanno.setSelected(true);
                break;
            }
            case PALY: {
                this.jRadioButtonPaly.setSelected(true);
                break;
            }
            case MACRO: {
                this.jRadioButtonMacro.setSelected(true);
            }
        }
    }

    private void stopSchemeTableEditing() {
        if (this.jTableScheme.isEditing()) {
            this.jTableScheme.getCellEditor().cancelCellEditing();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowUnlinked = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonWells = new JButton();
        this.jButtonCreate = new JButton();
        this.jPanelDisc = new JPanel();
        this.jRadioButtonMicro = new EnumRadioButton<Discipline>(Discipline.MICRO);
        this.jRadioButtonNanno = new EnumRadioButton<Discipline>(Discipline.NANNO);
        this.jRadioButtonPaly = new EnumRadioButton<Discipline>(Discipline.PALY);
        this.jRadioButtonMacro = new EnumRadioButton<Discipline>(Discipline.MACRO);
        this.jPanelSequence = new JPanel();
        this.jRadioButtonSqD = new EnumRadioButton<IGDScheme.SequenceType>(IGDScheme.SequenceType.DEPOSITIONAL);
        this.jRadioButtonSqG = new EnumRadioButton<IGDScheme.SequenceType>(IGDScheme.SequenceType.GENETIC);
        this.jButtonHelp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPaneSurfaces = new JScrollPane();
        this.jTableSurfaces = new SbugsTable((TableModel)this.modelSurfaces);
        this.jPanelLstrat = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jButtonLstratZoomIn = new JButton();
        this.jButtonLstratZoomOut = new JButton();
        this.jButtonLstratUndo = new JButton();
        this.jButtonLstratRedo = new JButton();
        this.jButtonLstratBlockProp = new JButton();
        this.jButtonLstratTemplate = new JButton();
        this.jScrollPaneUnits = new JScrollPane();
        this.jTableScheme = new SbugsTable((TableModel)this.modelUnits);
        this.jButtonCopyColour = new JButton();
        this.jTextFieldColour = new JTextField();
        this.jButtonPasteColour = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonRead = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.jSeparator3 = new JSeparator();
        this.jButtonEdit = new JButton();
        this.jPanelAudit = new JPanelAuditLine();
        this.jCheckBoxArchived = new JCheckBox();
        this.jPanelChronoScheme = new JPanel();
        this.jTextFieldChrono = new JTextField();
        this.jButtonChrono = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 580));
        this.jLabel1.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.setToolTipText("");
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setToolTipText("");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Remove");
        this.jButtonDelete.setToolTipText("");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUnlinked.setText("Show unlinked...");
        this.jButtonShowUnlinked.setToolTipText("Show unlinked intervals in this scheme");
        this.jButtonShowUnlinked.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUnlinked.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowUnlinkedActionPerformed(evt);
            }
        });
        this.jButtonWells.setText("Show wells...");
        this.jButtonWells.setToolTipText("");
        this.jButtonWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellsActionPerformed(evt);
            }
        });
        this.jButtonCreate.setText("Create...");
        this.jButtonCreate.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonCreate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCreateActionPerformed(evt);
            }
        });
        this.jPanelDisc.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jRadioButtonMicro.setText("Micro");
        this.jRadioButtonNanno.setText("Nanno");
        this.jRadioButtonPaly.setText("Paly");
        this.jRadioButtonMacro.setText("Macro");
        GroupLayout jPanelDiscLayout = new GroupLayout((Container)this.jPanelDisc);
        this.jPanelDisc.setLayout((LayoutManager)jPanelDiscLayout);
        jPanelDiscLayout.setHorizontalGroup((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDiscLayout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMicro, -2, -1, -2).addPreferredGap(0).add((Component)this.jRadioButtonNanno, -2, -1, -2).addPreferredGap(0).add((Component)this.jRadioButtonPaly, -2, -1, -2).addPreferredGap(0).add((Component)this.jRadioButtonMacro, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDiscLayout.setVerticalGroup((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(3).add((Component)this.jRadioButtonMicro, -2, -1, -2).add((Component)this.jRadioButtonNanno, -2, -1, -2).add((Component)this.jRadioButtonPaly, -2, -1, -2).add((Component)this.jRadioButtonMacro, -2, -1, -2)));
        this.jPanelSequence.setBorder(BorderFactory.createTitledBorder(null, "Sequence Type", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelSequence.setMinimumSize(new Dimension(580, 600));
        this.jRadioButtonSqD.setText("Depositional (Vail)");
        this.jRadioButtonSqG.setText("Genetic (Galloway)");
        GroupLayout jPanelSequenceLayout = new GroupLayout((Container)this.jPanelSequence);
        this.jPanelSequence.setLayout((LayoutManager)jPanelSequenceLayout);
        jPanelSequenceLayout.setHorizontalGroup((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSequenceLayout.createSequentialGroup().add((Component)this.jRadioButtonSqD, -2, -1, -2).addPreferredGap(1).add((Component)this.jRadioButtonSqG, -2, -1, -2)));
        jPanelSequenceLayout.setVerticalGroup((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSequenceLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(3).add((Component)this.jRadioButtonSqD, -2, -1, -2).add((Component)this.jRadioButtonSqG, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTableSurfaces.setModel(this.modelSurfaces);
        this.jScrollPaneSurfaces.setViewportView(this.jTableSurfaces);
        this.jTabbedPane1.addTab("Surfaces", this.jScrollPaneSurfaces);
        this.jPanelLstrat.setLayout(new BoxLayout(this.jPanelLstrat, 3));
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setAlignmentX(0.0f);
        this.jToolBar1.setPreferredSize(new Dimension(100, 30));
        this.jButtonLstratZoomIn.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/ZoomIn24.png")));
        this.jButtonLstratZoomIn.setFocusable(false);
        this.jButtonLstratZoomIn.setHorizontalTextPosition(0);
        this.jButtonLstratZoomIn.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratZoomIn);
        this.jButtonLstratZoomOut.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/ZoomOut24.png")));
        this.jButtonLstratZoomOut.setFocusable(false);
        this.jButtonLstratZoomOut.setHorizontalTextPosition(0);
        this.jButtonLstratZoomOut.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratZoomOut);
        this.jButtonLstratUndo.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/FrameSamples_Undo.png")));
        this.jButtonLstratUndo.setFocusable(false);
        this.jButtonLstratUndo.setHorizontalTextPosition(0);
        this.jButtonLstratUndo.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratUndo);
        this.jButtonLstratRedo.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/FrameSamples_Redo.png")));
        this.jButtonLstratRedo.setFocusable(false);
        this.jButtonLstratRedo.setHorizontalTextPosition(0);
        this.jButtonLstratRedo.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratRedo);
        this.jButtonLstratBlockProp.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/FrameSamples_ChartProperties.png")));
        this.jButtonLstratBlockProp.setFocusable(false);
        this.jButtonLstratBlockProp.setHorizontalTextPosition(0);
        this.jButtonLstratBlockProp.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratBlockProp);
        this.jButtonLstratTemplate.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/openSchemeTemplate.png")));
        this.jButtonLstratTemplate.setFocusable(false);
        this.jButtonLstratTemplate.setHorizontalTextPosition(0);
        this.jButtonLstratTemplate.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonLstratTemplate);
        this.jPanelLstrat.add(this.jToolBar1);
        this.jTabbedPane1.addTab("Graphic", this.jPanelLstrat);
        this.jTableScheme.setModel(this.modelUnits);
        this.jScrollPaneUnits.setViewportView(this.jTableScheme);
        this.jTabbedPane1.addTab("Units", this.jScrollPaneUnits);
        this.jButtonCopyColour.setText("Copy colour");
        this.jButtonCopyColour.setToolTipText("Copy colour of selected unit");
        this.jButtonCopyColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyColourActionPerformed(evt);
            }
        });
        this.jTextFieldColour.setEditable(false);
        this.jTextFieldColour.setToolTipText("Selected colour");
        this.jButtonPasteColour.setText("Paste colour");
        this.jButtonPasteColour.setToolTipText("Paste selected colour to selected unit");
        this.jButtonPasteColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPasteColourActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Read the contents of an XLS file into scheme units");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jCheckBoxArchived.setText("Archived");
        this.jCheckBoxArchived.setToolTipText("Archived schemes will not appear for selection.");
        this.jPanelChronoScheme.setBorder(BorderFactory.createTitledBorder(null, "Timescale", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelChronoScheme.setMinimumSize(new Dimension(580, 600));
        this.jTextFieldChrono.setEditable(false);
        this.jTextFieldChrono.setBackground(new Color(255, 255, 204));
        this.jButtonChrono.setText("...");
        this.jButtonChrono.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDScheme this$0;
            {
                DialogIGDScheme dialogIGDScheme = this$0;
                Objects.requireNonNull(dialogIGDScheme);
                this.this$0 = dialogIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChronoActionPerformed(evt);
            }
        });
        GroupLayout jPanelChronoSchemeLayout = new GroupLayout((Container)this.jPanelChronoScheme);
        this.jPanelChronoScheme.setLayout((LayoutManager)jPanelChronoSchemeLayout);
        jPanelChronoSchemeLayout.setHorizontalGroup((GroupLayout.Group)jPanelChronoSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoSchemeLayout.createSequentialGroup().add((Component)this.jTextFieldChrono, -2, 255, -2).add(18, 18, 18).add((Component)this.jButtonChrono, -2, 30, -2).add(0, 0, Short.MAX_VALUE)));
        jPanelChronoSchemeLayout.setVerticalGroup((GroupLayout.Group)jPanelChronoSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoSchemeLayout.createSequentialGroup().add((GroupLayout.Group)jPanelChronoSchemeLayout.createParallelGroup(3).add((Component)this.jTextFieldChrono, -2, -1, -2).add((Component)this.jButtonChrono)).add(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(23, 23, 23).add((Component)this.jTextFieldName)).add((Component)this.jTabbedPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelDisc, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanelSequence, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanelChronoScheme, -2, 331, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelAudit, -2, -1, -2).addPreferredGap(0, 230, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jButtonRead, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator3).add(2, (Component)this.jButtonPasteColour, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jTextFieldColour).add(2, (Component)this.jButtonCopyColour, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator2, -2, 91, -2).add(2, (Component)this.jButtonCreate, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonShowUnlinked, -2, 91, -2).add(2, (Component)this.jButtonWells, -2, 91, -2).add(2, (Component)this.jSeparator1).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonInsert, -2, 105, -2)).add((Component)this.filler1, -2, 91, -2).add((Component)this.jCheckBoxArchived)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCopyColour, this.jButtonCreate, this.jButtonDelete, this.jButtonEdit, this.jButtonInsert, this.jButtonPasteColour, this.jButtonRead, this.jButtonShowUnlinked, this.jButtonWells, this.jSeparator1, this.jSeparator2, this.jSeparator3, this.jTextFieldColour}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(19, 19, 19).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jCheckBoxArchived)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(59, 59, 59).add((Component)this.filler1, -2, 15, -2).addPreferredGap(0).add((Component)this.jButtonInsert).add(5, 5, 5).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonWells).addPreferredGap(0).add((Component)this.jButtonShowUnlinked).addPreferredGap(0).add((Component)this.jButtonCreate).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCopyColour).addPreferredGap(0).add((Component)this.jTextFieldColour, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonPasteColour).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonRead).add(0, 176, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanelDisc, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelSequence, -2, 44, -2)).add((Component)this.jPanelChronoScheme, -2, 44, -2)).addPreferredGap(0).add((Component)this.jTabbedPane1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanelAudit, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp))))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.isEditing()) {
            this.jTableScheme.getCellEditor().stopCellEditing();
        }
        if (this.jTableSurfaces.isEditing()) {
            this.jTableSurfaces.getCellEditor().stopCellEditing();
        }
        IGDSchemeUpdate update = new IGDSchemeUpdate(this.modelUnits.igdType, this.scheme);
        update.setDetails(this.jTextFieldName.getText(), this.parentScheme, this.discButtonGroup.getSelectedValue(), this.sqButtonGroup.getSelectedValue(), this.modelUnits.scheme, this.modelSurfaces.scheme, this.jCheckBoxArchived.isSelected());
        new SbugsProcessHandler(update, (Component)((Object)this)).handleProcess();
        if (update.getResult() == SbugsProcess.ProcessResult.SUCCESS) {
            this.schemeAdded = update.getSchemeAdded();
            this.setOK();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                this.jTableScheme.editingCanceled(null);
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select one or more rows to remove", this.getTitle(), 2);
                    return;
                }
                LinkedList<IGDUnitBase.Builder> toDie = new LinkedList<IGDUnitBase.Builder>();
                for (int i = 0; i < indices.length; ++i) {
                    toDie.add(this.modelUnits.scheme.get(this.jTableScheme.convertRowIndexToModel(indices[i])));
                }
                ListIterator toDieIt = toDie.listIterator();
                ArrayList<IGDUnit.Builder> list = new ArrayList<IGDUnit.Builder>();
                while (toDieIt.hasNext()) {
                    IGDUnitBase.Builder dying = (IGDUnitBase.Builder)toDieIt.next();
                    list.clear();
                    for (IGDUnitBase.Builder builder : this.modelUnits.scheme) {
                        if (builder == dying || !(builder instanceof IGDUnit.Builder) || ((IGDUnit.Builder)builder).l_age_ref != dying && ((IGDUnit.Builder)builder).u_age_ref != dying) continue;
                        list.add((IGDUnit.Builder)builder);
                    }
                    if (list.isEmpty()) continue;
                    String msg = "'" + String.valueOf(dying) + "' is referenced by units:";
                    for (IGDUnitBase.Builder b : list) {
                        msg = msg + "\n  " + String.valueOf(b);
                    }
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this), msg + "\nAre you sure you want to delete it?", "Delete Units", 0);
                    if (n != 0) {
                        toDieIt.remove();
                        continue;
                    }
                    for (IGDUnit.Builder referencing3 : list) {
                        Double age;
                        if (referencing3.u_age_ref == dying) {
                            age = referencing3.getUage();
                            referencing3.ageRef(true, 0);
                            referencing3.age(true, age);
                        }
                        if (referencing3.l_age_ref != dying) continue;
                        age = referencing3.getLage();
                        referencing3.ageRef(false, 0);
                        referencing3.age(false, age);
                    }
                }
                Iterator it = toDie.iterator();
                while (it.hasNext()) {
                    this.modelUnits.scheme.remove(it.next());
                }
                if (indices.length > 1) {
                    this.jTableScheme.clearSelection();
                }
                this.modelUnits.fireTableDataChanged();
            } else {
                int[] indices = this.jTableSurfaces.getSelectedRows();
                this.jTableSurfaces.editingCanceled(null);
                if (indices.length == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select one or more rows to remove", this.getTitle(), 2);
                    return;
                }
                LinkedList<Surface.Builder> toDie = new LinkedList<Surface.Builder>();
                for (int i = 0; i < indices.length; ++i) {
                    toDie.add(this.modelSurfaces.scheme.get(this.jTableSurfaces.convertRowIndexToModel(indices[i])));
                }
                for (Surface.Builder surface : toDie) {
                    if (surface.getNOccs() <= 0) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "You can't delete surfaces that are picked in wells. You must delete the well data first.", this.getTitle(), 2);
                    return;
                }
                Iterator it = toDie.iterator();
                while (it.hasNext()) {
                    this.modelSurfaces.scheme.remove(it.next());
                }
                if (indices.length > 1) {
                    this.jTableSurfaces.clearSelection();
                }
                this.modelSurfaces.fireTableDataChanged();
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
            if (this.jTableScheme.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No row selected", this.getTitle(), 2);
                return;
            }
            IGDUnitBase.Builder selected = this.modelUnits.scheme.get(this.jTableScheme.convertRowIndexToModel(this.jTableScheme.getSelectedRow()));
            IGDUnitBase.Builder unit = this.modelUnits.newBuilder(this.db).hier(selected.getHier());
            int sort = -1;
            for (RowSorter.SortKey k : this.jTableScheme.getRowSorter().getSortKeys()) {
                sort = k.getColumn();
            }
            if (sort == 6) {
                age = selected.getLage();
                if (unit instanceof IGDUnit.Builder) {
                    ((IGDUnit.Builder)unit).age(age, age);
                }
            } else if (sort == 3) {
                age = selected.getUage();
                if (unit instanceof IGDUnit.Builder) {
                    ((IGDUnit.Builder)unit).age(age, age);
                }
            }
            this.modelUnits.scheme.add(this.jTableScheme.convertRowIndexToModel(this.jTableScheme.getSelectedRow()), unit);
            this.modelUnits.fireTableDataChanged();
        } else {
            if (this.jTableSurfaces.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No row selected", this.getTitle(), 2);
                return;
            }
            Surface.Builder surface = new Surface.Builder(this.db);
            Surface.Builder selected = this.modelSurfaces.scheme.get(this.jTableSurfaces.convertRowIndexToModel(this.jTableSurfaces.getSelectedRow()));
            int sort = -1;
            for (RowSorter.SortKey k : this.jTableSurfaces.getRowSorter().getSortKeys()) {
                sort = k.getColumn();
            }
            if (sort == 3) {
                double age = selected.getAge();
                surface.age(age);
            }
            this.modelSurfaces.scheme.add(this.jTableSurfaces.convertRowIndexToModel(this.jTableSurfaces.getSelectedRow()), surface);
            this.modelSurfaces.fireTableDataChanged();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int hier = this.modelUnits.scheme.size() > 0 ? this.modelUnits.scheme.get(this.modelUnits.scheme.size() - 1).getHier() : IGDIntervalZone.getDefaultHier(this.modelUnits.igdType);
                IGDUnitBase.Builder builder = this.modelUnits.newBuilder(this.db);
                builder.hier(hier);
                this.modelUnits.scheme.add(builder);
                this.modelUnits.fireTableDataChanged();
                int index = this.modelUnits.scheme.size() - 1;
                this.jTableScheme.scrollRectToVisible(this.jTableScheme.getCellRect(index, 0, false));
                this.jTableScheme.setRowSelectionInterval(index, index);
            } else {
                Surface.Builder surface = new Surface.Builder(this.db);
                this.modelSurfaces.scheme.add(surface);
                this.modelSurfaces.fireTableDataChanged();
                int index = this.modelSurfaces.scheme.size() - 1;
                this.jTableSurfaces.scrollRectToVisible(this.jTableSurfaces.getCellRect(index, 0, false));
                this.jTableSurfaces.setRowSelectionInterval(index, index);
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonShowUnlinkedActionPerformed(ActionEvent evt) {
        if (this.scheme == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Scheme is not stored", this.getTitle(), 2);
            return;
        }
        try {
            List<IGDScheme.UnlinkedInterval> list = this.scheme.getUnlinkedIntervals();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "There are no unlinked informal terms for this scheme", this.getTitle(), 1);
                return;
            }
            DialogUnlinked dialog = new DialogUnlinked((JDialog)((Object)this), true, this.scheme, list);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selection != null) {
                int startIndex;
                int endIndex = startIndex = -1;
                for (IGDScheme.UnlinkedInterval interval : dialog.selection) {
                    if (this.scheme.findUnitBase(interval.informalName) != null) continue;
                    IGDUnitBase.Builder b = this.modelUnits.newBuilder(this.scheme.getDatabase());
                    b.name(interval.informalName);
                    b.hier(IGDIntervalZone.getDefaultHier(this.scheme.getIGDType()));
                    this.modelUnits.scheme.add(b);
                    endIndex = this.modelUnits.scheme.size() - 1;
                    if (startIndex >= 0) continue;
                    startIndex = endIndex;
                }
                this.modelUnits.fireTableDataChanged();
                if (startIndex >= 0) {
                    this.jTableScheme.scrollRectToVisible(this.jTableScheme.getCellRect(endIndex, 0, false));
                    this.jTableScheme.setRowSelectionInterval(startIndex, endIndex);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException | SBException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jButtonWellsActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select one unit to display", this.getTitle(), 2);
                    return;
                }
                IGDUnitBase.Builder unit = this.modelUnits.scheme.get(this.jTableScheme.convertRowIndexToModel(indices[0]));
                if (unit.getOriginalID() <= 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No original unit", this.getTitle(), 2);
                    return;
                }
                IGDUnitBase origUnit = this.scheme.findUnitBase(unit.getOriginalID());
                if (origUnit == null || origUnit.getUnitID() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Unit is not stored in scheme.", this.getTitle(), 2);
                    return;
                }
                if (origUnit.getNoccs(true) > 0) {
                    DialogUnitUsage dialog = new DialogUnitUsage(this.frameParent, false, origUnit, this.db);
                    dialog.setLocationRelativeTo((Component)((Object)this));
                    dialog.setVisible(true);
                    return;
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Unit: " + unit.getName() + " does not occur in any wells.", this.getTitle(), 1);
                }
                return;
            }
            int[] indices = this.jTableSurfaces.getSelectedRows();
            if (indices.length != 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select one surface to display", this.getTitle(), 2);
                return;
            }
            Surface.Builder surface = this.modelSurfaces.scheme.get(this.jTableSurfaces.convertRowIndexToModel(indices[0]));
            Surface origSurface = this.scheme.getSurface(surface.getOriginalID());
            if (origSurface == null || origSurface.getSurfaceID() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Surface is not stored in scheme.", this.getTitle(), 2);
                return;
            }
            DialogEventOcc dialog = new DialogEventOcc((JDialog)((Object)this), true, 21, this.db);
            dialog.setSurface(origSurface);
            dialog.setLocationRelativeTo((Component)((Object)this));
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.selectedWellResult == null) return;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void jButtonCreateActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
            try {
                void var4_17;
                if (this.modelSurfaces.scheme.size() > 0) {
                    boolean canClear = true;
                    for (Surface.Builder builder : this.modelSurfaces.scheme) {
                        if (builder.getNOccs() <= 0) continue;
                        canClear = false;
                    }
                    if (canClear) {
                        opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Clear all existing surfaces?", this.getTitle(), 1, 3);
                        if (opt == 2 || opt == -1) {
                            return;
                        }
                        if (opt == 0) {
                            this.modelUnits.scheme.clear();
                        }
                    } else {
                        opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Cannot clear existing surfaces because some have been picked in wells.\nContinue to create non-conflicting surfaces?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            return;
                        }
                    }
                }
                DialogSurfaceOption2 dialog = new DialogSurfaceOption2((JDialog)((Object)this), true, this.jRadioButtonSqD.isSelected());
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                int created = 0;
                for (IGDUnitBase.Builder unitB : this.modelUnits.scheme) {
                    Surface.Builder surface;
                    if (!unitB.hasAges()) continue;
                    if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.SBTOP || dialog.selection == DialogSurfaceOption2.SURFACEGEN.MFSTOP) {
                        if (DialogIGDScheme.findSurface(this.modelSurfaces.scheme, unitB.getUage()) != null) continue;
                        ++created;
                        surface = new Surface.Builder(this.db).age(unitB.getUage()).name(unitB.getName());
                        if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.SBTOP) {
                            surface.type(Surface.SurfaceType.SB);
                        } else if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.MFSTOP) {
                            surface.type(Surface.SurfaceType.MFS);
                        }
                        this.modelSurfaces.scheme.add(surface);
                        continue;
                    }
                    if (!(unitB.getLage() > 0.0) || DialogIGDScheme.findSurface(this.modelSurfaces.scheme, unitB.getLage()) != null) continue;
                    ++created;
                    surface = new Surface.Builder(this.db).age(unitB.getLage()).name(unitB.getName());
                    if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.SB) {
                        surface.type(Surface.SurfaceType.SB);
                    } else if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.MFS) {
                        surface.type(Surface.SurfaceType.MFS);
                    }
                    this.modelSurfaces.scheme.add(surface);
                }
                if (created > 0) {
                    String string = created + " surfaces were created. Press Surfaces tab to view.";
                } else {
                    String string = "No surfaces were created. There are no ages on the unit boundaries, or there are existing surfaces at boundary ages.";
                }
                JOptionPane.showMessageDialog((Component)((Object)this), var4_17, this.getTitle(), 1);
                this.modelSurfaces.fireTableDataChanged();
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        } else {
            try {
                void var4_21;
                if (this.modelUnits.scheme.size() > 0) {
                    boolean canClear = true;
                    for (IGDUnitBase.Builder builder : this.modelUnits.scheme) {
                        IGDUnit.Builder b = (IGDUnit.Builder)builder;
                        if (b.getNOccs() <= 0) continue;
                        canClear = false;
                    }
                    if (canClear) {
                        opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Clear all existing units?", this.getTitle(), 1, 3);
                        if (opt == 2 || opt == -1) {
                            return;
                        }
                        if (opt == 0) {
                            this.modelUnits.scheme.clear();
                        }
                    } else {
                        opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Cannot clear existing units because some have been picked in wells.\nContinue to create non-conflicting units?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            return;
                        }
                    }
                }
                DialogSurfaceOption dialog = new DialogSurfaceOption((JDialog)((Object)this), true, this.jRadioButtonSqD.isSelected());
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                IGDUnit.Builder unit = null;
                boolean bl = false;
                for (Surface.Builder surface : this.modelSurfaces.scheme) {
                    void var4_20;
                    if ((surface.getType() == Surface.SurfaceType.SB || surface.getType() == Surface.SurfaceType.CC) && dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPSB) {
                        if (unit != null) {
                            unit.age(false, (Double)surface.getAge());
                            if (this.addUnitToScheme(unit)) {
                                ++var4_20;
                            }
                        }
                        unit = new IGDUnit.Builder(this.db);
                        unit.age(true, (Double)surface.getAge()).hier(1);
                        unit.name(this.filterSurfaceName(surface.getName()));
                        continue;
                    }
                    if ((surface.getType() == Surface.SurfaceType.SB || surface.getType() == Surface.SurfaceType.CC) && dialog.selection == DialogSurfaceOption.SURFACEGEN.BASESB) {
                        if (unit == null) {
                            unit = new IGDUnit.Builder(this.db);
                            unit.age(true, (Double)0.0).hier(1);
                        }
                        unit.name(this.filterSurfaceName(surface.getName()));
                        unit.age(false, (Double)surface.getAge());
                        if (this.addUnitToScheme(unit)) {
                            ++var4_20;
                        }
                        unit = new IGDUnit.Builder(this.db);
                        unit.age(true, (Double)surface.getAge()).hier(1);
                        continue;
                    }
                    if (surface.getType() == Surface.SurfaceType.MFS && dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPMFS) {
                        if (unit != null) {
                            unit.age(false, (Double)surface.getAge());
                            if (this.addUnitToScheme(unit)) {
                                ++var4_20;
                            }
                        }
                        unit = new IGDUnit.Builder(this.db);
                        unit.age(true, (Double)surface.getAge()).hier(1);
                        unit.name(this.filterSurfaceName(surface.getName()));
                        continue;
                    }
                    if (surface.getType() != Surface.SurfaceType.MFS || dialog.selection != DialogSurfaceOption.SURFACEGEN.BASEMFS) continue;
                    if (unit == null) {
                        unit = new IGDUnit.Builder(this.db);
                        unit.age(true, (Double)0.0).hier(1);
                    }
                    unit.name(this.filterSurfaceName(surface.getName()));
                    unit.age(false, (Double)surface.getAge());
                    if (this.addUnitToScheme(unit)) {
                        ++var4_20;
                    }
                    unit = new IGDUnit.Builder(this.db);
                    unit.age(true, (Double)surface.getAge()).hier(1);
                }
                if (unit != null && (dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPMFS || dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPSB)) {
                    unit.age(false, unit.getUage());
                    if (this.addUnitToScheme(unit)) {
                        ++var4_21;
                    }
                }
                Object msg = var4_21 > 0 ? (int)var4_21 + " units were created. Select Units tab to view." : "No units were created.";
                JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 1);
                this.modelSurfaces.fireTableDataChanged();
                this.modelUnits.fireTableDataChanged();
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private String filterSurfaceName(String surfaceName) {
        for (Surface.SurfaceType type : Surface.SurfaceType.values()) {
            if (!surfaceName.endsWith(type.name())) continue;
            surfaceName = surfaceName.substring(0, surfaceName.length() - type.name().length()).trim();
            break;
        }
        return surfaceName;
    }

    private boolean addUnitToScheme(IGDUnit.Builder unit) {
        if (this.findUnit(unit.getName()) == null && !IGDScheme.isOverlap(this.modelUnits.scheme, unit)) {
            boolean inserted = false;
            int i = 0;
            for (IGDUnitBase.Builder b : this.modelUnits.scheme) {
                if (b.getSortEntry().compareTo(unit.getSortEntry()) > 0) {
                    this.modelUnits.scheme.add(i, unit);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                this.modelUnits.scheme.add(unit);
            }
            return true;
        }
        return false;
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        switch (this.modelUnits.igdType) {
            case 26: {
                FrameJsbugs.openHelp("magnetostrat.html");
                break;
            }
            default: {
                FrameJsbugs.openHelp("dialogigdscheme.html");
            }
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneSurfaces) {
            this.jButtonCreate.setText("Create units...");
        } else {
            this.jButtonCreate.setText("Create surfaces...");
            if (this.modelUnits.surfaces == null && this.modelSurfaces != null) {
                this.modelUnits.surfaces = this.modelSurfaces.scheme;
            }
        }
        boolean b = this.jTabbedPane1.getSelectedComponent() != this.jPanelLstrat;
        this.jButtonAdd.setEnabled(b);
        this.jButtonInsert.setEnabled(b);
        this.jButtonDelete.setEnabled(b);
        this.jButtonShowUnlinked.setEnabled(b);
        this.jButtonWells.setEnabled(b);
        this.jButtonCreate.setEnabled(b);
        this.jButtonCopyColour.setEnabled(b);
        this.jButtonPasteColour.setEnabled(b);
        if (b && LSTRAT_BALLOONTIP == null) {
            LSTRAT_BALLOONTIP = HintSequence.showHint(null, this.jButtonLstratTemplate, "You can show this scheme as part of an existing scheme block template.\n\nClick and drag whole units or corners.\n\nHold down SHIFT to constrain the age, or ALT to constrain x.\n\nHold down CTRL to create a new unit.", false);
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCopyColourActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select one unit to copy", this.getTitle(), 2);
                    return;
                }
                IGDUnitBase.Builder unit = this.modelUnits.scheme.get(this.jTableScheme.convertRowIndexToModel(indices[0]));
                this.copyColour = unit.getColour();
                this.jTextFieldColour.setBackground(this.copyColour);
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonPasteColourActionPerformed(ActionEvent evt) {
        if (this.copyColour == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No colour selected - copy first");
            return;
        }
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length == 0) {
                    return;
                }
                if (this.jTableScheme.isEditing()) {
                    this.jTableScheme.getCellEditor().stopCellEditing();
                }
                for (int i = 0; i < indices.length; ++i) {
                    IGDUnitBase.Builder builder = this.modelUnits.scheme.get(this.jTableScheme.convertRowIndexToModel(indices[i]));
                    if (builder instanceof IGDUnit.Builder) {
                        ((IGDUnit.Builder)builder).colour(this.copyColour);
                        continue;
                    }
                    if (!(builder instanceof LithostratUnit.Builder)) continue;
                    ((LithostratUnit.Builder)builder).colour(this.copyColour);
                }
            }
            this.modelUnits.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel files (xls)", "xls", "xlsx");
        jFileChooser.setFileFilter(filter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "JXLSFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser.showOpenDialog((Component)((Object)this))) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                File file = jFileChooser.getSelectedFile();
                String fileName = file.getPath();
                try {
                    Lastval.putString(this.db, "JXLSFILE", fileName);
                    this.db.commit();
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                List<IGDUnitBase.Builder> units = IGDSchemeXLSReader.read(this.db, file, this.modelUnits.igdType);
                for (IGDUnitBase.Builder b : units) {
                    this.modelUnits.scheme.add(b);
                }
                this.modelUnits.fireTableDataChanged();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (Exception re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonChronoActionPerformed(ActionEvent evt) {
        try {
            ArrayList<IGDScheme> toInclude = new ArrayList<IGDScheme>();
            if (this.scheme != null && this.scheme.getDatabase().isConnected() && this.scheme.getParentSchID() > 0) {
                toInclude.add(this.db.getIGDScheme(this.scheme.getParentSchID()));
            }
            List<IGDScheme> schemes = this.db.getIGDSchemes(3, toInclude);
            Collections.sort(schemes);
            if (this.modelUnits.igdType == 4 || this.modelUnits.igdType == 10) {
                List<IGDScheme> bzSchemes = this.db.getIGDSchemes(4, toInclude);
                Collections.sort(bzSchemes);
                schemes.addAll(bzSchemes);
            }
            if (this.modelUnits.igdType == 4) {
                List<IGDScheme> sqSchemes = this.db.getIGDSchemes(10, toInclude);
                Collections.sort(sqSchemes);
                schemes.addAll(sqSchemes);
            }
            DialogList<IGDScheme> dialog = new DialogList<IGDScheme>((JDialog)((Object)this), true, "Select Scheme", null, schemes, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null && dialog.getSelection() != this.parentScheme) {
                IGDUnitBase.Builder b;
                ArrayList<IGDUnit.Builder> referencing = new ArrayList<IGDUnit.Builder>();
                Iterator iterator = this.modelUnits.scheme.iterator();
                while (iterator.hasNext() && (b = (IGDUnitBase.Builder)iterator.next()) instanceof IGDUnit.Builder && b.hasAges()) {
                    if (!(((IGDUnit.Builder)b).u_age_ref instanceof IGDUnit) && !(((IGDUnit.Builder)b).l_age_ref instanceof IGDUnit)) continue;
                    referencing.add((IGDUnit.Builder)b);
                }
                if (!referencing.isEmpty()) {
                    String msg = "The current parent scheme is referenced by " + referencing.size() + " unit" + (referencing.size() > 1 ? "s" : "") + ".";
                    if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = msg + "\nSelecting a new scheme will reset all references.\nContinue?", "Change Parent Scheme", 0) != 0) {
                        return;
                    }
                    for (IGDUnit.Builder b2 : referencing) {
                        double age;
                        if (b2.u_age_ref instanceof IGDUnit) {
                            age = b2.getUage();
                            b2.ageRef(true, 0);
                            b2.age(true, (Double)age);
                        }
                        if (!(b2.l_age_ref instanceof IGDUnit)) continue;
                        age = b2.getLage();
                        b2.ageRef(false, 0);
                        b2.age(false, (Double)age);
                    }
                    this.modelUnits.fireTableDataChanged();
                }
                this.parentScheme = dialog.getSelection();
                this.parentScheme.loadUnits();
                this.jTextFieldChrono.setText(this.parentScheme.getName());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select one unit to edit", this.getTitle(), 2);
                    return;
                }
                int index = this.jTableScheme.convertRowIndexToModel(indices[0]);
                IGDUnitBase.Builder builder = this.modelUnits.scheme.get(index);
                if (builder instanceof LithostratUnit.Builder) {
                    this.stopSchemeTableEditing();
                    DialogLithostratUnit dialog = new DialogLithostratUnit(this.frameParent, true);
                    LithostratUnit.Builder lithBuilder = (LithostratUnit.Builder)builder;
                    dialog.setup(lithBuilder, this.scheme);
                    dialog.setLocationRelativeTo((Component)((Object)this));
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.modelUnits.scheme.set(index, dialog.getBuilder());
                        this.modelUnits.fireTableDataChanged();
                    }
                } else if (builder instanceof IGDUnit.Builder) {
                    this.stopSchemeTableEditing();
                    DialogIGDUnitBuilder dialog = new DialogIGDUnitBuilder(this.frameParent, true);
                    dialog.setup(this.scheme, this.igdType, (IGDUnit.Builder)builder, this.modelUnits.scheme);
                    dialog.setLocationRelativeTo((Component)((Object)this));
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        int old = this.jTableScheme.getSelectedRow();
                        this.modelUnits.scheme.set(index, dialog.getBuilder());
                        this.modelUnits.fireTableDataChanged();
                        this.jTableScheme.setRowSelectionInterval(old, old);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Unknown builder type, can't open editor.", this.getTitle(), 2);
                }
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    public void setUpdateUnits(LinkedList<IGDUnitBase> toUpdate, List<IGDUnitBase> workspaceUnits) throws SBException, SQLException {
        for (IGDUnitBase unit : toUpdate) {
            int i;
            IGDUnitBase.Builder b = this.findUnit(unit.getName());
            if (b == null) continue;
            b.name(unit.getName());
            if (b instanceof IGDUnit.Builder) {
                IGDUnit.Builder bUnit = (IGDUnit.Builder)b;
                if (!bUnit.getAbr().endsWith(unit.getAbr())) {
                    bUnit.abr(unit.getAbr());
                }
                if (unit instanceof IGDUnit && !bUnit.getComments().equals(((IGDUnit)unit).getComments())) {
                    bUnit.abr(unit.getAbr());
                }
                if (unit.getUage() != null && (b.getUage() == null || Math.abs(b.getUage() - unit.getUage()) > 1.0E-5)) {
                    bUnit.age(true, unit.getUage());
                }
                if (unit.getLage() != null && (b.getLage() == null || Math.abs(b.getLage() - unit.getLage()) > 1.0E-5)) {
                    bUnit.age(false, unit.getLage());
                }
                bUnit.colour(unit.getColour());
                if (bUnit.getigdAge(true).getConfidence() != ((IGDUnit)unit).getConfidence(true)) {
                    ((IGDSchTableModel)this.modelUnits).updateBuilderConf(bUnit, true, ((IGDUnit)unit).getConfidence(true));
                }
                if (bUnit.getigdAge(false).getConfidence() != ((IGDUnit)unit).getConfidence(false)) {
                    ((IGDSchTableModel)this.modelUnits).updateBuilderConf(bUnit, false, ((IGDUnit)unit).getConfidence(false));
                }
                block1: for (i = 0; i < 2; ++i) {
                    if (((IGDUnit)unit).getAgeRef(i == 0) <= 0) continue;
                    IGDUnitBase refUnit = null;
                    for (IGDUnitBase base : workspaceUnits) {
                        if (base.getUnitID() != ((IGDUnit)unit).getAgeRef(i == 0)) continue;
                        refUnit = base;
                        break;
                    }
                    if (refUnit == null) {
                        throw new IllegalStateException("No reference unit for " + String.valueOf(unit));
                    }
                    for (IGDUnitBase.Builder builder : this.modelUnits.scheme) {
                        if (builder.getOriginalID() != refUnit.getLink().getUnitID()) continue;
                        if (i == 0) {
                            bUnit.u_age_ref = builder;
                        } else {
                            bUnit.l_age_ref = builder;
                        }
                        bUnit.ageVal(i == 0, ((IGDUnit)unit).getAgePercent(i == 0));
                        continue block1;
                    }
                }
                continue;
            }
            if (b instanceof Chron.Builder) {
                Chron.Builder bChron = (Chron.Builder)b;
                if (Math.abs(b.getUage() - unit.getUage()) > 1.0E-5) {
                    bChron.uAge(unit.getUage());
                }
                if (Math.abs(b.getLage() - unit.getLage()) > 1.0E-5) {
                    bChron.lAge(unit.getLage());
                }
                bChron.polarity(((Chron)unit).getPolarity());
                continue;
            }
            if (!(b instanceof LithostratUnit.Builder)) continue;
            LithostratUnit.Builder bLithUnit = (LithostratUnit.Builder)b;
            if (unit.getColour() != null) {
                bLithUnit.colour(unit.getColour());
            }
            bLithUnit.lithology(((LithostratUnit)unit).getLithology());
            if (bLithUnit.getBnd(true) != ((LithostratUnit)unit).getUBnd()) {
                ((LithostratTableModel)this.modelUnits).updateBuilderBnd(bLithUnit, true, ((LithostratUnit)unit).getUBnd());
            }
            if (bLithUnit.getBnd(false) != ((LithostratUnit)unit).getLBnd()) {
                ((LithostratTableModel)this.modelUnits).updateBuilderBnd(bLithUnit, false, ((LithostratUnit)unit).getLBnd());
            }
            if (bLithUnit.getEBnd() != ((LithostratUnit)unit).getEBnd()) {
                bLithUnit.EBnd(((LithostratUnit)unit).getEBnd());
            }
            if (bLithUnit.getWBnd() != ((LithostratUnit)unit).getWBnd()) {
                bLithUnit.WBnd(((LithostratUnit)unit).getWBnd());
            }
            if (!bLithUnit.getAbr().endsWith(unit.getAbr())) {
                bLithUnit.abr(unit.getAbr());
            }
            for (i = 0; i < 4; ++i) {
                if (Math.abs(bLithUnit.getAge(i) - ((LithostratUnit)unit).getAge(i)) > 1.0E-6) {
                    bLithUnit.age(i, ((LithostratUnit)unit).getAge(i));
                }
                if (!((double)Math.abs(bLithUnit.getX(i) - ((LithostratUnit)unit).getX(i)) > 0.01)) continue;
                bLithUnit.x(i, ((LithostratUnit)unit).getX(i));
            }
        }
    }

    public void setUpdateSurfaces(LinkedList<Surface> toUpdate) throws SBException, SQLException {
        for (Surface surface : toUpdate) {
            Surface.Builder b = this.findSurface(surface.getName(), surface.getType());
            if (b == null || !(Math.abs(b.getAge() - surface.getAge()) > 1.0E-5)) continue;
            b.age(surface.getAge());
        }
    }

    private static Surface.Builder findSurface(List<Surface.Builder> list, double age) {
        for (Surface.Builder surface : list) {
            if (!(Math.abs(age - surface.getAge()) < 1.0E-5)) continue;
            return surface;
        }
        return null;
    }

    private Surface.Builder findSurface(String surfaceName, Surface.SurfaceType type) {
        for (Surface.Builder b : this.modelSurfaces.scheme) {
            if (b.getName().compareToIgnoreCase(surfaceName) != 0 || b.getType() != type) continue;
            return b;
        }
        return null;
    }

    private IGDUnitBase.Builder findUnit(String unitName) {
        for (IGDUnitBase.Builder b : this.modelUnits.scheme) {
            if (b.getName().compareToIgnoreCase(unitName) != 0) continue;
            return b;
        }
        return null;
    }

    public IGDScheme getSchemeAdded() {
        return this.schemeAdded;
    }

    private void tabbedPanelChanged() {
        this.setEditButtonEnabled();
    }

    private void setEditButtonEnabled() {
        this.jButtonEdit.setEnabled(this.jTabbedPane1.getSelectedComponent().equals(this.jScrollPaneUnits));
    }

    private class RefEditor
    extends ButtonEditor {
        IGDUnit.Builder builder;
        IGDUnitClass ref;
        int val;
        private boolean youngest;
        final /* synthetic */ DialogIGDScheme this$0;

        private RefEditor(DialogIGDScheme dialogIGDScheme) {
            DialogIGDScheme dialogIGDScheme2 = dialogIGDScheme;
            Objects.requireNonNull(dialogIGDScheme2);
            this.this$0 = dialogIGDScheme2;
        }

        @Override
        public Object getCellEditorValue() {
            return new Object[]{this.ref, this.val};
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.builder = (IGDUnit.Builder)this.this$0.modelUnits.scheme.get(this.this$0.jTableScheme.convertRowIndexToModel(row));
            switch (column) {
                case 4: {
                    this.ref = this.builder.u_age_ref;
                    this.val = this.ref == null ? 0 : this.builder.getigdAge(true).getPercent();
                    this.youngest = true;
                    break;
                }
                case 7: {
                    this.ref = this.builder.l_age_ref;
                    this.val = this.ref == null ? 100 : this.builder.getigdAge(false).getPercent();
                    this.youngest = false;
                }
            }
            return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<IGDUnitBase.Builder> filteredList = new LinkedList<IGDUnitBase.Builder>();
            for (IGDUnitBase.Builder b : this.this$0.modelUnits.scheme) {
                if (b.getHier() >= this.builder.getHier()) continue;
                filteredList.add(b);
            }
            IGDUnitClass refForDialog = this.ref;
            if (refForDialog == null) {
                refForDialog = this.youngest ? this.builder.l_age_ref : this.builder.u_age_ref;
            }
            DialogIGDAge dialog = new DialogIGDAge((Window)((Object)this.this$0), true, this.this$0.parentScheme, null, filteredList, this.this$0.jTextFieldName.getText(), refForDialog, this.val, this.builder);
            dialog.setLocationRelativeTo((Component)((Object)this.this$0));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.ref = dialog.ageRef;
                this.val = dialog.refVal;
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }
}

