/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import model3.IGDScheme;
import model3.IGDUnitBase;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;

class DialogUnlinked
extends JDialog {
    private static final String[] COL_TITLES = new String[]{"Informal name", "Occs.", "Exists in Scheme?"};
    private static final int[] COL_WIDTHS = new int[]{90, 30, 40};
    private final UnlinkedTableModel model = new UnlinkedTableModel();
    List<IGDScheme.UnlinkedInterval> selection = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonLink;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableUnlinked;
    private JTextField jTextFieldScheme;

    public DialogUnlinked(JDialog parent, boolean modal, IGDScheme scheme, List<IGDScheme.UnlinkedInterval> list) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.model.data = list;
        this.model.scheme = scheme;
        this.init();
    }

    private void init() {
        this.setTitle("Unlinked Scheme Intervals");
        this.model.setUpTable(this.jTableUnlinked);
        this.jTextFieldScheme.setText(this.model.scheme.toString());
        this.jTableUnlinked.setRowSorter(new TableRowSorter<UnlinkedTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableUnlinked).attach();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUnlinked = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonHelp = new JButton();
        this.jButtonLink = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setText("Unlinked units in scheme: ");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setText("jTextField1");
        this.jTableUnlinked.setModel(this.model);
        this.jTableUnlinked.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogUnlinked this$0;
            {
                DialogUnlinked dialogUnlinked = this$0;
                Objects.requireNonNull(dialogUnlinked);
                this.this$0 = dialogUnlinked;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableUnlinkedMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableUnlinked);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnlinked this$0;
            {
                DialogUnlinked dialogUnlinked = this$0;
                Objects.requireNonNull(dialogUnlinked);
                this.this$0 = dialogUnlinked;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnlinked this$0;
            {
                DialogUnlinked dialogUnlinked = this$0;
                Objects.requireNonNull(dialogUnlinked);
                this.this$0 = dialogUnlinked;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Select the units below you want to add to the scheme:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnlinked this$0;
            {
                DialogUnlinked dialogUnlinked = this$0;
                Objects.requireNonNull(dialogUnlinked);
                this.this$0 = dialogUnlinked;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonLink.setText("Link...");
        this.jButtonLink.setToolTipText("Link ALL instances of selected informal unit to scheme unit, either keeping or switching the informal term");
        this.jButtonLink.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnlinked this$0;
            {
                DialogUnlinked dialogUnlinked = this$0;
                Objects.requireNonNull(dialogUnlinked);
                this.this$0 = dialogUnlinked;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLinkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2, -1, 482, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldScheme, -1, 355, Short.MAX_VALUE)).add(1, (Component)this.jScrollPane1, -1, 482, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonLink)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldScheme, -2, -1, -2)).add(12, 12, 12).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonLink).addPreferredGap(0, 95, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(9, 9, 9).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int[] rows;
        if (this.jTableUnlinked.getSelectedRowCount() <= 0) {
            JOptionPane.showMessageDialog(this, "Select one or more rows to add to scheme, or Cancel to close without selecting.", this.getTitle(), 1);
            return;
        }
        this.selection = new LinkedList<IGDScheme.UnlinkedInterval>();
        for (int row : rows = this.jTableUnlinked.getSelectedRows()) {
            this.selection.add(this.model.data.get(this.jTableUnlinked.convertRowIndexToModel(row)));
        }
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogigdscheme.html#dialogunlinked");
    }

    private void jButtonLinkActionPerformed(ActionEvent evt) {
        if (this.jTableUnlinked.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one term only", this.getTitle(), 2);
            return;
        }
        IGDScheme.UnlinkedInterval interval = this.model.data.get(this.jTableUnlinked.convertRowIndexToModel(this.jTableUnlinked.getSelectedRow()));
        DialogList<IGDUnitBase> dialog = new DialogList<IGDUnitBase>(this, true, "Select Unit", null, this.model.scheme.getUnitBases(), true, false);
        dialog.setLocationRelativeTo(this);
        if (interval.getMatchingUnitID() != null) {
            LinkedList<IGDUnitBase> list = new LinkedList<IGDUnitBase>();
            try {
                list.add(this.model.scheme.findUnitBase(interval.informalName));
                dialog.setSelectedItems(list);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            IGDUnitBase unit = dialog.getSelection();
            boolean updateInformal = false;
            if (!unit.getName().equals(interval.informalName)) {
                String msg = "Do you want to update informal names of '" + interval.informalName + "' to '" + unit.getName() + "' as well as link to the unit?";
                int opt = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    updateInformal = true;
                }
            }
            try {
                this.model.scheme.linkInformal(interval, unit, updateInformal);
                this.model.data.remove(interval);
                this.jTableUnlinked.clearSelection();
                this.model.fireTableDataChanged();
                this.model.scheme.getDatabase().commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.model.scheme.getDatabase());
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jTableUnlinkedMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonLinkActionPerformed(null);
        }
    }

    private static class UnlinkedTableModel
    extends AbstractTableModel {
        IGDScheme scheme = null;
        List<IGDScheme.UnlinkedInterval> data;
        static final int COL_NAME = 0;
        static final int COL_OCCS = 1;
        static final int COL_EXISTS = 2;

        private UnlinkedTableModel() {
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            IGDScheme.UnlinkedInterval item = this.data.get(row);
            switch (col) {
                case 0: {
                    return item.informalName;
                }
                case 1: {
                    return item.getOccs();
                }
                case 2: {
                    return item.getMatchingUnitID() != null ? "Yes" : "";
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 2: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return Object.class;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(COL_TITLES[i]);
                columnModel.getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

