/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.scheme.Confidence;
import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jsbugs.model2.igdscheme.SchTableModel;
import jsbugs.table.ButtonRendererNoClear;
import jsbugs.table.ColourRenderer;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.DateRenderer;
import jsbugs.table.EnumEditor;
import model3.Chron;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.IGDUnitClass;
import model3.SBdb;
import util.SB;
import util.table.ColorEditor;

class IGDSchTableModel
extends SchTableModel {
    static String[] colTitles = new String[]{"Unit name", "Abr.", "Type", "Youngest", "", "Confidence", "Oldest", "", "Confidence", "Colour", "Comments", "Occs", "Surfaces", "Modified", "By"};
    static int[] colWidths = new int[]{90, 20, 30, 25, 35, 25, 25, 35, 25, 25, 15, 10, 20, 20, 20};
    static final int COL_NAME = 0;
    static final int COL_ABR = 1;
    static final int COL_TYPE = 2;
    static final int COL_YOUNGEST = 3;
    static final int COL_YOUNGEST_REF = 4;
    static final int COL_YOUNGEST_CONF = 5;
    static final int COL_OLDEST = 6;
    static final int COL_OLDEST_REF = 7;
    static final int COL_OLDEST_CONF = 8;
    static final int COL_COLOUR = 9;
    static final int COL_COMMENTS = 10;
    static final int COL_OCCS = 11;
    static final int COL_SURFACE = 12;
    static final int COL_MODIFIED = 13;
    static final int COL_MODIFIER = 14;

    public IGDSchTableModel(int igdType) {
        super(igdType);
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.scheme.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IGDUnitBase.Builder unit = (IGDUnitBase.Builder)this.scheme.get(row);
        switch (col) {
            case 0: {
                return unit.getName();
            }
            case 2: {
                if (unit.getHier() < 1) {
                    return "";
                }
                return IGDIntervalZone.getHierName(this.igdType, unit.getHier());
            }
            case 1: {
                return unit instanceof IGDUnit.Builder ? ((IGDUnit.Builder)unit).getAbr() : "";
            }
            case 10: {
                return unit instanceof IGDUnit.Builder ? ((IGDUnit.Builder)unit).getComments() : "";
            }
            case 3: {
                return unit.getUage();
            }
            case 4: {
                if (unit instanceof IGDUnit.Builder && ((IGDUnit.Builder)unit).u_age_ref != null) {
                    IGDUnit.Builder b = (IGDUnit.Builder)unit;
                    return b.getigdAge(true).getPercent() + "% " + b.u_age_ref.toString();
                }
                return "";
            }
            case 5: {
                return unit instanceof IGDUnit.Builder ? ((IGDUnit.Builder)unit).getigdAge(true).getConfidence() : null;
            }
            case 6: {
                return unit.getLage();
            }
            case 7: {
                if (unit instanceof IGDUnit.Builder && ((IGDUnit.Builder)unit).l_age_ref != null) {
                    IGDUnit.Builder b = (IGDUnit.Builder)unit;
                    return b.getigdAge(false).getPercent() + "% " + b.l_age_ref.toString();
                }
                return "";
            }
            case 8: {
                return unit instanceof IGDUnit.Builder ? ((IGDUnit.Builder)unit).getigdAge(false).getConfidence() : null;
            }
            case 9: {
                Chron.Builder b;
                if (unit instanceof Chron.Builder && (b = (Chron.Builder)unit).getHier() == 1) {
                    return null;
                }
                return unit.getColour();
            }
            case 11: {
                return unit instanceof IGDUnit.Builder ? ((IGDUnit.Builder)unit).getNOccs() : 0;
            }
            case 12: {
                if (this.surfaces != null) {
                    return IGDScheme.getSurfaces(this.surfaces, unit);
                }
                return "";
            }
            case 13: {
                return unit.getModified();
            }
            case 14: {
                return unit.getModifier();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        IGDUnitBase.Builder unit = (IGDUnitBase.Builder)this.scheme.get(row);
        switch (col) {
            case 0: {
                unit.name((String)obj);
                break;
            }
            case 2: {
                unit.hier(IGDIntervalZone.getHierNumber(this.igdType, (String)obj, true));
                break;
            }
            case 1: {
                if (!(unit instanceof IGDUnit.Builder)) break;
                ((IGDUnit.Builder)unit).abr((String)obj);
                break;
            }
            case 10: {
                if (!(unit instanceof IGDUnit.Builder)) break;
                ((IGDUnit.Builder)unit).comments((String)obj);
                break;
            }
            case 3: {
                Double newUAge = null;
                if (obj != null) {
                    newUAge = (Double)obj;
                }
                if (unit.getUage() != null && newUAge != null && !(Math.abs(newUAge - unit.getUage()) > 0.001)) break;
                if (unit instanceof IGDUnit.Builder) {
                    ((IGDUnit.Builder)unit).ageRef(true, 0);
                    ((IGDUnit.Builder)unit).age(true, newUAge);
                    break;
                }
                if (!(unit instanceof Chron.Builder)) break;
                ((Chron.Builder)unit).uAge(newUAge == null ? 0.0 : newUAge);
                break;
            }
            case 4: {
                Object[] arr = (Object[])obj;
                if (arr == null || arr.length != 2 || !(unit instanceof IGDUnit.Builder)) break;
                IGDUnit.Builder u = (IGDUnit.Builder)unit;
                if (u.u_age_ref == arr[0] && u.getigdAge(true).getPercent() == ((Integer)arr[1]).intValue()) {
                    return;
                }
                Double currentAge = unit.getUage();
                if (arr[0] instanceof IGDUnit) {
                    u.ageRef(true, ((IGDUnit)arr[0]).getUnitID());
                } else {
                    u.ageRef(true, 0);
                    u.age(true, currentAge);
                }
                u.u_age_ref = (IGDUnitClass)arr[0];
                u.ageVal(true, (Integer)arr[1]);
                if (u.u_age_ref != null) {
                    u.getigdAge(true).calcAge(u.u_age_ref);
                }
                this.updateBuilderAges(unit);
                break;
            }
            case 5: {
                if (!(unit instanceof IGDUnit.Builder)) break;
                this.updateBuilderConf((IGDUnit.Builder)unit, true, (Confidence)obj);
                break;
            }
            case 6: {
                Double newLAge = null;
                if (obj != null) {
                    newLAge = (Double)obj;
                }
                if (unit.getLage() != null && newLAge != null && !(Math.abs(newLAge - unit.getLage()) > 0.001)) break;
                if (unit instanceof IGDUnit.Builder) {
                    ((IGDUnit.Builder)unit).ageRef(false, 0);
                    ((IGDUnit.Builder)unit).age(false, newLAge);
                    break;
                }
                if (!(unit instanceof Chron.Builder)) break;
                ((Chron.Builder)unit).lAge(newLAge == null ? 0.0 : newLAge);
                break;
            }
            case 7: {
                Object[] arr2 = (Object[])obj;
                if (arr2 == null || arr2.length != 2 || !(unit instanceof IGDUnit.Builder)) break;
                IGDUnit.Builder u = (IGDUnit.Builder)unit;
                if (u.l_age_ref == arr2[0] && u.getigdAge(false).getPercent() == ((Integer)arr2[1]).intValue()) {
                    return;
                }
                Double currentAge = unit.getLage();
                if (arr2[0] instanceof IGDUnit) {
                    u.ageRef(false, ((IGDUnit)arr2[0]).getUnitID());
                } else {
                    u.ageRef(false, 0);
                    u.age(false, currentAge);
                }
                u.l_age_ref = (IGDUnitClass)arr2[0];
                u.ageVal(false, (Integer)arr2[1]);
                if (u.l_age_ref != null) {
                    u.getigdAge(false).calcAge(u.l_age_ref);
                }
                this.updateBuilderAges(unit);
                break;
            }
            case 8: {
                if (!(unit instanceof IGDUnit.Builder)) break;
                this.updateBuilderConf((IGDUnit.Builder)unit, false, (Confidence)obj);
                break;
            }
            case 9: {
                if (this.igdType == 26) {
                    ((Chron.Builder)unit).polarity((Chron.Polarity)((Object)obj));
                    break;
                }
                ((IGDUnit.Builder)unit).colour((Color)obj);
                break;
            }
            case 12: {
                break;
            }
        }
    }

    private void updateBuilderAges(IGDUnitBase.Builder hasChanged) {
        for (int i = 0; i < this.scheme.size(); ++i) {
            IGDUnitBase.Builder builder = (IGDUnitBase.Builder)this.scheme.get(i);
            if (!(builder instanceof IGDUnit.Builder) || builder == hasChanged) continue;
            IGDUnit.Builder b = (IGDUnit.Builder)builder;
            if (b.u_age_ref == hasChanged) {
                b.getigdAge(true).calcAge(hasChanged);
                this.fireTableCellUpdated(i, 3);
            }
            if (b.l_age_ref != hasChanged) continue;
            b.getigdAge(false).calcAge(hasChanged);
            this.fireTableCellUpdated(i, 6);
        }
    }

    void updateBuilderConf(IGDUnit.Builder toChange, boolean upper, Confidence confidence) {
        if (toChange.getigdAge(upper).getConfidence() == confidence) {
            return;
        }
        toChange.getigdAge(upper).setConfidence(confidence);
        for (IGDUnitBase.Builder builder : this.scheme) {
            if (!(builder instanceof IGDUnit.Builder) || builder == toChange || builder.getHier() != toChange.getHier() || !toChange.hasAges() || !builder.hasAges() || !(upper && Math.abs(builder.getLage() - toChange.getUage()) < 1.0E-6) && (upper || !(Math.abs(builder.getUage() - toChange.getLage()) < 1.0E-6))) continue;
            ((IGDUnit.Builder)builder).getigdAge(!upper).setConfidence(confidence);
            int index = this.scheme.indexOf(builder);
            this.fireTableCellUpdated(index, !upper ? 5 : 8);
            break;
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                return String.class;
            }
            case 3: 
            case 6: {
                return Double.class;
            }
            case 9: {
                return Color.class;
            }
            case 11: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return false;
            }
            case 9: {
                if (this.igdType != 26 || ((IGDUnitBase.Builder)this.scheme.get(row)).getHier() != 1) break;
                return false;
            }
        }
        return true;
    }

    @Override
    void setupTable(JTable jTableScheme, JComboBox hierComboBox) {
        SB.setTableHeaderBold((JTable)jTableScheme);
        if (hierComboBox.getItemCount() == 0) {
            for (int i = 1; i <= IGDIntervalZone.getNHier(this.igdType, true); ++i) {
                hierComboBox.addItem(IGDIntervalZone.getHierName(this.igdType, i));
            }
        }
        TableColumnModel columnModel = jTableScheme.getColumnModel();
        block5: for (int i = 0; i < colTitles.length; ++i) {
            switch (i) {
                case 9: {
                    columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
                    columnModel.getColumn(i).setHeaderValue(this.igdType == 26 ? "Polarity" : colTitles[i]);
                    if (this.igdType != 26) continue block5;
                    columnModel.getColumn(i).setCellEditor(new EnumEditor(new JComboBox(), Chron.Polarity.class, null));
                    continue block5;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    if (this.igdType == 26 || i == 12 && this.igdType != 10) {
                        columnModel.getColumn(i).setMinWidth(0);
                        columnModel.getColumn(i).setPreferredWidth(0);
                        columnModel.getColumn(i).setMaxWidth(0);
                        continue block5;
                    }
                }
                default: {
                    columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
                    columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                }
            }
        }
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(hierComboBox));
        columnModel.getColumn(11).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 4));
        columnModel.getColumn(12).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 0));
        columnModel.getColumn(2).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(4).setCellRenderer(new ButtonRendererNoClear(""));
        columnModel.getColumn(7).setCellRenderer(new ButtonRendererNoClear(""));
        columnModel.getColumn(2).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(5).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(8).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(5).setCellEditor(new EnumEditor(new JComboBox(), Confidence.class, null));
        columnModel.getColumn(8).setCellEditor(new EnumEditor(new JComboBox(), Confidence.class, null));
        columnModel.getColumn(13).setCellRenderer(new DateRenderer());
        columnModel.getColumn(14).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 2));
        jTableScheme.setDefaultRenderer(Color.class, new ColourRenderer(true));
        if (this.igdType != 26) {
            ColorEditor.setUpColorEditor((JTable)jTableScheme, (boolean)false);
        }
        jTableScheme.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    IGDUnitBase.Builder newBuilder(SBdb sbdb) {
        if (this.igdType == 26) {
            return new Chron.Builder(sbdb);
        }
        return new IGDUnit.Builder(sbdb);
    }
}

