/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.UnitEWBoundary;
import java.awt.Color;
import java.awt.geom.Line2D;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import jsbugs.LithologyCellRenderer;
import jsbugs.model2.igdscheme.SchTableModel;
import jsbugs.table.ColourRenderer;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import jsbugs.table.IntegerEditor;
import model3.IGDIntervalZone;
import model3.IGDUnitBase;
import model3.Lithology;
import model3.LithostratUnit;
import model3.SBdb;
import util.SB;
import util.table.ColorEditor;

class LithostratTableModel
extends SchTableModel {
    static String[] colTitles = new String[]{"Unit name", "Abr.", "Type", "Youngest West", "%E", "Youngest East", "%E", "Bnd (Youngest)", "Oldest West", "%E", "Oldest East", "%E", "Bnd (Oldest)", " West Shazam", "East Shazam", "Lithology", "Colour", "Occs"};
    static int[] colWidths = new int[]{90, 20, 30, 35, 15, 35, 15, 35, 15, 35, 15, 25, 25, 30, 30, 70, 10, 10};
    static final int COL_NAME = 0;
    static final int COL_ABR = 1;
    static final int COL_TYPE = 2;
    static final int COL_UW = 3;
    static final int COL_UW_X = 4;
    static final int COL_UE = 5;
    static final int COL_UE_X = 6;
    static final int COL_U_BND = 7;
    static final int COL_LW = 8;
    static final int COL_LW_X = 9;
    static final int COL_LE = 10;
    static final int COL_LE_X = 11;
    static final int COL_L_BND = 12;
    static final int COL_WSHZ = 13;
    static final int COL_ESHZ = 14;
    static final int COL_LITH = 15;
    static final int COL_COLOUR = 16;
    static final int COL_OCCS = 17;

    LithostratTableModel() {
        super(2);
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.scheme.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        LithostratUnit.Builder unit = (LithostratUnit.Builder)this.scheme.get(row);
        switch (col) {
            case 0: {
                return unit.getName();
            }
            case 2: {
                return IGDIntervalZone.getHierName(2, unit.getHier());
            }
            case 1: {
                return unit.getAbr();
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return unit.getAge(this.getAddress(col));
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return unit.getXint(this.getAddress(col));
            }
            case 7: {
                return unit.getBnd(true);
            }
            case 12: {
                return unit.getBnd(false);
            }
            case 16: {
                return unit.getColour();
            }
            case 13: {
                return unit.getWBnd();
            }
            case 14: {
                return unit.getEBnd();
            }
            case 15: {
                return unit.getLithology();
            }
            case 17: {
                return unit.getNOccs();
            }
        }
        return "";
    }

    public LithostratUnit.Builder getValue(int row) {
        return (LithostratUnit.Builder)this.scheme.get(row);
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        LithostratUnit.Builder unit = (LithostratUnit.Builder)this.scheme.get(row);
        switch (col) {
            case 0: {
                unit.name((String)obj);
                break;
            }
            case 2: {
                unit.hier(IGDIntervalZone.getHierNumber(2, (String)obj, true));
                break;
            }
            case 1: {
                unit.abr((String)obj);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                unit.age(this.getAddress(col), (Double)obj);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                unit.x(this.getAddress(col), Float.parseFloat(obj.toString()) / 100.0f);
                break;
            }
            case 7: {
                Boundary ubnd = (Boundary)obj;
                if (ubnd == unit.getBnd(true)) break;
                this.updateBuilderBnd(unit, true, ubnd);
                break;
            }
            case 12: {
                Boundary lbnd = (Boundary)obj;
                if (lbnd == unit.getBnd(false)) break;
                this.updateBuilderBnd(unit, false, lbnd);
                break;
            }
            case 14: {
                UnitEWBoundary eBnd = (UnitEWBoundary)obj;
                if (eBnd == unit.getEBnd()) break;
                unit.EBnd(eBnd);
                break;
            }
            case 13: {
                UnitEWBoundary wBnd = (UnitEWBoundary)obj;
                if (wBnd == unit.getWBnd()) break;
                unit.WBnd(wBnd);
                break;
            }
            case 16: {
                unit.colour((Color)obj);
                break;
            }
            case 15: {
                unit.lithology((Lithology)obj);
                break;
            }
        }
    }

    void updateBuilderBnd(LithostratUnit.Builder toChange, boolean upper, Boundary bnd) {
        toChange.bnd(upper, bnd);
        for (IGDUnitBase.Builder baseBuilder : this.scheme) {
            int index;
            LithostratUnit.Builder builder = (LithostratUnit.Builder)baseBuilder;
            if (builder == toChange) continue;
            Line2D builderLine = builder.getLine(upper);
            if (toChange.getLine(upper).ptLineDist(builder.getLine(upper).getX1(), builderLine.getY1()) == 0.0 && toChange.getLine(upper).ptLineDist(builder.getLine(upper).getX2(), builderLine.getY2()) == 0.0) {
                builder.bnd(upper, bnd);
                index = this.scheme.indexOf(builder);
                this.fireTableCellUpdated(index, 7);
                continue;
            }
            if (toChange.getLine(upper).ptLineDist(builder.getLine(!upper).getX1(), builderLine.getY1()) != 0.0 || toChange.getLine(upper).ptLineDist(builder.getLine(!upper).getX2(), builderLine.getY2()) != 0.0) continue;
            builder.bnd(!upper, bnd);
            index = this.scheme.indexOf(builder);
            this.fireTableCellUpdated(index, 12);
        }
    }

    private int getAddress(int col) {
        switch (col) {
            case 3: 
            case 4: {
                return 0;
            }
            case 8: 
            case 9: {
                return 3;
            }
            case 5: 
            case 6: {
                return 1;
            }
            case 10: 
            case 11: {
                return 2;
            }
        }
        return -1;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 16: {
                return Color.class;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 17: {
                return Integer.class;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return Double.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 17: {
                return false;
            }
        }
        return true;
    }

    @Override
    void setupTable(JTable jTableScheme, JComboBox hierComboBox) {
        SB.setTableHeaderBold((JTable)jTableScheme);
        if (hierComboBox.getItemCount() == 0) {
            for (int i = 1; i <= IGDIntervalZone.getNHier(2, true); ++i) {
                hierComboBox.addItem(IGDIntervalZone.getHierName(2, i));
            }
        }
        TableColumnModel columnModel = jTableScheme.getColumnModel();
        for (int i = 0; i < colTitles.length; ++i) {
            switch (i) {
                default: 
            }
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
        }
        columnModel.getColumn(2).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(hierComboBox));
        columnModel.getColumn(17).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 4));
        columnModel.getColumn(7).setCellEditor(new EnumEditor(new JComboBox(), Boundary.class, null));
        columnModel.getColumn(7).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(12).setCellEditor(new EnumEditor(new JComboBox(), Boundary.class, null));
        columnModel.getColumn(12).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(14).setCellEditor(new EnumEditor(new JComboBox(), UnitEWBoundary.class, null));
        columnModel.getColumn(14).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(13).setCellEditor(new EnumEditor(new JComboBox(), UnitEWBoundary.class, null));
        columnModel.getColumn(13).setCellRenderer(new ComboRenderer());
        columnModel.getColumn(15).setCellRenderer(new LithologyCellRenderer());
        jTableScheme.setDefaultRenderer(Color.class, new ColourRenderer(true));
        jTableScheme.setDefaultEditor(Integer.class, new IntegerEditor(0, 100));
        ColorEditor.setUpColorEditor((JTable)jTableScheme);
        jTableScheme.getTableHeader().setReorderingAllowed(false);
        TableCellEditor o = jTableScheme.getDefaultEditor(Object.class);
    }

    @Override
    LithostratUnit.Builder newBuilder(SBdb sbdb) {
        return new LithostratUnit.Builder(sbdb);
    }
}

