/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.taxon;

import com.stratadata.model3.taxon.Category;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.model2.taxon.DialogCategory;
import jsbugs.table.ColourRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import org.jdesktop.layout.GroupLayout;

public class DialogCategories
extends JDialog {
    private final SBdb db;
    private final TableModelCategories model = new TableModelCategories(this);
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableCats;

    public DialogCategories(Frame parent, boolean modal, SBdb db) throws SuppressedSQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SuppressedSQLException {
        this.setTitle("Categories");
        this.getRootPane().setDefaultButton(this.jButtonAdd);
        this.setUpTable();
        this.setUpModel();
        if ((this.db.getUser().getPriv() & 0x400) == 0) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonAdd.setToolTipText("Only key holders can edit categories");
            this.jButtonEdit.setEnabled(false);
            this.jButtonEdit.setToolTipText("Only key holders can edit categories");
            this.jButtonDelete.setEnabled(false);
            this.jButtonDelete.setToolTipText("Only key holders can delete categories");
        }
    }

    private void setUpTable() {
        TableUtils.setTableHeaderBold((JTable)this.jTableCats);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableCats.getColumnModel().getColumn(i).setHeaderValue(TableModelCategories.COL_TITLES[i]);
            this.jTableCats.getColumnModel().getColumn(i).setPreferredWidth(TableModelCategories.COL_WIDTHS[i]);
        }
        this.jTableCats.setDefaultRenderer(Color.class, new ColourRenderer(true));
        this.jTableCats.setSelectionMode(0);
        this.jTableCats.setRowSorter(new TableRowSorter<TableModelCategories>(this.model));
        new ColumnSortResetHandler(this.jTableCats).attach();
    }

    private void setUpModel() throws SuppressedSQLException {
        this.model.catList = new ArrayList<TableModelCategories.CategoryRow>();
        Map genOccs = this.db.getGenusService().getCategoryOccurrences();
        this.db.getCategoryService().getCategoryList().forEach(category -> this.model.catList.add(new TableModelCategories.CategoryRow((Category)category, ((Long)genOccs.get(category.getMnemonic())).intValue())));
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCats = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(332, 300));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTableCats.setModel(this.model);
        this.jTableCats.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogCategories this$0;
            {
                DialogCategories dialogCategories = this$0;
                Objects.requireNonNull(dialogCategories);
                this.this$0 = dialogCategories;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableCatsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCats);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 434, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jButtonAdd).add(2, (Component)this.jButtonEdit).add(2, (Component)this.jButtonDelete).add(2, (GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonClose, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 533, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 400, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private int indexOfCategory(String mnem) {
        for (int i = 0; i < this.model.catList.size(); ++i) {
            if (!this.model.catList.get((int)i).category.getMnemonic().equals(mnem)) continue;
            return this.jTableCats.convertRowIndexToView(i);
        }
        return -1;
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
            return;
        }
        TableModelCategories.CategoryRow catRow = this.model.catList.get(this.jTableCats.convertRowIndexToModel(this.jTableCats.getSelectedRow()));
        Category category = catRow.category();
        DialogCategory dialog = new DialogCategory(this, true, this.db, category);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            Category result = dialog.getResult();
            this.model.catList.set(this.model.catList.indexOf(catRow), new TableModelCategories.CategoryRow(result, catRow.nGenera()));
            this.model.fireTableDataChanged();
            int index = this.indexOfCategory(result.getMnemonic());
            this.jTableCats.setRowSelectionInterval(index, index);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogCategory dialog = new DialogCategory(this, true, this.db, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getResult() != null) {
            Category addedCategory = dialog.getResult();
            this.model.catList.add(new TableModelCategories.CategoryRow(addedCategory, 0));
            Collections.sort(this.model.catList);
            this.model.fireTableDataChanged();
            int viewIndex = this.indexOfCategory(addedCategory.getMnemonic());
            this.jTableCats.setRowSelectionInterval(viewIndex, viewIndex);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmanagecategories.html");
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
            return;
        }
        TableModelCategories.CategoryRow catRow = this.model.catList.get(this.jTableCats.convertRowIndexToModel(this.jTableCats.getSelectedRow()));
        if (catRow.nGenera() == 0) {
            try {
                this.db.getCategoryService().deleteCategory(catRow.category().getMnemonic());
                this.model.catList.remove(catRow);
                this.model.fireTableDataChanged();
            }
            catch (RuntimeException sql) {
                SbugsExceptionHandler.showStackError(sql);
            }
        } else {
            JOptionPane.showMessageDialog(this, "You cannot delete a category with related genera.", this.getTitle(), 2);
        }
    }

    private void jTableCatsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private class TableModelCategories
    extends AbstractTableModel {
        static final int COL_DISC = 0;
        static final int COL_ABR = 1;
        static final int COL_NAME = 2;
        static final int COL_COLOUR = 3;
        static final int COL_OCCS = 4;
        static String[] COL_TITLES = new String[]{"Disc.", "Abr.", "Name", "Colour", "Genera"};
        static int[] COL_WIDTHS = new int[]{30, 20, 100, 5, 5};
        List<CategoryRow> catList;
        final /* synthetic */ DialogCategories this$0;

        private TableModelCategories(DialogCategories dialogCategories) {
            DialogCategories dialogCategories2 = dialogCategories;
            Objects.requireNonNull(dialogCategories2);
            this.this$0 = dialogCategories2;
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.catList == null || this.catList.isEmpty()) {
                return null;
            }
            CategoryRow catRow = this.catList.get(row);
            Category cat = catRow.category();
            return switch (col) {
                case 0 -> cat.getDiscipline().getAbr(false);
                case 1 -> cat.getMnemonic();
                case 2 -> cat.getName();
                case 3 -> cat.getColour();
                case 4 -> catRow.nGenera();
                default -> null;
            };
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: {
                    return String.class;
                }
                case 3: {
                    return Color.class;
                }
                case 4: 
            }
            return Integer.class;
        }

        @Override
        public int getRowCount() {
            if (this.catList == null) {
                return 0;
            }
            return this.catList.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        record CategoryRow(Category category, int nGenera) implements Comparable<CategoryRow>
        {
            @Override
            public int compareTo(CategoryRow o) {
                return this.category.compareTo(o.category);
            }
        }
    }
}

