/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.taxon;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogCategory
extends SBDialog {
    private static final int NAME_LEN = 30;
    private static final int MNEM_LEN = 5;
    private final SBdb db;
    private final DefaultComboBoxModel<Discipline> model = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final Category original;
    private Category updatedCategory = null;
    private boolean changedMnem = false;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonOK;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAbb;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldName;

    public DialogCategory(JDialog parent, boolean modal, SBdb db, Category cat) {
        super((Window)parent, modal);
        this.db = db;
        this.original = cat;
        this.initComponents();
        this.init(null, null, null);
    }

    public DialogCategory(JDialog parent, boolean modal, SBdb db, String name, String mnem, Discipline discID) {
        super((Window)parent, modal);
        this.db = db;
        this.original = null;
        this.initComponents();
        this.init(name, mnem, discID);
    }

    private void init(String name, String mnem, Discipline discID) {
        if (this.original == null) {
            this.setTitle("Category : Add");
            if (name != null) {
                this.jTextFieldName.setText(name);
            }
            if (mnem != null) {
                this.jTextFieldAbb.setText(mnem);
            }
            if (discID != null) {
                this.jComboBoxDiscipline.setSelectedItem(discID);
            }
        } else {
            this.setTitle("Category : Edit");
            this.jTextFieldAbb.setText(this.original.getMnemonic());
            this.jTextFieldName.setText(this.original.getName());
            this.jComboBoxDiscipline.setSelectedItem(this.original.getDiscipline());
            this.jTextFieldColour.setBackground(this.original.getColour());
        }
        if ((this.db.getUser().getPriv() & 0x400) == 0) {
            this.jButtonOK.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = TextFieldUtils.buildLimitedLengthTextField(30);
        this.jTextFieldAbb = TextFieldUtils.buildLimitedLengthTextField(5);
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Discipline:");
        this.jComboBoxDiscipline.setModel(this.model);
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Mnemonic:");
        this.jTextFieldAbb.setFont(new Font("Segoe UI", 1, 12));
        this.jTextFieldAbb.setToolTipText("Category code or abbreviation (limited to 5 characters)");
        this.jTextFieldAbb.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCategory this$0;
            {
                DialogCategory dialogCategory = this$0;
                Objects.requireNonNull(dialogCategory);
                this.this$0 = dialogCategory;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAbbKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategory this$0;
            {
                DialogCategory dialogCategory = this$0;
                Objects.requireNonNull(dialogCategory);
                this.this$0 = dialogCategory;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategory this$0;
            {
                DialogCategory dialogCategory = this$0;
                Objects.requireNonNull(dialogCategory);
                this.this$0 = dialogCategory;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Colour:");
        this.jTextFieldColour.setEditable(false);
        this.jTextFieldColour.setBackground(new Color(0, 0, 0));
        this.jTextFieldColour.setToolTipText("Colour displayed on multi-analyst sample charts");
        this.jButtonColour.setText("...");
        this.jButtonColour.setToolTipText("Open colour chooser");
        this.jButtonColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategory this$0;
            {
                DialogCategory dialogCategory = this$0;
                Objects.requireNonNull(dialogCategory);
                this.this$0 = dialogCategory;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1, -1, 316, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldName, -1, 249, Short.MAX_VALUE).add((Component)this.jComboBoxDiscipline, 0, 249, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldColour, -2, 34, -2).addPreferredGap(0).add((Component)this.jButtonColour, -2, 31, -2).add(0, 0, Short.MAX_VALUE)).add((Component)this.jTextFieldAbb)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldAbb, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxDiscipline, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonColour).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldAbbKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAbb, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Category category = new Category(this.jTextFieldAbb.getText());
        category.setDiscipline((Discipline)this.jComboBoxDiscipline.getSelectedItem());
        category.setName(this.jTextFieldName.getText());
        category.setColour(this.jTextFieldColour.getBackground());
        if (category.getMnemonic().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter category abbreviation", this.getTitle(), 1);
            return;
        }
        if (category.getMnemonic().length() < 2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Abbreviation must be at least 2 characters", this.getTitle(), 1);
            return;
        }
        if (category.getName().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter category name", this.getTitle(), 1);
            return;
        }
        if (this.original != null && !this.original.getMnemonic().equals(category.getMnemonic())) {
            String msg = "Changing the category abbreviation is not advised.\nYou should use existing categories if possible, or create a new category.\nDo you want to continue?";
            if (JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 0) != 0) {
                return;
            }
            this.changedMnem = true;
        }
        try {
            Category existingSuper;
            Category existing = this.db.getCategoryService().findCategory(category.getMnemonic()).orElse(null);
            if (existing != null && !existing.equals((Object)this.original)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "This category already exists!", this.getTitle(), 1);
                return;
            }
            if (category.getMnemonic().length() > 2 && ((existingSuper = (Category)this.db.getCategoryService().findCategory(category.getMnemonic().substring(0, 2)).orElse(null)) == null || this.original != null && existingSuper.equals((Object)this.original))) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Categories with more than two characters must be sub-categories.\nEnter a higher level category.", this.getTitle(), 1);
                return;
            }
            if (this.original != null) {
                this.db.getCategoryService().updateCategory(this.original.getMnemonic(), category);
            } else {
                this.db.getCategoryService().addCategory(category);
            }
            this.updatedCategory = category;
            this.setOK();
        }
        catch (SuppressedSQLException se) {
            SbugsExceptionHandler.showStackError(se);
        }
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog((Component)((Object)this), "Colour : Select", this.jTextFieldColour.getBackground());
        if (colour != null) {
            this.jTextFieldColour.setBackground(colour);
        }
    }

    public Category getResult() {
        return this.updatedCategory;
    }
}

