/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.wellinterp;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.model2.wellinterp.InterpItemTableModel;
import jsbugs.table.DateRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Well;
import model3.wellinterp.InterpListViewer;
import util.SBException;

public class SQPickTableModel
extends InterpItemTableModel<SQPick> {
    private final SimpleTableColumn<SQPick> sampleColumn = new SimpleTableColumn<SQPick>("Sample", 55, Sample.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getSample();
        }
    });
    private final SimpleTableColumn<SQPick> qualifierColumn = new SimpleTableColumn<SQPick>("Qualifier", 20, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getQualifier();
        }
    });
    private final SimpleTableColumn<SQPick> surfaceColumn = new SimpleTableColumn<SQPick>("Surface", 50, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getName();
        }
    });
    private final SimpleTableColumn<SQPick> schemeColumn = new SimpleTableColumn<SQPick>("Scheme", 70, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            try {
                return pick.getSurface().getScheme().toString();
            }
            catch (SQLException ex) {
                return ex.getMessage();
            }
        }
    });
    private final SimpleTableColumn<SQPick> typeColumn = new SimpleTableColumn<SQPick>("Type", 20, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getTypeString();
        }
    });
    private final SimpleTableColumn<SQPick> boundaryColumn = new SimpleTableColumn<SQPick>("Boundary", 20, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getBnd();
        }
    });
    private final SimpleTableColumn<SQPick> obsColumn = new SimpleTableColumn<SQPick>("Obs.", 20, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.isObserved() ? "Yes" : "No";
        }
    });
    private final SimpleTableColumn<SQPick> modifiedByColumn = new SimpleTableColumn<SQPick>("Mod. By", 40, String.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            try {
                return pick.getModifierString();
            }
            catch (SQLException | SBException e) {
                return e.getMessage();
            }
        }
    });
    private final SimpleTableColumn<SQPick> modifiedOnColumn = new SimpleTableColumn<SQPick>("Modified", 40, Date.class, new IGetValue<SQPick>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(SQPick pick) {
            return pick.getModified();
        }
    });
    List<SimpleTableColumn<SQPick>> columns = new ArrayList<SimpleTableColumn>(Arrays.asList(this.sampleColumn, this.qualifierColumn, this.surfaceColumn, this.schemeColumn, this.typeColumn, this.boundaryColumn, this.obsColumn, this.modifiedByColumn, this.modifiedOnColumn));

    public SQPickTableModel() {
        super(SQPick.class);
    }

    public void setItems(InterpListViewer<SQPick> picks, Well well) {
        super.setItems(picks);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        SQPick pick = (SQPick)this.getItem(row);
        if (pick == null) {
            return null;
        }
        SimpleTableColumn<SQPick> columnValue = this.columns.get(col);
        return columnValue.getValueFromRow(pick);
    }

    public Class getColumnClass(int col) {
        SimpleTableColumn<SQPick> columnValue = this.columns.get(col);
        return columnValue.getValueClass();
    }

    @Override
    public void setupTable(JTable jTableSQPicks, SBdb sbdb) {
        this.init(jTableSQPicks, sbdb);
        jTableSQPicks.setDefaultRenderer(Sample.class, this.initTopSampleRenderer());
        jTableSQPicks.setDefaultRenderer(Date.class, new DateRenderer());
        jTableSQPicks.setRowHeight(20);
        this.restoreColumnOrder(jTableSQPicks);
    }

    @Override
    public String[] getColumnTitles() {
        String[] titles = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            titles[i] = this.columns.get(i).getTitle();
        }
        return titles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        int[] widths = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            widths[i] = this.columns.get(i).getDefaultWidth();
        }
        return widths;
    }

    @Override
    public String getPrefString() {
        return "TMSQPICK";
    }

    @Override
    public String getPrefOrderString() {
        return "TOSQPICK";
    }

    @Override
    public String getAutoResizeString() {
        return "TARSQPICK";
    }
}

