/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.wellinterp;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.model2.wellinterp.SQPickTableModel;
import jsbugs.table.CorrectedDepthRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleDepth;
import model3.Well;
import model3.wellinterp.InterpListViewer;

public class SQPickTableModelWithCorrections
extends SQPickTableModel {
    private Well well = null;
    private CorrectedDepthRenderer correctedRenderer = new CorrectedDepthRenderer(DepthUnits.M);
    private boolean displayCuttingSampleCorrections = true;
    private final SimpleTableColumn<SQPick> correctedColumn = new SimpleTableColumn<SQPick>("Corrected", 55, SampleDepth.class, new IGetValue<SQPick>(this){
        final /* synthetic */ SQPickTableModelWithCorrections this$0;
        {
            SQPickTableModelWithCorrections sQPickTableModelWithCorrections = this$0;
            Objects.requireNonNull(sQPickTableModelWithCorrections);
            this.this$0 = sQPickTableModelWithCorrections;
        }

        @Override
        public Object getValue(SQPick pick) {
            return this.this$0.getSampleDepth(pick.getSample());
        }
    });

    public SQPickTableModelWithCorrections() {
        this.columns.add(1, this.correctedColumn);
    }

    private Object getSampleDepth(Sample sample) {
        try {
            if (this.displayCuttingSampleCorrections || !sample.getType().equals((Object)SampleType.CU)) {
                return SampleDepth.BuildCorrectedSampleDepth(this.well, sample);
            }
            return new SampleDepth(sample.getDepth());
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void setItems(InterpListViewer<SQPick> picks, Well well) {
        super.setItems(picks);
        this.well = well;
    }

    @Override
    public void setupTable(JTable jTable, SBdb sbdb) {
        super.setupTable(jTable, sbdb);
        jTable.setDefaultRenderer(SampleDepth.class, this.correctedRenderer);
    }

    @Override
    public String getPrefString() {
        return "TMSQPIWC";
    }

    @Override
    public void setUnits(char units) {
        super.setUnits(units);
        this.correctedRenderer.setUnits(DepthUnits.getUnits((char)units));
    }

    @Override
    public String getPrefOrderString() {
        return "TOSQPIWC";
    }

    @Override
    public String getAutoResizeString() {
        return "TARSQPIWC";
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.displayCuttingSampleCorrections = value;
        this.fireTableDataChanged();
    }
}

