/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import com.stratadata.util.ui.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jsbugs.DialogList;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.ImportFileReader;
import model3.ImportFileReaderType;
import model3.SBdb;
import model3.WellChronoPickXLS;
import model3.WellHeader;
import model3.WellLstratPetrelXLS;
import model3.WellLstratPickXLS;
import model3.WellSQPickPetrelXLS;
import net.miginfocom.swing.MigLayout;

public class DialogImportFile
extends DialogBase {
    DefaultComboBoxModel fileTypeModel = new DefaultComboBoxModel();
    DefaultComboBoxModel columnHeaderModel = new DefaultComboBoxModel();
    private File importFile;
    SBdb db;
    private JLabel label4;
    private JTextField textFieldFilePath;
    private JLabel label1;
    private JComboBox comboBoxFileType;
    private JLabel label6;
    private JComboBox comboBoxColumnHeaders;
    private JLabel label2;
    private JTextField textFieldExtensions;
    private JPanel panel2;
    private JRadioButton radioButtonMetres;
    private JRadioButton radioButtonFeet;
    private JPanel panel1;
    private JLabel label5;
    private JTextField textFieldCountry;
    private JButton buttonCountry;
    private JLabel label3;
    private JScrollPane scrollPane1;
    private JTextArea textAreaDescription;

    public DialogImportFile(Window owner, SBdb db, File importFile) {
        super(owner);
        super.addOkButtonActionListener(new ActionListener(this){
            final /* synthetic */ DialogImportFile this$0;
            {
                DialogImportFile dialogImportFile = this$0;
                Objects.requireNonNull(dialogImportFile);
                this.this$0 = dialogImportFile;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.okButtonMethod(e);
            }
        });
        this.importFile = importFile;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs: File Import");
        for (ImportFileReaderType type : ImportFileReaderType.values()) {
            this.fileTypeModel.addElement(type);
        }
        this.comboBoxFileType.setModel(this.fileTypeModel);
        this.comboBoxColumnHeaders.setModel(this.columnHeaderModel);
        this.comboBoxFileType.setSelectedIndex(this.fileTypeModel.getSize() - 1);
        this.textFieldFilePath.setText(this.importFile.getAbsolutePath());
    }

    private void okButtonMethod(ActionEvent e) {
        ImportFileReaderType type = this.getSelected();
        if (type.isNeedsUnits() && !this.radioButtonFeet.isSelected() && !this.radioButtonMetres.isSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No units selected", "Import File Units", 2);
            return;
        }
        super.returnWithCode(DialogBase.ReturnCode.SUCCESS);
    }

    private void fileType(ActionEvent e) {
        ImportFileReader.ImportFileReaderColumn[] columns;
        ImportFileReaderType type = this.getSelected();
        this.textAreaDescription.setText(type.getDescription());
        Object exts = "";
        for (String s : type.getFileExtensions()) {
            exts = (String)exts + s + ", ";
        }
        exts = ((String)exts).substring(0, ((String)exts).length() - 2);
        this.textFieldExtensions.setText((String)exts);
        this.radioButtonFeet.setEnabled(type.isNeedsUnits());
        this.radioButtonMetres.setEnabled(type.isNeedsUnits());
        this.textFieldCountry.setEnabled(type.isNeedsCountry());
        this.buttonCountry.setEnabled(type.isNeedsCountry());
        this.columnHeaderModel.removeAllElements();
        for (ImportFileReader.ImportFileReaderColumn column : columns = (switch (type) {
            default -> throw new MatchException(null, null);
            case ImportFileReaderType.PETREL_LSTRAT -> new WellLstratPickXLS().getColumns();
            case ImportFileReaderType.PETREL_CHRONO -> new WellChronoPickXLS().getColumns();
            case ImportFileReaderType.AKERBP_PETREL_LSTRAT -> new WellLstratPetrelXLS().getColumns();
            case ImportFileReaderType.PETREL_SEQUENCE -> new WellSQPickPetrelXLS().getColumns();
        })) {
            this.columnHeaderModel.addElement(column.toString());
        }
    }

    public ImportFileReaderType getSelected() {
        return (ImportFileReaderType)((Object)this.comboBoxFileType.getSelectedItem());
    }

    public char getDepthUnits() {
        return this.radioButtonMetres.isSelected() ? (char)'M' : 'F';
    }

    public String getCountry() {
        return this.textFieldCountry.getText();
    }

    private void countrySelected(ActionEvent e) {
        try {
            List<String> list = WellHeader.getCountries(this.db);
            DialogList<String> dialog = new DialogList<String>((JDialog)((Object)this), true, "Select Country", new UserPrefsHelper(this.db), list, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.textFieldCountry.setText(dialog.getSelection());
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void initComponents() {
        this.label4 = new JLabel();
        this.textFieldFilePath = new JTextField();
        this.label1 = new JLabel();
        this.comboBoxFileType = new JComboBox();
        this.label6 = new JLabel();
        this.comboBoxColumnHeaders = new JComboBox();
        this.label2 = new JLabel();
        this.textFieldExtensions = new JTextField();
        this.panel2 = new JPanel();
        this.radioButtonMetres = new JRadioButton();
        this.radioButtonFeet = new JRadioButton();
        this.panel1 = new JPanel();
        this.label5 = new JLabel();
        this.textFieldCountry = new JTextField();
        this.buttonCountry = new JButton();
        this.label3 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.textAreaDescription = new JTextArea();
        this.setPreferredSize(new Dimension(930, 410));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fill,insets panel,hidemode 3", "[98,fill][grow,fill][grow,fill]", "[][34][][][][][grow,fill]"));
        this.label4.setText("File name:");
        contentPanel.add((Component)this.label4, "cell 0 0");
        contentPanel.add((Component)this.textFieldFilePath, "cell 1 0");
        this.label1.setText("Import as file:");
        contentPanel.add((Component)this.label1, "cell 0 1");
        this.comboBoxFileType.addActionListener(e -> this.fileType(e));
        contentPanel.add((Component)this.comboBoxFileType, "cell 1 1");
        this.label6.setText("Column headers:");
        contentPanel.add((Component)this.label6, "cell 0 2");
        this.comboBoxColumnHeaders.setEditable(true);
        contentPanel.add((Component)this.comboBoxColumnHeaders, "cell 1 2");
        this.label2.setText("Extensions:");
        contentPanel.add((Component)this.label2, "cell 0 3");
        this.textFieldExtensions.setEditable(false);
        contentPanel.add((Component)this.textFieldExtensions, "cell 1 3");
        this.panel2.setBorder(new TitledBorder("Depth Units"));
        this.panel2.setLayout(new BorderLayout());
        this.radioButtonMetres.setText("Metres");
        this.radioButtonMetres.setSelected(true);
        this.radioButtonMetres.setHorizontalAlignment(2);
        this.panel2.add((Component)this.radioButtonMetres, "Center");
        this.radioButtonFeet.setText("Feet");
        this.radioButtonFeet.setHorizontalAlignment(2);
        this.panel2.add((Component)this.radioButtonFeet, "South");
        contentPanel.add((Component)this.panel2, "cell 1 4");
        this.panel1.setLayout(new BorderLayout());
        contentPanel.add((Component)this.panel1, "cell 1 4,wmin 50%");
        this.label5.setText("Country:");
        contentPanel.add((Component)this.label5, "cell 0 5");
        this.textFieldCountry.setText("NORWAY");
        this.textFieldCountry.setEditable(false);
        contentPanel.add((Component)this.textFieldCountry, "cell 1 5");
        this.buttonCountry.setText("...");
        this.buttonCountry.addActionListener(e -> this.countrySelected(e));
        contentPanel.add((Component)this.buttonCountry, "cell 2 5");
        this.label3.setText("Description:");
        contentPanel.add((Component)this.label3, "cell 0 6,aligny top,growy 0");
        this.textAreaDescription.setLineWrap(true);
        this.textAreaDescription.setEditable(false);
        this.scrollPane1.setViewportView(this.textAreaDescription);
        contentPanel.add((Component)this.scrollPane1, "cell 1 6");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.radioButtonMetres);
        buttonGroup1.add(this.radioButtonFeet);
    }
}

