/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogList;
import jsbugs.DialogMatch;
import jsbugs.DialogSearchUnit;
import jsbugs.organiser.IGDWellUnits;
import jsbugs.organiser.TableModelMatchIGDWellUnits;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.InvalidFieldException;
import util.SBException;
import util.exception.StackError;

public class DialogMatchIGDWellUnits
extends JDialog {
    TableModelMatchIGDWellUnits model = new TableModelMatchIGDWellUnits();
    Image backgroundImage;
    IGDScheme scheme;
    SBdb wsDB;
    SBdb dbDB;
    public boolean isOK = false;
    private JButton jButtonAssignScheme;
    private JButton jButtonCancel;
    private JButton jButtonFindUnit;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchIGDWellUnits;
    private JTextField jTextFieldScheme;

    public DialogMatchIGDWellUnits(JDialog parent, boolean modal, SBdb ws, SBdb db, IGDScheme scheme) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.wsDB = ws;
        this.dbDB = db;
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Stratigraphic Units");
        this.getRootPane().setDefaultButton(this.jButtonCancel);
        this.jTextFieldScheme.setText(this.scheme.toString());
        this.model.init(this.wsDB, this.scheme);
        this.model.setUpTable(this.jTableMatchIGDWellUnits);
        this.jTableMatchIGDWellUnits.setRowSorter(new TableRowSorter<TableModelMatchIGDWellUnits>(this.model));
        new ColumnSortResetHandler(this.jTableMatchIGDWellUnits).attach();
        this.model.fireTableDataChanged();
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIGDWellUnits this$0;
            {
                DialogMatchIGDWellUnits dialogMatchIGDWellUnits = this$0;
                Objects.requireNonNull(dialogMatchIGDWellUnits);
                this.this$0 = dialogMatchIGDWellUnits;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchIGDWellUnits = new JTable();
        this.jLabel1 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonAssignScheme = new JButton();
        this.jButtonFindUnit = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTableMatchIGDWellUnits.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchIGDWellUnits);
        this.jLabel1.setText("Scheme in workspace:");
        this.jTextFieldScheme.setEditable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDWellUnits this$0;
            {
                DialogMatchIGDWellUnits dialogMatchIGDWellUnits = this$0;
                Objects.requireNonNull(dialogMatchIGDWellUnits);
                this.this$0 = dialogMatchIGDWellUnits;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDWellUnits this$0;
            {
                DialogMatchIGDWellUnits dialogMatchIGDWellUnits = this$0;
                Objects.requireNonNull(dialogMatchIGDWellUnits);
                this.this$0 = dialogMatchIGDWellUnits;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAssignScheme.setText("Assign scheme ...");
        this.jButtonAssignScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDWellUnits this$0;
            {
                DialogMatchIGDWellUnits dialogMatchIGDWellUnits = this$0;
                Objects.requireNonNull(dialogMatchIGDWellUnits);
                this.this$0 = dialogMatchIGDWellUnits;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAssignSchemeActionPerformed(evt);
            }
        });
        this.jButtonFindUnit.setText("Find unit ...");
        this.jButtonFindUnit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDWellUnits this$0;
            {
                DialogMatchIGDWellUnits dialogMatchIGDWellUnits = this$0;
                Objects.requireNonNull(dialogMatchIGDWellUnits);
                this.this$0 = dialogMatchIGDWellUnits;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFindUnitActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldScheme)).addComponent(this.jScrollPane1, -1, 826, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonAssignScheme, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFindUnit, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(14, 14, 14)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldScheme, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 515, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonAssignScheme).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFindUnit).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonAssignSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGDWellUnits.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        try {
            List<IGDScheme> schemes = this.dbDB.getIGDSchemes(this.scheme.getIGDType());
            Collections.sort(schemes);
            DialogList<IGDScheme> dialogList = new DialogList<IGDScheme>(this, true, "Select Scheme", null, schemes, true, false);
            dialogList.setLocationRelativeTo(this);
            dialogList.setVisible(true);
            if (dialogList.getSelection() == null) {
                return;
            }
            IGDScheme dbScheme = dialogList.getSelection();
            LinkedList<IGDWellUnits> toAssign = new LinkedList<IGDWellUnits>();
            int[] selection = this.jTableMatchIGDWellUnits.getSelectedRows();
            for (int i = 0; i < selection.length; ++i) {
                toAssign.add(this.model.data.get(this.jTableMatchIGDWellUnits.convertRowIndexToModel(selection[i])));
            }
            for (IGDWellUnits u : toAssign) {
                u.dbScheme = dbScheme;
                IGDUnit dbUnit = null;
                if (u.wsUnit != null) {
                    dbUnit = (IGDUnit)dbScheme.findUnitBase(u.wsUnit.getName(), u.wsUnit.getHier());
                }
                if (dbUnit == null) {
                    dbUnit = dbScheme.findUnit(u.wsUnitName);
                }
                u.dbUnit = dbUnit;
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            StackError.showStackError((String)"SQL Error checking matches", (SQLException)sqle);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            int nAssigned = 0;
            for (IGDWellUnits u : this.model.data) {
                IGDScheme dbScheme = u.dbScheme;
                IGDUnit wsUnit = null;
                if (dbScheme == null || dbScheme == this.scheme.getLink()) continue;
                IGDScheme wsScheme = this.wsDB.getIGDScheme(dbScheme.getName(), dbScheme.getIGDType());
                if (wsScheme == null) {
                    wsScheme = this.wsDB.addIGDScheme(dbScheme.getIGDType(), dbScheme.getName(), dbScheme.getComments());
                    wsScheme.setLink(dbScheme);
                    for (IGDUnit dbUnit : dbScheme.getUnits()) {
                        IGDUnit.Builder builder = new IGDUnit.Builder(this.wsDB);
                        builder.name(dbUnit.getName());
                        builder.abr(dbUnit.getAbr()).comments(dbUnit.getComments());
                        builder.age(dbUnit.getUage(), dbUnit.getLage()).hier(dbUnit.getHier());
                        builder.confidence(true, dbUnit.getConfidence(true)).confidence(false, dbUnit.getConfidence(false));
                        builder.colour(dbUnit.getColour());
                        IGDUnitBase wsAddUnit = wsScheme.addUnit(builder);
                        wsAddUnit.setLink(dbUnit, null);
                    }
                } else if (wsScheme.getLink() == null) {
                    dbScheme.loadUnits();
                    wsScheme.setLink(dbScheme);
                }
                if (u.dbUnit != null && (wsUnit = (IGDUnit)wsScheme.findUnitBase(u.dbUnit.getName(), u.dbUnit.getHier())) == null) {
                    throw new SBException("Failed to relocate database scheme unit in workspace scheme: " + u.dbUnit.getName());
                }
                Iterator<Well> it = this.wsDB.getWellIterator();
                while (it.hasNext()) {
                    Well well = it.next();
                    Iterator<WellInterp> iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp interp = iit.next();
                        List<IGDIntervalZone> zones = interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
                        for (IGDIntervalZone zone : zones) {
                            String term = zone.getUppInf();
                            if (term != null && !term.isBlank() && term.equals(u.wsUnitName)) {
                                zone.setSchID(wsScheme.getID());
                                zone.setUppZone(wsUnit != null ? wsUnit.getUnitID() : 0);
                                if (zone.getLowZone() > 0 && wsScheme.findUnit(zone.getLowZone()) == null) {
                                    zone.setLowZone(0);
                                }
                                ++nAssigned;
                            }
                            if ((term = zone.getLowInf()) == null || term.isBlank() || !term.equals(u.wsUnitName)) continue;
                            zone.setSchID(wsScheme.getID());
                            zone.setLowZone(wsUnit != null ? wsUnit.getUnitID() : 0);
                            if (zone.getUppZone() > 0 && wsScheme.findUnit(zone.getUppZone()) == null) {
                                zone.setUppZone(0);
                            }
                            ++nAssigned;
                        }
                    }
                }
            }
            if (nAssigned > 0) {
                JOptionPane.showMessageDialog(this, "Number of unit terms reassigned: " + nAssigned, "Match Well Units", 1);
            }
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException | InvalidFieldException | SBException sqle) {
            StackError.showStackError((String)"Error: ", (Throwable)sqle);
        }
    }

    private void jButtonFindUnitActionPerformed(ActionEvent evt) {
        String searchTerm = null;
        if (this.jTableMatchIGDWellUnits.getSelectedRowCount() == 1) {
            searchTerm = (String)this.model.getValueAt(this.jTableMatchIGDWellUnits.convertRowIndexToModel(this.jTableMatchIGDWellUnits.getSelectedRow()), 0);
        }
        DialogSearchUnit dialog = new DialogSearchUnit(this, true, this.dbDB, searchTerm);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

