/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.ui.SbugsLookAndFeelSetup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import jsbugs.ITaxonSelectionChangedListener;
import jsbugs.overlay.IOverlayControlsListener;
import jsbugs.overlay.SizeFactor;
import model3.Taxon;

public class JPanelOverlayControls
extends JPanel
implements ITaxonSelectionChangedListener {
    private boolean mkrSelected = false;
    private boolean cvSelected = false;
    private boolean rwSelected = false;
    private boolean questionableSelected = false;
    private boolean numpadSelected = false;
    private boolean imagesSelected = false;
    private SizeFactor selectedSize = SizeFactor.MEDIUM;
    private List<JButton> semiQuantButtons = new ArrayList<JButton>();
    private static final Color PALE_BLUE = new Color(230, 230, 255);
    private boolean displayQuant = true;
    private boolean showSizeFactors = false;
    private AbundanceScheme abundanceScheme;
    private String selectedSQEntry;
    private boolean enableQSQSelection = false;
    private IOverlayControlsListener listener;
    private JButton jButtonCoarse;
    private JButton jButtonCv;
    private JButton jButtonDesign;
    private JButton jButtonEnter;
    private JButton jButtonFine;
    private JButton jButtonImage;
    private JButton jButtonMedium;
    private JButton jButtonMkr;
    private JButton jButtonNumpad;
    private JButton jButtonQSQ;
    private JButton jButtonQuestionable;
    private JButton jButtonRw;
    private JButton jButtonTaxonName;

    public JPanelOverlayControls() {
        this.initComponents();
        this.setSizeFractionButtonsVisible(false);
    }

    public JPanelOverlayControls(boolean showCMF) {
        this.initComponents();
        this.setSizeFractionButtonsVisible(showCMF);
    }

    public Situation getSituation() {
        if (this.rwSelected) {
            return Situation.RW;
        }
        if (this.cvSelected) {
            return Situation.CV;
        }
        return Situation.INSITU;
    }

    public boolean isMkr() {
        return this.mkrSelected;
    }

    public boolean isCaved() {
        return this.cvSelected;
    }

    public boolean isReworked() {
        return this.rwSelected;
    }

    public boolean isQuestionable() {
        return this.questionableSelected;
    }

    public void setShowImages(boolean value) {
        this.imagesSelected = value;
        this.updateImageButtonColour();
        this.revalidate();
        this.repaint();
    }

    public void enableQSQSelection() {
        this.enableQSQSelection = true;
    }

    public void clearAbundanceScheme() {
        if (this.abundanceScheme != null) {
            this.abundanceScheme = null;
            if (!this.displayQuant) {
                this.removeSemiQuantButtons();
                this.addSemiQuantButtons();
            }
        }
    }

    public void setNumpadButtonHighlighted() {
        this.jButtonNumpad.setBackground(PALE_BLUE);
        this.numpadSelected = true;
    }

    private void setSizeFractionButtonsVisible(boolean value) {
        this.jButtonFine.setVisible(value);
        this.jButtonMedium.setVisible(value);
        this.jButtonCoarse.setVisible(value);
        if (value) {
            this.updateSizeFractionButtons();
        } else {
            this.selectedSize = SizeFactor.MEDIUM;
        }
    }

    private void setSelectedSize(SizeFactor size) {
        this.selectedSize = size;
        this.updateSizeFractionButtons();
    }

    private void updateSizeFractionButtons() {
        for (JButton b : Arrays.asList(this.jButtonCoarse, this.jButtonMedium, this.jButtonFine)) {
            this.colourButtonUnselected(b);
        }
        this.colourButtonSelected(switch (this.selectedSize) {
            case SizeFactor.COARSE -> this.jButtonCoarse;
            case SizeFactor.FINE -> this.jButtonFine;
            default -> this.jButtonMedium;
        });
    }

    private void colourButtonSelected(JButton selected) {
        if (SbugsLookAndFeelSetup.isNativeLAF()) {
            selected.setBackground(new Color(102, 102, 102));
            selected.setOpaque(true);
            selected.setForeground(Color.WHITE);
        } else {
            selected.setForeground(Color.RED);
        }
    }

    private void colourButtonUnselected(JButton b) {
        if (SbugsLookAndFeelSetup.isNativeLAF()) {
            b.setBackground(new Color(204, 204, 204));
            b.setOpaque(true);
            b.setForeground(Color.BLACK);
        } else {
            b.setForeground(Color.BLACK);
        }
    }

    private void toggleQSQVisible() {
        if (!this.enableQSQSelection) {
            return;
        }
        if (this.displayQuant) {
            this.setSizeFractionButtonsVisible(false);
            this.addSemiQuantButtons();
            this.displayQuant = false;
        } else {
            this.setSizeFractionButtonsVisible(this.showSizeFactors);
            this.removeSemiQuantButtons();
            this.displayQuant = true;
        }
    }

    private void addSemiQuantButtons() {
        if (this.abundanceScheme == null) {
            JButton b = this.buildSQButton("Select abundance scheme for suite.", 12);
            this.addSQButton(b);
            this.semiQuantButtons.add(b);
        } else {
            for (int i = this.abundanceScheme.getEntryCount() - 1; i >= 0; --i) {
                String s = this.abundanceScheme.getEntry(i).abr();
                JButton b = this.buildSQButton(s, 18);
                this.addSQButton(b);
                b.addActionListener(new ActionListener(this){
                    final /* synthetic */ JPanelOverlayControls this$0;
                    {
                        JPanelOverlayControls jPanelOverlayControls = this$0;
                        Objects.requireNonNull(jPanelOverlayControls);
                        this.this$0 = jPanelOverlayControls;
                    }

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        this.this$0.semiquantButtonClick((JButton)evt.getSource());
                    }
                });
                if (i == 0) {
                    this.selectedSQEntry = s;
                    this.colourButtonSelected(b);
                } else {
                    this.colourButtonUnselected(b);
                }
                this.semiQuantButtons.add(b);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void semiquantButtonClick(JButton sender) {
        for (JButton b : this.semiQuantButtons) {
            this.colourButtonUnselected(b);
        }
        this.colourButtonSelected(sender);
        this.selectedSQEntry = sender.getText();
    }

    private void addSQButton(JButton b) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        this.add(b, c, 4);
    }

    private JButton buildSQButton(String text, int fontSize) {
        JButton b = new JButton();
        b.setBackground(new Color(255, 255, 255));
        b.setFont(new Font("Tahoma", 0, fontSize));
        b.setText(text);
        b.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        b.setContentAreaFilled(false);
        b.setFocusPainted(false);
        b.setMinimumSize(new Dimension(b.getPreferredSize().width + 16, b.getPreferredSize().height));
        b.setPreferredSize(b.getMinimumSize());
        b.setOpaque(true);
        return b;
    }

    private void removeSemiQuantButtons() {
        for (JButton b : this.semiQuantButtons) {
            this.remove(b);
        }
        this.semiQuantButtons.clear();
        this.revalidate();
        this.repaint();
    }

    private void updateImageButtonColour() {
        if (this.imagesSelected) {
            this.jButtonImage.setBackground(PALE_BLUE);
        } else {
            this.jButtonImage.setBackground(Color.white);
        }
    }

    private void initComponents() {
        this.jButtonDesign = new JButton();
        this.jButtonQSQ = new JButton();
        this.jButtonCoarse = new JButton();
        this.jButtonMedium = new JButton();
        this.jButtonFine = new JButton();
        this.jButtonTaxonName = new JButton();
        this.jButtonMkr = new JButton();
        this.jButtonCv = new JButton();
        this.jButtonRw = new JButton();
        this.jButtonQuestionable = new JButton();
        this.jButtonImage = new JButton();
        this.jButtonNumpad = new JButton();
        this.jButtonEnter = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMinimumSize(new Dimension(544, 50));
        this.setLayout(new GridBagLayout());
        this.jButtonDesign.setBackground(new Color(255, 255, 255));
        this.jButtonDesign.setFont(new Font("Tahoma", 0, 18));
        this.jButtonDesign.setText("Design");
        this.jButtonDesign.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonDesign.setContentAreaFilled(false);
        this.jButtonDesign.setFocusPainted(false);
        this.jButtonDesign.setMinimumSize(new Dimension(60, 50));
        this.jButtonDesign.setOpaque(true);
        this.jButtonDesign.setPreferredSize(new Dimension(75, 50));
        this.jButtonDesign.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDesignActionPerformed(evt);
            }
        });
        this.jButtonDesign.addPropertyChangeListener(new PropertyChangeListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.this$0.jButtonDesignPropertyChange(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonDesign, gridBagConstraints);
        this.jButtonQSQ.setBackground(new Color(255, 255, 255));
        this.jButtonQSQ.setFont(new Font("Tahoma", 0, 18));
        this.jButtonQSQ.setText("Q/SQ");
        this.jButtonQSQ.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonQSQ.setContentAreaFilled(false);
        this.jButtonQSQ.setFocusPainted(false);
        this.jButtonQSQ.setMinimumSize(new Dimension(60, 50));
        this.jButtonQSQ.setOpaque(true);
        this.jButtonQSQ.setPreferredSize(new Dimension(60, 50));
        this.jButtonQSQ.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonQSQActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonQSQ, gridBagConstraints);
        this.jButtonCoarse.setBackground(new Color(204, 204, 204));
        this.jButtonCoarse.setFont(new Font("Tahoma", 0, 18));
        this.jButtonCoarse.setText("Coarse");
        this.jButtonCoarse.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonCoarse.setContentAreaFilled(false);
        this.jButtonCoarse.setFocusPainted(false);
        this.jButtonCoarse.setMinimumSize(new Dimension(70, 50));
        this.jButtonCoarse.setOpaque(true);
        this.jButtonCoarse.setPreferredSize(new Dimension(70, 50));
        this.jButtonCoarse.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCoarseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonCoarse, gridBagConstraints);
        this.jButtonMedium.setBackground(new Color(102, 102, 102));
        this.jButtonMedium.setFont(new Font("Tahoma", 0, 18));
        this.jButtonMedium.setForeground(new Color(255, 255, 255));
        this.jButtonMedium.setText("Medium");
        this.jButtonMedium.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonMedium.setContentAreaFilled(false);
        this.jButtonMedium.setFocusPainted(false);
        this.jButtonMedium.setMinimumSize(new Dimension(80, 50));
        this.jButtonMedium.setOpaque(true);
        this.jButtonMedium.setPreferredSize(new Dimension(80, 50));
        this.jButtonMedium.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMediumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonMedium, gridBagConstraints);
        this.jButtonFine.setBackground(new Color(204, 204, 204));
        this.jButtonFine.setFont(new Font("Tahoma", 0, 18));
        this.jButtonFine.setText("Fine");
        this.jButtonFine.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonFine.setContentAreaFilled(false);
        this.jButtonFine.setFocusPainted(false);
        this.jButtonFine.setMinimumSize(new Dimension(60, 50));
        this.jButtonFine.setOpaque(true);
        this.jButtonFine.setPreferredSize(new Dimension(60, 50));
        this.jButtonFine.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonFine, gridBagConstraints);
        this.jButtonTaxonName.setBackground(new Color(255, 255, 255));
        this.jButtonTaxonName.setFont(new Font("Tahoma", 0, 18));
        this.jButtonTaxonName.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonTaxonName.setContentAreaFilled(false);
        this.jButtonTaxonName.setFocusPainted(false);
        this.jButtonTaxonName.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonTaxonName, gridBagConstraints);
        this.jButtonMkr.setBackground(new Color(255, 255, 255));
        this.jButtonMkr.setFont(new Font("Tahoma", 0, 18));
        this.jButtonMkr.setText("Mkr");
        this.jButtonMkr.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonMkr.setContentAreaFilled(false);
        this.jButtonMkr.setFocusPainted(false);
        this.jButtonMkr.setMinimumSize(new Dimension(40, 50));
        this.jButtonMkr.setOpaque(true);
        this.jButtonMkr.setPreferredSize(new Dimension(40, 50));
        this.jButtonMkr.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMkrActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonMkr, gridBagConstraints);
        this.jButtonCv.setBackground(new Color(255, 255, 255));
        this.jButtonCv.setFont(new Font("Tahoma", 0, 18));
        this.jButtonCv.setText("Cv");
        this.jButtonCv.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonCv.setContentAreaFilled(false);
        this.jButtonCv.setFocusPainted(false);
        this.jButtonCv.setMinimumSize(new Dimension(40, 50));
        this.jButtonCv.setOpaque(true);
        this.jButtonCv.setPreferredSize(new Dimension(40, 50));
        this.jButtonCv.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCvActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonCv, gridBagConstraints);
        this.jButtonRw.setBackground(new Color(255, 255, 255));
        this.jButtonRw.setFont(new Font("Tahoma", 0, 18));
        this.jButtonRw.setText("Rw");
        this.jButtonRw.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonRw.setContentAreaFilled(false);
        this.jButtonRw.setFocusPainted(false);
        this.jButtonRw.setMinimumSize(new Dimension(40, 50));
        this.jButtonRw.setOpaque(true);
        this.jButtonRw.setPreferredSize(new Dimension(40, 50));
        this.jButtonRw.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRwActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonRw, gridBagConstraints);
        this.jButtonQuestionable.setBackground(new Color(255, 255, 255));
        this.jButtonQuestionable.setFont(new Font("Tahoma", 0, 18));
        this.jButtonQuestionable.setText("?");
        this.jButtonQuestionable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonQuestionable.setContentAreaFilled(false);
        this.jButtonQuestionable.setFocusPainted(false);
        this.jButtonQuestionable.setMinimumSize(new Dimension(40, 50));
        this.jButtonQuestionable.setOpaque(true);
        this.jButtonQuestionable.setPreferredSize(new Dimension(40, 50));
        this.jButtonQuestionable.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonQuestionableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonQuestionable, gridBagConstraints);
        this.jButtonImage.setBackground(new Color(255, 255, 255));
        this.jButtonImage.setFont(new Font("Tahoma", 0, 18));
        this.jButtonImage.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/camera.png")));
        this.jButtonImage.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonImage.setContentAreaFilled(false);
        this.jButtonImage.setFocusPainted(false);
        this.jButtonImage.setMinimumSize(new Dimension(50, 50));
        this.jButtonImage.setOpaque(true);
        this.jButtonImage.setPreferredSize(new Dimension(50, 50));
        this.jButtonImage.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonImage, gridBagConstraints);
        this.jButtonNumpad.setBackground(new Color(255, 255, 255));
        this.jButtonNumpad.setFont(new Font("Tahoma", 0, 18));
        this.jButtonNumpad.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/numpad.png")));
        this.jButtonNumpad.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonNumpad.setContentAreaFilled(false);
        this.jButtonNumpad.setFocusPainted(false);
        this.jButtonNumpad.setMinimumSize(new Dimension(50, 50));
        this.jButtonNumpad.setOpaque(true);
        this.jButtonNumpad.setPreferredSize(new Dimension(50, 50));
        this.jButtonNumpad.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNumpadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonNumpad, gridBagConstraints);
        this.jButtonEnter.setBackground(new Color(255, 255, 255));
        this.jButtonEnter.setFont(new Font("Tahoma", 0, 18));
        this.jButtonEnter.setText("Enter");
        this.jButtonEnter.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonEnter.setContentAreaFilled(false);
        this.jButtonEnter.setFocusPainted(false);
        this.jButtonEnter.setMinimumSize(new Dimension(60, 50));
        this.jButtonEnter.setOpaque(true);
        this.jButtonEnter.setPreferredSize(new Dimension(75, 31));
        this.jButtonEnter.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayControls this$0;
            {
                JPanelOverlayControls jPanelOverlayControls = this$0;
                Objects.requireNonNull(jPanelOverlayControls);
                this.this$0 = jPanelOverlayControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEnterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonEnter, gridBagConstraints);
    }

    private void jButtonDesignPropertyChange(PropertyChangeEvent evt) {
    }

    private void jButtonMkrActionPerformed(ActionEvent evt) {
        this.toggleMarker();
    }

    private void jButtonCvActionPerformed(ActionEvent evt) {
        this.toggleCaved();
    }

    private void jButtonRwActionPerformed(ActionEvent evt) {
        this.toggleReworked();
    }

    private void jButtonQuestionableActionPerformed(ActionEvent evt) {
        this.toggleQuestionable();
    }

    private void jButtonNumpadActionPerformed(ActionEvent evt) {
        if (this.numpadSelected) {
            this.jButtonNumpad.setBackground(Color.white);
            this.numpadSelected = false;
        } else {
            this.jButtonNumpad.setBackground(PALE_BLUE);
            this.numpadSelected = true;
        }
        if (this.listener != null) {
            this.listener.numpadDisplayChanged(this.numpadSelected);
        }
    }

    private void jButtonImageActionPerformed(ActionEvent evt) {
        this.imagesSelected = !this.imagesSelected;
        this.updateImageButtonColour();
        if (this.listener != null) {
            this.listener.imagesDisplayChanged(this.imagesSelected);
        }
    }

    private void jButtonQSQActionPerformed(ActionEvent evt) {
        this.toggleQSQVisible();
    }

    private void jButtonCoarseActionPerformed(ActionEvent evt) {
        this.setSelectedSize(SizeFactor.COARSE);
    }

    private void jButtonMediumActionPerformed(ActionEvent evt) {
        this.setSelectedSize(SizeFactor.MEDIUM);
    }

    private void jButtonFineActionPerformed(ActionEvent evt) {
        this.setSelectedSize(SizeFactor.FINE);
    }

    private void jButtonEnterActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.onEnterPressed();
        }
    }

    private void jButtonDesignActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.onDesignToggle();
        }
    }

    @Override
    public void selectedTaxonChanged(Taxon taxon) {
        if (taxon == null) {
            this.jButtonTaxonName.setText("");
        } else {
            this.jButtonTaxonName.setText(taxon.toString(false, false));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void displaySizeFactors() {
        this.showSizeFactors = true;
        if (this.displayQuant) {
            this.setSizeFractionButtonsVisible(true);
        }
    }

    public void hideSizeFactors() {
        this.showSizeFactors = false;
        if (this.displayQuant) {
            this.setSizeFractionButtonsVisible(false);
        }
    }

    public void setAbundanceScheme(AbundanceScheme scheme) {
        if (scheme == null) {
            if (this.abundanceScheme != null && this.isSemiQuantMode()) {
                this.removeSemiQuantButtons();
                this.abundanceScheme = scheme;
                this.addSemiQuantButtons();
            }
        } else if (this.isSemiQuantMode() && scheme.getAbnSchID() != this.abundanceScheme.getAbnSchID()) {
            this.removeSemiQuantButtons();
            this.abundanceScheme = scheme;
            this.addSemiQuantButtons();
        } else {
            this.abundanceScheme = scheme;
        }
    }

    public SizeFactor getSelectedSize() {
        return this.selectedSize;
    }

    public boolean isSemiQuantMode() {
        return !this.displayQuant;
    }

    public boolean isQuantativeMode() {
        return this.displayQuant;
    }

    public void setListener(IOverlayControlsListener listener) {
        this.listener = listener;
    }

    public String getAbundanceEntry() {
        return this.selectedSQEntry;
    }

    public void toggleQuestionable() {
        this.questionableSelected = this.setToggle(this.questionableSelected, this.jButtonQuestionable);
    }

    boolean setToggle(boolean toggleSelected, JButton button) {
        if (SbugsLookAndFeelSetup.isNativeLAF()) {
            if (toggleSelected) {
                button.setBackground(Color.white);
            } else {
                button.setBackground(Color.red);
            }
        } else if (toggleSelected) {
            button.setForeground(Color.black);
        } else {
            button.setForeground(Color.red);
        }
        return !toggleSelected;
    }

    public void toggleReworked() {
        if (!this.rwSelected) {
            this.cvSelected = this.setToggle(true, this.jButtonCv);
        }
        this.rwSelected = this.setToggle(this.rwSelected, this.jButtonRw);
    }

    public void toggleCaved() {
        if (!this.cvSelected) {
            this.rwSelected = this.setToggle(true, this.jButtonRw);
        }
        this.cvSelected = this.setToggle(this.cvSelected, this.jButtonCv);
    }

    public void toggleMarker() {
        this.mkrSelected = this.setToggle(this.mkrSelected, this.jButtonMkr);
    }
}

