/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.well.analysis.Situation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsbugs.FrameJsbugs;
import jsbugs.ITaxonSelectionChangedListener;
import jsbugs.TaxonTransferHandler;
import jsbugs.overlay.GridLayoutHelper;
import jsbugs.overlay.ITaxonDoubleClickListener;
import jsbugs.overlay.Line;
import jsbugs.overlay.OverlayCellArtist;
import jsbugs.overlay.OverlayCellData;
import jsbugs.overlay.OverlayMouseSelectionManager;
import model3.Overlay;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import util.SBException;
import util.SBPermissionException;

public class OverlayJPanel
extends JPanel
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(OverlayJPanel.class.getName());
    private final int lasooStrokeWidth = 2;
    private final Stroke lasooStroke = new BasicStroke(2.0f, 0, 0);
    private final int dragTargetStrokeWidth = 3;
    private final Stroke dragTargetStroke = new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private final int dragAreaWidth = 2;
    private final Stroke dragAreaStroke = new BasicStroke(2.0f, 0, 0);
    private final Color dragAreaColour = Color.RED;
    private Overlay overlay;
    public float zoom = 1.0f;
    public static final float pixPerMM = 2.8346457f;
    public boolean antialias = true;
    final int nControls = 16;
    static final float BAR_HEIGHT = 50.0f;
    final Color selectedColour = new Color(255, 255, 150);
    final Color loggedColour = new Color(230, 230, 255);
    final Color SBUGSPURPLE = new Color(148, 49, 99);
    final Color bgGrey = new Color(240, 240, 240);
    public int selectedCell = -1;
    private int lastCell = -1;
    boolean countMode = true;
    Smpdtl smpdtl;
    Well well;
    private SBdb db;
    int nCategories = 0;
    HashMap<Integer, Color> genColours = new HashMap();
    boolean isQuant = true;
    Situation situation = Situation.INSITU;
    boolean isMarker = false;
    boolean isQuestionable = false;
    private boolean insertRow = true;
    private int totaliser = 0;
    boolean showCMF = false;
    private GridLayoutHelper helper;
    private final OverlayCellArtist artist;
    private List<OverlayCellData> cellDataList;
    private final OverlayMouseSelectionManager selectionManager;
    private final List<ITaxonSelectionChangedListener> taxonListeners = new ArrayList<ITaxonSelectionChangedListener>();
    private final List<ITaxonDoubleClickListener> taxonClickListeners = new ArrayList<ITaxonDoubleClickListener>();

    public OverlayJPanel(SBdb db, Overlay overlay, Well well, Smpdtl smpdtl, boolean cmf) {
        this.setBackground(Color.WHITE);
        this.db = db;
        this.overlay = overlay;
        this.artist = new OverlayCellArtist(db.getImageRecordService(), db.getImageLoader());
        this.selectionManager = new OverlayMouseSelectionManager(this, overlay, db);
        this.addMouseListener(this.selectionManager);
        this.addMouseMotionListener(this.selectionManager);
        this.setSmpdtl(well, smpdtl);
        if (well == null) {
            this.countMode = false;
        }
        this.setTransferHandler(new TaxonTransferHandler(db, null));
        overlay.addObserver(this);
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setTotaliser(int n) {
        this.totaliser = n;
    }

    public int getTotaliser() {
        return this.totaliser;
    }

    public Taxon getSelectedTaxon() throws SQLException {
        if (this.selectedCell >= 0 && this.overlay != null) {
            Taxon t = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell));
            return t;
        }
        return null;
    }

    public TaxonOcc getSelectedOccurrence() throws SQLException {
        if (this.getSelectedTaxon() != null) {
            return this.smpdtl.getFss(this.getSelectedTaxon(), this.situation, this.isQuestionable ? (char)'?' : 'P', 0);
        }
        return null;
    }

    public void moveSelectionDown() {
        this.moveUpDown(false);
    }

    public void moveSelectionUp() {
        this.moveUpDown(true);
    }

    public void moveSelectionLeft() {
        this.moveLeftRight(true);
    }

    public void moveSelectionRight() {
        this.moveLeftRight(false);
    }

    private void moveUpDown(boolean up) {
        if (this.selectedCell >= 0) {
            int row = this.getRow(this.selectedCell) + (up ? -1 : 1);
            int col = this.getCol(this.selectedCell);
            try {
                if ((up && row >= 0 || !up && row < this.overlay.getRows()) && this.overlay.getTaxon(row, col) != null) {
                    this.selectedCell = col + row * this.overlay.getCols();
                    this.repaint();
                }
                Taxon taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell));
                this.notifyTaxonSelectionListeners(taxon);
            }
            catch (SQLException ex) {
                Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void moveLeftRight(boolean left) {
        if (this.selectedCell >= 0) {
            int row = this.getRow(this.selectedCell);
            int col = this.getCol(this.selectedCell) + (left ? -1 : 1);
            try {
                if ((left && col >= 0 || !left && col < this.overlay.getCols()) && this.overlay.getTaxon(row, col) != null) {
                    this.selectedCell = col + row * this.overlay.getCols();
                    this.repaint();
                }
                Taxon taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell));
                this.notifyTaxonSelectionListeners(taxon);
            }
            catch (SQLException ex) {
                Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void close() {
        this.overlay.deleteObservers();
        if (this.smpdtl != null) {
            this.smpdtl.deleteObserver(this);
        }
    }

    public boolean isCountMode() {
        return this.countMode;
    }

    public void setSmpdtl(Well w, Smpdtl d) {
        if (w != this.well) {
            this.well = w;
        }
        if (d != this.smpdtl) {
            if (this.smpdtl != null) {
                this.smpdtl.deleteObserver(this);
            }
            this.smpdtl = d;
            if (this.smpdtl != null) {
                this.smpdtl.addObserver(this);
            }
        }
        this.repaint();
    }

    @Override
    public void update(Observable obs, Object obj) {
        this.repaint();
    }

    public boolean setCellMoveDropRange(Point lastPoint, Point dropPoint) throws SQLException {
        Point dropCell = this.getCell(dropPoint);
        if (this.selectionManager.getDragEndCell() == null || !this.selectionManager.getDragEndCell().equals(dropCell)) {
            this.selectionManager.setDragEndCell(dropCell);
            this.repaint();
        }
        return this.willMoveDropFit();
    }

    private Rectangle getSelectionOutlineRectangle() {
        int minCol = this.overlay.getCols();
        int maxCol = -1;
        int minRow = this.overlay.getRows();
        int maxRow = -1;
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (!this.overlay.getSelection(row, col)) continue;
                if (col < minCol) {
                    minCol = col;
                }
                if (col > maxCol) {
                    maxCol = col;
                }
                if (row < minRow) {
                    minRow = row;
                }
                if (row <= maxRow) continue;
                maxRow = row;
            }
        }
        return new Rectangle(minCol, minRow, maxCol - minCol + 1, maxRow - minRow + 1);
    }

    private Rectangle getDragTargetRectangle() {
        if (!this.selectionManager.areDragCellsSet()) {
            return null;
        }
        Rectangle selection = this.getSelectionOutlineRectangle();
        Point dragStart = this.selectionManager.getDragStartCell();
        Point dragEnd = this.selectionManager.getDragEndCell();
        int startCol = dragEnd.x - (dragStart.x - selection.x);
        int startRow = dragEnd.y - (dragStart.y - selection.y);
        return new Rectangle(startCol, startRow, selection.width, selection.height);
    }

    private boolean willMoveDropFit() {
        if (!this.selectionManager.areDragCellsSet()) {
            return false;
        }
        Rectangle targetArea = this.getDragTargetRectangle();
        if (targetArea == null) {
            return false;
        }
        if (targetArea.x < 0 || targetArea.x + targetArea.width > this.overlay.getCols() || targetArea.y < 0 || targetArea.y + targetArea.height > this.overlay.getRows()) {
            return false;
        }
        for (int x = targetArea.x; x < targetArea.x + targetArea.width; ++x) {
            for (int y = targetArea.y; y < targetArea.y + targetArea.height; ++y) {
                if (!this.hasData(y, x) || this.overlay.getSelection(y, x)) continue;
                return false;
            }
        }
        return true;
    }

    public void moveSelectedTaxa(Point start) throws SQLException, SBException {
        int col;
        int row;
        if (!this.willMoveDropFit() || !this.selectionManager.areDragCellsSet()) {
            return;
        }
        Rectangle selection = this.getSelectionOutlineRectangle();
        Point dragStart = this.selectionManager.getDragStartCell();
        Point dragEnd = this.selectionManager.getDragEndCell();
        int rowOffset = dragEnd.y - dragStart.y;
        int columnOffset = dragEnd.x - dragStart.x;
        int[][] map = new int[this.overlay.getRows()][this.overlay.getCols()];
        for (row = selection.y; row < selection.y + selection.height; ++row) {
            for (col = selection.x; col < selection.x + selection.width; ++col) {
                int speciesId = this.overlay.getSpecID(row, col);
                if (speciesId <= 0 || !this.overlay.getSelection(row, col)) continue;
                this.overlay.setCell(0, row, col);
                map[row + rowOffset][col + columnOffset] = speciesId;
            }
        }
        for (row = selection.y + rowOffset; row < selection.y + selection.height + rowOffset; ++row) {
            for (col = selection.x + columnOffset; col < selection.x + selection.width + columnOffset; ++col) {
                if (map[row][col] <= 0 || !this.overlay.getSelection(row - rowOffset, col - columnOffset)) continue;
                this.overlay.setCell(map[row][col], row, col);
            }
        }
        this.setCursor(new Cursor(0));
    }

    public void setCellDropRange(Point lastPoint, Point dropPoint, int nItems) throws SQLException {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (lastPoint != null) {
            g.setColor(Color.white);
            this.paintCellDropRange(g, this.getCell(lastPoint), nItems);
        }
        g.setColor(Color.gray);
        this.paintCellDropRange(g, this.getCell(dropPoint), nItems);
        g.setColor(Color.BLACK);
    }

    private void paintCellDropRange(Graphics2D g, Point cell, int nItems) throws SQLException {
        block8: {
            int filled = 0;
            if (this.insertRow) {
                for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                    for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        Rectangle r = this.helper.getCell(row, col);
                        g.fillRect(r.x, r.y, r.width, r.height);
                        if (++filled < nItems) {
                            continue;
                        }
                        break block8;
                    }
                    cell.y = 0;
                }
            } else {
                for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                    for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        Rectangle r = this.helper.getCell(row, col);
                        g.fillRect(r.x, r.y, r.width, r.height);
                        if (++filled < nItems) {
                            continue;
                        }
                        break block8;
                    }
                    cell.x = 0;
                }
            }
        }
    }

    public void fillSpecies(Point start, Collection<Taxon> list) throws SQLException, SBException {
        block10: {
            ArrayList<Taxon> taxonList = new ArrayList<Taxon>(list);
            Collections.sort(taxonList);
            Iterator it = taxonList.iterator();
            Point cell = this.getCell(start);
            if (this.insertRow) {
                for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                    for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        while (it.hasNext()) {
                            int specID = ((Taxon)it.next()).getSpecID();
                            if (this.overlay.hasSpecID(specID)) continue;
                            this.overlay.setCell(specID, row, col);
                            break;
                        }
                        if (it.hasNext()) {
                            continue;
                        }
                        break block10;
                    }
                    cell.y = 0;
                }
            } else {
                for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                    for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        while (it.hasNext()) {
                            int specID = ((Taxon)it.next()).getSpecID();
                            if (this.overlay.hasSpecID(specID)) continue;
                            this.overlay.setCell(specID, row, col);
                            break;
                        }
                        if (it.hasNext()) {
                            continue;
                        }
                        break block10;
                    }
                    cell.x = 0;
                }
            }
        }
    }

    public void setCountMode() {
        this.countMode = true;
    }

    public void setDesignMode() {
        this.selectedCell = -1;
        this.countMode = false;
        this.repaint();
    }

    public void overlayEditCancel() {
        try {
            this.selectedCell = -1;
            this.overlay.clearSelection();
            this.overlay.reload();
            this.countMode = !this.countMode;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    public void overlayEditOk() {
        try {
            this.selectedCell = -1;
            this.overlay.clearSelection();
            try {
                this.overlay.storeMap();
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog(this, "Can't update overlay:\n" + pe.getMessage(), "Update Overlay", 2);
            }
            this.countMode = !this.countMode;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    public void autoArrange() {
        this.overlay.clearSelection();
        this.overlay.autoArrange(this.insertRow);
        this.repaint();
    }

    public void removeSelectedTaxon() {
        this.overlay.clearSelected();
        this.overlay.clearSelection();
        this.repaint();
    }

    public void setInsertRowMode() {
        this.insertRow = true;
    }

    public void setInsertColumnMode() {
        this.insertRow = false;
    }

    public void commit() throws SQLException {
        this.db.commit();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.overlay != null) {
            Cursor cursor = null;
            if (this.overlay.showImages()) {
                cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            this.drawOverlay((Graphics2D)g);
            if (this.overlay.showImages()) {
                this.setCursor(cursor);
            }
        }
    }

    protected boolean hasData(int row, int col) {
        if (this.cellDataList != null && !this.cellDataList.isEmpty()) {
            for (OverlayCellData d : this.cellDataList) {
                if (d.getRow() != row || d.getColumn() != col) continue;
                return true;
            }
        }
        return false;
    }

    private void drawOverlay(Graphics2D g) {
        Rectangle thisVisibleRect = this.getVisibleRect();
        int lineWidth = 2;
        Dimension visibleSize = new Dimension(thisVisibleRect.width, thisVisibleRect.height);
        this.helper = new GridLayoutHelper(visibleSize, this.overlay.getRows(), this.overlay.getCols(), lineWidth);
        this.setupTaxonColours();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawGridlines(g, lineWidth);
        this.cellDataList = this.buildCellDataList();
        this.drawDesignCellSelection(g);
        this.drawSelectedCell(g);
        this.artist.setupFontSize(g, this.cellDataList.toArray(new OverlayCellData[this.cellDataList.size()]), this.helper.getBaseCellSize(), this.overlay.useCodes(), this.overlay.getMaximiseText());
        for (OverlayCellData cellData : this.cellDataList) {
            Rectangle location = this.helper.getCell(cellData.getRow(), cellData.getColumn());
            try {
                Taxon taxon = this.overlay.getTaxon(cellData.getRow(), cellData.getColumn());
                if (cellData.getCount().length() > 0) {
                    int cellNo = this.getCellNumber(cellData.getRow(), cellData.getColumn());
                    boolean isSelected = false;
                    isSelected = this.countMode ? cellNo == this.selectedCell : this.overlay.getSelection(cellData.getRow(), cellData.getColumn());
                    if (!isSelected) {
                        g.setColor(this.isOccMkr(taxon) ? Color.PINK : this.loggedColour);
                        Rectangle cell = this.helper.getCell(cellData.getRow(), cellData.getColumn());
                        g.fillRect(cell.x, cell.y, cell.width, cell.height);
                    }
                }
                g.setColor(this.getTaxonColour(taxon));
                int boxBorderSize = 2;
                g.setStroke(new BasicStroke(boxBorderSize, 0, 0));
                Rectangle outline = this.helper.getCellOutline(cellData.getRow(), cellData.getColumn(), boxBorderSize);
                g.drawRect(outline.x, outline.y, outline.width, outline.height);
                this.artist.drawGridCell(g, location, cellData, this.overlay.showImages(), this.overlay.useCodes());
            }
            catch (Exception e) {
                Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, "Error drawing overlay cell.", e);
                this.drawStringTokenized(g, e.getMessage(), location.x, location.y, location.width, location.height);
            }
        }
        if (!this.countMode) {
            this.drawSelectionLasoo(g);
            this.drawDragMoveOutline(g);
        }
    }

    private void drawGridlines(Graphics2D g, int lineWidth) {
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(new BasicStroke(lineWidth, 0, 0));
        for (Line l : this.helper.getGridlines()) {
            g.drawLine(l.start.x, l.start.y, l.end.x, l.end.y);
        }
    }

    private List<OverlayCellData> buildCellDataList() {
        ArrayList<OverlayCellData> data = new ArrayList<OverlayCellData>();
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                try {
                    Taxon taxon = this.overlay.getTaxon(row, col);
                    if (taxon == null) continue;
                    OverlayCellData d = this.getTaxonData(row, col, taxon);
                    data.add(d);
                    continue;
                }
                catch (SQLException ex) {
                    Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, "Error occurred retriving overlay taxon.", ex);
                }
            }
        }
        return data;
    }

    private void drawSelectedCell(Graphics2D g) {
        if (this.selectedCell >= 0) {
            g.setColor(this.selectedColour);
            int row = this.getRow(this.selectedCell);
            int col = this.getCol(this.selectedCell);
            Rectangle cell = this.helper.getCell(row, col);
            g.fillRect(cell.x, cell.y, cell.width, cell.height);
        }
    }

    private void drawDesignCellSelection(Graphics2D g) {
        if (!this.countMode) {
            g.setColor(this.selectedColour);
            for (int row = 0; row < this.overlay.getRows(); ++row) {
                for (int col = 0; col < this.overlay.getCols(); ++col) {
                    if (!this.overlay.getSelection(row, col)) continue;
                    Rectangle cell = this.helper.getCell(row, col);
                    g.fillRect(cell.x, cell.y, cell.width, cell.height);
                }
            }
        }
    }

    private void drawDragMoveOutline(Graphics2D g) {
        if (this.selectionManager.areDragCellsSet()) {
            Point dragEnd = this.selectionManager.getDragEndCell();
            g.setStroke(this.dragTargetStroke);
            g.setColor(Color.BLACK);
            Rectangle r = this.helper.getCellOutline(dragEnd.y, dragEnd.x, 3);
            g.drawRect(r.x, r.y, r.width, r.height);
            if (this.willMoveDropFit()) {
                Rectangle targetArea = this.getDragTargetRectangle();
                g.setStroke(this.dragAreaStroke);
                g.setColor(this.dragAreaColour);
                r = this.helper.getSelectionBorder(targetArea, 3);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    private void drawSelectionLasoo(Graphics2D g) {
        if (this.selectionManager.getSelectionStartCell() == null || this.selectionManager.getSelectionEndCell() == null) {
            return;
        }
        Point start = this.selectionManager.getSelectionStartCell();
        Point end = this.selectionManager.getSelectionEndCell();
        int minX = Math.min(start.x, end.x);
        int maxX = Math.max(start.x, end.x);
        int minY = Math.min(start.y, end.y);
        int maxY = Math.max(start.y, end.y);
        Rectangle lasoo = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        g.setColor(Color.BLACK);
        g.setStroke(this.lasooStroke);
        Rectangle border = this.helper.getSelectionBorder(lasoo, 2);
        g.drawRect(border.x, border.y, border.width, border.height);
    }

    private OverlayCellData getTaxonData(int row, int col, Taxon taxon) {
        String taxonString = null;
        String genusString = null;
        if (taxonString == null || taxonString.length() == 0) {
            genusString = taxon.getGenus().toString(false);
            taxonString = taxon.toString(false, false);
            taxonString = taxonString.substring(genusString.length()).trim();
            String author = taxon.getAuthorString(false);
            if (author != null && author.length() > 0) {
                taxonString = taxonString.substring(0, taxonString.length() - author.length());
            }
        }
        ImageSet imageSet = null;
        if (this.overlay.showImages()) {
            try {
                int typeImageSetID = this.db.getTaxonImageService().getTypeImageSetID(taxon.getSpecID());
                if (typeImageSetID > 0) {
                    imageSet = new ImageSet(typeImageSetID);
                }
            }
            catch (RuntimeException ex) {
                Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, "Error retrieving taxon type image", ex);
            }
        }
        return new OverlayCellData(row, col, genusString, taxonString, taxon.getAlphaCode(), this.getOccurrenceString(taxon), imageSet);
    }

    private String getOccurrenceString(Taxon taxon) {
        Object occString = "";
        if (this.smpdtl != null) {
            boolean cv = false;
            for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
                if (occ.getTaxon() != taxon) continue;
                cv = occ.getCaved();
                if (occ.getTotalCount() > 0) {
                    occString = (String)occString + (((String)occString).length() > 0 ? "," : "") + occ.getTotalCount();
                    occString = (String)occString + (occ.getIdentType() == '?' ? "?" : "");
                    occString = (String)occString + (occ.getReworked() ? "Rw" : "");
                    continue;
                }
                occString = (String)occString + (((String)occString).length() > 0 ? "," : "") + occ.getSubAbund(true);
                occString = (String)occString + (occ.getIdentType() == '?' ? "?" : "");
                occString = (String)occString + (occ.getReworked() ? "Rw" : "");
            }
            if (cv) {
                occString = (String)occString + " Cv";
            }
        }
        return occString;
    }

    private boolean isOccMkr(Taxon taxon) {
        boolean mkr = false;
        for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
            if (occ.getTaxon() != taxon || !occ.isMarker()) continue;
            mkr = true;
            break;
        }
        return mkr;
    }

    private Color getTaxonColour(Taxon taxon) throws SQLException {
        if (this.nCategories >= 2) {
            Color c = this.db.getCategory(taxon.getCatMnem()).getColour();
            if (c == null) {
                return Color.WHITE;
            }
            return c;
        }
        return this.genColours.get(taxon.getGenID());
    }

    private void setupTaxonColours() {
        HashSet<String> cats = new HashSet<String>();
        this.genColours.clear();
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                try {
                    Taxon taxon = this.overlay.getTaxon(row, col);
                    if (taxon == null) continue;
                    cats.add(taxon.getCatMnem());
                    this.genColours.put(taxon.getGenID(), Color.WHITE);
                    continue;
                }
                catch (SQLException ex) {
                    Logger.getLogger(OverlayJPanel.class.getName()).log(Level.SEVERE, "Exception in setupTaxonColours()", ex);
                }
            }
        }
        this.nCategories = cats.size();
        if (this.nCategories < 2) {
            int nGenera = this.genColours.size();
            int colourInc = 0x1000000 / (nGenera + 4);
            Iterator<Integer> it = this.genColours.keySet().iterator();
            boolean i = false;
            Color c = null;
            while (it.hasNext()) {
                c = c == null ? Color.black : new Color(c.getRGB() + colourInc);
                this.genColours.put(it.next(), c);
            }
        }
    }

    private void drawStringTokenized(Graphics2D g, String string, int left, int top, int width, int height) {
        int fWidth = g.getFontMetrics().stringWidth(string);
        int fHeight = g.getFontMetrics().getHeight();
        if (fWidth < width) {
            left += width / 2 - fWidth / 2;
        } else {
            StringTokenizer tok = new StringTokenizer(string);
            if (tok.countTokens() > 1) {
                Font saveFont = g.getFont();
                if (height < fHeight * tok.countTokens()) {
                    g.setFont(new Font(saveFont.getFontName(), saveFont.getStyle(), (int)((float)height / (float)tok.countTokens())));
                }
                height = (int)((float)height / (float)tok.countTokens());
                while (tok.hasMoreTokens()) {
                    this.drawStringTokenized(g, tok.nextToken(), left, top - height / 6, width, height);
                    top += height * 5 / 6;
                }
                g.setFont(saveFont);
                return;
            }
            if (this.overlay.getMaximiseText()) {
                while (string.length() >= 2) {
                    string = string.substring(0, string.length() - 1);
                    fWidth = g.getFontMetrics().stringWidth(string);
                    if (fWidth > width) continue;
                    break;
                }
            } else {
                do {
                    Font saveFont = g.getFont();
                    g.setFont(new Font(saveFont.getFontName(), saveFont.getStyle(), saveFont.getSize() - 1));
                } while ((fWidth = g.getFontMetrics().stringWidth(string)) > width);
            }
        }
        g.drawString(string, left, top += height / 2 + fHeight / 2);
    }

    Point getCell(MouseEvent evt) {
        Rectangle grid = new Rectangle(this.getVisibleRect().x, this.getVisibleRect().y, this.getVisibleRect().width, this.getVisibleRect().height);
        int row = (int)((float)evt.getY() / (float)grid.height * (float)this.overlay.getRows());
        int col = (int)((float)evt.getX() / (float)grid.width * (float)this.overlay.getCols());
        return new Point(col, row);
    }

    protected int getCellNumber(MouseEvent evt) {
        Point cellPoint = this.getCell(evt);
        int cell = cellPoint.x + cellPoint.y * this.overlay.getCols();
        return cell;
    }

    Point getCell(Point location) {
        Rectangle grid = new Rectangle(this.getVisibleRect().x, this.getVisibleRect().y, this.getVisibleRect().width, this.getVisibleRect().height);
        int row = (int)((float)location.getY() / (float)grid.height * (float)this.overlay.getRows());
        int col = (int)((float)location.getX() / (float)grid.width * (float)this.overlay.getCols());
        return new Point(col, row);
    }

    private int getRow(int selectedCell) {
        return selectedCell / this.overlay.getCols();
    }

    private int getCol(int selectedCell) {
        return selectedCell - this.getRow(selectedCell) * this.overlay.getCols();
    }

    private int getCellNumber(int row, int col) {
        return col + row * this.overlay.getCols();
    }

    public void addTaxonSelectionListener(ITaxonSelectionChangedListener listener) {
        if (!this.taxonListeners.contains(listener)) {
            this.taxonListeners.add(listener);
        }
    }

    public void clearSelectionListeners() {
        this.taxonListeners.clear();
    }

    protected void notifyTaxonSelectionListeners(Taxon selectedTaxon) {
        for (ITaxonSelectionChangedListener listener : this.taxonListeners) {
            listener.selectedTaxonChanged(selectedTaxon);
        }
    }

    public void addTaxonDoubleClickListener(ITaxonDoubleClickListener listener) {
        if (!this.taxonClickListeners.contains(listener)) {
            this.taxonClickListeners.add(listener);
        }
    }

    public void clearClickListeners() {
        this.taxonListeners.clear();
    }

    protected void notifyTaxonClickListeners(Taxon selectedTaxon, boolean isLeftMouseButton) {
        for (ITaxonDoubleClickListener listener : this.taxonClickListeners) {
            listener.taxonDoubleClicked(selectedTaxon, isLeftMouseButton);
        }
    }
}

