/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import jsbugs.FrameJsbugs;
import jsbugs.imagegallery.DialogTaxonImages;
import jsbugs.overlay.OverlayJPanel;
import model3.Overlay;
import model3.SBdb;
import model3.Taxon;
import util.SBException;
import util.exception.StackError;

public class OverlayMouseSelectionManager
implements MouseListener,
MouseMotionListener {
    private final OverlayJPanel overlayPanel;
    private final SBdb db;
    private static final Logger log = Logger.getLogger(OverlayMouseSelectionManager.class.getName());
    private final Overlay overlay;
    public static final Map<Component, Integer> MULTI_CLICK_MAP = new HashMap<Component, Integer>();
    private final Timer timer = new Timer();
    Point[] cellClicked = new Point[2];
    private Point lastCellMoved = null;
    private boolean dragMode;
    private boolean appendSelection;
    private Point selectionStart;
    private Point selectionEnd;
    private Point dragStartCell;
    private Point dragEndCell;
    private boolean[][] selectionBeingAppended;

    public OverlayMouseSelectionManager(OverlayJPanel overlayPanel, Overlay overlay, SBdb db) {
        this.overlayPanel = overlayPanel;
        this.overlay = overlay;
        this.db = db;
    }

    public Point getSelectionStartCell() {
        return this.selectionStart;
    }

    public Point getSelectionEndCell() {
        return this.selectionEnd;
    }

    public Point getDragStartCell() {
        return this.dragStartCell;
    }

    public Point getDragEndCell() {
        return this.dragEndCell;
    }

    public void setDragEndCell(Point cell) {
        this.dragEndCell = cell;
    }

    public boolean areDragCellsSet() {
        return this.dragEndCell != null && this.dragStartCell != null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        try {
            this.onMouseClicked(evt);
        }
        catch (IOException | SQLException | SBException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error in mouse click", (Exception)ex, this.db);
            this.overlayPanel.repaint();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!this.overlayPanel.isCountMode()) {
            Point targetCell = this.overlayPanel.getCell(evt);
            this.dragMode = (evt.getModifiersEx() & 0x40) != 0;
            boolean bl = this.appendSelection = (evt.getModifiersEx() & 0x80) != 0;
            if (this.dragMode && this.overlayPanel.hasData(targetCell.y, targetCell.x) || this.overlay.getSelection(targetCell.y, targetCell.x) && !this.appendSelection) {
                if (this.dragMode && !this.overlay.getSelection(targetCell.y, targetCell.x)) {
                    this.overlay.setSelection(targetCell.y, targetCell.x, true);
                }
                this.dragMode = true;
                this.selectionStart = null;
                this.selectionEnd = null;
                this.dragStartCell = targetCell;
                this.overlayPanel.setCursor(DragSource.DefaultMoveDrop);
            } else {
                this.dragMode = false;
                this.selectionStart = targetCell;
                this.selectionEnd = targetCell;
                this.dragStartCell = null;
                this.dragEndCell = null;
                if (this.appendSelection) {
                    this.selectionBeingAppended = this.overlay.getSelectionArrayCopy();
                } else {
                    this.overlay.clearSelection();
                }
                if (this.overlayPanel.hasData(this.selectionStart.y, this.selectionStart.x)) {
                    boolean existingSelection = this.overlay.getSelection(this.selectionStart.y, this.selectionStart.x);
                    this.overlay.setSelection(this.selectionStart.y, this.selectionStart.x, !existingSelection);
                }
            }
        }
        this.overlayPanel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.dragStartCell != null && this.dragEndCell == null) {
            this.overlay.clearSelection();
        }
        this.selectionStart = null;
        this.selectionEnd = null;
        this.dragEndCell = null;
        this.dragStartCell = null;
        this.cellClicked[0] = this.cellClicked[1];
        this.cellClicked[1] = this.overlayPanel.getCell(evt);
        this.overlayPanel.setCursor(new Cursor(0));
        this.overlayPanel.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        try {
            if (!this.overlayPanel.isCountMode()) {
                Point currentCell = this.overlayPanel.getCell(evt);
                if (this.dragMode) {
                    JComponent c = (JComponent)evt.getSource();
                    TransferHandler handler = c.getTransferHandler();
                    handler.exportAsDrag(c, evt, 1);
                } else if (!currentCell.equals(this.selectionStart)) {
                    if (this.appendSelection) {
                        this.overlay.setSelectionArray(this.selectionBeingAppended);
                    } else {
                        this.overlay.clearSelection();
                    }
                    int minX = Math.min(currentCell.x, this.selectionStart.x);
                    int maxX = Math.max(currentCell.x, this.selectionStart.x);
                    int minY = Math.min(currentCell.y, this.selectionStart.y);
                    int maxY = Math.max(currentCell.y, this.selectionStart.y);
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = minY; y <= maxY; ++y) {
                            if (!this.overlayPanel.hasData(y, x)) continue;
                            this.overlay.setSelection(y, x, true);
                        }
                    }
                    this.selectionEnd = currentCell;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in mouseDragged: " + e.getMessage());
        }
        this.overlayPanel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        boolean isDrag;
        Point targetCell = this.overlayPanel.getCell(evt);
        boolean bl = isDrag = (evt.getModifiersEx() & 0x40) != 0;
        if (isDrag && this.overlayPanel.hasData(targetCell.y, targetCell.x) || this.overlay.getSelection(targetCell.y, targetCell.x)) {
            this.overlayPanel.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.overlayPanel.setCursor(new Cursor(0));
        }
        if (!targetCell.equals(this.lastCellMoved)) {
            try {
                if (this.overlay.getSpecID(targetCell.y, targetCell.x) > 0) {
                    Taxon taxon = this.overlay.getTaxon(targetCell.y, targetCell.x);
                    this.overlayPanel.setToolTipText(taxon.toString(false, false));
                } else {
                    this.overlayPanel.setToolTipText(null);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in mouseMoved: " + e.getMessage());
            }
        }
        this.lastCellMoved = targetCell;
    }

    boolean onMouseClicked(MouseEvent evt) throws SBException, SQLException, IOException {
        boolean isDoubleClick = false;
        if (evt.getClickCount() > 1 && this.cellClicked[0].equals(this.cellClicked[1])) {
            isDoubleClick = true;
        } else {
            Component comp = evt.getComponent();
            if (!MULTI_CLICK_MAP.containsKey(comp)) {
                MULTI_CLICK_MAP.put(comp, 1);
            } else {
                int oldCounter = MULTI_CLICK_MAP.get(comp);
                MULTI_CLICK_MAP.put(comp, oldCounter + 1);
            }
            if (MULTI_CLICK_MAP.get(comp) == 2 && this.cellClicked[0].equals(this.cellClicked[1])) {
                MULTI_CLICK_MAP.remove(comp);
                isDoubleClick = true;
            } else {
                this.timer.schedule((TimerTask)new ClickResetter(comp), 800L);
            }
        }
        int clickedCell = this.overlayPanel.getCellNumber(evt);
        Point targetCell = this.overlayPanel.getCell(evt);
        Taxon taxon = this.overlay.getTaxon(targetCell.y, targetCell.x);
        this.overlayPanel.notifyTaxonSelectionListeners(taxon);
        if (this.overlayPanel.isCountMode()) {
            this.overlay.clearSelection();
            this.overlayPanel.selectedCell = taxon == null ? -1 : clickedCell;
            if (taxon != null && isDoubleClick) {
                this.overlayPanel.notifyTaxonClickListeners(taxon, evt.getButton() == 1);
            }
            this.overlayPanel.repaint();
            return true;
        }
        if (taxon != null && isDoubleClick) {
            this.overlayPanel.setCursor(Cursor.getPredefinedCursor(3));
            DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxon(null, taxon, this.db);
            dialog.setAlwaysOnTop(true);
            Point p = evt.getLocationOnScreen();
            Rectangle bounds = this.overlayPanel.getGraphicsConfiguration().getBounds();
            dialog.setLocation(Math.max(p.x - dialog.getWidth() / 2, bounds.x), Math.max(p.y - dialog.getHeight() / 2, bounds.y));
            this.overlayPanel.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            this.overlayPanel.repaint();
        }
        return true;
    }

    private static class ClickResetter
    extends TimerTask {
        private final Component component;

        public ClickResetter(Component component) {
            this.component = component;
        }

        @Override
        public void run() {
            MULTI_CLICK_MAP.remove(this.component);
        }
    }
}

