/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.refresh;

import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import jsbugs.refresh.RefreshHelper;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import util.SBException;

class DataRefreshTask
extends SwingWorker {
    private static final Logger LOGGER = Logger.getLogger(DataRefreshTask.class.getName());
    private final JLabel jLabelRefresh;
    private final JButton jButtonRefresh;
    private Date time;
    private Exception ex;

    DataRefreshTask(JLabel jLabelRefresh, JButton jButtonRefresh) {
        this.jLabelRefresh = jLabelRefresh;
        this.jButtonRefresh = jButtonRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doInBackground() {
        try {
            Object object = RefreshHelper.REFRESH_LOCK;
            synchronized (object) {
                this.time = new Date();
                LOGGER.info("Refreshing data...");
                SbugsSession.getDb().refresh();
                LOGGER.info("Refreshing charts...");
                SbugsSession.getSession().getChartManager().refresh();
                LOGGER.info("... Refresh complete.");
            }
        }
        catch (IOException | RuntimeException | SQLException | SBException x) {
            this.ex = x;
            x.printStackTrace();
        }
        return null;
    }

    @Override
    protected void done() {
        if (this.ex != null) {
            SbugsExceptionHandler.showStackError("Error during data refresh", this.ex);
            if (!(this.ex instanceof SQLTransientConnectionException)) {
                RefreshHelper.stopRefresh();
                this.jLabelRefresh.setText("Data refresh error");
            } else {
                this.jLabelRefresh.setText("Data refresh timeout");
            }
        } else {
            Date time2 = new Date();
            int secs = (int)((time2.getTime() - this.time.getTime()) / 1000L);
            String msg = "Updated: " + new SimpleDateFormat("HH:mm:ss").format(this.time);
            if (secs > 0) {
                msg = msg + " (" + secs + "s)";
            }
            this.jLabelRefresh.setText(msg);
            if (this.jButtonRefresh != null) {
                this.jButtonRefresh.setBackground(new Color(153, 255, 153));
            }
        }
    }
}

