/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsbugs.DialogSelectSample;
import jsbugs.sampleage.SampleAgeTextFieldBuilder;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import util.AgeFormat;
import util.AgeUtils;
import util.NumberUtils;
import util.SBException;

public class DialogSampleAgeAdd
extends SBDialog {
    private static final Logger LOGGER = Logger.getLogger(DialogSampleAgeAdd.class.getName());
    private final SBdb db;
    private final Well well;
    private final char units;
    private Sample sample = null;
    private Double age = null;
    private Float errorPlus = null;
    private Float errorMinus = null;
    private Double ratio = null;
    private final int interpId;
    private final AgeFormat ageUnits;
    private Color originalAgeBorderColor = null;
    private Color originalSampleBorderColor = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonSelectSample;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelAgeUnits;
    private JLabel jLabelErrorMinusUnits;
    private JLabel jLabelErrorPlusUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAge;
    private JTextField jTextFieldErrorMinus;
    private JTextField jTextFieldErrorPlus;
    private JTextField jTextFieldIsotopeRatio;
    private JTextField jTextFieldSample;

    public DialogSampleAgeAdd(Frame parent, boolean modal, SBdb db, Well well, char units, int interpId, AgeFormat ageUnits) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.well = well;
        this.units = units;
        this.ageUnits = ageUnits;
        this.interpId = interpId;
        this.init();
    }

    private void init() {
        LineBorder lineBorder;
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAge(this.jTextFieldAge, this.ageUnits);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAgeError(this.jTextFieldErrorPlus, this.ageUnits);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAgeError(this.jTextFieldErrorMinus, this.ageUnits);
        this.jLabelAgeUnits.setText(this.ageUnits.getDescr());
        this.jLabelErrorMinusUnits.setText(this.ageUnits.getDescr());
        this.jLabelErrorPlusUnits.setText(this.ageUnits.getDescr());
        Border border = this.jTextFieldAge.getBorder();
        if (border instanceof LineBorder) {
            lineBorder = (LineBorder)border;
            this.originalAgeBorderColor = lineBorder.getLineColor();
        } else {
            this.originalAgeBorderColor = Color.LIGHT_GRAY;
        }
        border = this.jTextFieldSample.getBorder();
        if (border instanceof LineBorder) {
            lineBorder = (LineBorder)border;
            this.originalSampleBorderColor = lineBorder.getLineColor();
        } else {
            this.originalSampleBorderColor = Color.LIGHT_GRAY;
        }
        this.jTextFieldAge.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.ageValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.ageValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.ageValueChanged();
            }
        });
        this.jTextFieldErrorPlus.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.errorPlusChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.errorPlusChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.errorPlusChanged();
            }
        });
        this.jTextFieldErrorMinus.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.errorMinusChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.errorMinusChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.errorMinusChanged();
            }
        });
        this.jTextFieldIsotopeRatio.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.ratioChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.ratioChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.ratioChanged();
            }
        });
    }

    private void ageValueChanged() {
        Double ageInUnits = NumberUtils.tryParseDouble((String)this.jTextFieldAge.getText());
        this.age = AgeUtils.convertToMa((Double)ageInUnits, (AgeFormat)this.ageUnits);
        this.updateAddButtonEnabled();
    }

    private void errorPlusChanged() {
        Float errorInUnits = NumberUtils.tryParseFloat((String)this.jTextFieldErrorPlus.getText());
        this.errorPlus = AgeUtils.convertToMa((Float)errorInUnits, (AgeFormat)this.ageUnits);
        this.updateAddButtonEnabled();
    }

    private void errorMinusChanged() {
        Float errorInUnits = NumberUtils.tryParseFloat((String)this.jTextFieldErrorMinus.getText());
        this.errorMinus = AgeUtils.convertToMa((Float)errorInUnits, (AgeFormat)this.ageUnits);
        this.updateAddButtonEnabled();
    }

    private void ratioChanged() {
        this.ratio = NumberUtils.tryParseDouble((String)this.jTextFieldIsotopeRatio.getText());
        this.updateAddButtonEnabled();
    }

    private void updateAddButtonEnabled() {
        if (this.getSample() != null && this.getAge() != null) {
            this.jButtonAdd.setEnabled(true);
        } else {
            this.jButtonAdd.setEnabled(false);
        }
        if (this.getAge() == null) {
            this.jTextFieldAge.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            this.jTextFieldAge.setBorder(BorderFactory.createLineBorder(this.originalAgeBorderColor));
        }
        if (this.getSample() == null) {
            this.jTextFieldSample.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            this.jTextFieldSample.setBorder(BorderFactory.createLineBorder(this.originalSampleBorderColor));
        }
    }

    private List<Sample> getSamplesWithAge() {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        try {
            for (Sample s : this.well.getSamples()) {
                if (!s.hasAgeData(this.interpId)) continue;
                samples.add(s);
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return samples;
    }

    private void initComponents() {
        this.jTextFieldSample = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonAdd = new JButton();
        this.jTextFieldAge = SampleAgeTextFieldBuilder.BuildSampleAgeTextField();
        this.jTextFieldErrorPlus = SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField();
        this.jTextFieldErrorMinus = SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField();
        this.jTextFieldIsotopeRatio = SampleAgeTextFieldBuilder.BuildIsotopeRatioTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jButtonSelectSample = new JButton();
        this.jLabelAgeUnits = new JLabel();
        this.jLabelErrorPlusUnits = new JLabel();
        this.jLabelErrorMinusUnits = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sample Age : Add");
        this.setResizable(false);
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldSample.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldSample.setEnabled(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setEnabled(false);
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Sample:");
        this.jLabel2.setText("Age:");
        this.jLabel3.setText("Error plus:");
        this.jLabel4.setText("Error minus:");
        this.jLabel5.setText("Isotope ratio:");
        this.jButtonSelectSample.setText("...");
        this.jButtonSelectSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeAdd this$0;
            {
                DialogSampleAgeAdd dialogSampleAgeAdd = this$0;
                Objects.requireNonNull(dialogSampleAgeAdd);
                this.this$0 = dialogSampleAgeAdd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSampleActionPerformed(evt);
            }
        });
        this.jLabelAgeUnits.setText("Ma");
        this.jLabelErrorPlusUnits.setText("Ma");
        this.jLabelErrorMinusUnits.setText("Ma");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSample)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldIsotopeRatio, -2, 105, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAge, -2, 104, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldErrorPlus).addComponent(this.jTextFieldErrorMinus, -1, 104, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAgeUnits, -2, 28, -2).addComponent(this.jLabelErrorMinusUnits, -2, 28, -2).addComponent(this.jLabelErrorPlusUnits, -2, 28, -2).addComponent(this.jButtonSelectSample, -2, 28, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSample, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jButtonSelectSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAge, -2, -1, -2).addComponent(this.jLabelAgeUnits).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldErrorPlus, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabelErrorPlusUnits)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldErrorMinus, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabelErrorMinusUnits)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldIsotopeRatio, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonAdd)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonSelectSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, null, this.units, false);
            dialog.hideSamples(this.getSamplesWithAge());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.pack();
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.sample = dialog.getSelection();
                this.jTextFieldSample.setText(this.getSample().toString(this.units).trim());
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, (Component)((Object)this));
        }
        this.updateAddButtonEnabled();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.setIsOK(true);
        this.setVisible(false);
    }

    public Sample getSample() {
        return this.sample;
    }

    public Double getAge() {
        return this.age;
    }

    public Float getErrorPlus() {
        return this.errorPlus;
    }

    public Float getErrorMinus() {
        return this.errorMinus;
    }

    public Double getRatio() {
        return this.ratio;
    }
}

