/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import jsbugs.FrameJsbugs;
import jsbugs.sampleage.SampleAgeTextFieldBuilder;
import jsbugs.uiutil.DocumentChangeListener;
import jsbugs.uiutil.TextFieldUtils;
import model3.Sample;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.AgeFormat;
import util.AgeUtils;
import util.NumberUtils;

public class DialogSampleAgeEdit
extends SBDialog {
    Sample sample;
    int interpID;
    Well well;
    private Double age;
    private Double ageBelow;
    private Double ratio;
    private Float errorMinus;
    private Float errorPlus;
    private final AgeFormat ageUnits;
    private DecimalFormat df = new DecimalFormat("0");
    private Color originalAgeBorderColor;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelAgeBelowUnits;
    private JLabel jLabelAgeUnits;
    private JLabel jLabelErrorMinusUnits;
    private JLabel jLabelErrorPlusUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAge;
    private JTextField jTextFieldAgeBelow;
    private JTextField jTextFieldErrorMinus;
    private JTextField jTextFieldErrorPlus;
    private JTextField jTextFieldRatio;

    public DialogSampleAgeEdit(Frame parent, boolean modal, Well well, Sample sample, int interpID, AgeFormat ageUnits) {
        super(parent, modal);
        this.df.setMaximumFractionDigits(340);
        this.sample = sample;
        this.interpID = interpID;
        this.well = well;
        this.ageUnits = ageUnits;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Sample Age : " + String.valueOf(this.sample));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.originalAgeBorderColor = this.jTextFieldAge.getBorder() instanceof LineBorder ? ((LineBorder)this.jTextFieldAge.getBorder()).getLineColor() : Color.LIGHT_GRAY;
        this.jLabelAgeUnits.setText(this.ageUnits.getDescr());
        this.jLabelAgeBelowUnits.setText(this.ageUnits.getDescr());
        this.jLabelErrorPlusUnits.setText(this.ageUnits.getDescr());
        this.jLabelErrorMinusUnits.setText(this.ageUnits.getDescr());
        this.age = this.sample.getAge(this.interpID);
        this.ageBelow = this.sample.getAgeBelow(this.interpID);
        this.ratio = this.sample.getRatio(this.interpID);
        this.errorPlus = this.sample.getAgeErrorPlus(this.interpID);
        this.errorMinus = this.sample.getAgeErrorMinus(this.interpID);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAge(this.jTextFieldAge, this.ageUnits);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAge(this.jTextFieldAgeBelow, this.ageUnits);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAgeError(this.jTextFieldErrorMinus, this.ageUnits);
        SampleAgeTextFieldBuilder.UpdateTextFieldDocumentForSampleAgeError(this.jTextFieldErrorPlus, this.ageUnits);
        Double ageInUnits = AgeUtils.convertFromMa((Double)this.getAge(), (AgeFormat)this.ageUnits);
        TextFieldUtils.trySetText(this.jTextFieldAge, ageInUnits);
        Double ageBelowInUnits = AgeUtils.convertFromMa((Double)this.getAgeBelow(), (AgeFormat)this.ageUnits);
        TextFieldUtils.trySetText(this.jTextFieldAgeBelow, ageBelowInUnits);
        TextFieldUtils.trySetText(this.jTextFieldRatio, this.getRatio(), this.df);
        Float erroPlusInUnits = AgeUtils.convertFromMa((Float)this.getErrorPlus(), (AgeFormat)this.ageUnits);
        TextFieldUtils.trySetText(this.jTextFieldErrorPlus, erroPlusInUnits);
        Float errorMinusInUnits = AgeUtils.convertFromMa((Float)this.getErrorMinus(), (AgeFormat)this.ageUnits);
        TextFieldUtils.trySetText(this.jTextFieldErrorMinus, errorMinusInUnits);
        this.jTextFieldAge.getDocument().addDocumentListener(new DocumentChangeListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void onDocumentChange(DocumentEvent e) {
                this.this$0.ageValueChanged();
            }
        });
        this.jTextFieldAgeBelow.getDocument().addDocumentListener(new DocumentChangeListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void onDocumentChange(DocumentEvent e) {
                this.this$0.ageBelowValueChanged();
            }
        });
        this.jTextFieldRatio.getDocument().addDocumentListener(new DocumentChangeListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void onDocumentChange(DocumentEvent e) {
                this.this$0.ratioValueChanged();
            }
        });
        this.jTextFieldErrorMinus.getDocument().addDocumentListener(new DocumentChangeListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void onDocumentChange(DocumentEvent e) {
                this.this$0.errorMinusValueChanged();
            }
        });
        this.jTextFieldErrorPlus.getDocument().addDocumentListener(new DocumentChangeListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void onDocumentChange(DocumentEvent e) {
                this.this$0.errorPlusValueChanged();
            }
        });
    }

    private void ageValueChanged() {
        this.age = AgeUtils.convertToMa((Double)NumberUtils.tryParseDouble((String)this.jTextFieldAge.getText()), (AgeFormat)this.ageUnits);
        this.updateOKButtonEnabled();
    }

    private void ageBelowValueChanged() {
        this.ageBelow = AgeUtils.convertToMa((Double)NumberUtils.tryParseDouble((String)this.jTextFieldAgeBelow.getText()), (AgeFormat)this.ageUnits);
        this.updateOKButtonEnabled();
    }

    private void ratioValueChanged() {
        this.ratio = NumberUtils.tryParseDouble((String)this.jTextFieldRatio.getText());
        this.updateOKButtonEnabled();
    }

    private void errorPlusValueChanged() {
        this.errorPlus = AgeUtils.convertToMa((Float)NumberUtils.tryParseFloat((String)this.jTextFieldErrorPlus.getText()), (AgeFormat)this.ageUnits);
        this.updateOKButtonEnabled();
    }

    private void errorMinusValueChanged() {
        this.errorMinus = AgeUtils.convertToMa((Float)NumberUtils.tryParseFloat((String)this.jTextFieldErrorMinus.getText()), (AgeFormat)this.ageUnits);
        this.updateOKButtonEnabled();
    }

    private void updateOKButtonEnabled() {
        this.jButtonOK.setEnabled(this.getAge() != null);
        if (this.getAge() == null) {
            this.jTextFieldAge.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            this.jTextFieldAge.setBorder(BorderFactory.createLineBorder(this.originalAgeBorderColor));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldAge = SampleAgeTextFieldBuilder.BuildSampleAgeTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldAgeBelow = SampleAgeTextFieldBuilder.BuildSampleAgeTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldRatio = SampleAgeTextFieldBuilder.BuildIsotopeRatioTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldErrorPlus = SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField();
        this.jTextFieldErrorMinus = SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField();
        this.jLabelAgeBelowUnits = new JLabel();
        this.jLabelAgeUnits = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelErrorPlusUnits = new JLabel();
        this.jLabelErrorMinusUnits = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Age:");
        this.jLabel2.setText("Age below:");
        this.jLabel3.setForeground(new Color(102, 102, 102));
        this.jLabel3.setText("<html>Warning: 'Age below' is a redundant field from v2.0 onward. Use the depth/age curve to create unconformities.</html>");
        this.jLabel4.setText("Isotope ratio:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setEnabled(false);
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeEdit this$0;
            {
                DialogSampleAgeEdit dialogSampleAgeEdit = this$0;
                Objects.requireNonNull(dialogSampleAgeEdit);
                this.this$0 = dialogSampleAgeEdit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Error plus:");
        this.jLabel6.setText("Error minus:");
        this.jLabelAgeBelowUnits.setText("Ma");
        this.jLabelAgeUnits.setText("Ma");
        this.jLabelErrorPlusUnits.setText("Ma");
        this.jLabelErrorMinusUnits.setText("Ma");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).add(0, 0, Short.MAX_VALUE)).add((Component)this.jLabel3, -2, 0, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(3, 3, 3).add((Component)this.jLabel4)).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel1)).add(2, (Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldAge).add((Component)this.jTextFieldAgeBelow)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabelAgeBelowUnits).add(2, (Component)this.jLabelAgeUnits))).add((Component)this.jTextFieldRatio).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldErrorMinus).add((Component)this.jTextFieldErrorPlus)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelErrorPlusUnits).add((Component)this.jLabelErrorMinusUnits)))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldAge, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jLabelAgeUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldAgeBelow, -2, -1, -2).add((Component)this.jLabelAgeBelowUnits)).addPreferredGap(0).add((Component)this.jLabel3, -2, 56, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldErrorPlus, -2, -1, -2).add((Component)this.jLabelErrorPlusUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldErrorMinus, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.jLabelErrorMinusUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldRatio, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(16, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsampleage.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
        this.setVisible(false);
    }

    public Double getAge() {
        return this.age;
    }

    public Double getAgeBelow() {
        return this.ageBelow;
    }

    public Double getRatio() {
        return this.ratio;
    }

    public Float getErrorMinus() {
        return this.errorMinus;
    }

    public Float getErrorPlus() {
        return this.errorPlus;
    }
}

