/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.io.DialogCSVExporOptions;
import jsbugs.sampleage.DialogSampleAgeAdd;
import jsbugs.sampleage.DialogSampleAgeEdit;
import jsbugs.sampleage.DialogSampleAgeImport;
import jsbugs.sampleage.ISampleAgeUpdater;
import jsbugs.sampleage.SampleAgeCreationRecord;
import jsbugs.sampleage.SampleAgeTableModel;
import jsbugs.sampleage.SampleAgeUpdateRecord;
import jsbugs.sampleage.SampleCreationRequest;
import jsbugs.sampleage.TextExporterSampleAge;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import model3.Sample;
import model3.SampleInsertException;
import model3.Well;
import util.AgeFormat;
import util.DepthUnits;
import util.FilePathUtils;
import util.SBPermissionException;
import util.exception.StackError;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.GridWriter;

public class PanelInterpSampleAge
extends JPanel
implements ISampleAgeUpdater {
    private SampleAgeTableModel tableModel;
    private char units = (char)77;
    private Well well;
    private Integer interpId;
    private boolean canWrite = false;
    private AgeFormat ageUnits = AgeFormat.MA;
    public static final String LAST_WINDOWS_SAMPLE_AGE_EXPORT_KEY = "WINSAGEEXP";
    public static final String LAST_UNIX_SAMPLE_AGE_EXPORT_KEY = "UNXSAGEEXP";
    private ButtonGroup buttonGroupAgeUnits;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private JButton jButtonSampleAdd;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonKaUnits;
    private JRadioButton jRadioButtonMaUnits;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTable1;

    public PanelInterpSampleAge() {
        this.initComponents();
    }

    public void setup(Well well, char units) {
        this.units = units;
        this.well = well;
        try {
            this.canWrite = well.canWrite(SbugsSession.getDb(), null);
        }
        catch (SQLException ex) {
            Logger.getLogger(PanelInterpSampleAge.class.getName()).log(Level.SEVERE, null, ex);
            FrameJsbugs.showStackError("SQL Error", ex, well.getDataModel());
        }
        this.setupTable();
        this.jButtonEdit.setEnabled(this.canWrite);
        this.jButtonSampleAdd.setEnabled(this.canWrite);
        this.jButtonDelete.setEnabled(this.canWrite);
        this.jButtonImport.setEnabled(this.canWrite);
        this.tableModel.setEditable(this.canWrite);
        if ((SbugsSession.getDb().getUser().getPriv() & 0x4000) > 0) {
            this.jButtonExport.setEnabled(false);
        }
    }

    private void setupTable() {
        this.tableModel = new SampleAgeTableModel(this);
        this.tableModel.setUnits(this.units);
        this.jTable1.setModel(this.tableModel);
        this.tableModel.setupTable(this.jTable1, SbugsSession.getDb());
        this.jTable1.setRowSorter(new TableRowSorter<SampleAgeTableModel>(this.tableModel));
        new ColumnSortResetHandler(this.jTable1).attach();
    }

    public void setInterpretationId(int interpId) {
        this.interpId = interpId;
        this.updateTable();
    }

    private void updateTable() {
        List<Sample> samplesWithAgeData = this.filterSamples(this.getWellSamples(), this.interpId);
        this.tableModel.setSamples(samplesWithAgeData, this.interpId);
        this.tableModel.fireTableDataChanged();
    }

    public void setUnits(char units) {
        this.units = units;
        this.tableModel.setUnits(units);
        TableUtils.updateTableColumnNames((JTable)this.jTable1);
        this.tableModel.fireTableDataChanged();
    }

    private Sample getSelectedSample() {
        if (this.jTable1.getSelectedRow() >= 0) {
            int row = this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow());
            return this.tableModel.getSampleByRowNum(row);
        }
        return null;
    }

    private void setSelectedSample(int sampleId) {
        for (int modelRow = 0; modelRow < this.tableModel.getRowCount(); ++modelRow) {
            if (this.tableModel.getSampleByRowNum(modelRow).getSampID() != sampleId) continue;
            int viewRow = this.jTable1.convertRowIndexToView(modelRow);
            this.jTable1.setRowSelectionInterval(viewRow, viewRow);
            break;
        }
    }

    private CSVExportOptions showCSVOptionsDialog() {
        DialogCSVExporOptions dlg = new DialogCSVExporOptions((JFrame)this.getRootPane().getParent(), true);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        if (!dlg.isOK()) {
            return null;
        }
        CSVExportOptions options = dlg.getExportOptions();
        dlg.dispose();
        return options;
    }

    private void initComponents() {
        this.buttonGroupAgeUnits = new ButtonGroup();
        this.jButtonSampleAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMaUnits = new JRadioButton();
        this.jRadioButtonKaUnits = new JRadioButton();
        this.jButtonSampleAdd.setText("Add ...");
        this.jButtonSampleAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit ...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonImport.setText("Read ...");
        this.jButtonImport.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImportActionPerformed(evt);
            }
        });
        this.jButtonExport.setText("Save as ...");
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTable1.setRowHeight(20);
        this.jTable1.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTable1MouseClicked(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupAgeUnits.add(this.jRadioButtonMaUnits);
        this.jRadioButtonMaUnits.setSelected(true);
        this.jRadioButtonMaUnits.setText("Ma");
        this.jRadioButtonMaUnits.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMaUnitsActionPerformed(evt);
            }
        });
        this.buttonGroupAgeUnits.add(this.jRadioButtonKaUnits);
        this.jRadioButtonKaUnits.setText("Ka");
        this.jRadioButtonKaUnits.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelInterpSampleAge this$0;
            {
                PanelInterpSampleAge panelInterpSampleAge = this$0;
                Objects.requireNonNull(panelInterpSampleAge);
                this.this$0 = panelInterpSampleAge;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonKaUnitsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMaUnits).addComponent(this.jRadioButtonKaUnits)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonMaUnits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonKaUnits).addContainerGap(18, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonSampleAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonImport, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExport, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 496, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 329, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSampleAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addGap(1, 1, 1).addComponent(this.jButtonImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExport).addGap(34, 34, 34).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        if (this.interpId == null) {
            return;
        }
        DialogSampleAgeImport dlg = new DialogSampleAgeImport((JFrame)this.getRootPane().getParent(), true, this.getWellSamples(), this.units, this.ageUnits, SbugsSession.getDb());
        dlg.setLocationRelativeTo(this);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.isOK() && dlg.getUpdateRecords() != null) {
            for (SampleAgeCreationRecord sampleAgeCreationRecord : dlg.getCreationRecords()) {
                try {
                    Sample sample = this.createSampleInWell(sampleAgeCreationRecord.getSampleToCreate());
                    this.updateSampleAgeInWell(sample, sampleAgeCreationRecord.getAge(), null, sampleAgeCreationRecord.getPositiveError(), sampleAgeCreationRecord.getNegativeError(), sampleAgeCreationRecord.getIsotopeRatio());
                }
                catch (SQLException | SampleInsertException | SBPermissionException ex) {
                    FrameJsbugs.showStackError("Error inserting a new sample for the imported sample age.", (Exception)ex, SbugsSession.getDb());
                }
            }
            for (SampleAgeUpdateRecord sampleAgeUpdateRecord : dlg.getUpdateRecords()) {
                this.updateSampleAgeInWell(sampleAgeUpdateRecord.getSapmleToUpdate(), sampleAgeUpdateRecord.getAge(), null, sampleAgeUpdateRecord.getPositiveError(), sampleAgeUpdateRecord.getNegativeError(), sampleAgeUpdateRecord.getIsotopeRatio());
            }
            this.updateTable();
        }
        dlg.dispose();
    }

    private void jButtonSampleAddActionPerformed(ActionEvent evt) {
        if (this.interpId == null) {
            JOptionPane.showMessageDialog(this.getParent(), "No version selected");
            return;
        }
        DialogSampleAgeAdd dlg = new DialogSampleAgeAdd((JFrame)this.getRootPane().getParent(), true, SbugsSession.getDb(), this.well, this.units, this.interpId, this.ageUnits);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        if (dlg.isOK()) {
            this.updateSampleAgeInWell(dlg.getSample(), dlg.getAge(), null, dlg.getErrorPlus(), dlg.getErrorMinus(), dlg.getRatio());
            this.updateTable();
            this.setSelectedSample(dlg.getSample().getSampID());
        }
        dlg.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        this.showEditSampleAgeDialog();
    }

    public void showEditSampleAgeDialog() throws HeadlessException {
        if (this.interpId != null) {
            Sample selectedSample = this.getSelectedSample();
            if (selectedSample == null) {
                JOptionPane.showMessageDialog(this, "No sample selected.", "Edit Sample Ages", 1);
                return;
            }
            DialogSampleAgeEdit dlg = new DialogSampleAgeEdit((JFrame)this.getRootPane().getParent(), true, this.well, selectedSample, this.interpId, this.ageUnits);
            dlg.pack();
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            if (dlg.isOK()) {
                this.updateSampleAgeInWell(selectedSample, dlg.getAge(), dlg.getAgeBelow(), dlg.getErrorPlus(), dlg.getErrorMinus(), dlg.getRatio());
                this.tableModel.fireTableDataChanged();
                this.updateTable();
                this.setSelectedSample(selectedSample.getSampID());
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedSample();
    }

    private void deleteSelectedSample() throws HeadlessException {
        int[] modelRows = TableUtils.getSelectedModelRows((JTable)this.jTable1);
        if (modelRows.length == 0) {
            JOptionPane.showMessageDialog(this, "No sample selected.", "Delete Sample Ages", 1);
        } else {
            int response;
            Object confirmText = "Really delete this sample age?";
            if (modelRows.length > 1) {
                confirmText = "Really delete these " + modelRows.length + " sample ages?";
            }
            if ((response = JOptionPane.showConfirmDialog(this, confirmText, "Delete Sample Ages", 0, 3)) != 0) {
                return;
            }
            for (int row : modelRows) {
                Sample s = this.tableModel.getSampleByRowNum(row);
                this.updateSampleAgeInWell(s, null, null, null, null, null);
            }
            this.updateTable();
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.interpId == null) {
            return;
        }
        if (this.tableModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No data to save", "Save sample ages", 1);
            return;
        }
        String lastExport = Lastval.tryGetString(SbugsSession.getDb(), LAST_WINDOWS_SAMPLE_AGE_EXPORT_KEY, LAST_UNIX_SAMPLE_AGE_EXPORT_KEY);
        File f = FileChooserUtils.saveAsGridDataDialog((Component)this, (String)lastExport, (String)this.well.getWellName());
        if (f != null) {
            GridWriter gw = new GridWriter();
            gw.getXLSOptions().setSheetName(this.well.getWellName());
            gw.getXLSOptions().setAuthorName(SbugsSession.getDb().getUser().getName());
            if (!FilePathUtils.isFileExtension((String)f.getPath(), (String[])new String[]{"xls", "xlsx"})) {
                CSVExportOptions options = this.showCSVOptionsDialog();
                if (options == null) {
                    return;
                }
                gw.setCSVOptions(options);
            }
            if (!FileOverwriteCheck.checkForGridFileOverwriting((JFrame)this.getRootPane().getParent(), (Component)this, f, gw)) {
                return;
            }
            Object[][] data = new TextExporterSampleAge().getSampleAgeData(this.tableModel.getSamples(), this.interpId, DepthUnits.getUnits((char)this.units), this.ageUnits);
            try {
                gw.write(f, data);
                JOptionPane.showMessageDialog(this, "The file " + f.getName() + " was written successfully.", "Export complete", 1);
                Lastval.tryPutString(SbugsSession.getDb(), LAST_WINDOWS_SAMPLE_AGE_EXPORT_KEY, LAST_UNIX_SAMPLE_AGE_EXPORT_KEY, f.getPath());
            }
            catch (IOException ex) {
                StackError.showStackError((String)("An error occurred while writing to " + f.getName()), (Throwable)ex);
            }
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && this.canWrite) {
            this.showEditSampleAgeDialog();
        }
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127 && this.canWrite) {
            this.deleteSelectedSample();
        }
    }

    private void jRadioButtonKaUnitsActionPerformed(ActionEvent evt) {
        this.updateSampleAgeUnits();
    }

    private void jRadioButtonMaUnitsActionPerformed(ActionEvent evt) {
        this.updateSampleAgeUnits();
    }

    @Override
    public void setSampleAge(Sample s, Double age, Double ageBelow, Float errorPlus, Float errorMinus, Double ratio) {
        if (s == null) {
            return;
        }
        if (age == null) {
            int response = JOptionPane.showConfirmDialog(this, "Remove this sample from the table?", "Delete Sample Age", 0, 3);
            if (response == 0) {
                age = null;
                ageBelow = null;
                errorPlus = null;
                errorMinus = null;
                ratio = null;
            } else {
                return;
            }
        }
        this.updateSampleAgeInWell(s, age, ageBelow, errorPlus, errorMinus, ratio);
        this.sampleAgesChanged();
    }

    private void updateSampleAgeInWell(Sample s, Double age, Double ageBelow, Float errorPlus, Float errorMinus, Double ratio) {
        try {
            this.well.setSampleAge(s, this.interpId, age, ageBelow, errorPlus, errorMinus, ratio);
            this.well.getDataModel().commit();
            s.notifyObservers();
        }
        catch (SQLException | SBPermissionException ex) {
            this.well.getDataModel().doRollback();
            Logger.getLogger(PanelInterpSampleAge.class.getName()).log(Level.SEVERE, null, ex);
            StackError.showStackError((String)"An error occurred while updating the sample age.", (Throwable)ex);
        }
    }

    private void updateSampleAgeUnits() {
        boolean changed = false;
        if (this.ageUnits != AgeFormat.MA && this.jRadioButtonMaUnits.isSelected()) {
            this.ageUnits = AgeFormat.MA;
            changed = true;
        }
        if (this.ageUnits != AgeFormat.KA && this.jRadioButtonKaUnits.isSelected()) {
            this.ageUnits = AgeFormat.KA;
            changed = true;
        }
        if (changed) {
            this.tableModel.setAgeUnits(this.ageUnits);
            TableUtils.updateTableColumnNames((JTable)this.jTable1);
            this.tableModel.buildAgeCellEditors(this.jTable1);
            this.tableModel.fireTableDataChanged();
        }
    }

    private List<Sample> filterSamples(List<Sample> samples, int interpId) {
        ArrayList<Sample> rows = new ArrayList<Sample>();
        for (Sample sample : samples) {
            if (!sample.hasAgeData(interpId)) continue;
            rows.add(sample);
        }
        return rows;
    }

    private List<Sample> getWellSamples() {
        ArrayList<Sample> samples = new ArrayList();
        try {
            samples = this.well.getSamples();
        }
        catch (SQLException ex) {
            Logger.getLogger(PanelInterpSampleAge.class.getName()).log(Level.SEVERE, null, ex);
            SbugsExceptionHandler.showStackError("Error retriving well samples", ex);
        }
        return samples;
    }

    public void sampleAgesChanged() {
        Sample s = this.getSelectedSample();
        this.updateTable();
        if (s != null) {
            this.setSelectedSample(s.getSampID());
        }
    }

    private Sample createSampleInWell(SampleCreationRequest sampleToCreate) throws SampleInsertException, SQLException, SBPermissionException {
        Sample.Builder builder = new Sample.Builder();
        builder.topDepth(sampleToCreate.getTopDepth());
        builder.baseDepth(sampleToCreate.getBaseDepth());
        builder.label(sampleToCreate.getLabel());
        builder.type(sampleToCreate.getType());
        Sample existingSample = this.well.getSample(builder);
        if (existingSample != null) {
            return existingSample;
        }
        Sample sample = this.well.addSample(builder, 0, null);
        this.well.notifyObservers(sample);
        SbugsSession.getDb().commit();
        return sample;
    }

    public TableModelSB getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.jTable1;
    }
}

