/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import jsbugs.TableModelSB;
import jsbugs.sampleage.ISampleAgeUpdater;
import jsbugs.sampleage.SampleAgeTextFieldBuilder;
import jsbugs.table.DecimalRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.uiutil.DecimalCellEditor;
import model3.SBdb;
import model3.Sample;
import util.AgeFormat;
import util.AgeUtils;
import util.NumberUtils;

public class SampleAgeTableModel
extends TableModelSB {
    private List<Sample> samples;
    private int interpId;
    private char units;
    private final ISampleAgeUpdater updater;
    private boolean editable = true;
    private AgeFormat ageUnits = AgeFormat.MA;
    private String[] columnNames = new String[]{"Top Depth", "Base Depth", "Label", "Type", "Age", "Error +ve", "Error -ve", "Isotope Ratio"};

    public SampleAgeTableModel(ISampleAgeUpdater updater) {
        this.updater = updater;
    }

    void setAgeUnits(AgeFormat ageUnits) {
        this.ageUnits = ageUnits;
    }

    @Override
    public String getPrefString() {
        return "TMSAMPA";
    }

    @Override
    public String getPrefOrderString() {
        return "TOSAMPA";
    }

    @Override
    public String getAutoResizeString() {
        return "TARSAMPA";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return new int[]{110, 135, 100, 50, 80, 110, 110, 110};
    }

    @Override
    public String[] getColumnTitles() {
        return this.columnNames;
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(Columns.TOP_DEPTH.ordinal()).setCellRenderer(new DepthRenderer());
        tcm.getColumn(Columns.BASE_DEPTH.ordinal()).setCellRenderer(new DepthRenderer());
        tcm.getColumn(Columns.AGE.ordinal()).setCellRenderer(new DecimalRenderer(true));
        tcm.getColumn(Columns.AGE_ERROR_PLUS.ordinal()).setCellRenderer(new DecimalRenderer(true));
        tcm.getColumn(Columns.AGE_ERROR_MINUS.ordinal()).setCellRenderer(new DecimalRenderer(true));
        tcm.getColumn(Columns.ISOTOPE_RATIO.ordinal()).setCellRenderer(new DecimalRenderer(true));
        this.buildAgeCellEditors(table);
        tcm.getColumn(Columns.ISOTOPE_RATIO.ordinal()).setCellEditor(this.buildCellEditor(SampleAgeTextFieldBuilder.BuildIsotopeRatioTextField()));
        this.restoreColumnOrder(table);
    }

    public void buildAgeCellEditors(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(Columns.AGE.ordinal()).setCellEditor(this.buildCellEditor(SampleAgeTextFieldBuilder.BuildSampleAgeTextField(this.ageUnits)));
        tcm.getColumn(Columns.AGE_ERROR_PLUS.ordinal()).setCellEditor(this.buildCellEditor(SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField(this.ageUnits)));
        tcm.getColumn(Columns.AGE_ERROR_MINUS.ordinal()).setCellEditor(this.buildCellEditor(SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField(this.ageUnits)));
    }

    private DefaultCellEditor buildCellEditor(JTextField tf) {
        tf.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        tf.setHorizontalAlignment(10);
        return new DecimalCellEditor(tf);
    }

    public void setSamples(List<Sample> samples, int interpId) {
        this.samples = samples;
        this.interpId = interpId;
    }

    public Sample getSampleByRowNum(int rownum) {
        return this.samples.get(rownum);
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public void setUnits(char units) {
        this.units = units;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int getRowCount() {
        if (this.samples == null) {
            return 0;
        }
        return this.samples.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    public Class getColumnClass(int c) {
        Columns column = Columns.values()[c];
        switch (column.ordinal()) {
            case 0: 
            case 1: 
            case 4: 
            case 7: {
                return Double.class;
            }
            case 3: {
                return SampleType.class;
            }
            case 2: {
                return String.class;
            }
            case 5: 
            case 6: {
                return Float.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Sample sample = this.samples.get(row);
        Columns column = Columns.values()[col];
        switch (column.ordinal()) {
            case 0: {
                if (!sample.hasTopDepth()) {
                    return null;
                }
                return sample.getTopDepth(this.units);
            }
            case 1: {
                if (!sample.hasBaseDepth()) {
                    return null;
                }
                return sample.getBaseDepth(this.units);
            }
            case 3: {
                return sample.getType().getAbr();
            }
            case 2: {
                return sample.getLabel();
            }
            case 4: {
                return this.getAgeValueFromMa(sample.getAge(this.interpId));
            }
            case 5: {
                return this.getAgeValueFromMa(sample.getAgeErrorPlus(this.interpId));
            }
            case 6: {
                return this.getAgeValueFromMa(sample.getAgeErrorMinus(this.interpId));
            }
            case 7: {
                return sample.getRatio(this.interpId);
            }
        }
        return null;
    }

    private Double getAgeValueFromMa(Double ageInMa) {
        return AgeUtils.convertFromMa((Double)ageInMa, (AgeFormat)this.ageUnits);
    }

    private Float getAgeValueFromMa(Float ageInMa) {
        return AgeUtils.convertFromMa((Float)ageInMa, (AgeFormat)this.ageUnits);
    }

    private Double getAgeValueInMa(Double ageInUnits) {
        return AgeUtils.convertToMa((Double)ageInUnits, (AgeFormat)this.ageUnits);
    }

    private Float getAgeValueInMa(Float ageInUnits) {
        return AgeUtils.convertToMa((Float)ageInUnits, (AgeFormat)this.ageUnits);
    }

    @Override
    public String getColumnName(int col) {
        Columns column = Columns.values()[col];
        switch (column.ordinal()) {
            case 0: 
            case 1: {
                return this.columnNames[col] + " (" + DepthUnits.getUnits((char)this.units).getAbr() + ")";
            }
            case 4: 
            case 5: 
            case 6: {
                return this.columnNames[col] + " (" + this.ageUnits.getDescr() + ")";
            }
        }
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Columns column = Columns.values()[columnIndex];
        switch (column.ordinal()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.editable;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.samples == null) {
            return;
        }
        Columns column = Columns.values()[columnIndex];
        Sample s = this.samples.get(rowIndex);
        Double age = s.getAge(this.interpId);
        Double ageBelow = s.getAgeBelow(this.interpId);
        Float errorPlus = s.getAgeErrorPlus(this.interpId);
        Float errorMinus = s.getAgeErrorMinus(this.interpId);
        Double ratio = s.getRatio(this.interpId);
        switch (column.ordinal()) {
            case 4: {
                age = this.getAgeValueInMa(NumberUtils.tryParseDouble((String)aValue.toString()));
                break;
            }
            case 5: {
                errorPlus = this.getAgeValueInMa(NumberUtils.tryParseFloat((String)aValue.toString()));
                break;
            }
            case 6: {
                errorMinus = this.getAgeValueInMa(NumberUtils.tryParseFloat((String)aValue.toString()));
                break;
            }
            case 7: {
                ratio = NumberUtils.tryParseDouble((String)aValue.toString());
                break;
            }
            default: {
                return;
            }
        }
        this.updater.setSampleAge(s, age, ageBelow, errorPlus, errorMinus, ratio);
    }

    static enum Columns {
        TOP_DEPTH,
        BASE_DEPTH,
        LABEL,
        TYPE,
        AGE,
        AGE_ERROR_PLUS,
        AGE_ERROR_MINUS,
        ISOTOPE_RATIO;

    }
}

